/******************************************************************************
** (C) Chris Oldwood
**
** MODULE:		MEMDC.CPP
** COMPONENT:	Windows C++ Library.
** DESCRIPTION:	CMemDC class methods.
**
*******************************************************************************
*/

#include "wcl.hpp"

#ifdef _DEBUG
// For memory leak detection.
#define new DBGCRT_NEW
#endif

/******************************************************************************
** Method:		Constructor.
**
** Description:	Creates a compatible device.
**
** Parameters:	rDC		The DC to copy.
**
** Returns:		Nothing.
**
*******************************************************************************
*/

CMemDC::CMemDC(const CDC& rDC)
{
	m_hDC     = CreateCompatibleDC(rDC.Handle());
	m_iState  = SaveState();
	m_devType = rDC.Type();

	ASSERT(m_hDC);

#ifdef _DEBUG
	// Passify BoundsChecker.
	m_hOrgBitmap  = (HBITMAP)  ::GetCurrentObject(m_hDC, OBJ_BITMAP);
	m_hOrgBrush   = (HBRUSH)   ::GetCurrentObject(m_hDC, OBJ_BRUSH );
	m_hOrgFont    = (HFONT)    ::GetCurrentObject(m_hDC, OBJ_FONT  );
	m_hOrgPalette = (HPALETTE) ::GetCurrentObject(m_hDC, OBJ_PAL   );
	m_hOrgPen     = (HPEN)     ::GetCurrentObject(m_hDC, OBJ_PEN   );
#endif
}

/******************************************************************************
** Method:		Destructor
**
** Description:	Cleans up the DC before freeing.
**
** Parameters:	None.
**
** Returns:		Nothing.
**
*******************************************************************************
*/

CMemDC::~CMemDC()
{
	// Restore DC to inital settings.
	RestoreState(m_iState);
	
#ifdef _DEBUG
	// Passify BoundsChecker.
	::SelectObject (m_hDC, m_hOrgBitmap );
	::SelectObject (m_hDC, m_hOrgBrush  );
	::SelectObject (m_hDC, m_hOrgFont   );
	::SelectPalette(m_hDC, m_hOrgPalette, FALSE);
	::SelectObject (m_hDC, m_hOrgPen    );
#endif

	// Free up DC.
	DeleteDC(m_hDC);
}

/******************************************************************************
** Method:		Type()
**
** Description:	Returns the actual type of the device. This is used when you
**				need to know the actual device type to perform different
**				drawing actions and you only have a Device.
**
** Parameters:	None.
**
** Returns:		The device enumerated type.
**
*******************************************************************************
*/

CDC::Device CMemDC::Type() const
{
	return m_devType;
}
