// ONSPlus: Coded by Shambler (Shambler__@Hotmail.com or Shambler@OldUnreal.com , ICQ:108730864)
Class ONSPlusxPlayer extends xPlayer;

var bool bDisplayExitPoints;
var config bool bDisableExitPointDisplay;
var config bool bDisableSelectableExits;

var config bool bDisableLiftBeacons;
var config bool bDisableEnhancedRadarMap;

// Seriously...Why the fuck does this have to be so difficult, the playerinput system is totally stupid
var private transient PlayerInput PlayerInputPlus;

var float LastCallForLift;
var float LastVRequestTime;

var bool bDidVersionCheck;

replication
{
	reliable if (Role == ROLE_Authority)
		DoVersionCheck;

	reliable if (Role < ROLE_Authority)
		ServerTogglePreferredExit, SelectExitPointServer, CallForLift;
}

exec function GetWeapon(class<Weapon> NewWeaponClass)
{
	if (NewWeaponClass == Class'LinkGun')
		NewWeaponClass = Class'ONSPlusLinkGun';
	else if (NewWeaponClass == Class'ONSAVRiL')
		NewWeaponClass = Class'ONSPlusAVRiL';

	Super.GetWeapon(NewWeaponClass);
}

exec function ToggleExitPointDisplay()
{
	bDisableExitPointDisplay = !bDisableExitPointDisplay;
}

exec function ToggleSelectableExits()
{
	bDisableSelectableExits = !bDisableSelectableExits;

	SaveConfig();

	if (bDisableSelectableExits)
		EmptyExitSelections();
}

// Clientside
exec function DisplayExitPoints()
{
	bDisplayExitPoints = !bDisplayExitPoints;
}

// Clientside
exec function TogglePreferredExit()
{
	if (!bDisableSelectableExits)
		ServerTogglePreferredExit();
}

// Serverside
function ServerTogglePreferredExit()
{
	if (ONSPlusHoverBike(Pawn) != None)
		ONSPlusHoverBike(Pawn).TogglePreferredExit();
	else if (ONSPlusHoverTank(Pawn) != None)
		ONSPlusHoverTank(Pawn).TogglePreferredExit();
	else if (ONSPlusRV(Pawn) != None)
		ONSPlusRV(Pawn).TogglePreferredExit();
	else if (ONSPlusPRV(Pawn) != None)
		ONSPlusPRV(Pawn).TogglePreferredExit();
	else if (ONSPlusArtillery(Pawn) != None)
		ONSPlusArtillery(Pawn).TogglePreferredExit();
	else if (ONSPlusAttackCraft(Pawn) != None)
		ONSPlusAttackCraft(Pawn).TogglePreferredExit();
	else if (ONSPlusDualAttackCraft(Pawn) != None)
		ONSPlusDualAttackCraft(Pawn).TogglePreferredExit();
	else if (ONSPlusShockTank(Pawn) != None)
		ONSPlusShockTank(Pawn).TogglePreferredExit();
	else if (ONSPlusMobileAssaultStation(Pawn) != None)
		ONSPlusMobileAssaultStation(Pawn).TogglePreferredExit();
}

exec function SetPreferredExit(string Direction, optional bool bPermenant, optional int Duration)
{
	local int Dir;

	if (bDisableSelectableExits)
		return;

	if (Direction ~= "Left")
		Dir = 1;
	else if (Direction ~= "Right")
		Dir = 2;
	else if (Direction ~= "Forward" || Direction ~= "Front")
		Dir = 3;
	else if (Direction ~= "Back" || Direction ~= "Backwards")
		Dir = 4;
	else if (Direction ~= "1" || Direction ~= "2" || Direction ~= "3" || Direction ~= "4")
		Dir = int(Direction);

	if (Duration > 0)
		bPermenant = False;

	SelectExitPoint(Dir, bPermenant, Duration);
	SelectExitPointServer(Dir, bPermenant, Duration);
}

exec function EmptyExitSelections()
{
	SelectExitPoint(5);
	SelectExitPointServer(5);
}

exec function CallForLift()
{
	local int i;

	if (Level.TimeSeconds - LastCallForLift > 5 || LastCallForLift == 0)
	{
		LastCallForLift = Level.TimeSeconds;

		// This is a bit nasty, it appears functions replicated using a PlayerReplicationInfo only get replicated to the owning client...thus I made a workaround
		if (Role == ROLE_Authority && PlayerReplicationInfo != none && ONSPlusPlayerReplicationInfo(PlayerReplicationInfo) != none)
			for (i=0; i<GameReplicationInfo.PRIArray.Length; i++)
				if (ONSPlusPlayerReplicationInfo(GameReplicationInfo.PRIArray[i]) != none)
					ONSPlusPlayerReplicationInfo(GameReplicationInfo.PRIArray[i]).ClientCallForLift(ONSPlusPlayerReplicationInfo(PlayerReplicationInfo));
			
	}
}

exec function DisplayLiftBeacons()
{
	bDisableLiftBeacons = !bDisableLiftBeacons;
	SaveConfig();
}

exec function DisplayEnhancedRadarMap()
{
	bDisableEnhancedRadarMap = !bDisableEnhancedRadarMap;
	SaveConfig();
}

function SelectExitPoint(int Point, optional bool bPermenant, optional int Duration)
{
	if (Duration <= 0)
		Duration = 3;

	if (ONSPlusHoverBike(Pawn) != None)
		ONSPlusHoverBike(Pawn).SelectDirectionalExit(Point, Duration, bPermenant);
	else if (ONSPlusAttackCraft(Pawn) != None)
		ONSPlusAttackCraft(Pawn).SelectDirectionalExit(Point, Duration, bPermenant);
	else if (ONSPlusHoverTank(Pawn) != None)
		ONSPlusHoverTank(Pawn).SelectDirectionalExit(Point, Duration, bPermenant);
	else if (ONSPlusPRV(Pawn) != None)
		ONSPlusPRV(Pawn).SelectDirectionalExit(Point, Duration, bPermenant);
	else if (ONSPlusRV(Pawn) != None)
		ONSPlusRV(Pawn).SelectDirectionalExit(Point, Duration, bPermenant);
	else if (ONSPlusMobileAssaultStation(Pawn) != None)
		ONSPlusMobileAssaultStation(Pawn).SelectDirectionalExit(Point, Duration, bPermenant);
	else if (ONSPlusArtillery(Pawn) != None)
		ONSPlusArtillery(Pawn).SelectDirectionalExit(Point, Duration, bPermenant);
	else if (ONSPlusShockTank(Pawn) != None)
		ONSPlusShockTank(Pawn).SelectDirectionalExit(Point, Duration, bPermenant);
	else if (ONSPlusDualAttackCraft(Pawn) != None)
		ONSPlusDualAttackCraft(Pawn).SelectDirectionalExit(Point, Duration, bPermenant);
}

function SelectExitPointServer(int Point, optional bool bPermenant, optional int Duration)
{
	if (Level.NetMode != NM_Standalone)
		SelectExitPoint(Point, bPermenant, Duration);
}

state PlayerDriving
{
ignores SeePlayer, HearNoise, Bump;

	function PlayerMove(float DeltaTime)
	{
		local eDoubleClickDir DoubleClickMove;

		Super.PlayerMove(DeltaTime);

		if ((Role < ROLE_Authority || Level.Netmode == NM_Standalone) && !bDisableSelectableExits)
		{
			DoubleClickMove = PlayerInputPlus.CheckForDoubleClickMove(1.1 * DeltaTime / Level.TimeDilation);

			if (DoubleClickMove > 0 && DoubleClickmove < 5)
			{
				SelectExitPointServer(DoubleClickMove);
				SelectExitPoint(DoubleClickMove);
			}
		}
	}
}

simulated function InitInputSystem()
{
	PlayerInputPlus = new(self) Class'ONSPlusPlayerInput';

	Super.InitInputSystem();
}

function PlayerTick(float DeltaTime)
{
	PlayerInputPlus.PlayerInput(DeltaTime);

	Super.PlayerTick(DeltaTime);
}

simulated function ClientReceiveLoginMenu(string MenuClass, bool bForce)
{
	if (GameReplicationInfo.GameClass ~= "Onslaught.ONSOnslaughtGame" || MenuClass ~= "GUI2k4.UT2K4OnslaughtLoginMenu")
		LoginMenuClass = "ONSPlus.ONSPlusLoginMenu";
	else
		LoginMenuClass = "ONSPlus.ONSPlusLoginMenuVCTF";

	bForceLoginMenu = bForce;
}

// I have modified this function to request a vehicle info update every time the menu is opened (more efficient than the last implementation)
function ClientOpenMenu(string Menu, optional bool bDisconnect,optional string Msg1, optional string Msg2)
{
	if (Menu == MidGameMenuClass)
		GetVInfoUpdate();

	Super.ClientOpenMenu(Menu, bDisconnect, Msg1, Msg2);
}

function GetVInfoUpdate()
{
	if (Level.TimeSeconds - LastVRequestTime > 3.0 && !bDisableEnhancedRadarMap && PlayerReplicationInfo != none && ONSPlusPlayerReplicationInfo(PlayerReplicationInfo) != none)
	{
		LastVRequestTime = Level.TimeSeconds;
		ONSPlusPlayerReplicationInfo(PlayerReplicationInfo).RequestVehicleInfoUpdate();
	}
}

// Since this version of ONSPlus is only compatable with the 3369 patch I have decided to add a little bit of extra code here to popup a warning message
function DoVersionCheck()
{
	if (int(Level.EngineVersion) < 3369)
	{
		ClientOpenMenu("ONSPlus.ONSPlusBadVersionMsg", false,
				"You are running a version of UT2004 that is incompatable with the ONSPlus mutator",
				"Please update to UT2004 version 3369 by clicking the Download button below, "$
				"if you continue to play on this version then be advised that you will be prone to crashing");
	}
}

// Blacklisted word checks (commented out for now because I don't want to spend the time testing and tinkering with this yet)
/*exec function SetName(coerce string S)
{
	local int i, iTempInt;

	if (PlayerReplicationInfo != none && ONSPlusPlayerReplicationInfo(PlayerReplicationInfo) != none
		&& ONSPlusPlayerReplicationInfo(PlayerReplicationInfo).WordFilterList.Length > 0)
	{
		for (i=0; i<ONSPlusPlayerReplicationInfo(PlayerReplicationInfo).WordFilterList.Length; ++i)
		{
			iTempInt = InStr(Caps(S), Caps(ONSPlusPlayerReplicationInfo(PlayerReplicationInfo).WordFilterList[i]));

			if (iTempInt != -1)
			{
				S = Left(S, iTempInt)$"****"$Mid(S, iTempInt + Len(ONSPlusPlayerReplicationInfo(PlayerReplicationInfo).WordFilterList[i]));

				// Repeat the same check in case the same word is in the list more than once
				i--;
			}
		}
	}

	ChangeName(S);
	UpdateURL("Name", S, true);
	SaveConfig();
}

exec function Say(string Msg)
{
	local int i, iTempInt;

	Msg = Left(Msg, 128);


	if (PlayerReplicationInfo != none && ONSPlusPlayerReplicationInfo(PlayerReplicationInfo) != none
		&& ONSPlusPlayerReplicationInfo(PlayerReplicationInfo).WordFilterList.Length > 0)
	{
		for (i=0; i<ONSPlusPlayerReplicationInfo(PlayerReplicationInfo).WordFilterList.Length; ++i)
		{
			iTempInt = InStr(Caps(Msg), Caps(ONSPlusPlayerReplicationInfo(PlayerReplicationInfo).WordFilterList[i]));

			if (iTempInt != -1)
			{
				Msg = Left(Msg, iTempInt)$"****"
					$Mid(Msg, iTempInt + Len(ONSPlusPlayerReplicationInfo(PlayerReplicationInfo).WordFilterList[i]));

				// Repeat the same check in case the same word is in the list more than once
				i--;
			}
		}
	}

	if (AllowTextMessage(Msg))
		ServerSay(Msg);
}

exec function TeamSay(string Msg)
{
	local int i, iTempInt;

	Msg = Left(Msg, 128);


	if (PlayerReplicationInfo != none && ONSPlusPlayerReplicationInfo(PlayerReplicationInfo) != none
		&& ONSPlusPlayerReplicationInfo(PlayerReplicationInfo).WordFilterList.Length > 0)
	{
		for (i=0; i<ONSPlusPlayerReplicationInfo(PlayerReplicationInfo).WordFilterList.Length; ++i)
		{
			iTempInt = InStr(Caps(Msg), Caps(ONSPlusPlayerReplicationInfo(PlayerReplicationInfo).WordFilterList[i]));

			if (iTempInt != -1)
			{
				Msg = Left(Msg, iTempInt)$"****"
					$Mid(Msg, iTempInt + Len(ONSPlusPlayerReplicationInfo(PlayerReplicationInfo).WordFilterList[i]));

				// Repeat the same check in case the same word is in the list more than once
				i--;
			}
		}
	}

	if (AllowTextMessage(Msg))
		ServerTeamSay(Msg);
}*/