// ONSPlus: Coded by Shambler (Shambler__@Hotmail.com or Shambler@OldUnreal.com , ICQ:108730864)
// NOTE: I can't be held responsible for any damage to mental health caused by looking at this code
Class ONSPlusMutator extends Mutator
	config(ONSPlus);

CONST ONSPlusVersion="v1.0";

// Failed to bring this over to mutator, not reliable : / (whitelist requirements)
/*var config bool bEnableTieBreaks;

var config enum ETieBreakType
{
	TIE_NodeCount,
	TIE_NoWin,
	TIE_Expose,
	TIE_RandomWin,
	TIE_InstaDeath,
} TieBreakType;

var config ETieBreakType SecondaryTieBreakType;

var config bool bNodeCountHealth;

var bool bInitialWait;*/

// General configurable variables, for disabling specific features
var config bool bDisablePlayerClass;
var config bool bDropChecks;
var config bool bSelectableExits;
var config bool bNodeHealScoreFix;
var config bool bVehicleHealScore;
var config bool bVehicleDamageScore;

var config float HealValueScore; // After a player heals this much vehicle health he is rewarded one point
var config float DamageValueScore; // Same as above but relates to damage dealt instead


var config bool bNodeIsolateBonus;
var config int IsolateBonusPctPerNode;

var config bool bAllowEnhancedRadar;

var config bool bDisablePreferredTeam;
var config bool bDisableVersionCheck;


// Word filter list for names/say command
/*var config array<string> BlacklistedWords;
var config bool bEnableWordFilter;*/


var ONSPlusScoreRules ScoreRules;


// Setup WebAdmin settings
static function FillPlayInfo(PlayInfo PlayInfo)
{
	Super.FillPlayInfo(PlayInfo);

	PlayInfo.AddSetting("ONSPlus", "bDropChecks", "Drop Checks", 0, 0, "Check");
	PlayInfo.AddSetting("ONSPlus", "bSelectableExits", "Selectable Exits", 0, 0, "Check");

	PlayInfo.AddSetting("ONSPlus", "bVehicleHealScore", "Give Vehicle Heal Bonus", 0, 1, "Check");
	PlayInfo.AddSetting("ONSPlus", "HealValueScore", "Heal Damage Per Point", 0, 2, "Text");

	PlayInfo.AddSetting("ONSPlus", "bVehicleDamageScore", "Give Vehicle Damage Bonus", 0, 3, "Check");
	PlayInfo.AddSetting("ONSPlus", "DamageValueScore", "Damage Per Point", 0, 4, "Text");

	PlayInfo.AddSetting("ONSPlus", "bNodeHealScoreFix", "Share Node Healing", 0, 0, "Check");
	PlayInfo.AddSetting("ONSPlus", "bNodeIsolateBonus", "Give Node Isolation Bonus", 0, 5, "Check");
	PlayInfo.AddSetting("ONSPlus", "IsolateBonusPctPerNode", "% Increase Per Node", 0, 6, "Text");

	PlayInfo.AddSetting("ONSPlus", "bAllowEnhancedRadar", "Enhanced Menu Radar", 0, 7, "Check");

	PlayInfo.AddSetting("ONSPlus", "bDisablePreferredTeam", "Disable Preferred Teams", 0, 8, "Check");
	PlayInfo.AddSetting("ONSPlus", "bDisableVersionCheck", "Disable UT2k4 version check", 0, 9, "Check");

	// Word filter
	//PlayInfo.AddSetting("WordFilter", "bEnableWordFilter", "Enable Word filteR", 0, 0, "Check");
	//PlayInfo.AddSetting("WordFilter", "BlacklistedWords", "Filtered Words", 0, 1, "Text");
}

static event string GetDescriptionText(string PropName)
{
	switch (PropName)
	{
		case "bDropChecks":		return "Enable/Disable exit height checks when leaving a vehicle";
		case "bSelectableExits":	return "Enable/Disable players being able to choose their vehicle exits";
		case "bNodeHealScoreFix":	return "Enable/Disable shared scoring between linked players when healing nodes";

		case "bVehicleHealScore":	return "Enable/Disable bonus points for healing a vehicle";
		case "HealValueScore":		return "One point is awarded every time a player heals this much health on a vehicle";

		case "bVehicleDamageScore":	return "Enable/Disable bonus points for damaging a vehicle";
		case "DamageValueScore":	return "One point is awarded every time a player damages a vehicle this much";


		case "bNodeIsolateBonus":	return "Enable/Disable bonus points for isolating nodes";
		case "IsolateBonusPctPerNode":	return "The percentage of bonus points awarded to a player for every isolated node";

		case "bAllowEnhancedRadar":	return "Enable/Disable improved menu radar which shows occupied vehicle spawns";

		case "bDisablePreferredTeam":	return "Enable/Disable assigned players to their preferred team";
		case "bDisableVersionCheck":	return "Enable/Disable incompatability message that gets shown to pre-3369 clients";

		// Word filter
		//case "bEnableWordFilter":	return "Enable/Disable the filtering of bad words in players names and text communication";
		//case "BlacklistedWords":	return "Words that are filtered and replaced with ****";
	}
}

// Replace various stuff
function PreBeginPlay()
{
	local actor A;

	local vector GunnerPos, FireImpulse, AltFireImpulse, DrivePos, EntryPosition,
		FPCamPos, FPCamViewOffset, TPCamLookat, TPCamWorldOffset,
		HUDOverlayOffset, MGPLocation;
	local rotator GunnerRot, DriveRot, MGPRotation;
	local class<Actor> DestroyEffectClass;
	local name CameraBone, DriveAnim;
	local color CrosshairColor;
	local float CrosshairX, CrosshairY, Steering, Throttle, Rise, EntryRadius,
		TPCamDistance, WaterDamage, HUDOverlayFOV;
	local Texture CrosshairTexture;
	local bool bDrawDriverInTP, bDriverCollideActors, bRelativeExitPos,
		bDrawMeshInFP, bZeroPCRotOnEntry, bHUDTrackVehicle, bHighScoreKill,
		bDesiredBehindView, bFPNoZFromCameraPitch;
	local byte Team;
	local array<Vector> ExitPositions;
	local Range TPCamDistRange;
	local int MaxViewYaw, MaxViewPitch;
	local array<sound> BulletSounds;
	local Material SpawnOverlay[2];
	local ONSPlusManualGunPawn OPMGP;

	if (Level.Netmode != NM_Standalone && int(Level.EngineVersion) < 3369)
	{
		Log("This version of ONSPlus is only 100% compatable with patch 3369, any previous patch won't work and any patch released after is untested", 'ONSPlusError');
		Destroy();

		return;
	}

	Level.Game.GameReplicationInfoClass = Class'ONSPlusGameReplicationInfo';

	if (ONSOnslaughtGame(level.game) != none)
		Level.Game.HUDType = "ONSPlus.ONSPlusHUD";
	else if (xVehicleCTFGame(level.game) != none)
		Level.Game.HUDType = "ONSPlus.ONSPlusHUDVCTF";

	foreach AllActors(Class'Actor', A)
	{
		if (ONSManualGunPawn(A) != None && ONSPlusManualGunPawn(A) == None)
		{
			GunnerPos = ONSManualGunPawn(A).GunnerPos;
			FireImpulse = ONSManualGunPawn(A).FireImpulse;
			AltFireImpulse = ONSManualGunPawn(A).AltFireImpulse;
			DrivePos = ONSManualGunPawn(A).DrivePos;
			EntryPosition = ONSManualGunPawn(A).EntryPosition;
			FPCamPos = ONSManualGunPawn(A).FPCamPos;
			FPCamViewOffset = ONSManualGunPawn(A).FPCamViewOffset;
			TPCamLookat = ONSManualGunPawn(A).TPCamLookat;
			TPCamWorldOffset = ONSManualGunPawn(A).TPCamWorldOffset;
			HUDOverlayOffset = ONSManualGunPawn(A).HUDOverlayOffset;
			MGPLocation = ONSManualGunPawn(A).Location;

			GunnerRot = ONSManualGunPawn(A).GunnerRot;
			DriveRot = ONSManualGunPawn(A).DriveRot;
			MGPRotation = ONSManualGunPawn(A).Rotation;

			DestroyEffectClass = ONSManualGunPawn(A).DestroyEffectClass;

			CameraBone = ONSManualGunPawn(A).CameraBone;
			DriveAnim = ONSManualGunPawn(A).DriveAnim;

			CrosshairColor = ONSManualGunPawn(A).CrosshairColor;

			CrosshairX = ONSManualGunPawn(A).CrosshairX;
			CrosshairY = ONSManualGunPawn(A).CrosshairY;
			Steering = ONSManualGunPawn(A).Steering;
			Throttle = ONSManualGunPawn(A).Throttle;
			Rise = ONSManualGunPawn(A).Rise;
			EntryRadius = ONSManualGunPawn(A).EntryRadius;
			TPCamDistance = ONSManualGunPawn(A).TPCamDistance;
			WaterDamage = ONSManualGunPawn(A).WaterDamage;
			HUDOverlayFOV = ONSManualGunPawn(A).HUDOverlayFOV;

			CrosshairTexture = ONSManualGunPawn(A).CrosshairTexture;

			bDrawDriverInTP = ONSManualGunPawn(A).bDrawDriverInTP;
			bDriverCollideActors = ONSManualGunPawn(A).bDriverCollideActors;
			bRelativeExitPos = ONSManualGunPawn(A).bRelativeExitPos;
			bDrawMeshInFP = ONSManualGunPawn(A).bDrawMeshInFP;
			bZeroPCRotOnEntry = ONSManualGunPawn(A).bZeroPCRotOnEntry;
			bHUDTrackVehicle = ONSManualGunPawn(A).bHUDTrackVehicle;
			bHighScoreKill = ONSManualGunPawn(A).bHighScoreKill;
			bDesiredBehindView = ONSManualGunPawn(A).bDesiredBehindView;
			bFPNoZFromCameraPitch = ONSManualGunPawn(A).bFPNoZFromCameraPitch;

			Team = ONSManualGunPawn(A).Team;

			ExitPositions = ONSManualGunPawn(A).ExitPositions;

			TPCamDistRange = ONSManualGunPawn(A).TPCamDistRange;

			MaxViewYaw = ONSManualGunPawn(A).MaxViewYaw;
			MaxViewPitch = ONSManualGunPawn(A).MaxViewPitch;

			BulletSounds = ONSManualGunPawn(A).BulletSounds;

			SpawnOverlay[0] = ONSManualGunPawn(A).SpawnOverlay[0];
			SpawnOverlay[1] = ONSManualGunPawn(A).SpawnOverlay[1];


			ONSManualGunPawn(A).Destroy();

			OPMGP = Spawn(Class'ONSPlusManualGunPawn',,, MGPLocation, MGPRotation);


			OPMGP.GunnerPos = GunnerPos;
			OPMGP.FireImpulse = FireImpulse;
			OPMGP.AltFireImpulse = AltFireImpulse;
			OPMGP.DrivePos = DrivePos;
			OPMGP.EntryPosition = EntryPosition;
			OPMGP.FPCamPos = FPCamPos;
			OPMGP.FPCamViewOffset = FPCamViewOffset;
			OPMGP.TPCamLookat = TPCamLookat;
			OPMGP.TPCamWorldOffset = TPCamWorldOffset;
			OPMGP.HUDOverlayOffset = HUDOverlayOffset;

			OPMGP.GunnerRot = GunnerRot;
			OPMGP.DriveRot = DriveRot;

			OPMGP.DestroyEffectClass = DestroyEffectClass;

			OPMGP.CameraBone = CameraBone;
			OPMGP.DriveAnim = DriveAnim;

			OPMGP.CrosshairColor = CrosshairColor;

			OPMGP.CrosshairX = CrosshairX;
			OPMGP.CrosshairY = CrosshairY;
			OPMGP.Steering = Steering;
			OPMGP.Throttle = Throttle;
			OPMGP.Rise = Rise;
			OPMGP.EntryRadius = EntryRadius;
			OPMGP.TPCamDistance = TPCamDistance;
			OPMGP.WaterDamage = WaterDamage;
			OPMGP.HUDOverlayFOV = HUDOverlayFOV;

			OPMGP.CrosshairTexture = CrosshairTexture;

			OPMGP.bDrawDriverInTP = bDrawDriverInTP;
			OPMGP.bDriverCollideActors = bDriverCollideActors;
			OPMGP.bRelativeExitPos = bRelativeExitPos;
			OPMGP.bDrawMeshInFP = bDrawMeshInFP;
			OPMGP.bZeroPCRotOnEntry = bZeroPCRotOnEntry;
			OPMGP.bHUDTrackVehicle = bHUDTrackVehicle;
			OPMGP.bHighScoreKill = bHighScoreKill;
			OPMGP.bDesiredBehindView = bDesiredBehindView;
			OPMGP.bFPNoZFromCameraPitch = bFPNoZFromCameraPitch;

			OPMGP.Team = Team;

			OPMGP.ExitPositions = ExitPositions;

			OPMGP.TPCamDistRange = TPCamDistRange;

			OPMGP.MaxViewYaw = MaxViewYaw;
			OPMGP.MaxViewPitch = MaxViewPitch;

			OPMGP.BulletSounds = BulletSounds;

			OPMGP.SpawnOverlay[0] = SpawnOverlay[0];
			OPMGP.SpawnOverlay[1] = SpawnOverlay[1];
		}
	}

	Super.PreBeginPlay();
}

function PostBeginPlay()
{
	if (bDeleteMe)
		return;

	// Hack for replacing stuff after PostBeginPlay is called (note: use the initialstate function or whatever instead?)
	SetTimer(0.001, false);


	if (!bDisablePlayerClass)
		Level.Game.PlayerControllerClassName = "ONSPlus.ONSPlusxPlayer";

	ScoreRules = Spawn(Class'ONSPlusScoreRules');
	ScoreRules.MutatorOwner = self;
	ScoreRules.OPInitialise();
	Level.Game.AddGameModifier(ScoreRules);

	if (ONSOnslaughtGame(level.game) != none)
		ONSOnslaughtGame(Level.Game).GameUMenuType="ONSPlus.ONSPlusLoginMenu";
	else if (xVehicleCTFGame(level.game) != none)
		xVehicleCTFGame(level.game).GameUMenuType="ONSPlus.ONSPlusLoginMenuVCTF";
}

// Initiate the GRI variables for replication
function InitGRI()
{
	if (Level.Game.GameReplicationInfo != None && ONSPlusGameReplicationInfo(Level.Game.GameReplicationInfo) != None)
	{
		ONSPlusGameReplicationInfo(Level.Game.GameReplicationInfo).bDropChecks = bDropChecks;

		ONSPlusGameReplicationInfo(Level.Game.GameReplicationInfo).bSelectableExits = bSelectableExits;
		ONSPlusGameReplicationInfo(Level.Game.GameReplicationInfo).bVehicleHealScoreFix = bVehicleHealScore;
		ONSPlusGameReplicationInfo(Level.Game.GameReplicationInfo).bVehicleDamageScore = bVehicleDamageScore;

		ONSPlusGameReplicationInfo(Level.Game.GameReplicationInfo).HealScoreQuota = HealValueScore;
		ONSPlusGameReplicationInfo(Level.Game.GameReplicationInfo).DamageScoreQuota = DamageValueScore;

		if (ONSOnslaughtGame(level.game) != none)
		{
			ONSPlusGameReplicationInfo(Level.Game.GameReplicationInfo).bAllowEnhancedRadar = bAllowEnhancedRadar;
			ONSPlusGameReplicationInfo(Level.Game.GameReplicationInfo).bNodeHealScoreFix = bNodeHealScoreFix;
			ONSPlusGameReplicationInfo(Level.Game.GameReplicationInfo).bIsolateNodeBonus = bNodeIsolateBonus;
			ONSPlusGameReplicationInfo(Level.Game.GameReplicationInfo).IsolateBonusPctPerNode = IsolateBonusPctPerNode;
		}
	}
}

function Timer()
{
	local actor A;
	local ONSVehicleFactory VF;
	local KarmaBoostVolume KB;
	local BlockingVolume BV;
	local SpecialVehicleObjective SV;
	local Trigger T;
	local int i;

	Super.Timer();

	InitGRI();

	// Part of removed tiebreak code
	//if (bEnableTieBreaks)
	//	SetTimer(Level.TimeDilation, True);

	// Various map-fixing replacements and ONSPlus specific replacements
	foreach AllActors(Class'Actor', A)
	{
		// Replace vehicles
		if (ONSVehicleFactory(A) != None)
		{
			VF = ONSVehicleFactory(A);

			if (VF.VehicleClass == Class'ONSAttackCraft')
				VF.VehicleClass = Class'ONSPlusAttackCraft';
			else if (VF.VehicleClass == Class'ONSHoverBike')
				VF.VehicleClass = Class'ONSPlusHoverBike';
			else if (VF.VehicleClass == Class'ONSRV')
				VF.VehicleClass = Class'ONSPlusRV';
			else if (VF.VehicleClass == Class'ONSPRV')
				VF.VehicleClass = Class'ONSPlusPRV';
			else if (VF.VehicleClass == Class'ONSHoverTank')
				VF.VehicleClass = Class'ONSPlusHoverTank';
			else if (VF.VehicleClass == Class'ONSMobileAssaultStation')
				VF.VehicleClass = Class'ONSPlusMobileAssaultStation';
			else if (VF.VehicleClass == Class'ONSDualAttackCraft')
				VF.VehicleClass = Class'ONSPlusDualAttackCraft';
			else if (VF.VehicleClass == Class'ONSArtillery')
				VF.VehicleClass = Class'ONSPlusArtillery';
			else if (VF.VehicleClass == Class'ONSShockTank')
				VF.VehicleClass = Class'ONSPlusShockTank';
		}
		// Replace LinkGun
		else if (xWeaponBase(A) != None && xWeaponBase(A).WeaponType == Class'LinkGun')
		{
			if (bNodeHealScoreFix || bVehicleHealScore)
				xWeaponBase(A).WeaponType = Class'ONSPlusLinkGun';
		}
		else if (WeaponLocker(A) != None)
		{
			if (bVehicleHealScore || bNodeHealScoreFix)
			{
				for (i=0; i<WeaponLocker(A).Weapons.Length; i++)
				{
					if (WeaponLocker(A).Weapons[i].WeaponClass == Class'LinkGun' && (bNodeHealScoreFix || bVehicleHealScore))
						WeaponLocker(A).Weapons[i].WeaponClass = Class'ONSPlusLinkGun';
					else if (WeaponLocker(A).Weapons[i].WeaponClass == Class'ONSAVRiL')
						WeaponLocker(A).Weapons[i].WeaponClass = Class'ONSPlusAVRiL';
				}
			}
		}
		else if (LinkGunPickup(A) != None)
		{
			if (bNodeHealScoreFix || bVehicleHealScore)
				LinkGunPickup(A).InventoryType = Class'ONSPlusLinkGun';
		}
		// Replace AVRiL
		else if (xWeaponBase(A) != None && xWeaponBase(A).WeaponType == Class'ONSAVRiL')
		{
			xWeaponBase(A).WeaponType = Class'ONSPlusAVRiL';
		}
		else if (ONSAVRiLPickup(A) != None)
		{
			ONSAVRiLPickup(A).InventoryType = Class'ONSPlusAVRiL';
		}
		// Set KarmaBoostVolume's vehicle settings to the new vehicles
		else if (KarmaBoostVolume(A) != None)
		{
			KB = KarmaBoostVolume(A);

			for (i=0; i<KB.AffectedClasses.Length; i++)
			{
				if (KB.AffectedClasses[i] == Class'ONSAttackCraft')
					KB.AffectedClasses[i] = Class'ONSPlusAttackCraft';
				else if (KB.AffectedClasses[i] == Class'ONSHoverBike')
					KB.AffectedClasses[i] = Class'ONSPlusHoverBike';
				else if (KB.AffectedClasses[i] == Class'ONSRV')
					KB.AffectedClasses[i] = Class'ONSPlusRV';
				else if (KB.AffectedClasses[i] == Class'ONSPRV')
					KB.AffectedClasses[i] = Class'ONSPlusPRV';
				else if (KB.AffectedClasses[i] == Class'ONSHoverTank')
					KB.AffectedClasses[i] = Class'ONSPlusHoverTank';
				else if (KB.AffectedClasses[i] == Class'ONSMobileAssaultStation')
					KB.AffectedClasses[i] = Class'ONSPlusMobileAssaultStation';
				else if (KB.AffectedClasses[i] == Class'ONSDualAttackCraft')
					KB.AffectedClasses[i] = Class'ONSPlusDualAttackCraft';
				else if (KB.AffectedClasses[i] == Class'ONSArtillery')
					KB.AffectedClasses[i] = Class'ONSPlusArtillery';
				else if (KB.AffectedClasses[i] == Class'ONSShockTank')
					KB.AffectedClasses[i] = Class'ONSPlusShockTank';
			}
		}
		// Set BlockingVolume's vehicle settings to the new vehicles (is this even needed?)
		else if (BlockingVolume(A) != None)
		{
			BV = BlockingVolume(A);

			for (i=0; i<BV.BlockedClasses.Length; i++)
			{
				if (BV.BlockedClasses[i] == Class'ONSAttackCraft')
					BV.BlockedClasses[i] = Class'ONSPlusAttackCraft';
				else if (BV.BlockedClasses[i] == Class'ONSHoverBike')
					BV.BlockedClasses[i] = Class'ONSPlusHoverBike';
				else if (BV.BlockedClasses[i] == Class'ONSRV')
					BV.BlockedClasses[i] = Class'ONSPlusRV';
				else if (BV.BlockedClasses[i] == Class'ONSPRV')
					BV.BlockedClasses[i] = Class'ONSPlusPRV';
				else if (BV.BlockedClasses[i] == Class'ONSHoverTank')
					BV.BlockedClasses[i] = Class'ONSPlusHoverTank';
				else if (BV.BlockedClasses[i] == Class'ONSMobileAssaultStation')
					BV.BlockedClasses[i] = Class'ONSPlusMobileAssaultStation';
				else if (BV.BlockedClasses[i] == Class'ONSDualAttackCraft')
					BV.BlockedClasses[i] = Class'ONSPlusDualAttackCraft';
				else if (BV.BlockedClasses[i] == Class'ONSArtillery')
					BV.BlockedClasses[i] = Class'ONSPlusArtillery';
				else if (BV.BlockedClasses[i] == Class'ONSShockTank')
					BV.BlockedClasses[i] = Class'ONSPlusShockTank';
			}
		}
		else if (SpecialVehicleObjective(A) != None)
		{
			SV = SpecialVehicleObjective(A);

			for (i=0; i<SV.AccessibleVehicleClasses.Length; i++)
			{
				if (SV.AccessibleVehicleClasses[i] == Class'ONSAttackCraft')
					SV.AccessibleVehicleClasses[i] = Class'ONSPlusAttackCraft';
				else if (SV.AccessibleVehicleClasses[i] == Class'ONSHoverBike')
					SV.AccessibleVehicleClasses[i] = Class'ONSPlusHoverBike';
				else if (SV.AccessibleVehicleClasses[i] == Class'ONSRV')
					SV.AccessibleVehicleClasses[i] = Class'ONSPlusRV';
				else if (SV.AccessibleVehicleClasses[i] == Class'ONSPRV')
					SV.AccessibleVehicleClasses[i] = Class'ONSPlusPRV';
				else if (SV.AccessibleVehicleClasses[i] == Class'ONSHoverTank')
					SV.AccessibleVehicleClasses[i] = Class'ONSPlusHoverTank';
				else if (SV.AccessibleVehicleClasses[i] == Class'ONSMobileAssaultStation')
					SV.AccessibleVehicleClasses[i] = Class'ONSPlusMobileAssaultStation';
				else if (SV.AccessibleVehicleClasses[i] == Class'ONSDualAttackCraft')
					SV.AccessibleVehicleClasses[i] = Class'ONSPlusDualAttackCraft';
				else if (SV.AccessibleVehicleClasses[i] == Class'ONSArtillery')
					SV.AccessibleVehicleClasses[i] = Class'ONSPlusArtillery';
				else if (SV.AccessibleVehicleClasses[i] == Class'ONSShockTank')
					SV.AccessibleVehicleClasses[i] = Class'ONSPlusShockTank';
			}
		}
		else if (Trigger(A) != None && Trigger(A).TriggerType == TT_ClassProximity)
		{
			T = Trigger(A);

			if (T.ClassProximityType == Class'ONSAttackCraft')
				T.ClassProximityType = Class'ONSPlusAttackCraft';
			else if (T.ClassProximityType == Class'ONSHoverBike')
				T.ClassProximityType = Class'ONSPlusHoverBike';
			else if (T.ClassProximityType == Class'ONSRV')
				T.ClassProximityType = Class'ONSPlusRV';
			else if (T.ClassProximityType == Class'ONSPRV')
				T.ClassProximityType = Class'ONSPlusPRV';
			else if (T.ClassProximityType == Class'ONSHoverTank')
				T.ClassProximityType = Class'ONSPlusHoverTank';
			else if (T.ClassProximityType == Class'ONSMobileAssaultStation')
				T.ClassProximityType = Class'ONSPlusMobileAssaultStation';
			else if (T.ClassProximityType == Class'ONSDualAttackCraft')
				T.ClassProximityType = Class'ONSPlusDualAttackCraft';
			else if (T.ClassProximityType == Class'ONSArtillery')
				T.ClassProximityType = Class'ONSPlusArtillery';
			else if (T.ClassProximityType == Class'ONSShockTank')
				T.ClassProximityType = Class'ONSPlusShockTank';
		}
	}
}

// It's very frustrating that this doesn't work...well..it 'does' work but adding the health back on like I've done has one
// of two undesired side effects: the core health shows up higher than it really is OR the core dies earlier than it should
// A pity because if it were not for this small problem I could keep the overtime code
/*
function Timer()
{
	local int CDmg[2], i, TeamNodes[2], TotalNodes;
	local ONSOnslaughtGame OG;

	//Log("In timer");

	if (Level.Game.IsInState('MatchInProgress') && ONSOnslaughtGame(Level.Game).bOvertime)
	{
		if (!bInitialWait)
		{
			bInitialWait = True;
			return;
		}

		//Log("Reducing core dmg");

		OG = ONSOnslaughtGame(Level.Game);

		for (i=0; i<OG.PowerCores.Length; i++)
		{
			if (!OG.PowerCores[i].bFinalCore && OG.PowerCores[i].CoreStage != 255)
			{
				if (OG.PowerCores[i].CoreStage == 0 && OG.PowerCores[i].DefenderTeamIndex < 2)
					TeamNodes[OG.PowerCores[i].DefenderTeamIndex]++;

				TotalNodes++;
			}
		}

		CDmg[0] = OG.OvertimeCoreDrainPerSec - OG.OvertimeCoreDrainPerSec * (float(TeamNodes[0]) / TotalNodes);
		CDmg[1] = OG.OvertimeCoreDrainPerSec - OG.OvertimeCoreDrainPerSec * (float(TeamNodes[1]) / TotalNodes);

        	OG.PowerCores[OG.FinalCore[0]].Health += CDmg[0];
        	OG.PowerCores[OG.FinalCore[1]].Health += CDmg[1];
	}
}*/

// This will prevent the mutator from being whitelisted
/*function string GetHumanReadableName()
{
	return "ONSPlus"$ONSPlusVersion;
}*/

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	if (bVehicleHealScore && Controller(Other) != None && MessagingSpectator(Other) == None)
		Controller(Other).PlayerReplicationInfoClass = class'ONSPlusPlayerReplicationInfo';

	return true;
}

// Added to initialise vehicle factory info
function ModifyPlayer(Pawn Other)
{
	//local int i, iTempInt;
	//local string sNewName;

	Super.ModifyPlayer(Other);

	if (ONSOnslaughtGame(level.game) == none)
		return;

	if (Other != none && Other.PlayerReplicationInfo != none && ONSPlusPlayerReplicationInfo(Other.PlayerReplicationInfo) != none)
	{
		if (!ONSPlusPlayerReplicationInfo(Other.PlayerReplicationInfo).bInitializedVSpawnList
			|| ONSPlusPlayerReplicationInfo(Other.PlayerReplicationInfo).LastInitialiseTeam != Other.GetTeamNum())
		{
			ScoreRules.InitialiseVehicleSpawnList(ONSPlusPlayerReplicationInfo(Other.PlayerReplicationInfo));
			ONSPlusPlayerReplicationInfo(Other.PlayerReplicationInfo).bInitializedVSpawnList = True;
			ONSPlusPlayerReplicationInfo(Other.PlayerReplicationInfo).LastInitialiseTeam = Other.GetTeamNum();
		}

		/*if (bEnableWordFilter && !ONSPlusPlayerReplicationInfo(Other.PlayerReplicationInfo).bInitialisedWordList)
		{
			ONSPlusPlayerReplicationInfo(Other.PlayerReplicationInfo).bInitialisedWordList = True;

			// Check the players name to make sure it contains no blacklisted words (this only happens once serverside)
			sNewName = Other.PlayerReplicationInfo.PlayerName;

			for (i=0; i<BlacklistedWords.Length; i++)
			{
				// While checking the player name, send the info to the PRI at the same time
				ONSPlusPlayerReplicationInfo(Other.PlayerReplicationInfo).UpdateWordFilter(BlacklistedWords[i]);

				iTempInt = InStr(caps(sNewName), caps(BlacklistedWords[i]));

				if (iTempInt != -1)
				{
					sNewName = Left(sNewName, iTempInt)$"****"$Mid(sNewName, iTempInt + Len(BlackListedWords[i]));

					// Repeat the same check in case the same word is in the list more than once
					i--;
				}
			}

			// If the name has had to be modified then assign the new name to the player
			if (sNewName != Other.PlayerReplicationInfo.PlayerName)
				Other.PlayerReplicationInfo.SetPlayerName(sNewName);
		}*/

		// Do a check on the client to make sure he/she is running 3369 or higher, if not then a popup will open for them
		if (!bDisableVersionCheck && Other.Controller != none && ONSPlusxPlayer(Other.Controller) != none && !ONSPlusxPlayer(Other.Controller).bDidVersionCheck)
		{
			ONSPlusxPlayer(Other.Controller).bDidVersionCheck = True;
			ONSPlusxPlayer(Other.Controller).DoVersionCheck();
		}
	}
}

function ModifyLogin(out string Portal, out string Options)
{
	local int iTempInt, iTempInt2;
	local string sTempStr;

	// Remove the preferred team
	if (bDisablePreferredTeam)
	{
		iTempInt = InStr(Caps(Options), "?TEAM=");
		sTempStr = Mid(Options, iTempInt + 1);
		iTempInt2 = InStr(sTempStr, "?");

		if (iTempInt2 != -1)
			sTempStr = Left(Options, iTempInt)$Mid(sTempStr, iTempInt2);
		else
			sTempStr = Left(Options, iTempInt);
	}

	Super.ModifyLogin(Portal, Options);
}

static function string GetONSPlusVersion()
{
	return ONSPlusVersion;
}

defaultproperties
{
	bAddToServerPackages=True

	bDropChecks=True
	bAllowEnhancedRadar=True

	bSelectableExits=True

	bNodeHealScoreFix=True
	bVehicleHealScore=True
	bVehicleDamageScore=True

	bNodeIsolateBonus=True
	IsolateBonusPctPerNode=20

	HealValueScore=200.000000
	DamageValueScore=400.000000

	FriendlyName="ONSPlus"
	Description="ONSPlus adds many fixes and small enhancements to the Onslaught and VehicleCTF gametypes"
}