// ONSPlus: Coded by Shambler (Shambler__@Hotmail.com or Shambler@OldUnreal.com , ICQ:108730864)
Class ONSPlusMASSideGunPawn extends ONSMASSideGunPawn;

var bool bForcedDuck;
var pawn DuckForcedPawn;

var ONSPlusGameReplicationInfo OPGRI;

function bool TryToDrive(Pawn P)
{
	if (VehicleBase != None)
	{
		if (VehicleBase.NeedsFlip())
		{
			VehicleBase.Flip(vector(P.Rotation), 1);
			return false;
		}

		if (P.GetTeamNum() != Team)
		{
			if (VehicleBase.Driver == None)
				return VehicleBase.TryToDrive(P);

			VehicleLocked(P);
			return false;
		}
	}


	if (bNonHumanControl || P.Controller == None || Driver != None || P.DrivenVehicle != None || !P.Controller.bIsPlayer || P.IsA('Vehicle') || Health <= 0)
		return false;

	if(!Level.Game.CanEnterVehicle(self, P))
		return false;

	// Check vehicle Locking....
	if (!bTeamLocked || P.GetTeamNum() == Team)
	{
		if (bEnterringUnlocks && bTeamLocked)
			bTeamLocked = false;

		KDriverEnter(P);


		bForcedDuck = False;

		if (P.bIsCrouched)
		{
			P.bIsCrouched = False;
			DuckForcedPawn = P;
			bForcedDuck = True;
		}

		return true;
	}
	else
	{
		VehicleLocked(P);
		return false;
	}
}

function bool KDriverLeave(bool bForceLeave)
{
	local bool bResult;

	bResult = Super.KDriverLeave(bForceLeave);

	if (bResult && bForcedDuck)
		DuckForcedPawn.bIsCrouched = True;

	return bResult;
}

function ServerChangeDriverPosition(byte F)
{
	local Pawn OldDriver, Bot;

	if (Driver == None || VehicleBase == None)
		return;

	if (F == 1 && (VehicleBase.Driver == None || AIController(VehicleBase.Controller) != None))
	{
		OldDriver = Driver;

		// If human player wants a bot's seat, bot swaps with him
		if (AIController(VehicleBase.Controller) != None)
		{
			Bot = VehicleBase.Driver;
			VehicleBase.KDriverLeave(true);
		}

		KDriverLeave(true);

		if (!VehicleBase.TryToDrive(OldDriver))
		{
			KDriverEnter(OldDriver);

			if (Bot != None)
				VehicleBase.KDriverEnter(Bot);
		}
		else
		{
			if (bForcedDuck)
			{
				if (VehicleBase.IsA('ONSPlusMobileAssaultStation'))
				{
					ONSPlusMobileAssaultStation(VehicleBase).bForcedDuck = True;
					ONSPlusMobileAssaultStation(VehicleBase).DuckForcedPawn = DuckForcedPawn;
				}
				else if (VehicleBase.IsA('ONSPlusArtillery'))
				{
					ONSPlusArtillery(VehicleBase).bForcedDuck = True;
					ONSPlusArtillery(VehicleBase).DuckForcedPawn = DuckForcedPawn;
				}
				else if (VehicleBase.IsA('ONSPlusDualAttackCraft'))
				{
					ONSPlusDualAttackCraft(VehicleBase).bForcedDuck = True;
					ONSPlusDualAttackCraft(VehicleBase).DuckForcedPawn = DuckForcedPawn;
				}
				else if (VehicleBase.IsA('ONSPlusHoverTank'))
				{
					ONSPlusHoverTank(VehicleBase).bForcedDuck = True;
					ONSPlusHoverTank(VehicleBase).DuckForcedPawn = DuckForcedPawn;
				}
				else if (VehicleBase.IsA('ONSPlusPRV'))
				{
					ONSPlusPRV(VehicleBase).bForcedDuck = True;
					ONSPlusPRV(VehicleBase).DuckForcedPawn = DuckForcedPawn;
				}
			}

			if (Bot != None)
				TryToDrive(Bot);
		}

		return;
	}

	F -= 2;


	if (F < VehicleBase.WeaponPawns.length && (VehicleBase.WeaponPawns[F].Driver == None || AIController(VehicleBase.WeaponPawns[F].Controller) != None))
	{
		OldDriver = Driver;

		// If human player wants a bot's seat, bot swaps with him
		if (AIController(VehicleBase.WeaponPawns[F].Controller) != None)
		{
			Bot = VehicleBase.WeaponPawns[F].Driver;
			VehicleBase.WeaponPawns[F].KDriverLeave(true);
		}

		KDriverLeave(true);

		if (!VehicleBase.WeaponPawns[F].TryToDrive(OldDriver))
		{
			KDriverEnter(OldDriver);

			if (Bot != None)
				VehicleBase.WeaponPawns[F].KDriverEnter(Bot);
		}
		else if (bForcedDuck)
		{
			if (VehicleBase.WeaponPawns[F].IsA('ONSPlusMASSideGunPawn'))
			{
				ONSPlusMASSideGunPawn(VehicleBase.WeaponPawns[F]).bForcedDuck = True;
				ONSPlusMASSideGunPawn(VehicleBase.WeaponPawns[F]).DuckForcedPawn = DuckForcedPawn;
			}
			else if (VehicleBase.WeaponPawns[F].IsA('ONSPlusArtillerySideGunPawn'))
			{
				ONSPlusArtillerySideGunPawn(VehicleBase.WeaponPawns[F]).bForcedDuck = True;
				ONSPlusArtillerySideGunPawn(VehicleBase.WeaponPawns[F]).DuckForcedPawn = DuckForcedPawn;
			}
			else if (VehicleBase.WeaponPawns[F].IsA('ONSPlusDualACGatlingGunPawn'))
			{
				ONSPlusDualACGatlingGunPawn(VehicleBase.WeaponPawns[F]).bForcedDuck = True;
				ONSPlusDualACGatlingGunPawn(VehicleBase.WeaponPawns[F]).DuckForcedPawn = DuckForcedPawn;
			}
			else if (VehicleBase.WeaponPawns[F].IsA('ONSPlusPRVRearGunPawn'))
			{
				ONSPlusPRVRearGunPawn(VehicleBase.WeaponPawns[F]).bForcedDuck = True;
				ONSPlusPRVRearGunPawn(VehicleBase.WeaponPawns[F]).DuckForcedPawn = DuckForcedPawn;
			}
			else if (VehicleBase.WeaponPawns[F].IsA('ONSPlusPRVSideGunPawn'))
			{
				ONSPlusPRVSideGunPawn(VehicleBase.WeaponPawns[F]).bForcedDuck = True;
				ONSPlusPRVSideGunPawn(VehicleBase.WeaponPawns[F]).DuckForcedPawn = DuckForcedPawn;
			}
			else if (VehicleBase.WeaponPawns[F].IsA('ONSPlusTankSecondaryTurretPawn'))
			{
				ONSPlusTankSecondaryTurretPawn(VehicleBase.WeaponPawns[F]).bForcedDuck = True;
				ONSPlusTankSecondaryTurretPawn(VehicleBase.WeaponPawns[F]).DuckForcedPawn = DuckForcedPawn;
			}
		}

		if (Bot != None)
			TryToDrive(Bot);
	}
}

function bool PlaceExitingDriver()
{
	local int i;
	local vector tryPlace, Extent, HitLocation, HitNormal, ZOffset;
	local bool bTrace0, bTrace1;
	local array<vector> PreferredPositions, SecondaryPositions;

	if (OPGRI == none && Controller != None && PlayerController(Controller) != None && PlayerController(Controller).GameReplicationInfo != None)
		OPGRI = ONSPlusGameReplicationInfo(PlayerController(Controller).GameReplicationInfo);

	if (OPGRI == none || !OPGRI.bDropChecks)
		return Super.PlaceExitingDriver();

	Extent = Driver.default.CollisionRadius * vect(1,1,0);
	Extent.Z = Driver.default.CollisionHeight;
	ZOffset = Driver.default.CollisionHeight * vect(0,0,0.5);

	// Avoid running driver over by placing in direction perpendicular to velocity
	if (VehicleBase != None && VSize(VehicleBase.Velocity) > 100)
	{
		tryPlace = Normal(VehicleBase.Velocity cross vect(0,0,1)) * (VehicleBase.CollisionRadius * 1.25);

		// Checks to see if drop location is 'clear'
		bTrace0 = VehicleBase.Trace(HitLocation, HitNormal, VehicleBase.Location + tryPlace + ZOffset, VehicleBase.Location + ZOffset, false, Extent) == None;
		bTrace1 = VehicleBase.Trace(HitLocation, HitNormal, VehicleBase.Location - tryPlace + ZOffset, VehicleBase.Location + ZOffset, false, Extent) == None;

		// If both drop locations are clear, check for long-falls
		if (bTrace0 && bTrace1)
		{
			bTrace0 = VehicleBase.Trace(HitLocation, HitNormal, VehicleBase.Location + tryPlace + ZOffset - vect(0,0,750), VehicleBase.Location + tryPlace + ZOffset, false, Extent)
					== None;
			bTrace1 = VehicleBase.Trace(HitLocation, HitNormal, VehicleBase.Location - tryPlace + ZOffset - vect(0,0,750), VehicleBase.Location - tryPlace + ZOffset, false, Extent)
					== None;

			// If both have long falls or both hit ground then it doesn't matter which one you pick
			if (bTrace0 == bTrace1)
			{
				// Check if driver can be dropped at either locations
				if (Driver.SetLocation(VehicleBase.Location + tryPlace + ZOffset))
					return True;
				else if (Driver.SetLocation(VehicleBase.Location - tryPlace + ZOffset))
					return True;
			}
			// If the first trace is a long drop, let the player out at the other side
			else if (bTrace0)
			{
				if (Driver.SetLocation(VehicleBase.Location - tryPlace + ZOffset))
					return True;
			}
			// Same as above, except this is for the second trace
			else if (Driver.SetLocation(VehicleBase.Location + tryPlace + ZOffset))
				return True;
		}
		// If this is the only clear drop location you MUST drop out here regardless of fall
		else if (bTrace0)
		{
			if (Driver.SetLocation(VehicleBase.Location + tryPlace + ZOffset))
				return True;
		}
		// Same as above
		else if (bTrace1)
		{
			if (Driver.SetLocation(VehicleBase.Location - tryPlace + ZOffset))
				return True;
		}
	}

	for(i=0; i<ExitPositions.Length; i++)
	{
		if (bRelativeExitPos)
		{
			if (VehicleBase != None)
				tryPlace = VehicleBase.Location + (ExitPositions[i] >> VehicleBase.Rotation) + ZOffset;
			else if (Gun != None)
				tryPlace = Gun.Location + (ExitPositions[i] >> Gun.Rotation) + ZOffset;
			else
				tryPlace = Location + (ExitPositions[i] >> Rotation);
		}

		// First, do a line check (stops us passing through things on exit).
		if (bRelativeExitPos)
		{
			if (VehicleBase != None)
			{
				if (VehicleBase.Trace(HitLocation, HitNormal, tryPlace, VehicleBase.Location + ZOffset, false, Extent) != None)
					continue;
			}
			else
				if (Trace(HitLocation, HitNormal, tryPlace, Location + ZOffset, false, Extent) != None)
					continue;
		}

		if (VehicleBase.Trace(HitLocation, HitNormal, tryPlace - vect(0,0,750), tryPlace, false, Extent) == None)
		{
			SecondaryPositions.Length = SecondaryPositions.Length + 1;
			SecondaryPositions[SecondaryPositions.Length - 1] = tryPlace;
		}
		else
		{
			PreferredPositions.Length = PreferredPositions.Length + 1;
			PreferredPositions[PreferredPositions.Length - 1] = tryPlace;
		}
	}

	// Iterate positions
	for (i=0; i<PreferredPositions.Length; i++)
		if (Driver.SetLocation(PreferredPositions[i]))
			return True;

	for (i=0; i<SecondaryPositions.Length; i++)
		if (Driver.SetLocation(SecondaryPositions[i]))
			return True;

	return false;
}