// ONSPlus: Coded by Shambler (Shambler__@Hotmail.com or Shambler@OldUnreal.com , ICQ:108730864)
Class ONSPlusHUDVCTF extends HUDCCaptureTheFlag;

/*struct BeaconData
{
	var vector PlayerLoc;
	var float FadeMult;
};

var array<BeaconData> BeaconInfo;*/

// Fix for the shitty implementation of sprites..system was better in unreal1/ut99 (this is the easiest way for me to add alpha/transparancy to sprites)
simulated function PostRender(canvas Canvas)
{
	local ONSPlusPlayerReplicationInfo PRI;
	local vector ScreenLoc, BeaconLoc;
	local float Dist, FadeMult;
	local UnrealPawn UPawn;

	if (PlayerOwner == none || ONSPlusxPlayer(PlayerOwner) == none || ONSPlusxPlayer(PlayerOwner).bDisableLiftBeacons)
	{
		Super.PostRender(Canvas);
		return;
	}

	//BeaconInfo.Length = 0;


	// Draw the lift beacons, first check: make sure the local player is in a vehicle
	if (PlayerOwner.Pawn != none && Vehicle(PlayerOwner.Pawn) != none)
	{
		// Iterate through all the colliding actors within this distance (this is less efficient than iterating the PRI's, however this is the most simple way of making it work online)
		foreach PlayerOwner.Pawn.CollidingActors(Class'UnrealPawn', UPawn, 12000.0)
		{
			PRI = ONSPlusPlayerReplicationInfo(UPawn.PlayerReplicationInfo);

			if (PRI != none && Level.TimeSeconds - PRI.LastLiftCall < 5.0 && !PRI.bIsSpectator && PlayerOwner.GetTeamNum() == UPawn.GetTeamNum())
			{
				if (Level.TimeSeconds - PRI.LastLiftCall < 1.0)
					FadeMult = Level.TimeSeconds - PRI.LastLiftCall;
				else if (Level.TimeSeconds - PRI.LastLiftCall > 4.0)
					FadeMult = 5.0 - (Level.TimeSeconds - PRI.LastLiftCall);
				else
					FadeMult = 1.0;

				// N.B. Removed because I only use this in Onslaught
				// The beacon will also be displayed on the HUD map, use the BeaconInfo array to save the data from here so it can be drawn when the HUD map is drawn
				/*iTempInt = BeaconInfo.Length;
				BeaconInfo.Length = BeaconInfo.Length + 1;

				BeaconInfo[iTempInt].PlayerLoc = UPawn.Location;
				BeaconInfo[iTempInt].FadeMult = FadeMult;*/


				// Line of sight check (for HUD only, beacons will be drawn on radar map regardless of this check)
				if (FastTrace(UPawn.Location, PlayerOwner.CalcViewLocation))
				{
					// Calculate where the beacon should be (tricky and a bit complicated)
					BeaconLoc = UPawn.Location + (vect(0,0,1) * PlayerOwner.Pawn.CollisionHeight * FClamp(0.85 + ((PlayerOwner.FOVBias
						* Canvas.WorldToScreen(UPawn.Location).Z * 0.85) * (1.0 / 1200.0)), 1.1, 1.75));

					if (Normal(BeaconLoc - PlayerOwner.CalcViewLocation) Dot vector(PlayerOwner.GetViewRotation()) >= Cos((Pi * PlayerOwner.DesiredFOV) / 360.0))
					{
						ScreenLoc = Canvas.WorldToScreen(BeaconLoc);

						ScreenLoc.X -= float(Texture'OPThumbUp'.USize) * 0.125;
						ScreenLoc.Y -= float(Texture'OPThumbUp'.VSize) * 0.4;

						// Make sure the beacon isn't 'off' the canvas, if unchecked then WorldToScreen can cause a problem where beacons behind you are drawn on HUD
						if (ScreenLoc.X > 0 || ScreenLoc.Y > 0)
						{
							Canvas.DrawColor.R = 255;
							Canvas.DrawColor.G = 255;
							Canvas.DrawColor.B = 255;

							// Manage the transparancy of the beacon based upon the players distance
							Dist = VSize(UPawn.Location - PlayerOwner.CalcViewLocation);

							if (Dist < 6000.0)
								Canvas.DrawColor.A = 128.0 * FadeMult;
							else
								Canvas.DrawColor.A = 128.0 * ((12000.0 - Dist) / 6000.0) * FadeMult;

							Canvas.Style = ERenderStyle.STY_Alpha;

							Canvas.SetPos(ScreenLoc.X, ScreenLoc.Y);
							Canvas.DrawIcon(Texture'OPThumbUp', 0.25);
						}
					}
				}
			}
		}
	}

	Super.PostRender(Canvas);
}