// ONSPlus: Coded by Shambler (Shambler__@Hotmail.com or Shambler@OldUnreal.com , ICQ:108730864)
Class ONSPlusAttackCraftMissle extends ONSAttackCraftMissle;

simulated function Destroyed()
{
	if (TrailEmitter != None)
		TrailEmitter.Destroy();

	if (Role == ROLE_Authority && HomingTarget != None)
		GiveLostLockNotification(HomingTarget);

	Super(Projectile).Destroyed();
}

function SetHomingTarget(Vehicle NewTarget)
{
	if (HomingTarget != None)
		GiveLostLockNotification(HomingTarget);

	HomingTarget = NewTarget;

	if (HomingTarget != None)
		GiveLockedOnNotification(HomingTarget);
}

function GiveLostLockNotification(vehicle V)
{
	if (ONSPlusHoverBike(V) != None)
		ONSPlusHoverBike(V).NotifyPlusEnemyLostLock(Self);
	else if (ONSPlusAttackCraft(V) != None)
		ONSPlusAttackCraft(V).NotifyPlusEnemyLostLock(Self);
	else if (ONSPlusPRV(V) != None)
		ONSPlusPRV(V).NotifyPlusEnemyLostLock(Self);
	else if (ONSPlusRV(V) != None)
		ONSPlusRV(V).NotifyPlusEnemyLostLock(Self);
	else if (ONSPlusMobileAssaultStation(V) != None)
		ONSPlusMobileAssaultStation(V).NotifyPlusEnemyLostLock(Self);
	else if (ONSPlusHoverTank(V) != None)
		ONSPlusHoverTank(V).NotifyPlusEnemyLostLock(Self);
	else if (ONSPlusArtillery(V) != None)
		ONSPlusArtillery(V).NotifyPlusEnemyLostLock(Self);
	else if (ONSPlusDualAttackCraft(V) != None)
		ONSPlusDualAttackCraft(V).NotifyPlusEnemyLostLock(Self);
	else if (ONSPlusShockTank(V) != None)
		ONSPlusShockTank(V).NotifyPlusEnemyLostLock(Self);
	else if (ONSPlusManualGunPawn(V) != None)
		ONSPlusManualGunPawn(V).NotifyPlusEnemyLostLock(Self);
}

function GiveLockedOnNotification(vehicle V)
{
	if (ONSPlusHoverBike(V) != None)
		ONSPlusHoverBike(V).NotifyPlusEnemyLockedOn(Self);
	else if (ONSPlusAttackCraft(V) != None)
		ONSPlusAttackCraft(V).NotifyPlusEnemyLockedOn(Self);
	else if (ONSPlusPRV(V) != None)
		ONSPlusPRV(V).NotifyPlusEnemyLockedOn(Self);
	else if (ONSPlusRV(V) != None)
		ONSPlusRV(V).NotifyPlusEnemyLockedOn(Self);
	else if (ONSPlusMobileAssaultStation(V) != None)
		ONSPlusMobileAssaultStation(V).NotifyPlusEnemyLockedOn(Self);
	else if (ONSPlusHoverTank(V) != None)
		ONSPlusHoverTank(V).NotifyPlusEnemyLockedOn(Self);
	else if (ONSPlusArtillery(V) != None)
		ONSPlusArtillery(V).NotifyPlusEnemyLockedOn(Self);
	else if (ONSPlusDualAttackCraft(V) != None)
		ONSPlusDualAttackCraft(V).NotifyPlusEnemyLockedOn(Self);
	else if (ONSPlusShockTank(V) != None)
		ONSPlusShockTank(V).NotifyPlusEnemyLockedOn(Self);
	else if (ONSPlusManualGunPawn(V) != None)
		ONSPlusManualGunPawn(V).NotifyPlusEnemyLockedOn(Self);
}