// ONSPlus: Coded by Shambler (Shambler__@Hotmail.com or Shambler@OldUnreal.com , ICQ:108730864)
Class ONSPlusAVRiL extends ONSAVRiL;

simulated function WeaponTick(float deltaTime)
{
	local vector StartTrace, LockTrace;
	local rotator Aim;
	local float BestAim, BestDist;
	local bool bLastLockedOn, bBotLock;
	local Vehicle LastHomingTarget;
	local Vehicle AIFocus;
	local Vehicle V;
	local Actor AlternateTarget;

	if (Role < ROLE_Authority)
	{
		ActivateReticle(bLockedOn);
		return;
	}

	if (Instigator == None || Instigator.Controller == None)
	{
		LoseLock();
		ActivateReticle(false);

		return;
	}

	if (Level.TimeSeconds < LockCheckTime)
		return;

	LockCheckTime = Level.TimeSeconds + LockCheckFreq;

	bLastLockedOn = bLockedOn;
	LastHomingTarget = HomingTarget;
	bBotLock = true;

	if (AIController(Instigator.Controller) != None)
	{
		AIFocus = Vehicle(AIController(Instigator.Controller).Focus);

		if (CanLockOnTo(AIFocus) && ((AIFocus.Controller != None) || (AIFocus != Instigator.Controller.MoveTarget) || AIFocus.HasOccupiedTurret())
			&& FastTrace(AIFocus.Location, Instigator.Location + Instigator.EyeHeight * vect(0,0,1)))
		{
			HomingTarget = AIFocus;
			bLockedOn = true;
		}
		else
		{
			bLockedOn = false;
			bBotLock = false;
		}
	}
	else if (HomingTarget == None || Normal(HomingTarget.Location - Instigator.Location) Dot vector(Instigator.Controller.Rotation) < LockAim
			|| VSize(HomingTarget.Location - Instigator.Location) > MaxLockRange
			|| !FastTrace(HomingTarget.Location, Instigator.Location + Instigator.EyeHeight * vect(0,0,1)))
	{
		StartTrace = Instigator.Location + Instigator.EyePosition();
		Aim = Instigator.GetViewRotation();
		BestAim = LockAim;

		HomingTarget = Vehicle(Instigator.Controller.PickTarget(BestAim, BestDist, Vector(Aim), StartTrace, MaxLockRange));
	}

	// If no homing target, check for alternate targets
	if (HomingTarget == None)
	{
		StartTrace = Instigator.Location + Instigator.EyePosition();
		Aim = Instigator.GetViewRotation();

		for (V=Level.Game.VehicleList; V!=None; V=V.NextVehicle)
		{
			AlternateTarget = V.AlternateTarget();

			if (AlternateTarget != None)
			{
				LockTrace = AlternateTarget.Location - StartTrace;

				if (Normal(LockTrace) dot Vector(Aim) > LockAim && VSize(LockTrace) < MaxLockRange && FastTrace(AlternateTarget.Location,StartTrace))
				{
					HomingTarget = V;

					if (AIController(Instigator.Controller) != none)
						AIController(Instigator.Controller).Focus = V;

					break;
				}
			}
		}
	}

	bLockedOn = CanLockOnTo(HomingTarget);

	ActivateReticle(bLockedOn);

	if (!bLastLockedOn && bLockedOn)
	{
		if (bBotLock && HomingTarget != None)
			GiveLockedOnNotification(HomingTarget);

		if (PlayerController(Instigator.Controller) != None)
			PlayerController(Instigator.Controller).ClientPlaySound(Sound'WeaponSounds.LockOn');
	}
	else if (bLastLockedOn && !bLockedOn && LastHomingTarget != None)
			GiveLostLockNotification(LastHomingTarget);
}

function LoseLock()
{
	if (bLockedOn && HomingTarget != None)
		GiveLostLockNotification(HomingTarget);

	bLockedOn = false;
}

function GiveLostLockNotification(vehicle V)
{
	if (ONSPlusHoverBike(V) != None)
		ONSPlusHoverBike(V).NotifyPlusEnemyLostLock(Self);
	else if (ONSPlusAttackCraft(V) != None)
		ONSPlusAttackCraft(V).NotifyPlusEnemyLostLock(Self);
	else if (ONSPlusPRV(V) != None)
		ONSPlusPRV(V).NotifyPlusEnemyLostLock(Self);
	else if (ONSPlusRV(V) != None)
		ONSPlusRV(V).NotifyPlusEnemyLostLock(Self);
	else if (ONSPlusMobileAssaultStation(V) != None)
		ONSPlusMobileAssaultStation(V).NotifyPlusEnemyLostLock(Self);
	else if (ONSPlusHoverTank(V) != None)
		ONSPlusHoverTank(V).NotifyPlusEnemyLostLock(Self);
	else if (ONSPlusArtillery(V) != None)
		ONSPlusArtillery(V).NotifyPlusEnemyLostLock(Self);
	else if (ONSPlusDualAttackCraft(V) != None)
		ONSPlusDualAttackCraft(V).NotifyPlusEnemyLostLock(Self);
	else if (ONSPlusShockTank(V) != None)
		ONSPlusShockTank(V).NotifyPlusEnemyLostLock(Self);
	else if (ONSPlusManualGunPawn(V) != None)
		ONSPlusManualGunPawn(V).NotifyPlusEnemyLostLock(Self);
}

function GiveLockedOnNotification(vehicle V)
{
	if (ONSPlusHoverBike(V) != None)
		ONSPlusHoverBike(V).NotifyPlusEnemyLockedOn(Self);
	else if (ONSPlusAttackCraft(V) != None)
		ONSPlusAttackCraft(V).NotifyPlusEnemyLockedOn(Self);
	else if (ONSPlusPRV(V) != None)
		ONSPlusPRV(V).NotifyPlusEnemyLockedOn(Self);
	else if (ONSPlusRV(V) != None)
		ONSPlusRV(V).NotifyPlusEnemyLockedOn(Self);
	else if (ONSPlusMobileAssaultStation(V) != None)
		ONSPlusMobileAssaultStation(V).NotifyPlusEnemyLockedOn(Self);
	else if (ONSPlusHoverTank(V) != None)
		ONSPlusHoverTank(V).NotifyPlusEnemyLockedOn(Self);
	else if (ONSPlusArtillery(V) != None)
		ONSPlusArtillery(V).NotifyPlusEnemyLockedOn(Self);
	else if (ONSPlusDualAttackCraft(V) != None)
		ONSPlusDualAttackCraft(V).NotifyPlusEnemyLockedOn(Self);
	else if (ONSPlusShockTank(V) != None)
		ONSPlusShockTank(V).NotifyPlusEnemyLockedOn(Self);
	else if (ONSPlusManualGunPawn(V) != None)
		ONSPlusManualGunPawn(V).NotifyPlusEnemyLockedOn(Self);
}

defaultproperties
{
	PickupClass=Class'ONSPlusAVRiLPickup'
}