<!-- ####################################################################################
#	UT Server Info by El Muerte [TDS]	(thekiller@cyberjunkie.com)						#
#---------------------------------------------------------------------------------------#
#   This code is released under the GPL (http://www.gnu.org/copyleft/gpl.html)			#
#	If you don't acknoledge this licence you may not use it.							#
#---------------------------------------------------------------------------------------#
#	This is a updated version of the serverinfo.php script, this version is used for	#
#	the design independed server info version that every body can use on their site		#
#	(http://unreal.snt.utwente.nl/serverinfo-offsite.php) for more info.				#
#	This script is almost identicle to the serverinfo.php script, except that it uses	#
#	three functions to display the information:											#
#	writeSTable for the server info														#
#	writeGTable for the game info														#
#	writePTable for the player info														#
#	These function's don't output HTML but they output a bit of JavaScript, the			#
#	parameters received by the functions are converted to JavaScript arrays, and then	#
#	a corresponding JavaScript function is called (eg. jWriteSTable will be called		#
#	from writeSTable)																	#
#	The user has to define these JavaScript functions before they import the script,	#
#	these functions have to process the data and write HTML code to the page.			#
#---------------------------------------------------------------------------------------#
#	usage:																				#
#	<script src="[location to the serverinfi2.php with parameters]"></script>			#
#   serverinfo2.php?ip=<server ip>&port=<server port>[&refresh=<time>][&sort=<sort>]	#
#	refresh and sort are optional														#
#	<sort> values:																		#
#		name	sort by player name														#
#		frag	sort by player frag														#
#		ping	sort by player ping														#
#		team	sort by player team														#
##################################################################################### -->
<?php
define("S_VERSION","256");

function writeSTable($title,$names,$values)
{
	// function jWriteSTable(title,names,values);
	echo "names = new Array(".count($names).");\n";
	for ($i = 0; $i < count($names); $i++)
	{
		echo "names[".$i."] = '".htmlentities(addslashes($names[$i]))."';\n";
	}
	echo "values = new Array(".count($values).");\n";
	for ($i = 0; $i < count($values); $i++)
	{
		if ($i == 1) echo "values[".$i."] = '".addslashes($values[$i])."';\n";
		else echo "values[".$i."] = '".htmlentities(addslashes($values[$i]))."';\n";
	}
	echo "jWriteSTable('".$title."',names,values);\n";
}

function writeGTable($title,$names,$values)
{
	// function jWriteGTable(title,names,values);
	echo "names = new Array(".count($names).");\n";
	for ($i = 0; $i < count($names); $i++)
	{
		echo "names[".$i."] = '".htmlentities(addslashes($names[$i]))."';\n";
	}
	echo "values = new Array(".count($values).");\n";
	for ($i = 0; $i < count($values); $i++)
	{
		echo "values[".$i."] = '".htmlentities(addslashes($values[$i]))."';\n";
	}
	echo "jWriteGTable('".$title."',names,values);\n";
}

function writePTable($title,$names,$frags,$teams,$pings)
{
	// function jWritePTable(title,names,frags,teams,pings);
	echo "names = new Array(".count($names).");\n";
	for ($i = 0; $i < count($names); $i++)
	{
		echo "names[".$i."] = '".htmlentities(addslashes($names[$i]))."';\n";
	}
	echo "frags = new Array(".count($frags).");\n";
	for ($i = 0; $i < count($frags); $i++)
	{
		echo "frags[".$i."] = '".$frags[$i]."';\n";
	}
	echo "teams = new Array(".count($teams).");\n";
	for ($i = 0; $i < count($teams); $i++)
	{
		$theteam = "none";
		if ($teams[$i] == "0") $theteam = "red";
		if ($teams[$i] == "1") $theteam = "blue";
		if ($teams[$i] == "2") $theteam = "green";
		if ($teams[$i] == "3") $theteam = "gold";
		echo "teams[".$i."] = '".$theteam."';\n";
	}
	echo "pings = new Array(".count($pings).");\n";
	for ($i = 0; $i < count($pings); $i++)
	{
		echo "pings[".$i."] = '".$pings[$i]."';\n";
	}
	echo "jWritePTable('".$title."',names,frags,teams,pings);\n";
}

if (count(explode(".",$ip)) <> 4)
{	
	$values0[0] = "Invalid IP, please correct this. Note that you can't use domain names";
	$names0[0] = "";
	$values0[1] = "incorrect IP : <b>".$ip."</b>";
	$names0[1] = "";
	writeSTable("ERROR !",$names0,$values0);
}
else {

if (!is_int(intval($port)))
{	$values0[0] = "Invalid port, please correct this/";
	$names0[0] = "";
	$values0[1] = "incorrect port : <b>".$port."</b>";
	$names0[1] = "";
	writeSTable("ERROR !",$names0,$values0);
}
else {

$cmd = "/home/webmaster/netcat/ncb ".$ip." ".$port;
exec($cmd,$output);

if (count($output) < 1)
{	$values0[0] = "No data was received from the server. The server could be down.";
	$names0[0] = "";
	writeSTable("ERROR !",$names0,$values0);
}
else {

$outA = explode("\\",$output[0]);

for ($i = 0; $i < count($outA); $i++)
{	if ($outA[$i] == "gamever")
	{	$iGamever = $outA[$i+1];
	}
	if ($outA[$i] == "minnetver")
	{	$iMinnetver = $outA[$i+1];
	}
    if ($outA[$i] == "location")
	{	$iLocationr = $outA[$i+1];
	}
    if ($outA[$i] == "hostname")
	{	$iHostname = $outA[$i+1];
	}
    if ($outA[$i] == "hostport")
	{	$iHostport = $outA[$i+1];
	}
    if ($outA[$i] == "maptitle")
	{	$iMaptitle = $outA[$i+1];
	}
    if ($outA[$i] == "gametype")
	{	$iGametype = $outA[$i+1];
	}
    if ($outA[$i] == "numplayers")
	{	$iNumplayers = $outA[$i+1];
	}
    if ($outA[$i] == "maxplayers")
	{	$iMaxplayers = $outA[$i+1];
	}
    if ($outA[$i] == "gamemode")
	{	$iGamemode = $outA[$i+1];
	}
    if ($outA[$i] == "gamever")
	{	$iGamever = $outA[$i+1];
	}
    if ($outA[$i] == "mutators")
	{	$iMutators = $outA[$i+1];
	}
    if ($outA[$i] == "timelimit")
	{	$iTimelimit = $outA[$i+1];
	}
    if ($outA[$i] == "goalteamscore")
	{	$iGoalteamscore = $outA[$i+1];
	}
    if ($outA[$i] == "maxteams")
	{	$iMaxteams = $outA[$i+1];
	}
    if ($outA[$i] == "friendlyfire")
	{	$ifriendlyfire = $outA[$i+1];
	}
    if ($outA[$i] == "AdminName")
	{	$iAdminName = $outA[$i+1];
	}
    if ($outA[$i] == "AdminEMail")
	{	$iAdminEmail = $outA[$i+1];
	}
    if ($outA[$i] == "fraglimit")
	{	$iFraglimit = $outA[$i+1];
	}
    if ($outA[$i] == "botskill")
	{	$iBotskill = $outA[$i+1];
	}
    if ($outA[$i] == "gamestyle")
	{	$iGamestyle = $outA[$i+1];
	}
    if ($outA[$i] == "worldlog")
	{	$iWorldlog = $outA[$i+1];
	}
    for ($j = 0; $j < $iNumplayers; $j++)
    {   if ($outA[$i] == ("player_".$j))
	    {	$iPlayers[$j] = $i;
	    }
    }
	$iPlayers[$iNumplayers] = count($outA);
}

$names1[0] = "name";
$values1[0] = $iHostname;
$names1[1] = "connect to";
$values1[1] = "<a href=\"unreal://".$ip.":".$iHostport."\">".$ip.":".$iHostport."</a>";
$names1[2] = "server version";
$values1[2] = $iGamever;
$names1[3] = "minimal client version";
$values1[3] = $iMinnetver;
$names1[4] = "ngWorldStats logging";
$values1[4] = $iWorldlog;
$names1[5] = "admin name";
$values1[5] = $iAdminName;
$names1[6] = "admin email";
$values1[6] = $iAdminEmail;

writeSTable("server information",$names1,$values1);

unset($names1);
unset($values1);
$names1[0] = "game type";
$values1[0] = $iGametype;
$names1[1] = "map title";
$values1[1] = $iMaptitle;
$names1[2] = "maximum players";
$values1[2] = $iMaxplayers;
$names1[3] = "current players";
$values1[3] = $iNumplayers;
$names1[4] = "game mode";
$values1[4] = $iGamemode;
$names1[5] = "mutators";
$values1[5] = $iMutators;
$names1[6] = "time limit";
$values1[6] = $iTimelimit;
$names1[7] = "frag limit";
$values1[7] = $iFraglimit;
$names1[8] = "team score";
$values1[8] = $iGoalteamscore;
$names1[9] = "maximum teams";
$values1[9] = $iMaxteams;
$names1[10] = "friendly fire";
$values1[10] = $ifriendlyfire;
$names1[11] = "bot skill";
$values1[11] = $iBotskill;
$names1[12] = "game style";
$values1[12] = $iGamestyle;

writeGTable("game information",$names1,$values1);

unset($names1);

for ($i = 0; $i < ($iNumplayers); $i++)
{   for ($j = $iPlayers[$i]; $j < $iPlayers[$i+1]; $j++)
    {   if ($outA[$j] == "player_".$i)
	    {	$names1[$i] = $outA[$j+1];
	    }
        if ($outA[$j] == "frags_".$i)
	    {	$frags[$i] = $outA[$j+1];
	    }
        if ($outA[$j] == "ping_".$i)
	    {	$pings[$i] = $outA[$j+1];
	    }
        if ($outA[$j] == "team_".$i)
	    {	$teams[$i] = $outA[$j+1];
	    }
    }
}


class playerClass
{	
	var $name;
	var $frags;
	var $ping;
	var $team;
}

function sortByName($a, $b)
{	$c = strtolower($a->name);
	$d = strtolower($b->name);
	if ($c == $d)
	{	return 0;
	} else
	{	if ($c > $d)
		{	return 1;
		} else { return -1; }
	}
}

function sortByFrag($a, $b)
{	$c = strtolower($a->frag);
	$d = strtolower($b->frag);
	if ($c == $d)
	{	return 0;
	} else
	{	if ($c < $d)
		{	return 1;
		} else { return -1; }
	}
}

function sortByPing($a, $b)
{	$c = strtolower($a->ping);
	$d = strtolower($b->ping);
	if ($c == $d)
	{	return 0;
	} else
	{	if ($c > $d)
		{	return 1;
		} else { return -1; }
	}
}

function sortByTeam($a, $b)
{	$c = strtolower($a->team);
	$d = strtolower($b->team);
	if ($c == $d)
	{	return 0;
	} else
	{	if ($c > $d)
		{	return 1;
		} else { return -1; }
	}
}

if ($sort != "")
{
	$playerz = array();
	for ($i = 0; $i < count($names1); $i++)
	{	
		$nr = count($playerz);
		$playerz[$nr]->name = $names1[$i];
		$playerz[$nr]->frag = $frags[$i];
		$playerz[$nr]->ping = $pings[$i];
		$playerz[$nr]->team = $teams[$i];
	}

	if (strtolower($sort) == "name")
	{
		usort($playerz, sortByName);
	}
	if (strtolower($sort) == "frag")
	{
		usort($playerz, sortByFrag);
	}
	if (strtolower($sort) == "ping")
	{
		usort($playerz, sortByPing);
	}
	if (strtolower($sort) == "team")
	{
		usort($playerz, sortByTeam);
	}

	unset($names1);
	unset($frags);
	unset($pings);
	unset($teams);
	for ($i = 0; $i < count($playerz); $i++)
	{	
		$names1[$i] = $playerz[$i]->name;
		$frags[$i] = $playerz[$i]->frag;
		$pings[$i] = $playerz[$i]->ping;
		$teams[$i] = $playerz[$i]->team;
	}
}

writePTable("player information",$names1,$frags,$teams,$pings);

}}}
echo "document.writeln('<P><font size=\"-2\" face=\"arial\"><a href=\"http://unreal.snt.utwente.nl/serverinfo-offsite.php\" target=\"_blank\">UT server info script</a> version ".S_VERSION."<BR>programmed by <a href=\"mailto:thekiller@cyberjunkie.com\">El Muerte</a></font><p>');\n";
?>