<!-- ####################################################################################
#	UT Server Info by El Muerte	[TDS] (thekiller@cyberjunkie.com)						#
#---------------------------------------------------------------------------------------#
#   This code is released under the GPL (http://www.gnu.org/copyleft/gpl.html)			#
#	If you don't acknoledge this licence you may not use it.							#
#---------------------------------------------------------------------------------------#
#	The code you see here is the exact code that I used for the server info pages on    #
#	our server homepage (http://unreal.snt.utwente.nl). You can use this code as an	    #
#	example for your own version.														#
#	Here's a little explenation:														#
#	First the script check if the IP parameter is correct, then it checks if the port	#
#	parameter is correct. After that it runs the the shell command (defined by $cmd)	#
#	When it returns data, then that data is parsed and written to the page using the	#
#	WriteTable and the WritePTable function												#
#---------------------------------------------------------------------------------------#
#	usage:																				#
#   serverinfo.php?ip=<server ip>&port=<server port>[&refresh=<time>][&sort=<sort>]		#
#	refresh and sort are optional														#
#	<sort> values:																		#
#		name	sort by player name														#
#		frag	sort by player frag														#
#		ping	sort by player ping														#
#		team	sort by player team														#
##################################################################################### -->

<html>
<head>
	<title>The Drunk Snipers Unreal Tournament servers - [SERVER INFO]</title>
	<?php 
		require 'style.php'; 
		// this is an optional parameter to refresh the page every $refresh seconds
		if ($refresh > 10) echo "<meta http-equiv=\"refresh\" content=\"".$refresh.";\">";
	?>
</head>
<?php 
// import our page's design
require 'body.php';
require 'header.php';
require 'botpicture.php';
?>
<div style="position: absolute; left: 180px; top: 70px; z-index: 10;">

<?php
// let the browser display the already loaded crap
flush();
define("S_VERSION","203");

//change this to the right location of the Netcat shell script (UNIX) \ batch file (NT)
$cmd = "/home/webmaster/netcat/nc_b ".$ip." ".$port;

//this function is used to write the Server info table and the Game info table
function writeTable($title,$names,$values)
{
	echo "<table width=\"430\" border=\"0\" cellspacing=\"0\" cellpadding=\"1\"><tr><td align=\"left\" background=\"images/tablebbg.gif\" colspan=\"2\"><font face=\"Courier New\" size=\"-1\"><b>";
	echo $title;
	echo "</b></font></td></tr>";
	for ($i = 0; $i < count($names); $i++) //go through all names and values
	{
		echo "<tr><td background=\"images/tablecbg.gif\" valign=\"top\" align=\"right\"><font face=\"Arial\" size=\"-1\">&nbsp;";
		echo $names[$i];
		echo "</font></td><td background=\"images/tablecbg.gif\"><font face=\"Arial\" size=\"-1\">";
		echo $values[$i];
		echo "&nbsp;</font></td></tr>";
	}
	echo "</table><P>";
}

//this function is used to write the Player info
function writePTable($title,$names,$frags,$teams,$pings)
{
	global $ip;
	global $port;
	global $refresh;
	echo "<table width=\"430\" border=\"0\" cellspacing=\"0\" cellpadding=\"1\"><tr><td align=\"left\" background=\"images/tablebbg.gif\" colspan=\"4\"><font face=\"Courier New\" size=\"-1\"><b>";
	echo $title;
	echo "</b></font></td></tr>";
	if (count($names) == 0)
	{	echo "<tr><td background=\"images/tablecbg.gif\" valign=\"top\" align=\"center\"><font face=\"Arial\" size=\"-1\">";
		echo "There's not being played on this server";
		echo "</font></td><td background=\"images/tablecbg.gif\" align=\"center\"><font face=\"Arial\" size=\"-1\">&nbsp;";
		echo "</font></td><td background=\"images/tablecbg.gif\" align=\"center\"><font face=\"Arial\" size=\"-1\">&nbsp;";
		echo "</font></td><td background=\"images/tablecbg.gif\" align=\"center\"><font face=\"Arial\" size=\"-1\">&nbsp;";
		echo "</font></td><tr>";
	}
	else
	{
		$newurl = "serverinfo.php?ip=".$ip."&port=".$port; //used for the sort by collumn links
		if ($refresh != "")
		{	$newurl = $newurl."&refresh=".$refresh;
		}
		echo "<tr><td background=\"images/tabledbg.gif\" valign=\"top\" align=\"left\"><font face=\"Arial\" size=\"-2\"><a href=\"".$newurl."&sort=name\">&nbsp;&nbsp;NAME</a></font></td>";
		echo "<td background=\"images/tabledbg.gif\" align=\"center\"><font face=\"Arial\" size=\"-2\"><a href=\"".$newurl."&sort=frag\">FRAGS</a></font></td>";
		echo "<td background=\"images/tabledbg.gif\" align=\"center\"><font face=\"Arial\" size=\"-2\"><a href=\"".$newurl."&sort=team\">TEAM</a></font></td>";
		echo "<td background=\"images/tabledbg.gif\" align=\"center\"><font face=\"Arial\" size=\"-2\"><a href=\"".$newurl."&sort=ping\">PING</a></font></td><tr>";
		for ($i = 0; $i < count($names); $i++)
		{
			echo "<tr><td background=\"images/tablecbg.gif\" valign=\"top\" align=\"left\"><font face=\"Arial\" size=\"-1\">";
			echo htmlentities(addslashes($names[$i]));
			echo "</font></td><td background=\"images/tablecbg.gif\" align=\"center\"><font face=\"Arial\" size=\"-1\">";
			echo $frags[$i];
			echo "</font></td><td background=\"images/tablecbg.gif\" align=\"center\"><font face=\"Arial\" size=\"-1\">";
			$theteam = "none";
			// replace the team codes for the team names
			if ($teams[$i] == "0") $theteam = "red";
			if ($teams[$i] == "1") $theteam = "blue";
			if ($teams[$i] == "2") $theteam = "green";
			if ($teams[$i] == "3") $theteam = "gold";
			echo $theteam;
			echo "</font></td><td background=\"images/tablecbg.gif\" align=\"center\"><font face=\"Arial\" size=\"-1\">";
			echo $pings[$i];
			echo "</font></td><tr>";
		}
	}
	echo "</table><P>";
}

// check for a valid IP (only checks if it contains 4 part devided by 3 dots)
if (count(explode(".",$ip)) <> 4)
{	
	$values0[0] = "Invalid IP, please correct this. Note that you can't use internet names";
	$names0[0] = "";
	$values0[1] = "incorrect IP : <b>".$ip."</b>";
	$names0[1] = "";
	writeTable("ERROR !",$names0,$values0);
}
else {

// check if the port in an integer
if (!is_int(intval($port)))
{	$values0[0] = "Invalid port, please correct this";
	$names0[0] = "";
	$values0[1] = "incorrect port : <b>".$port."</b>";
	$names0[1] = "";
	writeTable("ERROR !",$names0,$values0);
}
else {

//execute the shell script \ batch file
exec($cmd,$output);

//if no data was received then the server might be down
if (count($output) < 1)
{	$values0[0] = "No data was received from the server. The server could be down.";
	$names0[0] = "";
	writeTable("ERROR !",$names0,$values0);
}
else {

//explode the received data to an array
$outA = explode("\\",$output[0]);

//get the info we need from the data
for ($i = 0; $i < count($outA); $i++)
{	if ($outA[$i] == "gamever")
	{	$iGamever = $outA[$i+1];
	}
	if ($outA[$i] == "minnetver")
	{	$iMinnetver = $outA[$i+1];
	}
    if ($outA[$i] == "location")
	{	$iLocationr = $outA[$i+1];
	}
    if ($outA[$i] == "hostname")
	{	$iHostname = $outA[$i+1];
	}
    if ($outA[$i] == "hostport")
	{	$iHostport = $outA[$i+1];
	}
    if ($outA[$i] == "maptitle")
	{	$iMaptitle = addslashes($outA[$i+1]);
	}
    if ($outA[$i] == "gametype")
	{	$iGametype = addslashes($outA[$i+1]);
	}
    if ($outA[$i] == "numplayers")
	{	$iNumplayers = $outA[$i+1];
	}
    if ($outA[$i] == "maxplayers")
	{	$iMaxplayers = $outA[$i+1];
	}
    if ($outA[$i] == "gamemode")
	{	$iGamemode = $outA[$i+1];
	}
    if ($outA[$i] == "gamever")
	{	$iGamever = $outA[$i+1];
	}
    if ($outA[$i] == "mutators")
	{	$iMutators = addslashes($outA[$i+1]);
	}
    if ($outA[$i] == "timelimit")
	{	$iTimelimit = $outA[$i+1];
	}
    if ($outA[$i] == "goalteamscore")
	{	$iGoalteamscore = $outA[$i+1];
	}
    if ($outA[$i] == "maxteams")
	{	$iMaxteams = $outA[$i+1];
	}
    if ($outA[$i] == "friendlyfire")
	{	$ifriendlyfire = $outA[$i+1];
	}
    if ($outA[$i] == "AdminName")
	{	$iAdminName = addslashes($outA[$i+1]);
	}
    if ($outA[$i] == "AdminEMail")
	{	$iAdminEmail = $outA[$i+1];
	}
    if ($outA[$i] == "fraglimit")
	{	$iFraglimit = $outA[$i+1];
	}
    if ($outA[$i] == "botskill")
	{	$iBotskill = $outA[$i+1];
	}
    if ($outA[$i] == "gamestyle")
	{	$iGamestyle = $outA[$i+1];
	}
    if ($outA[$i] == "worldlog")
	{	$iWorldlog = $outA[$i+1];
	}
    for ($j = 0; $j < $iNumplayers; $j++)
    {   if ($outA[$i] == ("player_".$j))
	    {	$iPlayers[$j] = $i;
	    }
    }
	$iPlayers[$iNumplayers] = count($outA);
}

// fill up the Server info table
$names1[0] = "name : ";
$values1[0] = $iHostname;
$names1[1] = "connect to : ";

// replace the IP's of our server address to a nice host name
if ($ip == "130.89.238.28")
{	$values1[1] = "<a href=\"unreal://unreal.snt.utwente.nl:".$iHostport."\">unreal.snt.utwente.nl:".$iHostport."</a>";
}
else {
	if ($ip == "130.89.232.53")
	{	$values1[1] = "<a href=\"unreal://unreal.student.utwente.nl:".$iHostport."\">unreal.student.utwente.nl:".$iHostport."</a>";
	}
	else {
		$values1[1] = "<a href=\"unreal://".$ip.":".$iHostport."\">".$ip.":".$iHostport."</a>";
	}
}
$names1[2] = "server version : ";
$values1[2] = $iGamever;
$names1[3] = "minimal client version : ";
$values1[3] = $iMinnetver;
$names1[4] = "ngWorldStats logging : ";
$values1[4] = $iWorldlog;
$names1[5] = "admin name : ";
$values1[5] = $iAdminName;
$names1[6] = "admin email : ";
$values1[6] = $iAdminEmail;

// print the server info table
writeTable("SERVER INFORMATION",$names1,$values1);
// and flush the new HTML code so that the browser will display it
flush();

// clear the tables and fill in the Game info
unset($names1);
unset($values1);
$names1[0] = "game type : ";
$values1[0] = $iGametype;
$names1[1] = "map title : ";
$values1[1] = $iMaptitle;
$names1[2] = "maximum players : ";
$values1[2] = $iMaxplayers;
$names1[3] = "current players : ";
$values1[3] = $iNumplayers;
$names1[4] = "game mode : ";
$values1[4] = $iGamemode;
$names1[5] = "mutators : ";
$values1[5] = $iMutators;
$names1[6] = "time limit : ";
$values1[6] = $iTimelimit;
$names1[7] = "frag limit : ";
$values1[7] = $iFraglimit;
$names1[8] = "team score : ";
$values1[8] = $iGoalteamscore;
$names1[9] = "maximum teams : ";
$values1[9] = $iMaxteams;
$names1[10] = "friendly fire : ";
$values1[10] = $ifriendlyfire;
$names1[11] = "bot skill : ";
$values1[11] = $iBotskill;
$names1[12] = "game style : ";
$values1[12] = $iGamestyle;

writeTable("GAME INFORMATION",$names1,$values1);
flush();

unset($names1);

// fill in the player info
for ($i = 0; $i < ($iNumplayers); $i++)
{   for ($j = $iPlayers[$i]; $j < $iPlayers[$i+1]; $j++)
    {   if ($outA[$j] == "player_".$i)
	    {	$names1[$i] = $outA[$j+1];
	    }
        if ($outA[$j] == "frags_".$i)
	    {	$frags[$i] = $outA[$j+1];
	    }
        if ($outA[$j] == "ping_".$i)
	    {	$pings[$i] = $outA[$j+1];
	    }
        if ($outA[$j] == "team_".$i)
	    {	$teams[$i] = $outA[$j+1];
	    }
    }
}

// player class only used with a sort option
class playerClass
{	
	var $name;
	var $frags;
	var $ping;
	var $team;
}

// misc sort functions
function sortByName($a, $b)
{	$c = strtolower($a->name);
	$d = strtolower($b->name);
	if ($c == $d)
	{	return 0;
	} else
	{	if ($c > $d)
		{	return 1;
		} else { return -1; }
	}
}

function sortByFrag($a, $b)
{	$c = strtolower($a->frag);
	$d = strtolower($b->frag);
	if ($c == $d)
	{	return 0;
	} else
	{	if ($c < $d)
		{	return 1;
		} else { return -1; }
	}
}

function sortByPing($a, $b)
{	$c = strtolower($a->ping);
	$d = strtolower($b->ping);
	if ($c == $d)
	{	return 0;
	} else
	{	if ($c > $d)
		{	return 1;
		} else { return -1; }
	}
}

function sortByTeam($a, $b)
{	$c = strtolower($a->team);
	$d = strtolower($b->team);
	if ($c == $d)
	{	return 0;
	} else
	{	if ($c > $d)
		{	return 1;
		} else { return -1; }
	}
}

// if a sort command has been given then sort it.
if ($sort != "")
{
	// convert the multiple arrays to one array for sorting..
	$playerz = array();
	for ($i = 0; $i < count($names1); $i++)
	{	
		$nr = count($playerz);
		$playerz[$nr]->name = $names1[$i];
		$playerz[$nr]->frag = $frags[$i];
		$playerz[$nr]->ping = $pings[$i];
		$playerz[$nr]->team = $teams[$i];
	}

	if (strtolower($sort) == "name")
	{
		usort($playerz, sortByName);
	}
	if (strtolower($sort) == "frag")
	{
		usort($playerz, sortByFrag);
	}
	if (strtolower($sort) == "ping")
	{
		usort($playerz, sortByPing);
	}
	if (strtolower($sort) == "team")
	{
		usort($playerz, sortByTeam);
	}

	unset($names1);
	unset($frags);
	unset($pings);
	unset($teams);
	for ($i = 0; $i < count($playerz); $i++)
	{	
		$names1[$i] = $playerz[$i]->name;
		$frags[$i] = $playerz[$i]->frag;
		$pings[$i] = $playerz[$i]->ping;
		$teams[$i] = $playerz[$i]->team;
	}
}
// write the player info
writePTable("PLAYER INFORMATION",$names1,$frags,$teams,$pings);
flush();

}}}
echo "<font size=\"-2\" face=\"arial\">UT server info script version ".S_VERSION."<BR>programmed by El Muerte</font><p>";
?></div>
</body></html>