<!--- UT Query PHP script v1.01 --->
<!--- By Almar Joling, 2003 --->
<!--- www.persistentrealities.com --->

<?
	//Show all errors...
	error_reporting(E_ALL);
	
	//Include configuration file
	include 'config.php';

//Various functions:
		function GetItemInfo ($itemname, $itemchunks) {

		  $retval = "N/A";
		  for ($i = 0; $i < count($itemchunks); $i++) {
			 //Found this item
			 if (strcasecmp($itemchunks[$i], $itemname) == 0) $retval = $itemchunks[$i+1];
		  }

		  //Return value
		  return  $retval;
		}

		function  GetColorValue($teamid) {
			$retval = "#DBDBDB";
			$colors = array("#FF8787","#0196FF","#90FF87","#FEFF91");
			
			if ($teamid < 4) $retval = $colors[$teamid];

			//Return value
			return $retval;	
			
		}

		function GetMinutes($seconds) {
			$timemins = intval($seconds / 60);
			$timesecs = ($seconds % 60);
			
			$Reqlength = 2; //Amount of digits we need
			if ($Reqlength-strlen($timemins) > 0) $timemins = str_repeat("0",($Reqlength-strlen($timemins))) . $timemins;
			if ($Reqlength-strlen($timesecs) > 0) $timesecs = str_repeat("0",($Reqlength-strlen($timesecs))) . $timesecs;
			return $timemins . ":" . $timesecs;
		}

		
		function GetServerName() {
			global $servername;

			//custom servername?
			if (strlen($servername) > 0) {
				return $servername;
			} else {
				return "UT Server query in PHP";
			}
		}
//End functions

?>

<html>
	<title><?=GetServerName()?></title>
	
	<head>
	<style type="text/css">
		<!--
			/* Classes every, so we do not mess-up someone else's layout */
			.tableclass { font-family: Verdana, Arial, Helvetica, sans-serif; font-size: xx-small; font-style: normal; font-weight: normal; color: #000000 }
			.copyfont { font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 7pt;}
			.formfont { font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 10pt; }

		-->
	</style>
	</head>

	<body >

<?
	//Check if the query form is enabled. Only show if it's true (see config file)
	If ($showform == true)
		{
?>
				<form  name="frmselect" action="index.php" METHOD="GET">
					<table class="formfont" width="25%" border="0" cellspacing="0" cellpadding="0" align="center">
						<tr> 
							<td width="12%">Server:</td>
							<td width="88%"><input name="txtip" type="text" value="<?=$defaultip?>"></td>
							</tr>
						<tr> 
						<td width="12%">Port:</td>
						<td width="88%"><input name="portnum" type="text" value="<?=$defaultport?>"></td>
						</tr>
					<tr> 
					  <td width="12%"></td>
					  <td width="88%"><input type="submit" name="submit"></td>
					</tr>
				  </table>
				  <br/>
				  <br/>
				</form>

			  <? if ($showlicence == true) echo ($licence); ?>
<?
		}
				//Do not autoquery?
				if ($autoquery == false) return;


				$txtip = $defaultip;
				$txtportnum = $defaultport;

				if (strlen($_GET['txtip']) > 0) {
					//Get variables from the URL
					$txtip = $_GET['txtip'];
					$txtportnum = $_GET['portnum'];
				}


				//If there is no IP, return (exit)
				if (strlen($txtip) == 0) return;

?>

				<table width="74%" border="0" cellspacing="0" cellpadding="0" align="center">
					<tr> 
						<td> 
<?





							//Open UDP socket to server
							$sock = fsockopen("udp://" . $txtip, $txtportnum, $errno, $errstr,4);

							//Check if we have a socket open, if not, display error message
							if (!$sock) {
								echo "$errstr ($errno)<br/>\n";
								exit;
							}

							{
								fputs($sock,"\\status\\\player_property\Health\\\game_property\ElapsedTime\\\game_property\RemainingTime\\");

								$gotfinal = False;
								$data = "";

								//Set starttime, for possible loop expiration, so the server doesn't get too much work.
								$starttime = Time();

								//Loop until final packet has been received.
								while(!($gotfinal == True || feof($sock))) {

									//Get data
									if(($buf = fgetc($sock)) == FALSE) {
										usleep(100); // wait for additional data? :S whatever
								}

								//Add to databuffer
								$data .= $buf;

								//Check if final item (queryid) has been received
								if (strpos($data,"final\\") != False) {
								$gotfinal = True;
							}

								//Protect webserver against massive loop.
								if ((Time() - $starttime) > 5) {
									echo "Data receiving took too long. Cancelled.<P>";
									$gotfinal = True;
								}
							}

							//Close socket
							fclose ($sock);

							//Split chunks by \
							$chunks = split('[\]', $data);

?>

					<b><font face="Verdana, Arial, Helvetica, sans-serif">Results (<?=$txtip . ":" . $txtportnum?>) <?=$servername?> <br/></font></b>
					<hr noshade size="1">
<?
	
					//Check if the map screenshots are enabled. Only show if it's true (see config file)
					If ($showscreenshot == true)
						{

						$mapfile = "images/" . getiteminfo("mapname",$chunks) . ".jpg";
						
						if (file_exists($mapfile)) {
					?>
							<img src="<? echo $mapfile;?>" align="right"/>
					<?
						} else {
					?>
							<img src="images\none.gif" align="right"/>
					<?
						}
					}

					//Check if the server info should be visible. Only show if it's true (see config file)
					If ($showserverinfo == true)
						{
?>

						  <table width="<?=$tablewidth;?>" border="0" cellspacing="0" cellpadding="0" align="default" class="tableclass">
							<tr> 
							  <td width="<?=$typewidth;?>">Gameversion:</td>
							  <td width="<?=$valuewidth;?>"> 
								<?=getiteminfo("gamever",$chunks);?>
							  </td>
							</tr>
							<tr> 
							  <td width="<?=$typewidth;?>">Min. required version:</td>
							  <td width="<?=$valuewidth;?>"> 
								<?=getiteminfo("minnetver",$chunks);?>
							  </td>
							</tr>
							<tr> 
							  <td width="<?=$typewidth;?>">Name:</td>
							  <td width="<?=$valuewidth;?>"> 
								<?=getiteminfo("hostname",$chunks);?>
							  </td>
							</tr>
							<tr> 
							  <td width="<?=$typewidth;?>">Server port:</td>
							  <td width="<?=$valuewidth;?>"> 
								<?=getiteminfo("hostport",$chunks);?>
							  </td>
							</tr>
							<tr> 
							  <td width="<?=$typewidth;?>">Mapname:</td>
							  <td width="<?=$valuewidth;?>"> 
								<?=getiteminfo("mapname",$chunks);?>
							  </td>
							</tr>
							<tr> 
							  <td width="<?=$typewidth;?>">Gametype:</td>
							  <td width="<?=$valuewidth;?>"> 
								<?=getiteminfo("gametype",$chunks);?>
							  </td>
							</tr>
							<tr> 
							  <td width="<?=$typewidth;?>">Number of players:</td>
							  <td width="<?=$valuewidth;?>"> 
								<?=getiteminfo("numplayers",$chunks);?>
							  </td>
							</tr>
							<tr> 
							  <td width="<?=$typewidth;?>">Max players:</td>
							  <td width="<?=$valuewidth;?>"> 
								<?=getiteminfo("maxplayers",$chunks);?>
							  </td>
							</tr>
							<tr> 
							  <td width="<?=$typewidth;?>">ngWorldStats:</td>
							  <td width="<?=$valuewidth;?>"> 
								<?=ucfirst(getiteminfo("worldlog",$chunks));?>
							  </td>
							</tr>
							<tr> 
							  <td width="<?=$typewidth;?>">Password required:</td>
							  <td width="<?=$valuewidth;?>"> 
								<?=getiteminfo("password",$chunks);?>
							  </td>
							</tr>
							<tr> 
							  <td width="<?=$typewidth;?>">Timelimit:</td>
							  <td width="<?=$valuewidth;?>"> 
								<?=getiteminfo("timelimit",$chunks);?>
							  </td>
							</tr>
							<tr> 
							  <td width="<?=$typewidth;?>">Team score goal:</td>
							  <td width="<?=$valuewidth;?>"> 
								<?=getiteminfo("goalteamscore",$chunks);?>
							  </td>
							</tr>
							<tr> 
							  <td width="<?=$typewidth;?>">Min. players:</td>
							  <td width="<?=$valuewidth;?>"> 
								<?=getiteminfo("minplayers",$chunks);?>
							  </td>
							</tr>
							<tr> 
							  <td width="<?=$typewidth;?>">Max teams:</td>
							  <td width="<?=$valuewidth;?>"> 
								<?=getiteminfo("maxteams",$chunks);?>
							  </td>
							</tr>
							<tr> 
							  <td width="<?=$typewidth;?>">Balance teams:</td>
							  <td width="<?=$valuewidth;?>"> 
								<?=getiteminfo("balanceteams",$chunks);?>
							  </td>
							</tr>
							<tr> 
							  <td width="<?=$typewidth;?>">Friendly fire:</td>
							  <td width="<?=$valuewidth;?>"> 
								<?=getiteminfo("friendlyfire",$chunks);?>
							  </td>
							</tr>
							<tr> 
							  <td width="<?=$typewidth;?>">Tournament mode:</td>
							  <td width="<?=$valuewidth;?>"> 
								<?=getiteminfo("tournament",$chunks);?>
							  </td>
							</tr>
							<tr> 
							  <td width="<?=$typewidth;?>">Gamestyle:</td>
							  <td width="<?=$valuewidth;?>"> 
								<?=getiteminfo("gamestyle",$chunks);?>
							  </td>
							</tr>
							<tr> 
							  <td width="<?=$typewidth;?>">Admin name:</td>
							  <td width="<?=$valuewidth;?>"> 
								<?=getiteminfo("adminname",$chunks);?>
							  </td>
							</tr>
							<tr> 
							  <td width="<?=$typewidth;?>">Admin email:</td>
							  <td width="<?=$valuewidth;?>"> 
								<?=getiteminfo("adminemail",$chunks);?>
							  </td>
							</tr>
							<tr> 
							  <td width="<?=$typewidth;?>">Remaining Time:</td>
							  <td width="<?=$valuewidth;?>"> 
								<?=GetMinutes(getiteminfo("RemainingTime",$chunks))  . " mins";?>
							  </td>
							</tr>
							<tr> 
							  <td width="<?=$typewidth;?>">Elapsed Time:</td>
							  <td width="<?=$valuewidth;?>"> 
								<?=GetMinutes(getiteminfo("ElapsedTime",$chunks)) . " mins";?>
							  </td>
							</tr>
						  </table>

					<?
						//End server info enabled check
						}
					?>
					<p> 

					<table width="<?=$Playertablewidth;?>" border="0" cellspacing="0" cellpadding="0" class="tableclass">

				<?
						//Check if the playerlist should be visible. Only show if it's true (see config file)
						If ($showplayers == true)
							{
				?>
								<tr> 
								  <td width="<?=$typewidth;?>">Player:</td>
								  <td width="<?=$typewidth;?>">Frags:</td>
								  <td width="<?=$typewidth;?>">Team:</td>
								  <td width="<?=$typewidth;?>">Ping:</td>
								  <td width="<?=$typewidth;?>">NGStats:</td>
								  <td width="<?=$typewidth;?>">Health:</td>
								</tr>
								<? 
						
								//Get number of players
								$numplayers = getiteminfo("numplayers",$chunks);



								//Loop through all players
								for ($i = 0; $i < $numplayers; $i++) {
									$actualid = $i;
									$itemx = $i+1;

									$rowcolor = "#FFFFFF";

									//Check if colors are enabled. If not, simply exit right here
									if ($usecolors == true) {
										$rowcolor = GetColorValue(getiteminfo("team_" . $actualid,$chunks));
								}
				?>
								<tr> 
								  <td width="<?=$typewidth;?>" bgcolor="<?=$rowcolor;?>"> 
									<?=getiteminfo("player_" . $actualid,$chunks);?>
								  </td>
								  <td width="<?=$typewidth;?>" bgcolor="<?=$rowcolor;?>"> 
									<?=getiteminfo("frags_" . $actualid,$chunks);?>
								  </td>
								  <td width="<?=$typewidth;?>" bgcolor="<?=$rowcolor;?>"> 
									<?=getiteminfo("team_" . $actualid,$chunks);?>
								  </td>
								  <td width="<?=$typewidth;?>" bgcolor="<?=$rowcolor;?>"> 
									<?=getiteminfo("ping_" . $actualid,$chunks);?>
								  </td>
								  <td width="<?=$typewidth;?>" bgcolor="<?=$rowcolor;?>"> 
									<?=ucfirst(getiteminfo("ngsecret_" . $actualid,$chunks));?>
								  </td>
								  <td width="<?=$typewidth;?>" bgcolor="<?=$rowcolor;?>"> 
									<?=getiteminfo("Health_" . $itemx,$chunks);?>
								  </td>
								</tr>
				<?
							}
						}
				?>
						<tr> 
					</table>
				<?
					}
				?>

			  <br/>
			  <hr size="1" noshade>
			  <div class="copyfont">UT PHP Server Query v1.2, by Almar Joling. (c) <?=date("Y")?><br/>
			  <a href="http://www.persistentrealities.com">www.persistentrealities.com</a> 


			  </div>
		    </td>
		  </tr>
		</table>
	</BODY>
</HTML>