// Smiling Monsters Boost Handler
// By Ti-Lung 19/09/2007
// Version 1.1 (20070919)
// Created for the Smiling Monsters community
// http://www.smiling-monsters.com/community/
// Request by Hermskii http://www.unrealadmin.org/forums/showthread.php?t=25095

class SMoBoostHandler expands Mutator
	config(SMoIdleHandler);

// config variable
var config bool bDefaultBoost;
var config bool bUseNoLockMethod;

// Internal variable
var bool bInitialized;
var int NoBoost[32];

function PreBeginPlay()
{
	local int i;

	if ( bInitialized )
		return;

	bInitialized = True;
	Log("Mutator initialized.",'SMoBoostHandler');

	Level.Game.RegisterDamageMutator(Self);

	// If boost default is off initialize array
	if( !bDefaultBoost )
	{
		for( i=0; i<32; i++ )
		{
			NoBoost[i] = 1;
		}
	}

	if ( NextMutator != None )
		NextMutator.PreBeginPlay();
}

function Mutate(string MutateString, PlayerPawn Sender)
{
    if ( NextMutator != None )
		NextMutator.Mutate(MutateString, Sender);

	if ( Caps(MutateString) == "BOOSTON" )
	{
		NoBoost[Sender.PlayerReplicationInfo.PlayerID] = 0;
		Sender.ClientMessage("SMoBoostHandler: Boost is on.");
	}

	if ( Caps(MutateString) == "BOOSTOFF" )
	{
		NoBoost[Sender.PlayerReplicationInfo.PlayerID] = 1;
		Sender.ClientMessage("SMoBoostHandler: Boost is off.");
	}
}

function MutatorTakeDamage( out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
	local vector NullVector;

	if( Victim != none && InstigatedBy != none)
	{
		if( Victim != InstigatedBy ) // Not damage to self
		{
			if( bool( NoBoost[Victim.PlayerReplicationInfo.PlayerID] ) )
			{
				if( InstigatedBy.Isa('PlayerPawn') || InstigatedBy.Isa('Bot') )
				{
					// Set no collision with actor to stop lockdown.
					// Proper solution is to modify addvelocity function of
					// player.
					if( bUseNoLockMethod )
						Victim.SetCollision( false, true, true );

					NullVector = Vect(0,0,0);

					// Stop boost effect for normal weapon
					Momentum = NullVector;
					// Stop throw player when hit by warhead explosion
					Victim.Velocity = NullVector;
					// Set damage 0 so no red flash
					ActualDamage = 0;
				}
				else
				{
						Victim.SetCollision( true, true, true );
				}
			}
		}
	}

	if ( NextDamageMutator != None )
		NextDamageMutator.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType );
}

defaultproperties
{
	bDefaultBoost=True
	bUseNoLockMethod=True
}
