// Smiling Monsters The Target mutator - Kill the Target or Be Killed !
// By Ti-Lung 22/08/2007
// Version 1.0 - 20070822
// http://www.smiling-monsters.com/community/

class SMoTheTarget extends Mutator;

#exec OBJ LOAD File="..\System\BotPack.u" // UCC does not find DeathMatchPlus :/

// class variable
var bool bInitialized;
var int TheTargetPlayerID;

// Inherited function

// Stop add mutator more than twice
function AddMutator(Mutator M)
{
	if ( M != Self )
		Super.AddMutator(M);
}

function PreBeginPlay()
{
	local Actor Other;

	if ( bInitialized)
		return;

	// Remove powerup from map
	foreach AllActors( class 'Actor', Other )
	{
		if(
			Other.IsA('Armor2')
			|| Other.IsA('ThighPads')
			|| Other.IsA('UT_ShieldBelt')
			|| Other.IsA('UT_Invisibility')
			|| Other.IsA('UT_Jumpboots')
			|| Other.IsA('UDamage')
			|| Other.IsA('WarHeadLauncher')
		)
		{
			if( Inventory(Other).MyMarker != None)
			{
				Other.Destroy();
			}
		}
    }

	TheTargetPlayerID = -1;

	bInitialized = True;
	Log("Mutator initialized. ",'SMoTheTarget');

	if ( NextMutator != None )
		NextMutator.PostBeginPlay();
}

// Keep Powerup in player inventory
function bool AlwaysKeep(Actor Other)
{
	if (
		Other.IsA('Armor2')
		|| Other.IsA('ThighPads')
		|| Other.IsA('UT_ShieldBelt')
		|| Other.IsA('UT_Invisibility')
		|| Other.IsA('UT_Jumpboots')
		|| Other.IsA('UDamage')
		|| Other.IsA('Warheadlauncher')
	)
		return true;

	Super.AlwaysKeep(Other);

	return false;
}

function ScoreKill(Pawn Killer, Pawn Other)
{
	local Pawn P, NewTarget;

	// First killer become the Target
	if( TheTargetPlayerID == -1 )
	{
		TheTargetPlayerID = Killer.PlayerReplicationInfo.PlayerID;
		MakeTheTarget( Killer );
		AnnounceTheTarget( Killer.PlayerReplicationInfo.PlayerName );
	}

	// If Target suicide choose random player to become New Target
	if(
			Other == Killer
			&& Killer.PlayerReplicationInfo.PlayerID == TheTargetPlayerID
	)
	{
		TheTargetPlayerID = SelectRandomPlayerID();
		NewTarget = PlayerIDToPawn( TheTargetPlayerID );
		MakeTheTarget( NewTarget );
		AnnounceTheTarget( NewTarget.PlayerReplicationInfo.PlayerName );
	}

	// Killer of the Target become new Target
	if(
			Other != Killer
			&& Killer.PlayerReplicationInfo.PlayerID != TheTargetPlayerID
			&& Other.PlayerReplicationInfo.PlayerID == TheTargetPlayerID
	)
	{
		Killer.PlayerReplicationInfo.Score += 5; // Bonus frag
		TheTargetPlayerID = Killer.PlayerReplicationInfo.PlayerID;
		MakeTheTarget( Killer );
		AnnounceTheTarget( Killer.PlayerReplicationInfo.PlayerName );
	}

	if ( NextMutator != None )
		NextMutator.ScoreKill(Killer, Other);
}

// Custom function

// Give all weapon with max ammo and powerup to TheTarget
function MakeTheTarget( Pawn P )
{
	local Inventory Inv;
	local Pickup PU;
	local Weapon Weap;

	// Give all weapon
	DeathMatchPlus(Level.Game).GiveWeapon( PlayerPawn(P), "BotPack.Impacthammer" );
	DeathMatchPlus(Level.Game).GiveWeapon( PlayerPawn(P), "BotPack.DoubleEnforcer" );
	DeathMatchPlus(Level.Game).GiveWeapon( PlayerPawn(P), "BotPack.UT_BioRifle" );
	DeathMatchPlus(Level.Game).GiveWeapon( PlayerPawn(P), "BotPack.ShockRifle" );
	DeathMatchPlus(Level.Game).GiveWeapon( PlayerPawn(P), "BotPack.Ripper" );
	DeathMatchPlus(Level.Game).GiveWeapon( PlayerPawn(P), "BotPack.UT_FlakCannon" );
	DeathMatchPlus(Level.Game).GiveWeapon( PlayerPawn(P), "BotPack.PulseGun" );
	DeathMatchPlus(Level.Game).GiveWeapon( PlayerPawn(P), "BotPack.Minigun2" );
	DeathMatchPlus(Level.Game).GiveWeapon( PlayerPawn(P), "BotPack.UT_Eightball" );
	DeathMatchPlus(Level.Game).GiveWeapon( PlayerPawn(P), "BotPack.SniperRifle" );
	DeathMatchPlus(Level.Game).GiveWeapon( PlayerPawn(P), "BotPack.Warheadlauncher" );

	// Set all weapon to max ammo
	for ( Inv=P.inventory; Inv!=None; Inv=Inv.inventory )
	{
		Weap = Weapon(Inv);
		if ( (Weap != None) && (Weap.AmmoType != None) )
			Weap.AmmoType.AmmoAmount = Weap.AmmoType.MaxAmmo;
	}

	// Give powerup
	GivePickup( P, "Botpack.Armor2" );
	GivePickup( P, "Botpack.ThighPads" );
	GivePickup( P, "Botpack.UT_ShieldBelt" );
	GivePickup( P, "Botpack.UT_Invisibility" );
	GivePickup( P, "Botpack.UT_Jumpboots" );
	GivePickup( P, "Botpack.UDamage" );
	GivePickup( P, "Botpack.HealthPack" );
}

// Special function to simulate Pickup
function GivePickup( Pawn P, string ItemClass )
{
	local class<TournamentPickup> PUClass;
	local Pickup PU;

	PUClass = class<TournamentPickup>(DynamicLoadObject(ItemClass, class'Class'));

	PU = Spawn( PUClass );

	if( PU != none )
	{
		PU.Touch( P ); // Touch player
		PU.Destroy();
	}
}

// Announce the target to all player
function AnnounceTheTarget( string Playername )
{
	local Pawn P;

	P = Level.PawnList;

	while ( P != none )
	{
		if( P.IsA('PlayerPawn') ) // Give message only to real player
		{
			if( P.PlayerReplicationInfo.PlayerID != TheTargetPlayerID )
			{
				PlayerPawn(P).ClearProgressMessages();
				PlayerPawn(P).SetProgressTime(3);
				PlayerPawn(P).SetProgressMessage( PlayerName@"is now the Target!",0 );
				P.ClientMessage( PlayerName@"is now the Target!" );
			}
			else
			{
				PlayerPawn(P).ClearProgressMessages();
				PlayerPawn(P).SetProgressTime(3);
				PlayerPawn(P).SetProgressMessage( "You are now the Target! Now go kill!",0 );
				P.ClientMessage( "You are now the Target! Now go kill!" );
			}
		}

		P = P.nextPawn;
	}
}

function int SelectRandomPlayerID()
{
	return rand(
		DeathMatchPlus(Level.Game).NumPlayers
		+ DeathMatchPlus(Level.Game).NumBots
		+ 1
	);
}

function Pawn PlayerIDToPawn( int PlayerID )
{
	local Pawn P;

	P = Level.PawnList;

	while ( P != none )
	{
		if( P.IsA('PlayerPawn') || P.IsA('Bot') )
		{
			if( P.PlayerReplicationInfo.PlayerID == PlayerID )
				return P;
		}

		P = P.nextPawn;
	}
}
