// Smiling Monsters FPH Alarm
// By Ti-Lung 25/09/2007
// Version 1.4 (20070925)
// Created for the Smiling Monsters community
// http://www.smiling-monsters.com/community/

class SMoFPHAlarm expands Mutator
	config( SMoFPHAlarm );

// config variable
var config bool
	bBroadCast,
	bDebugMode,
	bKick,
	bBan,
	bSimulate,
	bUseFPHAverage,
	bUseOutsideLog,
	bUseServerLog,
	bDetectFPH,
	bDetectFPHEndGame,
	bDetectHeadShot,
	bDetectHitscan,
	bDetectTeleporterKill,
	bDetectSuicide,
	bDetectTeamKill,
	bDetectViewRotation,
	bLogFPHEndGame,
	bLogSaveInfoEndGame,
	bLogSaveInfoLeaveGame;

var config int
	FPHLimitNormal,
	FPHLimitInstaGib,
	SuicideLimit,
	TeamKillLimit,
	NumFragVerify,
	NumPlayerVerify,
	MaxFPH,
	TeleporterKillLimit,
	TeleporterDistance;

// Internal variable
const ver = "14";

struct PlayerInfo
{
	var Pawn Player;
	var string PlayerName;
	var string PlayerIP;
	var int StartTime;
	var int Score;
	var int Deaths;
	var int FPH;
	var int FPHAverage;
	var int FPHCount;
	var int FPHTotal;
	var int TeleporterKillCount;
	var int SuicideCount;
	var int TeamKillCount;
	var int NumHeadShot;
	var int NumHitscanKill;
	var int NumProjectileKill;
	var int RotationCount;
	var int TotalDeltaPitch;
	var int TotalDeltaYaw;
	var int TotalDeltaRoll;
	var int DeltaPitchAverage;
	var int DeltaYawAverage;
	var rotator LastViewRotation;
};

var bool bInitialized, bGameStart, bLogStart, bNewPlayer;
var int FPHLimit, GameType, LastNumPlayers, NumTeleporter;
var float GameStartTime, GameTime;
var FPHAlarmLog LogClass;
var name ModName;
var PlayerInfo PlayerSaveInfo[32];
var string MapName, LoginName, LoginTime, LeftMessage;
var string IPSave[99];
var vector TeleporterLocationList[24];

/* PREBEGINPLAY */
function PreBeginPlay()
{
	local bool bDisable, bInstaGib;
	local int i;
	local Mutator M;
	local string TempString;
	local Teleporter T;

	if ( !bInitialized )
		bInitialized = True;

	// Initialize name of mod for log
	TempString = "SMoFPHAlarm_v" $ ver;
	SetPropertyText( "ModName" , TempString );

	log("Mutator initialized.", ModName );

	// This will make ini file if it does not exist
	SaveConfig();

	// Verify if mutator is not on dedicated server
	if( Level.netMode != NM_DedicatedServer )
	{
		log("This mutator is for dedicated server", ModName );
		bDisable = true;
	}

	if( InServerPackage( TempString ) )
	{
		log( "This is serverside mod. Please do not add to serverpackage!", ModName );
		bDisable = true;
	}

	if( bDisable )
	{
		log( "Mutator destroy" , ModName );
		Self.Destroy();
	}

	Level.Game.RegisterDamageMutator( self );
	Level.Game.RegisterMessageMutator( self );

	if( FindMutator( class'Botpack.InstaGibDM' ) )
		bInstagib = true;

	if( FindMutator( class'Botpack.SniperArena' ) )
		bInstagib = true;

	if( !bInstagib )
	{
		FPHLimit = FPHLimitNormal;
		log( "No detect InstaGib/SniperArena mutator" , ModName );
		log( "Automatic set to FPHLimitNormal ("
			$ FPHLimitNormal $ ")" , ModName );
	}
	else
	{
		FPHLimit = FPHLimitInstaGib; // Set instagib fphlimit
		log( "Detect InstaGib/SniperArena mutator" , ModName );
		log( "Automatic set to FPHLimitInstagib ("
			$ FPHLimitInstagib $ ")" , ModName );
	}

	// Gametype
	if( Level.Game.Class == class'Botpack.DeathMatchPlus' )
		GameType = 1;
	if( Level.Game.Class == class'Botpack.TeamGamePlus' )
		GameType = 2;

	foreach AllActors( class'Teleporter', T )
	{
		if( i >= ArrayCount( TeleporterLocationList ) )
		{
			log("Error: Teleporter location exceed array size !", ModName );
			break;
		}

		TeleporterLocationList[i] = T.Location;

		i++;
	}

	NumTeleporter = i+1;

	LeftMessage =  Level.Game.default.LeftMessage;

	Enable('Tick');

	Super.PreBeginPlay();
}

/* Custom function */

function bool FindMutator( class MutatorClass )
{
	local Mutator M;

	if( MutatorClass != none )
	{
		for(
			M = Level.Game.BaseMutator;
			M != none;
			M = M.NextMutator
		)
		{
			if( M.Class == MutatorClass )
				return true;
		}

		return false;
	}

	return false;
}

function bool InServerPackage( string ServerPackageName )
{
	local string ServerPackages;

	if( ServerPackageName != "" )
	{
		ServerPackages =
			CAPS( ConsoleCommand(
				"get ini:Engine.Engine.GameEngine ServerPackages" ) );

		if( InStr( CAPS( ServerPackages ) , CAPS( ServerPackageName ) ) != -1 )
			return true;

		return false;
	}

	return false;
}

/* End of custom function */

function Tick( float DeltaTime )
{
	if( !bGameStart )
	{
		bGameStart = GameStart(); // Check if game start
	}
}

function ModifyLogin( out class<playerpawn> SpawnClass, out string Portal,
	out string Options )
{
	LoginName = Left( level.game.ParseOption ( Options, "Name"), 20);
	LoginTime = GetShortAbsoluteTime();

	bNewPlayer = true;

	Super.ModifyLogin(SpawnClass, Portal, Options);
}

function ModifyPlayer( Pawn Other )
{
	local bool bFindPlayer;
    local Pawn P;
    local int i, PID;
	local float LevelTime, TimeInGame, GameTime;
    local string IP;

	// bool set in ModifyLogin
	if( bNewPlayer )
	{
   		if ( Other != none )
    	{
			if( Other.PlayerReplicationInfo.PlayerName == LoginName )
			{
				bNewPlayer = false;

				PID = Other.PlayerReplicationInfo.PlayerID;

				PlayerSaveInfo[ PID ].Player = Other;
				PlayerSaveInfo[ PID ].PlayerName =
					Other.PlayerReplicationInfo.PlayerName;
				PlayerSaveInfo[ PID ].PlayerIP =
					PlayerPawn( Other ).GetPlayerNetworkAddress();
				PlayerSaveInfo[ PID ].StartTime =
					Other.PlayerReplicationInfo.StartTime;

				LevelTime = Level.TimeSeconds;

				if( !bLogStart )
					Output("* INITIALIZE LOG *");

				Output( "* PLAYER ENTER *" );
				Output( "Server Time:" @ LoginTime );
				Output( "Name:" @ PlayerSaveInfo[ PID ].PlayerName );
				Output( "IP:" @ PlayerSaveInfo[ PID ].PlayerIP );
				Output( "NetSpeed:"
					@ PlayerPawn( Other ).Player.CurrentNetSpeed );
				Output( "Number of Players:"
					@ Level.Game.NumPlayers
					@ "(" $ DeathMatchPlus(Level.Game).Numbots @ "bots)" );
				Output( "Player list:" @ PlayerList() );
			}
		}
	}

	Super.ModifyPlayer( Other );
}

function bool MutatorBroadcastMessage( Actor Sender, Pawn Receiver,
	out coerce string Msg, optional bool bBeep, out optional name Type )
{
	local bool bStop;
	local int PID, LevelTime, TimeInGame;
	local string PlayerName, LeaveTime;

	if( Type == 'Event' )
	{
		if( Sender.IsA('TournamentGameInfo') )
		{
			if( InStr( CAPS( Msg ), CAPS( LeftMessage ) ) != -1 )
			{
				LeaveTime = GetShortAbsoluteTime();
				LevelTime = Level.TimeSeconds;
				PlayerName = left( Msg, Instr( Msg, " " ) );

				for( PID = 0; PID < 32 && !bStop ; PID++ )
				{
					// Find playername in save array
					if( PlayerSaveInfo[ PID ].PlayerName == PlayerName )
					{
						bStop = true;

						Output( "* PLAYER LEAVE *" );
						Output( "Server Time:" @ LeaveTime );
						Output( "Name:" @  PlayerName );
						Output( "Name:" @  PlayerSaveInfo[ PID ].PlayerIP );

						TimeInGame =
							LevelTime - PlayerSaveInfo[ PID ].StartTime;

						Output( "Game Time:"
							@ ConvertSeconds( GetGameTime() ) );
						Output( "Time In Game:"
							@ ConvertSeconds( TimeInGame ) );
						Output( "Number of Players:"
							@ Level.Game.NumPlayers
							@ "(" $ DeathMatchPlus(Level.Game).Numbots @ "bots)" );
						Output( "Player list:" @ PlayerList() );

						if( bLogSaveInfoLeaveGame )
							Output( GetSaveInfo( PID ) );

						Output( "Reset player save info" );
						ResetPlayerSaveInfo( PID );
					}
				}
			}
		}
	}

	Super.MutatorBroadcastMessage( Sender, Receiver, Msg, bBeep, Type );

	return true;
}

/* Custom function */

function ResetPlayerSaveInfo( int PlayerID )
{
	PlayerSaveInfo[ PlayerID ].Player = none;
	PlayerSaveInfo[ PlayerID ].PlayerName = "";
	PlayerSaveInfo[ PlayerID ].PlayerIP = "";
	PlayerSaveInfo[ PlayerID ].StartTime = 0;
	PlayerSaveInfo[ PlayerID ].Score = 0;
	PlayerSaveInfo[ PlayerID ].Deaths = 0;
	PlayerSaveInfo[ PlayerID ].FPH = 0;
	PlayerSaveInfo[ PlayerID ].FPHCount = 0;
	PlayerSaveInfo[ PlayerID ].FPHTotal = 0;
	PlayerSaveInfo[ PlayerID ].TeleporterKillCount = 0;
	PlayerSaveInfo[ PlayerID ].SuicideCount = 0;
	PlayerSaveInfo[ PlayerID ].TeamKillCount = 0;
	PlayerSaveInfo[ PlayerID ].NumHeadShot = 0;
	PlayerSaveInfo[ PlayerID ].NumHitscanKill = 0;
	PlayerSaveInfo[ PlayerID ].NumProjectileKill = 0;
	PlayerSaveInfo[ PlayerID ].RotationCount = 0;
	PlayerSaveInfo[ PlayerID ].TotalDeltaPitch = 0;
	PlayerSaveInfo[ PlayerID ].TotalDeltaYaw = 0;
	PlayerSaveInfo[ PlayerID ].TotalDeltaRoll = 0;
	PlayerSaveInfo[ PlayerID ].DeltaPitchAverage = 0;
	PlayerSaveInfo[ PlayerID ].DeltaYawAverage = 0;
	PlayerSaveInfo[ PlayerID ].LastViewRotation = rot( 0, 0, 0);
}

function bool GameStart()
{
	if( GetGameTime() > 0 ) // Detect start of game
	{
		GameStartTime = Level.TimeSeconds;

		Output( "* START GAME *" );
		Output( "Server Time:" @ GetShortAbsoluteTime() );
		Output( "Game Start Time:" @ ConvertSeconds( GameStartTime ) );

		MapName = string( Level.Game.GameReplicationInfo );
		MapName = left( MapName, Instr( MapName, "." ) );

		Output( "Map name:" @ MapName );

		return true;
	}
}

/* End of custom function */

function MutatorTakeDamage( out int ActualDamage, Pawn Victim,
	Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum,
		name DamageType)
{
	local bool bStop;
	local int i, DeltaDistance, PID, KillerScore;
	local rotator TempRotator;
	local vector PlayerLocation, TeleporterLocation;

	if( InstigatedBy != none && Victim != none )
	{
		PID = PawnToPlayerID( InstigatedBy );

		PlayerLocation = InstigatedBy.Location;

		if( ( Victim.Health - ActualDamage) <= 0 ) // Frag
		{
			TempRotator = PlayerPawn( InstigatedBy ).ViewRotation;

			// Does not work
			if( bDetectFPH )
			{
				if( InstigatedBy != Victim )
				{
					PlayerSaveInfo[ PID ].FPH = PlayerFPH( InstigatedBy );

					PlayerSaveInfo[ PID ].FPHCount++;

					PlayerSaveInfo[ PID ].FPHTotal += PlayerSaveInfo[ PID ].FPH;

					PlayerSaveInfo[ PID ].FPHAverage =
						PlayerSaveInfo[ PID ].FPHTotal
							/ PlayerSaveInfo[ PID ].FPHCount;

					if( PlayerSaveInfo[ PID ].FPH > MaxFPH )
					{
						MaxFPH = PlayerSaveInfo[ PID ].FPH;

						Output( "New MaxFPH:" @ MaxFPH );
						// Save config variable to ini file
						SaveConfig();
					}

					if( PlayerSaveInfo[ PID ].Score
							>= NumFragVerify && !bLogFPHEndGame )
					{
						if( !bUseFPHAverage )
						{
							if( PlayerSaveInfo[ PID ].FPH >= FPHLimit )
							{
								// 0: FPH
								// 1: Suicide
								// 2: Portal kill
								// 3: Team kill
								Alarm( InstigatedBy, 0 );
							}
						}
						else
						{
							if( PlayerSaveInfo[ PID ].FPHAverage >= FPHLimit )
							{
								// 0: FPH
								// 1: Suicide
								// 2: Portal kill
								// 3: Team kill
								Alarm( InstigatedBy, 0 );
							}
						}
					}
				}
			}

			if( bDetectTeleporterKill )
			{
				for( i = 0;
					i < NumTeleporter && !bStop;
					i++ )
				{
					if( PlayerProximity
							( TeleporterLocationList[ i ],
								PlayerLocation,
									TeleporterDistance ) )
					{
						// Killer weapon is impact hammer
						if( DamageType == 'impact' )
						{
							PlayerSaveInfo[ PID ].TeleporterKillCount++;

							if( PlayerSaveInfo[ PID ].TeleporterKillCount
									>= TeleporterKillLimit )
							{
								// 0: FPH
								// 1: Suicide
								// 2: Portal kill
								// 3: Team kill
								Alarm( InstigatedBy, 2 );

								PlayerSaveInfo[ PID ].TeleporterKillCount = 0;
							}
						}

						// Save teleporter location for admin?
						// TeleporterLocation = TeleportLocation[ i ];
						bStop = true;
					}
				}
			}

			// Does not detect console suicide (@see: PreventDeath function)
			// Test on server: ok
			if( bDetectSuicide )
			{
				if( InstigatedBy == Victim )
				{
					// Negative score in team deathmatch
					if( PlayerSaveInfo[ PID ].Score <= 0 && GameType == 2 )
					{
						PlayerSaveInfo[ PID ].SuicideCount++;

						if( PlayerSaveInfo[ PID ].SuicideCount
								>= SuicideLimit )
						{
							// DebugLog("Suicide detect");

							// 0: FPH
							// 1: Suicide
							// 2: Portal kill
							// 3: Team kill
							Alarm( Victim, 1 );

							PlayerSaveInfo[ PID ].SuicideCount = 0;
						}
					}
				}
			}

			if( bDetectTeamKill )
			{
				// Teamkill
				if( ( InstigatedBy != Victim )
						&& ( InstigatedBy.PlayerReplicationInfo.Team
							== Victim.PlayerReplicationInfo.Team ) )
				{
					PlayerSaveInfo[ PID ].TeamKillCount++;

					if( PlayerSaveInfo[ PID ].TeamKillCount
							>= TeamKillLimit && GameType == 2 )
					{
						// 0: FPH
						// 1: Suicide
						// 2: Portal kill
						// 3: Team kill
						Alarm( InstigatedBy, 3 );

						PlayerSaveInfo[ PID ].TeamKillCount = 0;
					}
				}
			}

			if( bDetectHeadShot )
			{
				// Detect sniper headshot
				// Test on server: ok
			    if( DamageType == 'Decapitated'
					&& InstigatedBy.Weapon.IsA('SniperRifle') )
						PlayerSaveInfo[ PID ].NumHeadShot++;
			}

			if( bDetectHitScan )
			{
				// Count hitscan and nonhitscan kill
				// Test on server: ok

				switch( DamageType )
				{
					case 'shot':
						PlayerSaveInfo[ PID ].NumHitscanKill++;
						break;
					case 'jolted':
						if( InstigatedBy.bFire != 0 )
							PlayerSaveInfo[ PID ].NumHitscanKill++;
						break;
					case 'zapped':
						PlayerSaveInfo[ PID ].NumHitscanKill++;
						break;

					default:
						PlayerSaveInfo[ PID ].NumProjectileKill++;
				}
			}

			if( bDetectViewRotation )
			{
				PlayerSaveInfo[ PID ].RotationCount++;

				if( PlayerSaveInfo[ PID ].RotationCount >= 1 )
				{
					// Use other statistic method to detect abnormality?
					PlayerSaveInfo[ PID ].TotalDeltaPitch +=
						Abs( PlayerSaveInfo[ PID ].LastViewRotation.Pitch
							- TempRotator.Pitch );
					PlayerSaveInfo[ PID ].TotalDeltaYaw +=
						Abs( PlayerSaveInfo[ PID ].LastViewRotation.Yaw
							- TempRotator.Yaw );
					PlayerSaveInfo[ PID ].TotalDeltaRoll +=
						Abs( PlayerSaveInfo[ PID ].LastViewRotation.Roll
							- TempRotator.Roll );

					PlayerSaveInfo[ PID ].DeltaPitchAverage =
						PlayerSaveInfo[ PID ].TotalDeltaPitch
						/ PlayerSaveInfo[ PID ].RotationCount;
					PlayerSaveInfo[ PID ].DeltaYawAverage =
						PlayerSaveInfo[ PID ].TotalDeltaYaw
						/ PlayerSaveInfo[ PID ].RotationCount;
				}

				PlayerSaveInfo[ PID ].LastViewRotation = TempRotator;
			}
		}
	}

	Super.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation,
		Momentum, DamageType );
}


function ScoreKill(Pawn Killer, Pawn Other)
{
	local int PID;

	if( Killer.PlayerReplicationInfo != none && Killer.bIsPlayer )
	{
		PID = PawnToPlayerID( Killer );

		PlayerSaveInfo[ PID ].Score = Killer.PlayerReplicationInfo.Score;

		PlayerSaveInfo[ PID ].Deaths = Killer.DieCount;
	}

	if( Other.PlayerReplicationInfo != none && Other.bIsPlayer)
	{
		PID = PawnToPlayerID( Other );

		PlayerSaveInfo[ PID ].Score = Other.PlayerReplicationInfo.Score;

		PlayerSaveInfo[ PID ].Deaths = Other.DieCount;
	}

	Super.ScoreKill(Killer, Other);
}

/* Custom function */

function bool PlayerProximity( vector ActorLocation, vector PlayerLocation,
	int Distance )
{
	local int DeltaDistance;

	if( ActorLocation != vect( 0, 0, 0 ) && PlayerLocation != vect( 0, 0, 0 ) )
	{
		DeltaDistance = VSize( PlayerLocation - ActorLocation );

		if( DeltaDistance <= Distance )
			return true;
	}

	return false;
}

/* End custom function */

function bool PreventDeath(Pawn Killed, Pawn Killer, name damageType,
	vector HitLocation)
{
	local int Score, PID;

	// Test on server: ok
	if( bDetectSuicide )
	{
		PID = PawnToPlayerID( Killed );

		if( ( Killer == none )
			&& ( damageType == 'Suicided' ) )
		{
			if( PlayerSaveInfo[ PID ].Score <= 0 && GameType == 2 )
			{
				PlayerSaveInfo[ PID ].SuicideCount++;

				if( PlayerSaveInfo[ PID ].SuicideCount
					>= SuicideLimit )
				{
					// 0: FPH
					// 1: Suicide
					// 2: Portal kill
					// 3: Team kill
					Alarm( Killed, 1 );

					PlayerSaveInfo[ PID ].SuicideCount = 0;
				}
			}
		}
	}

	Super.PreventDeath(Killed,Killer, damageType,HitLocation);
}

function Mutate( string MutateString, PlayerPawn Sender )
{
	local int i;

	if ( Sender.PlayerReplicationInfo.bAdmin ) // Player must be admin
	{
		if ( Caps(MutateString) == "ALARMSHOWINFO" )
		{
			for( i = 0; i < 32; i++ )
			{
				if( PlayerSaveInfo[ i ].Player != none )
				{
					Sender.ClientMessage( GetSaveInfo( i ) );
				}
			}
		}
	}

	Super.Mutate( MutateString, Sender );
}

/* Custom function */

function string GetSaveInfo( int PlayerID )
{
	local string TempString;

	TempString =
		"PID:" $ PlayerID
		@ "Nam:" $ PlayerSaveInfo[ PlayerID ].PlayerName
		@ "IP:" $ PlayerSaveInfo[ PlayerID ].PlayerIP
		@ "T:"
			$ ConvertSeconds
				(Level.TimeSeconds
					- PlayerSaveInfo[ PlayerID ].StartTime)
		@ "Sco/Dea:"
			$ PlayerSaveInfo[ PlayerID ].Score
			$ "/"
			$ PlayerSaveInfo[ PlayerID ].Deaths
		@ "FPH:" $ PlayerSaveInfo[ PlayerID ].FPH
		@ "FPHAv:" $ PlayerSaveInfo[ PlayerID ].FPHAverage
		@ "TpK:" $ PlayerSaveInfo[ PlayerID ].TeleporterKillCount
		@ "Sui:" $ PlayerSaveInfo[ PlayerID ].SuicideCount
		@ "TK:" $ PlayerSaveInfo[ PlayerID ].TeamKillCount
		@ "HS:" $ PlayerSaveInfo[ PlayerID ].NumHeadShot
		@ "Hit/NHit:"
			$ PlayerSaveInfo[ PlayerID ].NumHitscanKill
			$ "/"
			$ PlayerSaveInfo[ PlayerID ].NumProjectileKill
		@ "DPAv:" $ PlayerSaveInfo[ PlayerID ].DeltaPitchAverage
		@ "DYAv:" $ PlayerSaveInfo[ PlayerID ].DeltaYawAverage;

	return TempString;
}

function float PlayerFPH( Pawn Player )
{
	local float FPH, PlayerTime, PlayerKillCount;

	if( Player != none )
	{
		// Use killcount and not score
		PlayerKillCount = Player.KillCount;

		PlayerTime =
			Level.TimeSeconds - Player.PlayerReplicationInfo.StartTime;

		FPH = ( PlayerKillCount / PlayerTime ) * 3600;

		return FPH;
	}
}

function Alarm( Pawn Player, int AlarmNumber )
{
	local bool bKickResult;
	local int TimeInGame, PlayerID;

	PlayerID = Player.PlayerReplicationInfo.PlayerID;

	if( AlarmNumber >= 0)
	{
		switch( AlarmNumber )
		{
			case 0:
				Output( "* EXCEED FPH LIMIT *" );
				break;
			case 1:
				Output( "* EXCEED SUICIDE LIMIT *" );
				break;
			case 2:
				Output( "* EXCEED PORTAL KILL LIMIT *" );
				break;
			case 3:
				Output( "* EXCEED TEAM KILL LIMIT *" );
				break;
		}

		Output( "Server Time:" @ GetShortAbsoluteTime() );
		Output( "Game Time:" @ ConvertSeconds( GetGameTime() ) );
		Output( "Name:" @ Player.PlayerReplicationInfo.PlayerName );
		Output( "IP:" @ PlayerPawn( Player ).GetPlayerNetworkAddress() );
		Output( "Time In Game:" @
			ConvertSeconds(
				Level.TimeSeconds - PlayerSaveInfo[ PlayerID ].StartTime
			)
		);

		switch( AlarmNumber )
		{
			case 0:
				Output( "FPH:" @ PlayerSaveInfo[ PlayerID ].FPH );
				Output( "FPH Average:" @
					PlayerSaveInfo[ PlayerID ].FPHAverage );
				Output( "FPH Limit:" @ FPHLimit );
				break;
			case 1:
				Output( "Suicide:" @ PlayerSaveInfo[ PlayerID ].SuicideCount );
				Output( "Suicide Limit:" @ SuicideLimit );
				break;
			case 2:
				Output( "Portal Kill:" @
					PlayerSaveInfo[ PlayerID ].TeleporterKillCount );
				Output( "Portal Kill Limit:" @ TeleporterKillLimit );
				break;
			case 3:
				Output( "Team Kill:" @
					PlayerSaveInfo[ PlayerID ].TeamKillCount );
				Output( "Team Kill Limit:" @ TeamKillLimit );
				break;
		}

		if( bBan )
			Output( "* BAN PLAYER *" );
		else
			Output( "* KICK PLAYER *" );

		if( !bSimulate )
			bKickResult = KickBanPlayer( Player, bKick, bBan );
		else
			bKickResult = false;

		if( !bSimulate )
			ResetPlayerSaveInfo( PlayerID );

		if( !bKickResult )
			Output( "Error: Kick fail!" @ "(bSimulate is" @ bSimulate $ ")" );
	}
}

/* End of custom function */

function bool HandleEndGame()
{
	local int i, PID;
	local Pawn P;

	Output("* END GAME *");
	Output( "Server Time" @ GetShortAbsoluteTime() );
	Output( "Game Time:" @ ConvertSeconds( GetGameTime() ) );

	if( bDetectFPH && bLogFPHEndGame )
	{
	    P = Level.PawnList;

	    while ( P != none )
	    {
			PID = P.PlayerReplicationInfo.PlayerID;

			PlayerSaveInfo[ PID ].FPH = PlayerFPH( P );

			if( !bUseFPHAverage )
			{
				if( PlayerSaveInfo[ PID ].FPH >= FPHLimit )
				{
					// 0: FPH
					// 1: Suicide
					// 2: Portal kill
					// 3: Team kill
					Alarm( P, 0 );
				}
			}
			else
			{
				if( PlayerSaveInfo[ PID ].FPHAverage >= FPHLimit )
				{
					// 0: FPH
					// 1: Suicide
					// 2: Portal kill
					// 3: Team kill
					Alarm( P, 0 );
				}
			}
	    }
	}

	if( bLogSaveInfoEndGame )
	{
		for( PID = 0; PID < 32; PID++ )
		{
			if( PlayerSaveInfo[ i ].Player != none )
				Output( GetSaveInfo( PID ) );
		}
	}

	StopLog();

	Super.HandleEndGame();

	return false;
}

event Destroyed()
{
	StopLog();

	Super.Destroyed();
}

/* Custom function */

function bool KickBanPlayer(
	Pawn Player,
	bool bKick,
	optional bool bBan
)
{
	local bool bKickResult;
	local string IP;

	if( Player != none )
	{
		if( bKick || bBan ) // Kick also when bBan is true
		{
			IP = PlayerPawn( Player ).GetPlayerNetworkAddress();
			IP = left( IP, Instr( IP, ":" ) );

			if( bBan )
			{
				BanIP( IP ); // Ban player
			}

			// Destroy Pawn and disconnect player
			bKickResult = Player.Destroy();

			return bKickResult;
		}
	}

	return false;
}

// calculate the time after game start
function int GetGameTime()
{
	if( Level.Game != none )
	{
		if( Level.Game.GameReplicationInfo.RemainingTime > 0 )
			return
				( TournamentGameReplicationInfo(Level.Game.GameReplicationInfo).TimeLimit*60 )
				- Level.Game.GameReplicationInfo.RemainingTime;
		else
			return Level.Game.GameReplicationInfo.ElapsedTime;
	}

	return 0;
}

// Central function for output of message
function Output( string LogString )
{
	if( bUseServerLog )
		log( LogString, ModName );

	if( bUseOutsideLog )
	{
		if( !bLogStart )
			StartLog();

		if ( LogClass != none )
			LogClass.LogEventString( string( ModName ) $ ":" @ LogString );
	}

	if( bBroadcast )
		BroadcastMessage( LogString );
}

function DebugLog( string LogString )
{
	if( bDebugMode )
		Output( LogString );
}

function StartLog()
{
	LogClass = spawn( class'FPHAlarmLog' );

	if ( LogClass != none )
	{
		Log("Start outside log", ModName );
		LogClass.StartLog();
	}

	bLogStart = True;
}

function StopLog()
{
	if ( LogClass != None)
	{
		LogClass.StopLog();
		LogClass.Destroy();
		LogClass = None;
	}
}

function string PlayerList( optional bool bShowBots )
{
    local Pawn P;
	local string PlayerList;

    P = Level.PawnList;

    while ( P != none )
    {
        if( P.IsA('PlayerPawn') && !P.PlayerReplicationInfo.bIsSpectator )
			PlayerList = PlayerList $ P.PlayerReplicationInfo.PlayerName $ " ";

		if( P.IsA('Bot') && bShowBots )
			PlayerList =
				PlayerList $ P.PlayerReplicationInfo.PlayerName $ "(Bot) ";

        P = P.nextPawn;
    }

	return PlayerList;
}

// return Pawn with PlayerID
function Pawn PlayerIDToPawn( int PlayerID )
{
    local Pawn P;

    P = Level.PawnList;

    while ( P != none )
    {
        if( P.IsA('PlayerPawn') || P.IsA('Bot') )
        {
            if( P.PlayerReplicationInfo.PlayerID == PlayerID )
                return P;
        }

        P = P.nextPawn;
    }

	return P;
}

// Return playerid of a pawn
function int PawnToPlayerID( Pawn aPawn )
{
	local Pawn P;

	P = Level.PawnList;

	while ( P != none )
	{
		if( P.IsA('PlayerPawn') || P.IsA('Bot') )
		{
			if( P == aPawn )
				return P.PlayerReplicationInfo.PlayerID;
		}

		P = P.nextPawn;
	}

	return -1; // Should not happen
}

// Ban function from HiddenAdmin
function bool BanIP( string IPString )
{
	local bool bStop;
	local int i;

	if( Level.Game != none )
	{
		if ( Level.Game.CheckIPPolicy( IPString ) )
		{
			for (i=0; i < 50 && !bStop ; i++)
			{
				if ( Level.Game.IPPolicies[i] == "" )
					bStop = true; // exit iterator
			}

			if ( i < 50 )
			{
				Level.Game.IPPolicies[i] = "DENY,"$IPString;
				Level.Game.SaveConfig();

				return true;
			}
		}
	}

	return false;
}

function string ConvertSeconds( float TimeSeconds )
{
	local int Minutes, Seconds;
	local string TimeString;

	Minutes = TimeSeconds / 60;

	if( Minutes < 10 )
		TimeString = "0" $ ( Minutes ) $ "m";
	else
		TimeString = string( Minutes ) $ "m";

	Seconds = TimeSeconds - ( Minutes * 60 );

	if( Seconds < 10 )
		TimeString = TimeString $ "0" $ ( Seconds ) $ "s";
	else
		TimeString = TimeString $ ( Seconds ) $  "s";

	return TimeString;
}

// Server time from StatLog
function string GetShortAbsoluteTime()
{
	local string AbsoluteTime;

	AbsoluteTime = string(Level.Year);

	if (Level.Month < 10)
		AbsoluteTime = AbsoluteTime$".0"$Level.Month;
	else
		AbsoluteTime = AbsoluteTime$"."$Level.Month;

	if (Level.Day < 10)
		AbsoluteTime = AbsoluteTime$".0"$Level.Day;
	else
		AbsoluteTime = AbsoluteTime$"."$Level.Day;

	if (Level.Hour < 10)
		AbsoluteTime = AbsoluteTime$".0"$Level.Hour;
	else
		AbsoluteTime = AbsoluteTime$"."$Level.Hour;

	if (Level.Minute < 10)
		AbsoluteTime = AbsoluteTime$".0"$Level.Minute;
	else
		AbsoluteTime = AbsoluteTime$"."$Level.Minute;

	if (Level.Second < 10)
		AbsoluteTime = AbsoluteTime$".0"$Level.Second;
	else
		AbsoluteTime = AbsoluteTime$"."$Level.Second;

	return AbsoluteTime;
}

/* End of custom function */

defaultproperties
{
	bBan=false
	bDebugMode=True
	bKick=true
	bBroadcast=true
	bDetectFPH=true
	bDetectHeadShot=true
	bDetectHitscan=true
	bDetectTeleporterKill=true
	bDetectSuicide=true
	bDetectTeamKill=true
	bDetectViewRotation=true
	bLogFPHEndGame=true
	bLogSaveInfoEndGame=true
	bLogSaveInfoLeaveGame=true
	bSimulate=true
	bUseFPHAverage=true
	bUseOutsideLog=true
	bUseServerLog=true
	FPHLimitNormal=550
	FPHLimitInstaGib=1900
	SuicideLimit=7
	NumFragVerify=10
	NumPlayerVerify=5
	MaxFPH=0
	TeleporterDistance=200
	TeleporterKillLimit=3
	TeamKillLimit=10
}
