class sgScore extends UnrealCTFScoreBoard;

function DrawTrailer( canvas Canvas )
{
    local int Hours, Minutes, Seconds;
    local float XL, YL, YOffset, XOffset;
    local PlayerPawn PlayerOwner;
    local int i, nPC;
    local string sNames[32];
    local PlayerReplicationInfo PRI;
    local font CanvasFont;

    Super.DrawTrailer( Canvas );

    sNames[0]="Siege Spectators";
    sNames[1]="______________";
    nPC+=2;
    for ( i=0; i<32; i++ )
        if (PlayerPawn(Owner).GameReplicationInfo.PRIArray[i] != None)
	{
            PRI = PlayerPawn(Owner).GameReplicationInfo.PRIArray[i];
            if ( (PRI.bIsSpectator || PRI.bWaitingPlayer ) && PRI.PlayerName!="Player")
            {
                sNames[nPC]=PRI.PlayerName;
                nPC++;
            }
	}
    if (nPC==2) 
	sNames[nPC++]="None";

    Canvas.bCenter = true;
    Canvas.StrLen("Test", XL, YL);
    Canvas.DrawColor = WhiteColor;

    XOffset = 0; //Canvas.ClipX/2;
    YOffset = Canvas.ClipY - (4 * YL) -4;

    CanvasFont = Canvas.Font;
    Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
    YOffset-= (nPC * YL);

    for ( i=0; i<nPC; i++ )
    {
        Canvas.StrLen(sNames[i], XL, YL);
    	Canvas.SetPos(XOffset, YOffset + (i * YL));
    	//Canvas.SetPos(XOffset-(XL/2), YOffset + (i * YL));
	Canvas.DrawText(sNames[i], True);
    }
    Canvas.bCenter = false;
    Canvas.Font=CanvasFont;
}


defaultproperties
{
}
