//=============================================================================
// sgProtector.
// * Revised by 7DS'Lust
//=============================================================================
class sgProtector extends sgBuilding;

var() sound         FireSound;
var() class<Projectile>
                    ProjectileType;

simulated event Timer()
{
	Super.Timer();
	
	if ( SCount > 0 || Role != ROLE_Authority )
        return;
    
    if ( ShouldFire() )
		Shoot(FindEnemy());
}

function Shoot(Pawn target)
{
	local vector    fireSpot,
                    projStart;
	local Projectile
                    proj;
    local rotator   shootDirection;

	if ( target == None || VSize(target.Location - Location) > SightRadius )
        return;

    shootDirection = rotator(target.Location - Location);

	PlaySound(FireSound, SLOT_None, 0.75);

	if ( Grade > 2 )
	{
	    fireSpot = target.Location + FMin(1, 1.1 + 0.6 * FRand()) *
          target.Velocity * VSize(target.Location - Location) /
          ProjectileType.default.Speed;

		if ( !FastTrace(fireSpot, ProjStart) )
			fireSpot = 0.5 * (fireSpot + target.Location);

		shootDirection = Rotator(fireSpot - Location);
	}

	Spawn(ProjectileType, Self,, Location, shootDirection);
}

function bool ShouldFire()
{
    return ( FRand() < 0.05 + Grade/20 );
}

function bool ShouldAttack(Pawn enemy)
{
    local UT_Invisibility inv;
    local bool bInv;


    if ( enemy == None )
        return false;
    if ( !FastTrace(enemy.Location) )
        return false;
    if (enemy.bIsPlayer && enemy.PlayerReplicationInfo != None && enemy.PlayerReplicationInfo.Team != Team)
    {
    	inv = UT_Invisibility(enemy.FindInventoryType(class'UT_Invisibility'));
    	if (inv != None && inv.charge > 160) return false;
    }
    if ( sgBuilding(enemy) != None )
    {
        if ( sgBuilding(enemy).Team == Team || sgBuilding(enemy).Energy < 0 )
            return false;
    }
    else if ( enemy.PlayerReplicationInfo == None ||
      enemy.PlayerReplicationInfo.Team == Team ||
      enemy.Health <= 10 ||
      !enemy.bProjTarget)
        return false;
    return true;
}

function Pawn FindEnemy()
{
    local Pawn p, target;

    SightRadius = 1000 + 1750*Grade;

    foreach RadiusActors(class'Pawn', p, SightRadius)
        if ( ShouldAttack(p) && (target == None ||
          VSize(p.Location - Location) < VSize(target.Location - Location)) )
            target = p;

    return target;
}

defaultproperties
{
    FireSound=Sound'sgMedia.SFX.sgProtShot'
    ProjectileType=Class'sgProtProj'
    BuildingName="Protector"
    BuildCost=100
    UpgradeCost=40
    MaxEnergy=1200.00
    Model=LodMesh'Botpack.Crystal'
    DSofMFX=1.20
    NumOfMFX=3
    MFXrotX=(Pitch=20000,Yaw=20000,Roll=20000),
    SightRadius=3000.00
    MultiSkins(0)=Texture'sgMedia.GFX.sgProtSpriteT0'
    MultiSkins(1)=Texture'sgMedia.GFX.sgProtSpriteT1'
    MultiSkins(2)=Texture'sgMedia2.GFX.sgProtSpriteT2'
    MultiSkins(3)=Texture'sgMedia2.GFX.sgProtSpriteT3'
}
