//=============================================================================
// sgNukeRing.
// * Revised by 7DS'Lust
//=============================================================================
class sgNukeRing extends Effects;

var() float ds;
var bool done1, done2;

replication
{
	// Things the server should send to the client.
	reliable if ( Role == ROLE_Authority )
		done1, done2, ds;
}

simulated function Tick(float deltaTime)
{
	local sgNukeRing r;

	if ( !done1 && LifeSpan < 6.5)
	{
		r = Spawn(class'sgNukeRing',,, Location+vector(rotation)*256);
		r.ds = 320;
		r.done1 = true;
		r.done2 = true;
		r = Spawn(class'sgNukeRing',,, Location-vector(rotation)*256);
		r.ds = 320;
		r.done1 = true;
		r.done2 = true;
		done1 = true;
	}
	else if( !done2 && LifeSpan < 5)
	{
		r = Spawn(Class'sgnukering',,,Location+vector(rotation)*640);
		r.ds = 280;
		r.done1 = true;
		r.done2 = true;
		r = Spawn(Class'sgnukering',,,Location-vector(rotation)*640);
		r.ds = 280;
		r.done1 = true;
		r.done2 = true;
		done2 = true;
	}

	DrawScale = 10 + (ds * (1 - LifeSpan / default.LifeSpan));
	ScaleGlow = LifeSpan/default.LifeSpan;
	AmbientGlow = 128 * ScaleGlow;
}

defaultproperties
{
    ds=350.00
    RemoteRole=2
    LifeSpan=8.00
    Rotation=(Pitch=-16375,Yaw=0,Roll=0),
    DrawType=2
    Style=3
    Mesh=LodMesh'Botpack.UTsRingex'
    DrawScale=350.00
    AmbientGlow=128
    bUnlit=True
    MultiSkins=Texture'sgMedia.GFX.sgNukeRing'
}
