//=============================================================================
// sgMeshFX.
// * Revised by 7DS'Lust
//=============================================================================
class sgMeshFX extends Effects;

#exec Obj Load File=sgMedia2.u

var sgMeshFX NextFX;

function PostBeginPlay()
{
	if ( sgBuilding(Owner) != None )
        switch ( sgBuilding(Owner).Team )
        {
        case 1:
            Texture = texture'sgMedia.sgEnvSkinT1';
            break;

        case 2:
            Texture = texture'sgMedia2.sgEnvSkinT2';
            break;

        case 3:
            Texture = texture'sgMedia2.sgEnvSkinT3';
            break;

        default:
		    Texture = texture'sgMedia.sgEnvSkinT0';
        }
}

simulated function PostNetBeginPlay()
{
	if ( sgBuilding(Owner) != None && sgBuilding(Owner).Team == 0 )
		Texture = texture'sgMedia.sgEnvSkinT0';		
	else
		Texture = texture'sgMedia.sgEnvSkinT1';
}

simulated function Tick(float deltaTime)
{
	if ( sgBuilding(Owner) == None )
        Destroy();
}

simulated function Destroyed()
{
    Super.Destroyed();
    if ( NextFX != None )
    {
        NextFX.Destroy();
        NextFX = None;
    }
}

simulated function SetSize(float size)
{
    DrawScale = size;
    if ( NextFX != None )
        NextFX.SetSize(size);
}

defaultproperties
{
    Physics=5
    RemoteRole=0
    LODBias=0.50
    DrawType=2
    Style=3
    AmbientGlow=255
    bUnlit=True
    bMeshEnviroMap=True
    bFixedRotationDir=True
}
