//=============================================================================
// sgItem.
//=============================================================================
class sgItem extends sgBuilding
    abstract;

var() sound         FinishSound;
var() class<Inventory>
                    InventoryClass;
var() int           AmmoAmount;
var() bool          SwitchToWeapon,
                    PlayPickupSound;

simulated event Timer()
{
    local Pawn target;

    Super.Timer();

    if ( SCount > 0 || Role != ROLE_Authority )
        return;

    foreach RadiusActors(class'Pawn', target, 48)
        if ( (target == Owner || Owner == None || Owner.bDeleteMe) &&
          target.bIsPlayer && target.Health > 0 &&
          target.PlayerReplicationInfo != None &&
          target.PlayerReplicationInfo.Team == Team &&
          GiveItem(target) != None )
        {
            Destroy();
            return;
        }
}

simulated function FinishBuilding()
{
    Super.FinishBuilding();
    PlayFinishSound();
}

function PlayFinishSound()
{
    PlaySound(FinishSound, SLOT_None);
}

function Inventory GiveItem(Pawn target)
{
    local Inventory inv;

    if ( InventoryClass != None )
    {
        inv = target.FindInventoryType(InventoryClass);
        if ( inv != None )
        {
            if ( Weapon(inv) != None && Weapon(inv).AmmoType != None &&
              Weapon(inv).AmmoType.AmmoAmount < Weapon(inv).AmmoType.MaxAmmo )
            {
                Weapon(inv).AmmoType.AmmoAmount = 
                  FMin(Weapon(inv).AmmoType.AmmoAmount + 1,
                  Weapon(inv).AmmoType.MaxAmmo);
                if ( PlayerPawn(target) != None && SwitchToWeapon )
                    PlayerPawn(target).GetWeapon(class<Weapon>(InventoryClass));
                return inv;
            }
            else
                return None;
        }
     
        inv = Spawn(InventoryClass);
        if ( inv == None )
            return None;

        inv.GiveTo(target);

        if ( Pickup(inv) != None )
        {
            if ( inv.bActivatable )
            {
                if ( target.SelectedItem == None)
                    target.SelectedItem = inv;
                if ( Pickup(inv).bAutoActivate && target.bAutoActivate )
                {
                    Log("Activating");
                    inv.Activate();
                }
            }

		    if ( inv.PickupMessageClass == None )
                target.ClientMessage(inv.PickupMessage, 'Pickup');
	    	else
	            target.ReceiveLocalizedMessage(inv.PickupMessageClass, 0,
                  None, None, inv.Class);

			inv.PlaySound(inv.PickupSound,, 2.0);
			Pickup(inv).PickupFunction(target);
        }
        else 
        {
            if ( PlayPickupSound )
                inv.PlaySound(inv.PickupSound);
            if ( Weapon(inv) != None && Weapon(inv).AmmoType != None &&
              AmmoAmount != -1 )
                Weapon(inv).AmmoType.AmmoAmount = FMin(AmmoAmount,
                Weapon(inv).AmmoType.MaxAmmo);
        }

        return inv;
    }

    return None;
}

defaultproperties
{
    FinishSound=Sound'UnrealShare.Pickups.HEALTH1'
    AmmoAmount=-1
    PlayPickupSound=True
    UpgradeCost=0
    BuildTime=2.50
    SpriteScale=0.40
    MFXrotX=(Pitch=0,Yaw=20000,Roll=0),
    MultiSkins(0)=Texture'sgMedia.GFX.sgWarSpriteT0'
    MultiSkins(1)=Texture'sgMedia.GFX.sgWarSpriteT1'
    MultiSkins(2)=Texture'sgMedia2.GFX.sgWarSpriteT2'
    MultiSkins(3)=Texture'sgMedia2.GFX.sgWarSpriteT3'
}
