//=============================================================================
// sgInnerWave.
// * Revised by 7DS'Lust
//=============================================================================
class sgInnerWave extends sgSWave;

event PostBeginPlay()
{
	local Pawn P;

	RotationRate = (RotRand()-RotRand()*2)/2;

	if ( Instigator != None )
		MakeNoise(10.0);

	SetTimer(0.1, true);
}

simulated event PostNetBeginPlay()
{
    SetTimer(0.1, true);
}

simulated event Tick( float DeltaTime )
{
    local float life;
    life = LifeSpan / default.LifeSpan;
    
    if ( life > 0.5 )
        ShockSize = 20 - 40 * (life - 0.5);
    else if (life < 0.5 )
        ShockSize = 40 * life;

    ScaleGlow = life * 3;
    AmbientGlow = life * 255;
    DrawScale = ShockSize;
    LightBrightness = 255 * life;
    LightRadius = ShockSize * 12.5;
}

event Timer()
{
    local float     life;
    local Actor     victim;
    local float     damageScale,
                    dist,
                    moScale;
    local vector    dir;

    foreach RadiusActors( class 'Actor', victim, ShockSize*29, Location )
    {
        dir = Location - victim.Location;
        dist = VSize(dir); 
        dir = normal(dir); 

        MoScale = ((ShockSize*29)-dist)/(shocksize*29);

        if ( Pawn(victim) != None || Mover(victim) != None )
            victim.TakeDamage(moScale*70, Instigator, victim.Location -
              0.5 * (victim.CollisionHeight + victim.CollisionRadius)*dir,
              vect(0,0,0), 'exploded');
	}		
}

defaultproperties
{
    LifeSpan=2.00
    ScaleGlow=3.00
    AmbientGlow=255
    SpriteProjForward=31.00
    MultiSkins(1)=Texture'sgMedia.GFX.sgInnerExp'
    LightType=1
    LightEffect=13
    LightBrightness=255
    LightHue=36
    LightSaturation=127
    LightRadius=255
}
