//=============================================================================
// sgSuperHealthPod.
// Class created by nOs*Badger
//=============================================================================
class sgHealthPodXXL extends sgEquipmentSupplier;

simulated event Timer()
{
	local sgBaseCore building;
	Super.Timer();

	if ( SCount > 0 || Role != ROLE_Authority )
        return;

	foreach RadiusActors(class'sgBaseCore', building, 224+16*Grade)
		if ( FRand() <= 0.5 + Grade/5 && building.Team == Team)
			    building.Energy = FMin(building.Energy + Grade/5,building.MaxEnergy);

	if ( CurrentTarget == None || CurrentTarget.bDeleteMe ||
      VSize(Location - CurrentTarget.Location) > 60 )
        	CurrentTarget = FindTarget();

}

function Pawn FindTarget()
{
	local Pawn p;

	foreach RadiusActors(class'Pawn', p, 60)
		if ( p.bIsPlayer && p.Health > 0 &&
          p.PlayerReplicationInfo != None &&
          p.PlayerReplicationInfo.Team == Team)
	{
		if (p != None)
		{
			CurrentTarget = p;
			Supply(CurrentTarget);
		}
	}
    return None;
}

function Supply(Pawn target)
{
	local Inventory inv;

    inv = target.FindInventoryType(class'sgArmor');
    if ( inv == None )
    {
        inv = Spawn(class'sgArmor', target);
        if ( inv != None )
            inv.GiveTo(target);
    }
    if ( inv != None && FRand() < 0.5 + (Grade/15) && inv.Charge < 50 +
      Grade*25 )
        inv.Charge = FMin(inv.Charge + 1, 50 + grade * 25 );
	
	if ( FRand() < 2 + (Grade/40) && Target.Health < 75 + (grade*15) )
        Target.Health = Target.Health + 1;
	
	if ( FRand() < 0.5 )
        Target.PlaySound(sound'sgMedia.sgStockUp', SLOT_Misc,
          Target.SoundDampening*2.5);
}

defaultproperties
{
    BuildingName="Super Health Pod"
    BuildCost=1500
    UpgradeCost=35
    BuildTime=60.00
    MaxEnergy=30000.00
    Model=LodMesh'Botpack.BigSprocket'
    DSofMFX=1.25
    MFXrotX=(Pitch=30000,Yaw=30000,Roll=30000),
    MultiSkins(0)=Texture'sgMedia.GFX.sgSupSpriteT0'
    MultiSkins(1)=Texture'sgMedia.GFX.sgSupSpriteT1'
    MultiSkins(2)=Texture'sgMedia2.GFX.sgSupSpriteT2'
    MultiSkins(3)=Texture'sgMedia2.GFX.sgSupSpriteT3'
}
