//=============================================================================
// sgHUD.
// Revised by nOs*Badger
//=============================================================================
class sgHUD extends ChallengeTeamHUD;

#exec TEXTURE IMPORT NAME=JetStatus FILE=TEXTURES\JetStatus.PCX GROUP="Icons" MIPS=OFF FLAGS=2
#exec TEXTURE IMPORT NAME=SJetStatus FILE=TEXTURES\SJetStatus.PCX GROUP="Icons" MIPS=OFF FLAGS=2
#exec TEXTURE IMPORT NAME=JetStatusBar FILE=TEXTURES\JetStatusBar.PCX GROUP="Icons" MIPS=OFF FLAGS=2
#exec TEXTURE IMPORT NAME=SSpeed FILE=TEXTURES\SSpeed.PCX GROUP="Icons" MIPS=OFF FLAGS=2

var Pawn            IdentifyPawn;
var() color         GreyColor;

simulated function bool TraceIdentify(canvas Canvas)
{
	local Actor         other;
	local vector        hitLocation,
                        hitNormal,
                        startTrace,
                        endTrace;

	startTrace = Owner.Location;
	startTrace.Z += PawnOwner.BaseEyeHeight;
	endTrace = startTrace + vector(PawnOwner.ViewRotation) * 10000.0;
	other = Trace(hitLocation, hitNormal, endTrace, startTrace, true);

	if ( Pawn(other) != None && !other.bHidden )
	{
		IdentifyTarget = Pawn(other).PlayerReplicationInfo;
		IdentifyPawn = Pawn(other);
		IdentifyFadeTime = 3.0;
	}

	if ( IdentifyFadeTime == 0 || IdentifyPawn == None ||
      (IdentifyTarget != None && IdentifyTarget.bFeigningDeath) )
		return false;

	return true;
}

simulated function SetIDColor(canvas Canvas, int type)
{
    local int team;

    if ( sgBuilding(IdentifyPawn) != None )
        team = sgBuilding(IdentifyPawn).Team;
    else if ( IdentifyTarget != None )
        team = IdentifyTarget.Team;

    if ( type == 0 )
		Canvas.DrawColor = AltTeamColor[team] * 0.333 *
          IdentifyFadeTime;
	else
    	Canvas.DrawColor = TeamColor[team] * 0.333 *
          IdentifyFadeTime;
}

simulated function DrawTwoColorID(canvas Canvas, string TitleString,
  string ValueString, int YStart)
{
	local float XL, YL, XOffset, X1;

	Canvas.Style = ERenderStyle.STY_Masked;
	Canvas.StrLen(TitleString$": ", XL, YL);
	X1 = XL;
	Canvas.StrLen(ValueString, XL, YL);
	XOffset = Canvas.ClipX/2 - (X1+XL)/2;
	Canvas.SetPos(XOffset, YStart);
	SetIDColor(Canvas, 0);
	XOffset += X1;
	Canvas.DrawText(TitleString);
	Canvas.SetPos(XOffset, YStart);
	SetIDColor(Canvas, 1);
	Canvas.DrawText(ValueString);
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
}

simulated function bool DrawIdentifyInfo(canvas Canvas)
{
	local sgTeleporter tel;

	if ( !TraceIdentify(Canvas) )
		return false;

	if( sgBuilding(IdentifyPawn) != None )
	{

/*
		if (IdentifyPawn.IsA('sgTeleporter')){
			tel=sgTeleporter(IdentifyPawn);
			DrawTwoColorID(Canvas,
          "Properties", tel.URL1, Canvas.ClipY - 300 * Scale);}
*/

        if ( IdentifyPawn.bDeleteMe )
            return false;
		Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
		DrawTwoColorID(Canvas,
          sgBuilding(IdentifyPawn).BuildingName,
          string(int(sgBuilding(IdentifyPawn).Energy /
          sgBuilding(IdentifyPawn).MaxEnergy * 100)),
          Canvas.ClipY - 216 * Scale);

		Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
		DrawTwoColorID(Canvas,
          "Level",
          string(int(sgBuilding(IdentifyPawn).Grade)),
          Canvas.ClipY - 176 * Scale);
	}
	else
	{
        if( IdentifyTarget != None && IdentifyTarget.PlayerName != "" )
		{
			Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
			DrawTwoColorID(Canvas,
              IdentifyTarget.PlayerName,
              string(IdentifyPawn.Health),
              Canvas.ClipY - 256 * Scale);
		}
	}
	return true;
}

simulated function DrawTextCentered(Canvas canvas, coerce string text)
{
    local float width, height;
    canvas.TextSize(text, width, height);
    canvas.SetPos(Canvas.CurX - width/2, Canvas.CurY);
    canvas.DrawText(text, false);
}

simulated function DrawGameSynopsis(canvas Canvas)
{
    local TournamentGameReplicationInfo
                        GRI;
	local float         XL,
                        YL,
                        XOffset,
                        YOffset;
	local int           i,
                        X;
    local string        text;
    local sgConstructor gun;
    local class<sgBuilding>
                        buildType;
    local Inventory     inv;
    local float         fuelPercent;
    local sgPRI		PRI;

	PRI = sgPRI(PawnOwner.PlayerReplicationInfo);
	GRI = TournamentGameReplicationInfo(PlayerOwner.GameReplicationInfo);
	if ( GRI != None )
		for ( i = 0; i < 4; i++ )
			DrawTeam(Canvas, GRI.Teams[i]);

	if ( PawnOwner.PlayerReplicationInfo == None ||
      PawnOwner.PlayerReplicationInfo.bIsSpectator )
		return;

	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
	Canvas.DrawColor = WhiteColor;

    Canvas.TextSize("RU:", XL, YL);

    if ( bHideAllWeapons )
	    YOffset = Canvas.ClipY - YL*3;
	else if ( HudScale * WeaponScale * Canvas.ClipX <= Canvas.ClipX - 256 * Scale )
		YOffset = Canvas.ClipY - 64*Scale - YL*3;
	else
		YOffset = Canvas.ClipY - 128*Scale - YL*3;

    Canvas.SetPos(0, YOffset);
    Canvas.Style = ERenderStyle.STY_Masked;
    Canvas.DrawText("RU:", false);

    //Canvas.SetPos(0, YOffset+20);
    //Canvas.DrawText("Core:", false);

    if ( sgPRI(PawnOwner.PlayerReplicationInfo) != None )
    {
        Canvas.DrawColor = GreyColor;
        Canvas.SetPos(XL, YOffset);
        Canvas.DrawText(""@int(PRI.RU)@"/"@
          int(sgPRI(PawnOwner.PlayerReplicationInfo).MaxRU), false);
        Canvas.DrawColor = GreyColor;
        // Canvas.SetPos(XL+14, YOffset+20);
        // i = SiegeGI(Level.Game).Cores[PawnOwner.PlayerReplicationInfo.Team].Energy/300;
        // Canvas.DrawText(""@i, false);
        Canvas.SetPos(XL, YOffset+20);
    }



    gun = sgConstructor(PawnOwner.Weapon);
    if ( gun != None )
    {
        text = gun.GetOptionName();

	if ( gun.IsFunction() )
        {
	    Canvas.DrawColor = WhiteColor;
            X = Canvas.ClipX - 160 * Scale;
            Canvas.TextSize(text, XL, YL);
            Canvas.SetPos(X - XL/2, YOffset);
            Canvas.DrawText(text, false);
        }
        else if ( gun.IsCategory() )
        {
            Canvas.DrawColor = GreyColor;
            Canvas.TextSize("Select"@text, XL, YL);
            X = Canvas.ClipX - 160 * Scale - XL/2;
            Canvas.SetPos(X, YOffset);
            Canvas.DrawText("Select", false);

            Canvas.DrawColor = WhiteColor;
            Canvas.TextSize("Select", XL, YL);
            Canvas.SetPos(X + XL, YOffset);
            Canvas.DrawText(""@text, false);

            Canvas.DrawColor = GreyColor;
            X = Canvas.ClipX - 160 * Scale;
            Canvas.TextSize("category", XL, YL);
            Canvas.SetPos(X - XL/2, YOffset + YL);
            Canvas.DrawText("category", false);
        }
        else if ( gun.IsBuilding() )
        {
            Canvas.DrawColor = WhiteColor;
            X = Canvas.ClipX - 160 * Scale;
            Canvas.TextSize(text, XL, YL);
            Canvas.SetPos(X - XL/2, YOffset);
            Canvas.DrawText(text, false);

            buildType = gun.GetBuildType();
            if ( buildType != None )
                text = "Cost:"@buildType.default.BuildCost;
            else
                text = "Cost:";
            Canvas.DrawColor = GreyColor;
            Canvas.TextSize(text, XL, YL);
            Canvas.SetPos(X - XL/2, YOffset + YL);
            Canvas.DrawText(text, false);
        }
	
    }

    for ( inv = PlayerOwner.Inventory; inv != None; inv = inv.Inventory )
    {
        if ( JetPack(inv) != None )
        {
            Canvas.DrawColor = GreyColor;
            fuelPercent = FClamp(Jetpack(inv).Fuel / Jetpack(inv).MaxFuel,
              0, 1);
            Canvas.SetPos(4, YOffset - YL*2);

	    if ( JetPack(inv).ItemName != "Jetpack" )
	    {
                 Canvas.DrawTile(texture'SJetStatus', 128, 32, 0, 0, 128, 32);
	    }
	    else
	    {
                 Canvas.DrawTile(texture'JetStatus', 128, 32, 0, 0, 128, 32);
	    }
            Canvas.SetPos(5, YOffset - YL*2);
            Canvas.DrawTile(texture'JetStatusBar', 90 * fuelPercent + 1, 32,
              1, 0, 90 * fuelPercent + 1, 32);
        }
	if ( sgSpeed(inv) != None )
	{
            Canvas.DrawColor = GreyColor;
            Canvas.SetPos(4, YOffset - YL*2 + 26);
            Canvas.DrawTile(texture'SSpeed', 128, 32, 0, 0, 128, 32);
	}
    }
}

defaultproperties
{
    GreyColor=(R=128,G=128,B=128,A=0),
}
