//=============================================================================
// sgGuardian
// Written by nOs*Badger
//=============================================================================
class sgGuardian extends sgBuilding;

var() float         SupplyRadius;


simulated event Timer()
{

	Super.Timer();

	if ( SCount > 0 || Role != ROLE_Authority )
        	return;

	if ( FRand() < 1/(5/Grade) ) 
		Damage();


}

function Damage()
{
    local float     dist,
                    moScale;
    local vector    dir;
    local Pawn p;
    local sgBuilding s;
    local float ShockSize;
    local effects e;

    ShockSize = ((Grade+1)* 20)+100;

    foreach RadiusActors(class 'Pawn', p, ShockSize )
    {
        dir = Location - p.Location;
        dist = VSize(dir); 
        dir = normal(dir); 

        MoScale = (((ShockSize)-dist)/(ShockSize))+0.1;

    	if ( FastTrace(p.Location) )
		if (p.bIsPlayer && p.Health > 0 && p.PlayerReplicationInfo != None && p.PlayerReplicationInfo.Team != Team && !p.PlayerReplicationInfo.bIsSpectator)
		{
            		p.TakeDamage(moScale*10, Instigator, 0.5 * (p.CollisionHeight + p.CollisionRadius)*dir,vect(0,0,0), 'sgSpecial');
			if ( FRand() < 0.25) {
				Self.PlaySound(sound'UnrealShare.Skrjshot',, 7.0);
				e = Spawn(Class'UnrealShare.ParticleBurst', Owner, , Location); }
		}
    }
    foreach RadiusActors(class 'sgBuilding', s, ShockSize )
    {
        dir = Location - s.Location;
        dist = VSize(dir); 
        dir = normal(dir); 

        MoScale = (((ShockSize)-dist)/(ShockSize))+0.1;

    	if ( FastTrace(s.Location) )
		if (s.Health > 0 && s.Team != Team)
		{
            		s.TakeDamage(moScale*10, Instigator, 0.5 * (s.CollisionHeight + s.CollisionRadius)*dir,vect(0,0,0), 'sgSpecial');
			if ( FRand() < 0.15) {
				Self.PlaySound(sound'UnrealShare.Skrjshot',, 7.0);
				e = Spawn(Class'UnrealShare.ParticleBurst', Owner, , Location); }
		}
    }
}




function Upgraded()
{
     AmbientGlow=255/(6-Grade);
}



defaultproperties
{
    SupplyRadius=60.00
    BuildingName="Guardian"
    BuildCost=400
    BuildTime=15.00
    MaxEnergy=8500.00
    SpriteScale=1.20
    Model=LodMesh'Botpack.Module'
    DSofMFX=3.80
    NumOfMFX=3
    MFXrotX=(Pitch=20000,Yaw=20000,Roll=20000),
    AmbientGlow=40
    MultiSkins(0)=Texture'sgMedia.GFX.sgContSpriteT0'
    MultiSkins(1)=Texture'sgMedia.GFX.sgContSpriteT1'
    MultiSkins(2)=Texture'sgMedia2.GFX.sgContSpriteT2'
    MultiSkins(3)=Texture'sgMedia2.GFX.sgContSpriteT3'
    CollisionHeight=32.00
}
