//=============================================================================
// sgEquipmentSupplier.
// * Revised by 7DS'Lust
//=============================================================================
class sgEquipmentSupplier extends sgBuilding
    abstract;

var() float         SupplyRadius;
var Pawn            CurrentTarget;

simulated event Timer()
{
	Super.Timer();

	if ( SCount > 0 || Role != ROLE_Authority )
        return;

	if ( CurrentTarget == None || CurrentTarget.bDeleteMe ||
      VSize(Location - CurrentTarget.Location) > 60 )
        CurrentTarget = FindTarget();

	if ( CurrentTarget != None )
        Supply(CurrentTarget);
}

function Pawn FindTarget()
{
	local Pawn p;

	foreach RadiusActors(class'Pawn', p, 60)
		if ( p.bIsPlayer && p.Health > 0 &&
          p.PlayerReplicationInfo != None &&
          p.PlayerReplicationInfo.Team == Team)
			return p;

    return None;
}

function Supply(Pawn target);

defaultproperties
{
    SupplyRadius=60.00
}
