//=============================================================================
// Enforcer
// * Revised by 7DS'Lust
//=============================================================================
class sgEnforcer extends Enforcer;

var float AccuracyScale;

function TraceFire(float Accuracy)
{
	local vector RealOffset;
    local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z;
	local actor Other;
	local Pawn PawnOwner;

    //*** From Enforcer.uc
	RealOffset = FireOffset;
	FireOffset *= 0.35;
	if ( (SlaveEnforcer != None) || bIsSlave )
		Accuracy = FClamp(3*Accuracy,0.75,3);
	else if ( Owner.IsA('Bot') && !Bot(Owner).bNovice )
		Accuracy = FMax(Accuracy, 0.45);


    Accuracy *= AccuracyScale;

        //*** From Weapon.uc
        PawnOwner = Pawn(Owner);

	    Owner.MakeNoise(PawnOwner.SoundDampening);
	    GetAxes(PawnOwner.ViewRotation,X,Y,Z);
	    StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z; 
	    AdjustedAim = PawnOwner.AdjustAim(1000000, StartTrace, 2*AimError, False, False);	
	    EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000
		    + Accuracy * (FRand() - 0.5 ) * Z * 1000;
	    X = vector(AdjustedAim);
	    EndTrace += (10000 * X); 
	    Other = PawnOwner.TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
	    ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
        //***

	FireOffset = RealOffset;
    //***
}

function SetTwoHands()
{
	if ( SlaveEnforcer == None )
		return;

    if ( SlaveEnforcer.IsA('sgEnforcer') )
    {
        SlaveEnforcer.HitDamage = HitDamage;
        sgEnforcer(SlaveEnforcer).AccuracyScale = AccuracyScale;
    }

    Super.SetTwoHands();
}

defaultproperties
{
    AccuracyScale=1.00
    hitdamage=15
    AmmoName=Class'sgEClip'
    PickupAmmoCount=15
}
