//=============================================================================
// sgBuildingKillMsg.
//=============================================================================
class sgBuildingKillMsg extends CriticalEventPlus;

static function string GetArticle(string noun)
{
    local string letter;

    if ( noun == "" )
        return "";

    letter = Caps(Left(noun, 1));
    if ( letter == "A" || letter == "E" || letter == "I" || letter == "O" ||
      letter == "U" )
        return "A";
    return "An";
}

static function string GetString(
  optional int Switch,
  optional PlayerReplicationInfo RelatedPRI_1, 
  optional PlayerReplicationInfo RelatedPRI_2,
  optional Object OptionalObject)
{
    local string msg;
    
    if ( sgBuilding(OptionalObject) == None )
        return "";

    if ( RelatedPRI_1 != None )
        msg = RelatedPRI_1.PlayerName$"'s";
    else
        msg = GetArticle(sgBuilding(OptionalObject).BuildingName);

    log(OptionalObject@sgBuilding(OptionalObject).BuildingName);
    msg = msg@sgBuilding(OptionalObject).BuildingName@
      "was destroyed";

    if ( RelatedPRI_2 != None )
        msg = msg@"by"@RelatedPRI_2.PlayerName;

    return msg;
}

defaultproperties
{
}
