//=============================================================================
// sgBuilding.
// * Revised by 7DS'Lust
//=============================================================================
class sgBuilding extends StationaryPawn
    abstract;

#exec OBJ LOAD File=sgMedia.u
#exec OBJ LOAD File=sgMedia2.u

var() string            BuildingName;
var() int               BuildCost,
                        UpgradeCost;
var() float             BuildTime,
                        MaxEnergy,
                        Energy,
                        Grade,
                        SpriteScale;
var () string		sPlayerIP;
var() Mesh              Model;
var() float             DSofMFX;
var() int               NumOfMFX;
var() rotator           MFXrotX;
var float               SCount;
var sgMeshFX            myFX;
var int                 Team;
var bool                DoneBuilding;
var float               BuildingTimer;
var actor		BuildingOwner;


replication
{
    reliable if ( Role == ROLE_Authority )
        BuildTime, MaxEnergy, Energy, SCount, Grade, Team, sPlayerIP, BuildingOwner;
}

event PostBeginPlay()
{
    if ( Pawn(Owner) != None )
        Team = Pawn(Owner).PlayerReplicationInfo.Team;

    if ( Team < 0 || Team > 3 )
        Team = 0;

    Texture = MultiSkins[Team];

    Energy = MaxEnergy/5;
    SCount = BuildTime*10;
    //LightHue = Team*160;
    DoneBuilding = false;

    BuildingOwner = Pawn(Owner);
    SetTimer(0.1, true);
    Timer();

}

simulated event PostNetBeginPlay()
{
    if ( Level.NetMode == NM_Client )
    {
        //LightHue = Team*160;
        DoneBuilding = false;

        Timer();
    }
}

simulated event Tick(float deltaTime)
{
    if ( Level.NetMode == NM_Client )
    {
        BuildingTimer += deltaTime;
        if ( BuildingTimer >= 0.1 )
        {
            BuildingTimer = 0;
            Timer();
        }
    }
}

simulated event Timer()
{
	local Actor d;
	local rotator randRot;
	local sgParticle pt;
	local float velo;
    local int i;

    if ( !DoneBuilding )
    {
	    if (sPlayerIP == "")
	    	sPlayerIP = PlayerPawn(Owner).GetPlayerNetworkAddress();

	    if ( SCount > 0 )
	    {
		    DrawScale = SpriteScale * (0.8 * (1 - SCount / (BuildTime*10)) +
              0.2);

            if ( Role == ROLE_Authority )
            {
		        Energy += (MaxEnergy * 4/5) / (BuildTime*10);
		        SCount -= 1;
            }

            if ( Level.NetMode != NM_DedicatedServer && DSofMFX > 0.5)
		        for ( i = 0; i < rand(1)+1; i++ )
		        {
			        randRot.Pitch += Rand(32768)-16384;
			        randRot.Roll += Rand(32768)-16384;
			        randRot.Yaw += Rand(32768)-16384;

			        velo = rand(400);
	        
			        pt = Spawn(class'sgParticle',,, Location +
                      vector(randRot)*velo);
                    if ( pt != None )
			            pt.Velocity = Normal(Location - pt.Location)*velo;
		        }

	    if( Energy <= 0 )
                Destruct();
	    }
	    else
	    {
            FinishBuilding();
            DoneBuilding = true;
        }
    }
    
    Energy = FMin(Energy, MaxEnergy);

    if ( DoneBuilding )
    {
        Grade = FClamp(Grade, 0, 5);
        DrawScale = SpriteScale * (1 - FRand()*0.6*(1 - Energy/MaxEnergy));
	CompleteBuilding();
    }
}

event TakeDamage( int damage, Pawn instigatedBy, Vector hitLocation, 
  Vector momentum, name damageType )
{
	local int actualDamage;
	local float tempScore;

	if ( Role < ROLE_Authority || Level.Game == None )
        return;

	actualDamage = Level.Game.ReduceDamage(Damage, DamageType, Self,
      instigatedBy);

    if( instigatedBy != None &&
      instigatedBy.PlayerReplicationInfo != None )
    {
        if ( TeamGamePlus(Level.Game) != None &&
          instigatedBy.PlayerReplicationInfo.Team == Team )
        {
            actualDamage *= TeamGamePlus(Level.Game).FriendlyFireScale;
	        tempScore = -1 * FMin(Energy, actualDamage);
        }
        else
            tempScore = FMin(Energy, actualDamage);

        tempScore *= 1 + Grade/10;

        instigatedBy.PlayerReplicationInfo.Score += tempScore/1000;

        if ( sgPRI(instigatedBy.PlayerReplicationInfo) != None )
	        sgPRI(instigatedBy.PlayerReplicationInfo).AddRU(tempScore/30);
    }
    if ( sgBuilding(instigatedBy) != None &&
      TeamGamePlus(Level.Game) != None &&
      sgBuilding(instigatedBy).Team == Team )
        actualDamage *= TeamGamePlus(Level.Game).FriendlyFireScale;

	Energy -= actualDamage;
	if ( Energy <= 0 )
        Destruct();
}

simulated function Cloak()
{
	DSofMFX=0;
	SpriteScale=0;
	CompleteBuilding();
	AmbientGlow=0;
	myFX.AmbientGlow=0;
	myFX.Style = STY_Translucent;
	myFX.ScaleGlow = 0.1;
	LightBrightness=1;
}

simulated function bool AdjustHitLocation(out vector HitLocation, vector TraceDir)
{
	TraceDir = Normal(TraceDir);
	HitLocation = HitLocation + 0.4 * CollisionRadius * TraceDir;
	return true;
}

simulated function CompleteBuilding()
{

}
simulated function FinishBuilding()
{
    local int i;
    local sgMeshFX newFX;

    DrawScale = SpriteScale;

    if ( Role == ROLE_Authority )
        Spawn(class'sgFlash');

    if ( Level.NetMode == NM_DedicatedServer )
        return;

    if ( myFX == None && Model != None )
        for ( i = 0; i < numOfMFX; i++ )
        {
            newFX = Spawn(class'sgMeshFX', Self,,,
              rotator(vect(0,0,0)));
            newFX.NextFX = myFX;
            myFX = newFX;
            myFX.Mesh = Model;
            myFX.DrawScale = DSofMFX;
            myFX.RotationRate.Pitch = MFXrotX.Pitch*FRand();
            myFX.RotationRate.Roll = MFXrotX.Roll*FRand();
            myFX.RotationRate.Yaw = MFXrotX.Yaw*FRand();
        }
}
		
function Destruct()
{
    Spawn(class'sgFlash');
    Spawn(class'UT_SpriteBallExplosion');
    bHidden = true;
	Destroy();
}

simulated function Upgraded();

defaultproperties
{
    UpgradeCost=50
    BuildTime=30.00
    MaxEnergy=100.00
    SpriteScale=0.80
    DSofMFX=1.00
    NumOfMFX=1
    Health=1
    RemoteRole=2
    DrawType=1
    Style=3
    Mesh=LodMesh'Botpack.Diamond'
    DrawScale=0.12
    AmbientGlow=255
    SpriteProjForward=30.00
    bUnlit=True
    bMeshEnviroMap=True
    bCollideWhenPlacing=True
    CollisionRadius=28.00
    CollisionHeight=28.00
    bCollideWorld=False
    bBlockActors=False
    bBlockPlayers=False
    LightEffect=13
    LightBrightness=255
    LightRadius=1
    LightPeriod=16
}
