//=============================================================================
// JetTrail.
//=============================================================================
class JetTrail extends Effects;

simulated event PostBeginPlay()
{
    if ( Level.NetMode == NM_DedicatedServer )
        GotoState('Disabled');

    if ( Role != ROLE_Authority && Owner == None )
        return;

    GotoState('Active');
}

simulated event Tick(float deltaTime)
{
    if ( Owner != None )
        GotoState('Active');
}

simulated state Active
{
    simulated function BeginState()
    {
        Timer();
    }

    simulated event Tick(float deltaTime);
}

state Disabled
{
    event Tick(float deltaTime);
}

simulated event Timer()
{
    local float rate;
    local vector spawnLocation;
    local rotator rot;
    local JetParticle particle;

    AmbientSound = sound'Extro.Light5';

    if ( Level.bHighDetailMode )
        rate = 0.03;
    else
        rate = 0.1;

    spawnLocation = Owner.Location;
    spawnLocation.Z += 0.3 * Owner.CollisionHeight;

    rot.Yaw = Owner.Rotation.Yaw;
    spawnLocation -= vector(rot) * 20;

    particle = Spawn(class'JetParticle', Self,, SpawnLocation);
    if ( particle != None )
    {
        particle.Velocity = vector(rot) * -20;
        particle.Velocity.Z = -40;
    }     

    SetTimer(rate, false);
}



defaultproperties
{
    bNetTemporary=False
    Physics=11
    RemoteRole=2
    SoundRadius=60
    SoundVolume=192
}
