//================================================================================
// PlayerVoteListBox.
//================================================================================

class PlayerVoteListBox extends UWindowListBox;

var Color TeamColor[4];
var bool bDisabled;

function Paint (Canvas C, float MouseX, float MouseY)
{
  C.DrawColor.R = 255;
  C.DrawColor.G = 255;
  C.DrawColor.B = 255;
  DrawStretchedTexture(C,0.0,0.0,WinWidth,WinHeight,Texture'WhiteTexture');
  Super.Paint(C,MouseX,MouseY);
}

function DrawItem (Canvas C, UWindowList Item, float X, float Y, float W, float H)
{
  if ( bDisabled )
  {
    PlayerVoteListItem(Item).bSelected = False;
  }
  if ( PlayerVoteListItem(Item).bSelected )
  {
    C.DrawColor.R = 0;
    C.DrawColor.G = 0;
    C.DrawColor.B = 128;
    DrawStretchedTexture(C,X,Y,W,H - 1,Texture'WhiteTexture');
    C.DrawColor.R = 255;
    C.DrawColor.G = 255;
    C.DrawColor.B = 255;
  } else {
    if ( PlayerVoteListItem(Item).bHasVoted )
    {
      C.DrawColor.R = 32;
      C.DrawColor.G = 255;
      C.DrawColor.B = 32;
    } else {
      C.DrawColor.R = 255;
      C.DrawColor.G = 255;
      C.DrawColor.B = 255;
    }
    DrawStretchedTexture(C,X,Y,W,H - 1,Texture'WhiteTexture');
    if ( Left(PlayerVoteListItem(Item).PlayerName,1) == "9" )
    {
      C.DrawColor.R = 138;
      C.DrawColor.G = 164;
      C.DrawColor.B = 166;
    } else {
      C.DrawColor = TeamColor[int(Left(PlayerVoteListItem(Item).PlayerName,1))];
    }
  }
  C.Font = Root.Fonts[0];
  ClipText(C,X + 2,Y,Left(Mid(PlayerVoteListItem(Item).PlayerName,1),3) $ " - " $ Mid(PlayerVoteListItem(Item).PlayerName,4));
}

function KeyDown (int Key, float X, float Y)
{
  local int i;
  local UWindowListBoxItem ItemPointer;
  local PlayerPawn P;

  if ( bDisabled )
  {
    return;
  }
  P = GetPlayerOwner();
  if ( (Key == P.237) || (Key == P.40) )
  {
    if ( (SelectedItem != None) && (SelectedItem.Next != None) )
    {
      SetSelectedItem(UWindowListBoxItem(SelectedItem.Next));
      MakeSelectedVisible();
    }
  }
  if ( (Key == P.236) || (Key == P.38) )
  {
    if ( (SelectedItem != None) && (SelectedItem.Prev != None) && (SelectedItem.Sentinel != SelectedItem.Prev) )
    {
      SetSelectedItem(UWindowListBoxItem(SelectedItem.Prev));
      MakeSelectedVisible();
    }
  }
  if ( Key == P.34 )
  {
    if ( SelectedItem != None )
    {
      ItemPointer = SelectedItem;
      i = 0;
      if ( i < 7 )
      {
        if ( ItemPointer.Next == None )
        {
          return;
        }
        ItemPointer = UWindowListBoxItem(ItemPointer.Next);
        i++;
        goto JL0149;
      }
      SetSelectedItem(ItemPointer);
      MakeSelectedVisible();
    }
  }
  if ( Key == P.33 )
  {
    if ( SelectedItem != None )
    {
      ItemPointer = SelectedItem;
      i = 0;
      if ( i < 7 )
      {
        if ( (ItemPointer.Prev == None) || (ItemPointer.Prev == SelectedItem.Sentinel) )
        {
          return;
        }
        ItemPointer = UWindowListBoxItem(ItemPointer.Prev);
        i++;
        goto JL01D2;
      }
      SetSelectedItem(ItemPointer);
      MakeSelectedVisible();
    }
  }
  ParentWindow.KeyDown(Key,X,Y);
}

function SelectPlayer (string PlayerName)
{
  local PlayerVoteListItem PlayerItem;
  local string PlayerID;

  if ( bDisabled )
  {
    return;
  }
  PlayerID = Left(PlayerName,3);
  PlayerItem = PlayerVoteListItem(Items);
  if ( PlayerItem != None )
  {
    if ( PlayerID == Right(Left(PlayerItem.PlayerName,4),3) )
    {
      SetSelectedItem(PlayerItem);
      MakeSelectedVisible();
    } else {
      PlayerItem = PlayerVoteListItem(PlayerItem.Next);
      goto JL002A;
    }
  }
}

function DoubleClickItem (UWindowListBoxItem i)
{
  if ( bDisabled )
  {
    return;
  }
  UWindowDialogClientWindow(ParentWindow).Notify(self,11);
}

defaultproperties
{
    TeamColor(0)=(R=255,G=0,B=0,A=0),

    TeamColor(1)=(R=0,G=0,B=255,A=0),

    TeamColor(2)=(R=0,G=255,B=0,A=0),

    TeamColor(3)=(R=255,G=255,B=0,A=0),

    ItemHeight=12.00

    ListClass=Class'PlayerVoteListItem'

}
