//================================================================================
// MapVoteWRI.
//================================================================================

class MapVoteWRI extends WRI;

var BDBMapVote MapVoteMutator;
var string MapList[1024];
var int MapListNum[1024];
var string MapList1[256];
var string MapList2[256];
var string MapList3[256];
var string MapList4[256];
var int MapCount;
var string PlayerName[32];
var int gPlayerCount;
var bool bKickVote;
var string MapVoteResults[32];
var string KickVoteResults[32];
var string GameTypes;
var string OtherClass;
var int VoteTimeLimit;
var int KickPercent;
var bool bUseMapList;
var bool bAutoOpen;
var int ScoreBoardDelay;
var bool bAutoDetect;
var bool bCheckOtherGameTie;
var string ServerInfoURL;
var string MapInfoURL;
var string ReportText;
var string Mode;
var int RepeatLimit;
var string MapVoteHistoryType;
var int MidGameVotePercent;
var int MinMapCount;
var string MapPreFixOverRide;
var string PreFixSwap;
var string OtherPreFix;
var string HasStartWindow;
var bool bEntryWindows;
var bool bSortWithPreFix;
var bool bDebugMode;
var bool bRemoveCrashedMaps;
var bool bReloadMapsOnRequestOnly;
var string ActGameClass;
var string ActGamePrefix;
var string List1Title;
var string List2Title;
var string List3Title;
var string List4Title;
var string MapVoteTitle;
var float List1Priority;
var float List2Priority;
var float List3Priority;
var float List4Priority;
var string CustomGames[16];
var string CustomGamesState;
var bool bUseExcludeFilter;
var string PrefixDictionary;
var int LastMapsCount;
var int LastMapListCountX[5];
var string ASClass;
var bool bUpdated;
var bool blastCheck;
var int gAdminChechsum;
var int gPlayerChecksum;
var int gTitleChecksum;
var bool bAdminDone;
var string LogoTexture;
var bool bOpenWindowDispatched;
var bool bSetupWindowDelayDone;

replication
{
  reliable if ( Role == 4 )
    SendReportText,UpdateKickVoteResults,UpdateMapVoteResults,UpdatePlayerVoted,RemovePlayerName,AddNewPlayer,MapList1,MapList2,MapList3,MapList4,MapCount,PlayerName,bKickVote,MapVoteResults,KickVoteResults,GameTypes,OtherClass,VoteTimeLimit,KickPercent,bUseMapList,bAutoOpen,ScoreBoardDelay,bAutoDetect,bCheckOtherGameTie,ServerInfoURL,MapInfoURL,Mode,RepeatLimit,MapVoteHistoryType,MidGameVotePercent,MinMapCount,MapPreFixOverRide,PreFixSwap,OtherPreFix,HasStartWindow,bEntryWindows,bSortWithPreFix,bDebugMode,bRemoveCrashedMaps,bReloadMapsOnRequestOnly,ActGameClass,ActGamePrefix,List1Title,List2Title,List3Title,List4Title,MapVoteTitle,List1Priority,List2Priority,List3Priority,List4Priority,CustomGames,CustomGamesState,bUseExcludeFilter,PrefixDictionary,ASClass,LogoTexture;
}

simulated function bool OpenWindow ()
{
  if ( PlayerPawn(Owner).Player.Console.bTyping )
  {
    SetTimer(0.5,False);
    return False;
  }
  bOpenWindowDispatched = True;
  Super.OpenWindow();
}

simulated function bool SetupWindow ()
{
  local int i;

  if (  !bSetupWindowDelayDone )
  {
    SetTimer(0.5,False);
    return False;
  }
  if ( Class'BDBMapVote'.Default.bUseMsgTimeout )
  {
    Class'SayMessagePlus'.Default.Lifetime = Class'BDBMapVote'.Default.MsgTimeOut;
    Class'CriticalStringPlus'.Default.Lifetime = Class'BDBMapVote'.Default.MsgTimeOut;
    Class'RedSayMessagePlus'.Default.Lifetime = Class'BDBMapVote'.Default.MsgTimeOut;
    Class'TeamSayMessagePlus'.Default.Lifetime = Class'BDBMapVote'.Default.MsgTimeOut;
    Class'StringMessagePlus'.Default.Lifetime = Class'BDBMapVote'.Default.MsgTimeOut;
    Class'DeathMessagePlus'.Default.Lifetime = Class'BDBMapVote'.Default.MsgTimeOut;
  }
  DebugLog("MapVoteWRI: SetupWindow()");
  LastMapsCount = 0;
  LastMapListCountX[1] = 0;
  LastMapListCountX[2] = 0;
  LastMapListCountX[3] = 0;
  LastMapListCountX[4] = 0;
  if ( Super.SetupWindow() )
  {
    SetTimer(1.0,False);
  } else {
    Log("Super.SetupWindow() = false");
  }
}

function Timer ()
{
  local int i;
  local int MyCount;
  local int MyPlayerCount;
  local bool bHasVoted;
  local int repMapsCount;
  local int repMapListCountX[5];
  local int repAdminChechsum;
  local int TitleChecksum;
  local int repPlayerCount;
  local AdminWindow Window;
  local string temp;
  local int List;

  if (  !bOpenWindowDispatched )
  {
    OpenWindow();
    return;
  }
  if (  !bSetupWindowDelayDone )
  {
    bSetupWindowDelayDone = True;
    SetupWindow();
  }
  DebugLog("timer()");
  bUpdated = False;
  i = 0;
  if ( i < 1024 )
  {
    if ( i < 256 )
    {
      temp = i[];
      256
      )
      MapList1
    }
    goto JL010A;
    if ( i < 512 )
    {
      temp = i[];
      256
      )
      MapList2
      // There are 1 jump destination(s) inside the last statement!
    }
    goto JL010A;
    if ( i < 768 )
    {
      temp = i[];
      256
    }
    )
    MapList3
    goto JL010A;
    if ( i < 1024 )
    {
      temp = i[];
    }
    256
    )
    MapList4
    if ( temp != "" )
    {
      MapList[i] = Mid(temp,0,Len(temp) - 2);
      MapListNum[i] = int(Right(temp,1));
      repMapListCountX[MapListNum[i]]++ ;
      // There are 2 jump destination(s) inside the last statement!
    }
  }
  i++ ;
  goto JL004A;
  List = 1;
  if ( List <= 4 )
  {
    if ( repMapListCountX[List] > LastMapListCountX[List] )
    {
      MapVoteTabWindow(TheWindow).ClearList(List);
      i = 0;
      if ( i < 1024 )
      {
        if ( MapListNum[i] == List )
        {
          MapVoteTabWindow(TheWindow).AddMapName(List,MapList[i]);
          // There are 2 jump destination(s) inside the last statement!
        }
      }
      i++ ;
      goto JL01B5;
      LastMapListCountX[List] = repMapListCountX[List];
      // There are 1 jump destination(s) inside the last statement!
    }
    bUpdated = True;
    // There are 1 jump destination(s) inside the last statement!
  }
  List++ ;
  goto JL016E;
  repMapsCount = repMapListCountX[1] + repMapListCountX[2] + repMapListCountX[3] + repMapListCountX[4];
  if ( (repMapsCount > LastMapsCount) || (repMapsCount != MapCount) )
  {
    bUpdated = True;
    // There are 1 jump destination(s) inside the last statement!
  }
  LastMapsCount = repMapsCount;
  if ( (MapVoteTabWindow(TheWindow).AdminWindow != None) && PlayerPawn(Owner).PlayerReplicationInfo.bAdmin )
  {
    Window = AdminWindow(MapVoteTabWindow(TheWindow).AdminWindow.ClientArea);
    repAdminChechsum = ;
    Len(GameTypes) + Len(OtherClass) + Len(string(VoteTimeLimit)) + Len(string(KickPercent)) + Len(string(ScoreBoardDelay)) + Len(string(bUseMapList)) + Len(string(bAutoOpen)) + Len(string(bKickVote)) + Len(string(bAutoDetect)) + Len(List1Title) + Len(List2Title) + Len(List3Title) + Len(List4Title) + List1Priority + List2Priority + List3Priority + List4Priority + Len(PreFixSwap) + Len(string(bDebugMode)) + Len(string(bRemoveCrashedMaps)) + RepeatLimit + Len(MapVoteHistoryType) + MidGameVotePercent + Len(Mode) + MinMapCount + Len(MapPreFixOverRide) + Len(HasStartWindow) + Len(MapInfoURL) + Len(string(bEntryWindows)) + Len(string(bSortWithPreFix)) + Len(ASClass) + Len(CustomGamesState);
    Len(string(bUseExcludeFilter));
    )
    i = 0;
    if ( i < 16 )
    {
      repAdminChechsum += Len(CustomGames[i]);
      // There are 1 jump destination(s) inside the last statement!
    }
    i++ ;
    goto JL043D;
    if ( gAdminChechsum != repAdminChechsum )
    {
      bUpdated = True;
      // There are 1 jump destination(s) inside the last statement!
    }
    gAdminChechsum = repAdminChechsum;
    Window.cbLoadDM.bChecked = bool(Mid(GameTypes,0,1));
    Window.cbLoadLMS.bChecked = bool(Mid(GameTypes,1,1));
    Window.cbLoadTDM.bChecked = bool(Mid(GameTypes,2,1));
    Window.cbLoadAS.bChecked = bool(Mid(GameTypes,3,1));
    Window.cbLoadDOM.bChecked = bool(Mid(GameTypes,4,1));
    Window.cbLoadCTF.bChecked = bool(Mid(GameTypes,5,1));
    Window.sldVoteTimeLimit.SetValue(VoteTimeLimit);
    Window.sldKickPercent.SetValue(KickPercent);
    Window.sldScoreBoardDelay.SetValue(ScoreBoardDelay);
    Window.cbUseMapList.bChecked = bUseMapList;
    Window.cbAutoOpen.bChecked = bAutoOpen;
    Window.cbKickVote.bChecked = bKickVote;
    Window.cbAutoDetect.bChecked = bAutoDetect;
    Window.cbCheckOtherGameTie.bChecked = bCheckOtherGameTie;
    Window.cbReloadMapsOnRequestOnly.bChecked = bReloadMapsOnRequestOnly;
    Window.cbUseExcludeFilter.bChecked = bUseExcludeFilter;
    Window.txtRepeatLimit.SetValue(string(RepeatLimit));
    Window.cboMapVoteHistoryType.SetValue(MapVoteHistoryType);
    Window.sldMidGameVotePercent.SetValue(MidGameVotePercent);
    Window.cboMode.SetValue(Mode);
    Window.txtMinMapCount.SetValue(string(MinMapCount));
    Window.txtMapVoteTitle.SetValue(MapVoteTitle);
    Window.txtList1Title.SetValue(List1Title);
    Window.txtList2Title.SetValue(List2Title);
    Window.txtList3Title.SetValue(List3Title);
    Window.txtList4Title.SetValue(List4Title);
    Window.txtList1Priority.SetValue(string(List1Priority));
    Window.txtList2Priority.SetValue(string(List2Priority));
    Window.txtList3Priority.SetValue(string(List3Priority));
    Window.txtList4Priority.SetValue(string(List4Priority));
    Window.txtASClass.SetValue(ASClass);
    Window.cbRemoveCrashedMaps.bChecked = bRemoveCrashedMaps;
    Window.txtMapInfoURL.SetValue(MapInfoURL);
    Window.cbEntryWindows.bChecked = bEntryWindows;
    Window.cbSortWithPreFix.bChecked = bSortWithPreFix;
    Window.cbDebugMode.bChecked = bDebugMode;
    Window.lblActGame.SetText("C" $ "lass:" @ ActGameClass);
    Window.lblActPrefix.SetText("Map Prefix:" @ ActGamePrefix);
    if ( Len(CustomGamesState) > 10 )
    {
      i = 0;
      if ( i < 16 )
      {
        if ( Mid(CustomGamesState,i,1) == "1" )
        {
          Window.cbCustGame[i].bChecked = True;
          // There are 1 jump destination(s) inside the last statement!
        }
        goto JL09B5;
        Window.cbCustGame[i].bChecked = False;
        if ( CustomGames[i] != "" )
        {
          Window.lblCustGame[i].SetText(CustomGames[i]);
          Window.cbCustGame[i].bDisabled = False;
          // There are 1 jump destination(s) inside the last statement!
        }
        goto JL0A58;
        Window.lblCustGame[i].SetText("empty");
        Window.cbCustGame[i].bDisabled = True;
        // There are 3 jump destination(s) inside the last statement!
      }
    }
  }
  i++ ;
  goto JL0951;
  if ( bKickVote || PlayerPawn(Owner).PlayerReplicationInfo.bAdmin )
  {
    MapVoteTabWindow(TheWindow).EnableKickWindow();
    // There are 1 jump destination(s) inside the last statement!
  }
  i = 0;
  if ( (i < 32) && (PlayerName[i] != "") )
  {
    repPlayerCount = i + 1;
    // There are 1 jump destination(s) inside the last statement!
  }
  i++ ;
  goto JL0AA8;
  if ( repPlayerCount != gPlayerCount )
  {
    i = gPlayerCount;
    if ( i < repPlayerCount )
    {
      if ( Right(PlayerName[i],5) == "&?&!&" )
      {
        PlayerName[i] = Mid(PlayerName[i],0,Len(PlayerName[i]) - 5);
        // There are 1 jump destination(s) inside the last statement!
      }
      bHasVoted = True;
      goto JL0B62;
      bHasVoted = False;
      MapVoteTabWindow(TheWindow).AddPlayerName(PlayerName[i],bHasVoted);
      // There are 1 jump destination(s) inside the last statement!
    }
    i++ ;
    goto JL0AFA;
    gPlayerCount = repPlayerCount;
    // There are 1 jump destination(s) inside the last statement!
  }
  bUpdated = True;
  i = 0;
  if ( (MapVoteResults[i] != "") && (i < 31) )
  {
    UpdateMapVoteResults(MapVoteResults[i],i);
    // There are 1 jump destination(s) inside the last statement!
  }
  i++ ;
  goto JL0BAB;
  i = 0;
  if ( (KickVoteResults[i] != "") && (i < 31) )
  {
    UpdateKickVoteResults(KickVoteResults[i],i);
    // There are 1 jump destination(s) inside the last statement!
  }
  i++ ;
  goto JL0BF2;
  MapVoteTabWindow(TheWindow).MapWindow.lblMapCount.SetText(string(repMapsCount) $ "/" $ string(MapCount) $ " Maps loaded");
  MapVoteTabWindow(TheWindow).MapWindow.lblMode.SetText("Mode: " $ Mode);
  MapVoteTabWindow(TheWindow).MapWindow.lblTitle1.SetText(List1Title);
  MapVoteTabWindow(TheWindow).MapWindow.lblTitle2.SetText(List2Title);
  MapVoteTabWindow(TheWindow).MapWindow.lblTitle3.SetText(List3Title);
  MapVoteTabWindow(TheWindow).MapWindow.lblTitle4.SetText(List4Title);
  MapVoteTabWindow(TheWindow).MapWindow.lblTitle.SetText(MapVoteTitle);
  MapVoteTabWindow(TheWindow).MapWindow.lblPriority1.SetText("Priority:" @ Left(string(List1Priority),3));
  MapVoteTabWindow(TheWindow).MapWindow.lblPriority2.SetText("Priority:" @ Left(string(List2Priority),3));
  MapVoteTabWindow(TheWindow).MapWindow.lblPriority3.SetText("Priority:" @ Left(string(List3Priority),3));
  MapVoteTabWindow(TheWindow).MapWindow.lblPriority4.SetText("Priority:" @ Left(string(List4Priority),3));
  MapVoteTabWindow(TheWindow).MapWindow.LogoTexture = LogoTexture;
  TitleChecksum = ;
  Len(List1Title) + Len(List2Title) + Len(List3Title) + Len(List4Title) + List1Priority + List2Priority + List3Priority + List4Priority;
  Len(PrefixDictionary);
  )
  if ( TitleChecksum != gTitleChecksum )
  {
    gTitleChecksum = TitleChecksum;
    // There are 1 jump destination(s) inside the last statement!
  }
  bUpdated = True;
  if ( ServerInfoURL != "" )
  {
    MapVoteTabWindow(TheWindow).InfoWindow.SetInfoServerAddress(ServerInfoURL,MapInfoURL);
    if ( MapVoteTabWindow(TheWindow).AdminWindow != None )
    {
      AdminWindow(MapVoteTabWindow(TheWindow).AdminWindow.ClientArea).txtServerInfoURL.SetValue(ServerInfoURL);
      // There are 2 jump destination(s) inside the last statement!
    }
  }
  goto JL0FD6;
  MapVoteNavBar(MapVoteTabWindow(TheWindow).InfoWindow.VSplitter.BottomClientWindow).ServerInfoButton.bDisabled = True;
  MapVoteNavBar(MapVoteTabWindow(TheWindow).InfoWindow.VSplitter.BottomClientWindow).ReportButton1.bDisabled = False;
  MapVoteNavBar(MapVoteTabWindow(TheWindow).InfoWindow.VSplitter.BottomClientWindow).ReportButton2.bDisabled = False;
  MapVoteTabWindow(TheWindow).MapWindow.PrefixDictionary = PrefixDictionary;
  if (  !bUpdated && blastCheck )
  {
    if ( MapVoteTabWindow(TheWindow).AdminWindow != None )
    {
      AdminWindow(MapVoteTabWindow(TheWindow).AdminWindow.ClientArea).RemoteSaveButton.bDisabled = False;
      // There are 2 jump destination(s) inside the last statement!
    }
  }
  return;
  if (  !bUpdated )
  {
    blastCheck = True;
    // There are 1 jump destination(s) inside the last statement!
  }
  SetTimer(1.0,False);
}

function GetServerConfig ()
{
  local int i;

  bKickVote = Class'BDBMapVote'.Default.bKickVote;
  ScoreBoardDelay = Class'BDBMapVote'.Default.ScoreBoardDelay;
  ServerInfoURL = Class'BDBMapVote'.Default.ServerInfoURL;
  MapInfoURL = Class'BDBMapVote'.Default.MapInfoURL;
  Mode = Class'BDBMapVote'.Default.Mode;
  bEntryWindows = Class'BDBMapVote'.Default.bEntryWindows;
  bDebugMode = Class'BDBMapVote'.Default.bDebugMode;
  LogoTexture = Class'BDBMapVote'.Default.LogoTexture;
  List1Title = Class'BDBMapVote'.Default.List1Title;
  List2Title = Class'BDBMapVote'.Default.List2Title;
  List3Title = Class'BDBMapVote'.Default.List3Title;
  List4Title = Class'BDBMapVote'.Default.List4Title;
  MapVoteTitle = Class'BDBMapVote'.Default.MapVoteTitle;
  if ( PlayerPawn(Owner).bAdmin )
  {
    DebugLog("Admin is logged in. Sending admin vars...");
    if ( Class'BDBMapVote'.Default.bDM )
    {
      GameTypes = "1";
    } else {
      GameTypes = "0";
    }
    if ( Class'BDBMapVote'.Default.bLMS )
    {
      GameTypes = GameTypes $ "1";
    } else {
      GameTypes = GameTypes $ "0";
    }
    if ( Class'BDBMapVote'.Default.bTDM )
    {
      GameTypes = GameTypes $ "1";
    } else {
      GameTypes = GameTypes $ "0";
    }
    if ( Class'BDBMapVote'.Default.bAS )
    {
      GameTypes = GameTypes $ "1";
    } else {
      GameTypes = GameTypes $ "0";
    }
    if ( Class'BDBMapVote'.Default.bDOM )
    {
      GameTypes = GameTypes $ "1";
    } else {
      GameTypes = GameTypes $ "0";
    }
    if ( Class'BDBMapVote'.Default.bCTF )
    {
      GameTypes = GameTypes $ "1";
    } else {
      GameTypes = GameTypes $ "0";
    }
    if ( False )
    {
      GameTypes = GameTypes $ "1";
    } else {
      GameTypes = GameTypes $ "0";
    }
    ActGameClass = string(Level.Game.Class);
    ActGamePrefix = Level.Game.MapPrefix;
    bReloadMapsOnRequestOnly = Class'BDBMapVote'.Default.bReloadMapsOnRequestOnly;
    MinMapCount = Class'BDBMapVote'.Default.MinMapCount;
    bAutoDetect = Class'BDBMapVote'.Default.bAutoDetect;
    RepeatLimit = Class'BDBMapVote'.Default.RepeatLimit;
    KickPercent = Class'BDBMapVote'.Default.KickPercent;
    bUseMapList = Class'BDBMapVote'.Default.bUseMapList;
    bAutoOpen = Class'BDBMapVote'.Default.bAutoOpen;
    VoteTimeLimit = Class'BDBMapVote'.Default.VoteTimeLimit;
    bCheckOtherGameTie = Class'BDBMapVote'.Default.bCheckOtherGameTie;
    MapVoteHistoryType = Class'BDBMapVote'.Default.MapVoteHistoryType;
    MidGameVotePercent = Class'BDBMapVote'.Default.MidGameVotePercent;
    bSortWithPreFix = Class'BDBMapVote'.Default.bSortWithPreFix;
    bRemoveCrashedMaps = Class'BDBMapVote'.Default.bRemoveCrashedMaps;
    ASClass = Class'BDBMapVote'.Default.ASClass;
    bUseExcludeFilter = Class'BDBMapVote'.Default.bUseExcludeFilter;
  }
}

simulated function AddNewPlayer (string NewPlayerName, bool bHasVoted)
{
  if ( bKickVote )
  {
    if ( TheWindow != None )
    {
      MapVoteTabWindow(TheWindow).AddPlayerName(NewPlayerName,bHasVoted);
    }
  }
}

simulated function RemovePlayerName (string OldPlayerName)
{
  if ( bKickVote )
  {
    if ( TheWindow != None )
    {
      MapVoteTabWindow(TheWindow).RemovePlayerName(OldPlayerName);
    }
  }
}

simulated function UpdatePlayerVoted (string PlayerID)
{
  if ( TheWindow != None )
  {
    MapVoteTabWindow(TheWindow).UpdatePlayerVoted(PlayerID);
  }
}

simulated function UpdateMapVoteResults (string Text, int i)
{
  if ( TheWindow != None )
  {
    MapVoteTabWindow(TheWindow).UpdateMapVoteResults(Text,i);
  }
}

simulated function UpdateKickVoteResults (string Text, int i)
{
  if ( TheWindow != None )
  {
    MapVoteTabWindow(TheWindow).UpdateKickVoteResults(Text,i);
  }
}

simulated function SendReportText (string p_ReportText)
{
  if ( p_ReportText == "" )
  {
    if ( TheWindow != None )
    {
      MapVoteTabWindow(TheWindow).InfoWindow.SetMOTD(ReportText);
    }
    ReportText = "";
  } else {
    ReportText = ReportText $ p_ReportText;
  }
}

function DestroyWRI ()
{
  Super.DestroyWRI();
}

function DebugLog (string Msg)
{
  Log("MV " $ Msg);
}

defaultproperties
{
    WindowClass=Class'MapVoteTabWindow'

    WinLeft=50

    WinTop=20

    WinWidth=663

    WinHeight=526

}
