//================================================================================
// MapVoteTabWindow.
//================================================================================

class MapVoteTabWindow extends UWindowDialogClientWindow;

var UMenuPageControl Pages;
var MapVoteClientWindow MapWindow;
var ConfigWindow ConfigWindow;
var AdminTabWindow AdminWindow;
var ServerInfoWindow InfoWindow;
var string PrevSelectedMap;
var string PrevSelectedPlayer;
var int MapCount;
var string InfoServerAddress;
var int InfoServerPort;
var string InfoFilePath;
var string ServerInfoFile;

function Created ()
{
  local UWindowPageControlPage PageControl;

  WinLeft = (Root.WinWidth - WinWidth) / 2;
  WinTop = (Root.WinHeight - WinHeight) / 2;
  Pages = UMenuPageControl(CreateWindow(Class'MapVotePageControl',0.0,0.0,WinWidth,WinHeight));
  Pages.SetMultiLine(False);
  PageControl = Pages.AddPage("Maps/Kick",Class'MapVoteClientWindow');
  MapWindow = MapVoteClientWindow(PageControl.Page);
  PageControl = Pages.AddPage("Config",Class'ConfigWindow');
  ConfigWindow = ConfigWindow(PageControl.Page);
  PageControl = Pages.AddPage("Info",Class'ServerInfoWindow');
  InfoWindow = ServerInfoWindow(PageControl.Page);
  if ( GetPlayerOwner().PlayerReplicationInfo.bAdmin )
  {
    PageControl = Pages.AddPage("Admin",Class'AdminTabWindow');
    AdminWindow = AdminTabWindow(PageControl.Page);
  }
  Super.Created();
}

function AddMapName (int listNum, string MapName)
{
  local UMenuMapVoteList i;

  if ( listNum == 1 )
  {
    i = UMenuMapVoteList(MapWindow.MapListBox1.Items.Append(Class'UMenuMapVoteList'));
  } else {
    if ( listNum == 2 )
    {
      i = UMenuMapVoteList(MapWindow.MapListBox2.Items.Append(Class'UMenuMapVoteList'));
    } else {
      if ( listNum == 3 )
      {
        i = UMenuMapVoteList(MapWindow.MapListBox3.Items.Append(Class'UMenuMapVoteList'));
      } else {
        i = UMenuMapVoteList(MapWindow.MapListBox4.Items.Append(Class'UMenuMapVoteList'));
      }
    }
  }
  i.MapName = MapName;
}

function ClearList (int listNum)
{
  if ( listNum == 1 )
  {
    MapWindow.MapListBox1.Items.Clear();
  } else {
    if ( listNum == 2 )
    {
      MapWindow.MapListBox2.Items.Clear();
    } else {
      if ( listNum == 3 )
      {
        MapWindow.MapListBox3.Items.Clear();
      } else {
        if ( listNum == 4 )
        {
          MapWindow.MapListBox4.Items.Clear();
        }
      }
    }
  }
}

function AddPlayerName (string PlayerName, bool bHasVoted)
{
  local PlayerVoteListItem i;
  local UWindowList Item;
  local int j;

  Item = MapWindow.PlayerListBox.Items;
  if ( Item != None )
  {
    if ( PlayerVoteListItem(Item).PlayerName == PlayerName )
    {
      return;
    }
    Item = Item.Next;
    goto JL001D;
  }
  i = PlayerVoteListItem(MapWindow.PlayerListBox.Items.Append(Class'PlayerVoteListItem'));
  i.PlayerName = PlayerName;
  i.bHasVoted = bHasVoted;
}

function ClearPlayerList ()
{
  MapWindow.PlayerListBox.Items.Clear();
}

function RemovePlayerName (string PlayerID)
{
  local UWindowList Item;

  Item = MapWindow.PlayerListBox.Items;
  if ( Item != None )
  {
    if ( Mid(PlayerVoteListItem(Item).PlayerName,1,3) == PlayerID )
    {
      Item.Remove();
      return;
    }
    Item = Item.Next;
    goto JL001D;
  }
}

function UpdatePlayerVoted (string PlayerID)
{
  local UWindowList Item;

  Item = MapWindow.PlayerListBox.Items;
  if ( Item != None )
  {
    if ( Mid(PlayerVoteListItem(Item).PlayerName,1,3) == PlayerID )
    {
      PlayerVoteListItem(Item).bHasVoted = True;
      return;
    }
    Item = Item.Next;
    goto JL001D;
  }
}

function EnableKickWindow ()
{
  local UWindowPageControlPage PageControl;

  MapWindow.KickVoteButton.bDisabled = False;
  MapWindow.KickVoteButton.Text = "Kick";
  MapWindow.PlayerListBox.bDisabled = False;
}

simulated function UpdateMapVoteResults (string Text, int i)
{
  local UWindowList Item;
  local string MapName;
  local int pos;
  local float C;

  if ( Text == "Clear" )
  {
    if ( MapWindow.lstMapStatus.SelectedItem != None )
    {
      PrevSelectedMap = MapStatusListItem(MapWindow.lstMapStatus.SelectedItem).MapName;
    }
    MapWindow.lstMapStatus.Items.Clear();
    return;
  }
  pos = InStr(Text,",");
  if ( pos > 0 )
  {
    MapName = Left(Text,pos);
    C = float(Mid(Text,pos + 1));
  }
  Item = MapWindow.lstMapStatus.Items;
  if ( Item != None )
  {
    if ( MapStatusListItem(Item).MapName == MapName )
    {
      MapStatusListItem(Item).rank = i + 1;
      MapStatusListItem(Item).VoteCount = C;
      return;
    }
    Item = Item.Next;
    goto JL00DC;
  }
  Item = MapStatusListItem(MapWindow.lstMapStatus.Items.Append(Class'MapStatusListItem'));
  MapStatusListItem(Item).rank = i + 1;
  MapStatusListItem(Item).MapName = MapName;
  MapStatusListItem(Item).VoteCount = C;
  if ( PrevSelectedMap == MapName )
  {
    MapWindow.lstMapStatus.SelectMap(PrevSelectedMap);
  }
}

simulated function UpdateKickVoteResults (string Text, int i)
{
  local UWindowList Item;
  local string PlayerName;
  local int C;
  local int pos;

  if ( Text == "" )
  {
    return;
  }
  if ( Text == "Clear" )
  {
    if ( MapWindow.lstKickStatus.SelectedItem != None )
    {
      PrevSelectedPlayer = KickStatusListItem(MapWindow.lstKickStatus.SelectedItem).PlayerName;
    }
    MapWindow.lstKickStatus.Items.Clear();
    return;
  }
  pos = InStr(Text,",");
  if ( pos > 0 )
  {
    PlayerName = Left(Text,pos);
    C = int(Mid(Text,pos + 1));
  }
  if ( MapWindow.lstKickStatus.Items != None )
  {
    Item = MapWindow.lstKickStatus.Items;
    if ( Item != None )
    {
      if ( KickStatusListItem(Item).PlayerName == PlayerName )
      {
        KickStatusListItem(Item).VoteCount = C;
        return;
      }
      Item = Item.Next;
      goto JL0107;
    }
  }
  Item = KickStatusListItem(MapWindow.lstKickStatus.Items.Append(Class'KickStatusListItem'));
  KickStatusListItem(Item).PlayerName = PlayerName;
  KickStatusListItem(Item).VoteCount = C;
  if ( (PrevSelectedPlayer != "") && (PrevSelectedPlayer == PlayerName) )
  {
    MapWindow.lstKickStatus.SelectPlayer(PrevSelectedPlayer);
  }
}

