//================================================================================
// MapVoteClientWindow.
//================================================================================

class MapVoteClientWindow extends UWindowPageWindow;

var MapVoteListBox MapListBox1;
var MapVoteListBox MapListBox2;
var MapVoteListBox MapListBox3;
var MapVoteListBox MapListBox4;
var UWindowSmallButton CloseButton;
var UWindowSmallButton VoteButton;
var UWindowSmallButton InfoButton;
var PlayerVoteListBox PlayerListBox;
var UWindowSmallButton KickVoteButton;
var MapStatusListBox lstMapStatus;
var KickStatusListBox lstKickStatus;
var UWindowCheckbox cbLoadScreenShot;
var UMenuLabelControl lblStatusTitles;
var UMenuLabelControl lblTitle1;
var UMenuLabelControl lblTitle2;
var UMenuLabelControl lblTitle3;
var UMenuLabelControl lblTitle4;
var UMenuLabelControl lblTitle;
var UMenuLabelControl lblMaptxt1;
var UMenuLabelControl lblMaptxt2;
var UMenuLabelControl lblMaptxt3;
var UMenuLabelControl lblPriority1;
var UMenuLabelControl lblPriority2;
var UMenuLabelControl lblPriority3;
var UMenuLabelControl lblPriority4;
var UMenuLabelControl lblMapCount;
var UWindowEditControl txtFind;
var UWindowSmallButton SendButton;
var UWindowEditControl txtMessage;
var UMenuLabelControl lblMode;
var bool bKickVote;
var Texture Screenshot;
var string MapTitle;
var string MapAuthor;
var string IdealPlayerCount;
var float LastVoteTime;
var float SelectionTime;
var string LogoTexture;
var int MapListwidth;
var int PlayerListwidth;
var int ListHeight;
var bool bMapAlreadySet;
var string PrefixDictionary;

function Created ()
{
  local Color TextColor;
  local Color TextColorTitles;
  local Color TextColorTitle;
  local int LowSectionStart;
  local int RightSectionStart;

  Super.Created();
  TextColor.R = 255;
  TextColor.G = 255;
  TextColor.B = 255;
  TextColorTitles.R = 255;
  TextColorTitles.G = 10;
  TextColorTitles.B = 10;
  TextColorTitle.R = 255;
  TextColorTitle.G = 255;
  TextColorTitle.B = 10;
  MapListwidth = 120;
  PlayerListwidth = 120;
  ListHeight = 324;
  LowSectionStart = ListHeight + 81;
  RightSectionStart = 400;
  MapListBox1 = MapVoteListBox(CreateControl(Class'MapVoteListBox',10.0,26.0,MapListwidth,ListHeight));
  MapListBox1.Items.Clear();
  MapListBox2 = MapVoteListBox(CreateControl(Class'MapVoteListBox',20.0 + MapListwidth,26.0,MapListwidth,ListHeight));
  MapListBox2.Items.Clear();
  MapListBox3 = MapVoteListBox(CreateControl(Class'MapVoteListBox',40.0 + 2 * MapListwidth + PlayerListwidth,26.0,MapListwidth,ListHeight));
  MapListBox3.Items.Clear();
  MapListBox4 = MapVoteListBox(CreateControl(Class'MapVoteListBox',50.0 + 3 * MapListwidth + PlayerListwidth,26.0,MapListwidth,ListHeight));
  MapListBox4.Items.Clear();
  VoteButton = UWindowSmallButton(CreateControl(Class'UWindowSmallButton',10.0,ListHeight + 46,40.0 + 4 * MapListwidth + PlayerListwidth,21.0));
  VoteButton.DownSound = Sound'BeltSnd';
  VoteButton.Text = "Vote";
  VoteButton.bDisabled = False;
  PlayerListBox = PlayerVoteListBox(CreateControl(Class'PlayerVoteListBox',30.0 + 2 * MapListwidth,172.0,PlayerListwidth,-168.0 + ListHeight));
  PlayerListBox.Items.Clear();
  PlayerListBox.bDisabled = True;
  KickVoteButton = UWindowSmallButton(CreateControl(Class'UWindowSmallButton',30.0 + 2 * MapListwidth,ListHeight + 11,PlayerListwidth,18.0));
  KickVoteButton.DownSound = Sound'BeltSnd';
  if ( bKickVote || GetPlayerOwner().PlayerReplicationInfo.bAdmin )
  {
    KickVoteButton.Text = "Kick";
    KickVoteButton.bDisabled = True;
  } else {
    KickVoteButton.Text = "";
    KickVoteButton.bDisabled = False;
  }
  lblStatusTitles = UMenuLabelControl(CreateControl(Class'UMenuLabelControl',10.0,LowSectionStart - 15,30.0 + 2 * MapListwidth + PlayerListwidth,10.0));
  lblStatusTitles.SetText("Rank   Map name                       Votes                          Player name    Votes");
  lblStatusTitles.SetFont(0);
  lblStatusTitles.SetTextColor(TextColor);
  lstMapStatus = MapStatusListBox(CreateControl(Class'MapStatusListBox',10.0,LowSectionStart,200.0,90.0));
  lstMapStatus.bAcceptsFocus = False;
  lstMapStatus.Items.Clear();
  lstKickStatus = KickStatusListBox(CreateControl(Class'KickStatusListBox',230.0,LowSectionStart,150.0,90.0));
  lstKickStatus.bAcceptsFocus = False;
  lstKickStatus.Items.Clear();
  lblMaptxt1 = UMenuLabelControl(CreateControl(Class'UMenuLabelControl',30.0 + 2 * MapListwidth,140.0,PlayerListwidth,10.0));
  lblMaptxt1.SetTextColor(TextColor);
  lblMaptxt1.Align = 2;
  lblMaptxt2 = UMenuLabelControl(CreateControl(Class'UMenuLabelControl',30.0 + 2 * MapListwidth,149.0,PlayerListwidth,10.0));
  lblMaptxt2.SetTextColor(TextColor);
  lblMaptxt2.Align = 2;
  lblMaptxt3 = UMenuLabelControl(CreateControl(Class'UMenuLabelControl',30.0 + 2 * MapListwidth,158.0,PlayerListwidth,10.0));
  lblMaptxt3.SetTextColor(TextColor);
  lblMaptxt3.Align = 2;
  lblTitle1 = UMenuLabelControl(CreateControl(Class'UMenuLabelControl',0.0,10.0,MapListwidth + 20,20.0));
  lblTitle1.SetFont(1);
  lblTitle1.Align = 2;
  lblTitle1.SetTextColor(TextColorTitles);
  lblTitle2 = UMenuLabelControl(CreateControl(Class'UMenuLabelControl',10.0 + MapListwidth,10.0,MapListwidth + 20,20.0));
  lblTitle2.SetFont(1);
  lblTitle2.Align = 2;
  lblTitle2.SetTextColor(TextColorTitles);
  lblTitle = UMenuLabelControl(CreateControl(Class'UMenuLabelControl',15.0 + 2 * MapListwidth,10.0,PlayerListwidth + 30,20.0));
  lblTitle.SetFont(1);
  lblTitle.Align = 2;
  lblTitle.SetTextColor(TextColorTitle);
  lblTitle3 = UMenuLabelControl(CreateControl(Class'UMenuLabelControl',30.0 + 2 * MapListwidth + PlayerListwidth,10.0,MapListwidth + 20,20.0));
  lblTitle3.SetFont(1);
  lblTitle3.Align = 2;
  lblTitle3.SetTextColor(TextColorTitles);
  lblTitle4 = UMenuLabelControl(CreateControl(Class'UMenuLabelControl',40.0 + 3 * MapListwidth + PlayerListwidth,10.0,MapListwidth + 20,20.0));
  lblTitle4.SetFont(1);
  lblTitle4.Align = 2;
  lblTitle4.SetTextColor(TextColorTitles);
  lblPriority1 = UMenuLabelControl(CreateControl(Class'UMenuLabelControl',0.0,ListHeight + 30,MapListwidth + 20,20.0));
  lblPriority1.Align = 2;
  lblPriority1.SetTextColor(TextColor);
  lblPriority2 = UMenuLabelControl(CreateControl(Class'UMenuLabelControl',10.0 + MapListwidth,ListHeight + 30,MapListwidth + 20,20.0));
  lblPriority2.Align = 2;
  lblPriority2.SetTextColor(TextColor);
  lblPriority3 = UMenuLabelControl(CreateControl(Class'UMenuLabelControl',30.0 + 2 * MapListwidth + PlayerListwidth,ListHeight + 30,MapListwidth + 20,20.0));
  lblPriority3.Align = 2;
  lblPriority3.SetTextColor(TextColor);
  lblPriority4 = UMenuLabelControl(CreateControl(Class'UMenuLabelControl',40.0 + 3 * MapListwidth + PlayerListwidth,ListHeight + 30,MapListwidth + 20,20.0));
  lblPriority4.Align = 2;
  lblPriority4.SetTextColor(TextColor);
  lblMapCount = UMenuLabelControl(CreateControl(Class'UMenuLabelControl',RightSectionStart,LowSectionStart,110.0,20.0));
  lblMapCount.SetFont(0);
  lblMapCount.SetTextColor(TextColor);
  lblMode = UMenuLabelControl(CreateControl(Class'UMenuLabelControl',RightSectionStart + 120,LowSectionStart,100.0,20.0));
  lblMode.SetText("Mode:");
  lblMode.SetFont(0);
  lblMode.SetTextColor(TextColor);
  cbLoadScreenShot = UWindowCheckbox(CreateControl(Class'UWindowCheckbox',RightSectionStart,LowSectionStart + 20,70.0,20.0));
  cbLoadScreenShot.SetText("ScreenShot");
  cbLoadScreenShot.Align = 1;
  cbLoadScreenShot.SetFont(0);
  cbLoadScreenShot.SetTextColor(TextColor);
  cbLoadScreenShot.bChecked = Class'BDBMapVote'.Default.bLoadScreenShot;
  txtMessage = UWindowEditControl(CreateControl(Class'UWindowEditControl',RightSectionStart - 75 - MapListwidth,LowSectionStart + 45,2.0 * MapListwidth + 150,20.0));
  txtMessage.SetNumericOnly(False);
  txtMessage.SetHistory(True);
  txtMessage.SetMaxLength(150);
  SendButton = UWindowSmallButton(CreateControl(Class'UWindowSmallButton',RightSectionStart + 2 * MapListwidth - 30,LowSectionStart + 45,40.0,20.0));
  SendButton.Text = "Send";
  SendButton.bDisabled = False;
  CloseButton = UWindowSmallButton(CreateControl(Class'UWindowSmallButton',RightSectionStart,LowSectionStart + 75,2.0 * MapListwidth + 10,20.0));
  CloseButton.DownSound = Sound'WeaponPickup';
  CloseButton.Text = "Close";
  CloseButton.bDisabled = False;
}

function DeSelectAllOtherMapListBoxItems (MapVoteListBox selListBox, int listNum)
{
  if ( listNum != 1 )
  {
    if ( MapListBox1.SelectedItem != None )
    {
      MapListBox1.SelectedItem.bSelected = False;
    }
    MapListBox1.SelectedItem = None;
  }
  if ( listNum != 2 )
  {
    if ( MapListBox2.SelectedItem != None )
    {
      MapListBox2.SelectedItem.bSelected = False;
    }
    MapListBox2.SelectedItem = None;
  }
  if ( listNum != 3 )
  {
    if ( MapListBox3.SelectedItem != None )
    {
      MapListBox3.SelectedItem.bSelected = False;
    }
    MapListBox3.SelectedItem = None;
  }
  if ( listNum != 4 )
  {
    if ( MapListBox4.SelectedItem != None )
    {
      MapListBox4.SelectedItem.bSelected = False;
    }
    MapListBox4.SelectedItem = None;
  }
  if ( (listNum >= 1) && (listNum <= 4) )
  {
    selListBox.MakeSelectedVisible();
  }
}

function UWindowListBoxItem getSelectedItem ()
{
  if ( MapListBox1.SelectedItem != None )
  {
    return MapListBox1.SelectedItem;
  }
  if ( MapListBox2.SelectedItem != None )
  {
    return MapListBox2.SelectedItem;
  }
  if ( MapListBox3.SelectedItem != None )
  {
    return MapListBox3.SelectedItem;
  }
  if ( MapListBox4.SelectedItem != None )
  {
    return MapListBox4.SelectedItem;
  }
}

function Notify (UWindowDialogControl C, byte E)
{
  local int listNum;

  Super.Notify(C,E);
  switch (E)
  {
    case 1:
    switch (C)
    {
      default:
    }
    break;
    case 11:
    switch (C)
    {
      case MapListBox1:
      if ( GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 5 )
      {
        if ( (Left(UMenuMapVoteList(MapListBox1.SelectedItem).MapName,3) != "[X]") || GetPlayerOwner().PlayerReplicationInfo.bAdmin )
        {
          GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE MAP " $ UMenuMapVoteList(MapListBox1.SelectedItem).MapName);
          LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
        }
      }
      SelectionTime = GetPlayerOwner().Level.TimeSeconds;
      DeSelectAllOtherMapListBoxItems(MapListBox1,1);
      break;
      case MapListBox2:
      if ( GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 5 )
      {
        if ( (Left(UMenuMapVoteList(MapListBox2.SelectedItem).MapName,3) != "[X]") || GetPlayerOwner().PlayerReplicationInfo.bAdmin )
        {
          GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE MAP " $ UMenuMapVoteList(MapListBox2.SelectedItem).MapName);
          LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
        }
      }
      SelectionTime = GetPlayerOwner().Level.TimeSeconds;
      DeSelectAllOtherMapListBoxItems(MapListBox2,2);
      break;
      case MapListBox3:
      if ( GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 5 )
      {
        if ( (Left(UMenuMapVoteList(MapListBox3.SelectedItem).MapName,3) != "[X]") || GetPlayerOwner().PlayerReplicationInfo.bAdmin )
        {
          GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE MAP " $ UMenuMapVoteList(MapListBox3.SelectedItem).MapName);
          LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
        }
      }
      SelectionTime = GetPlayerOwner().Level.TimeSeconds;
      DeSelectAllOtherMapListBoxItems(MapListBox3,3);
      break;
      case MapListBox4:
      if ( GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 5 )
      {
        if ( (Left(UMenuMapVoteList(MapListBox4.SelectedItem).MapName,3) != "[X]") || GetPlayerOwner().PlayerReplicationInfo.bAdmin )
        {
          GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE MAP " $ UMenuMapVoteList(MapListBox4.SelectedItem).MapName);
          LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
        }
      }
      SelectionTime = GetPlayerOwner().Level.TimeSeconds;
      DeSelectAllOtherMapListBoxItems(MapListBox4,4);
      break;
      case lstMapStatus:
      listNum = getListNum(MapStatusListItem(lstMapStatus.SelectedItem).MapName);
      DeSelectAllOtherMapListBoxItems(MapListBox1,0);
      if ( listNum == 1 )
      {
        MapListBox1.SelectMap(MapStatusListItem(lstMapStatus.SelectedItem).MapName);
      }
      if ( listNum == 2 )
      {
        MapListBox2.SelectMap(MapStatusListItem(lstMapStatus.SelectedItem).MapName);
      }
      if ( listNum == 3 )
      {
        MapListBox3.SelectMap(MapStatusListItem(lstMapStatus.SelectedItem).MapName);
      }
      if ( listNum == 4 )
      {
        MapListBox4.SelectMap(MapStatusListItem(lstMapStatus.SelectedItem).MapName);
      }
      if ( GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 5 )
      {
        GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE MAP " $ MapStatusListItem(lstMapStatus.SelectedItem).MapName);
        LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
      }
      SelectionTime = GetPlayerOwner().Level.TimeSeconds;
      break;
      case PlayerListBox:
      if ( GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 5 )
      {
        GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE KICK " $ PlayerVoteListItem(PlayerListBox.SelectedItem).PlayerName);
        LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
      }
      break;
      case lstKickStatus:
      PlayerListBox.SelectPlayer(KickStatusListItem(lstKickStatus.SelectedItem).PlayerName);
      Log("Select Player:" @ KickStatusListItem(lstKickStatus.SelectedItem).PlayerName);
      if ( GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 5 )
      {
        GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE KICK " $ PlayerVoteListItem(PlayerListBox.SelectedItem).PlayerName);
        LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
      }
      break;
      default:
    }
    break;
    case 2:
    switch (C)
    {
      case SendButton:
      if ( txtMessage.GetValue() != "" )
      {
        GetPlayerOwner().ConsoleCommand("SAY " $ txtMessage.GetValue());
        txtMessage.SetValue("");
      }
      break;
      case VoteButton:
      if ( GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 5 )
      {
        if ( getSelectedItem() != None )
        {
          if ( (Left(UMenuMapVoteList(getSelectedItem()).MapName,3) != "[X]") || GetPlayerOwner().PlayerReplicationInfo.bAdmin )
          {
            if ( UMenuMapVoteList(getSelectedItem()).MapName != "" )
            {
              GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE MAP " $ UMenuMapVoteList(getSelectedItem()).MapName);
            }
            LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
          }
        }
      }
      break;
      case CloseButton:
      ParentWindow.ParentWindow.Close();
      break;
      case MapListBox1:
      SelectionTime = GetPlayerOwner().Level.TimeSeconds;
      DeSelectAllOtherMapListBoxItems(MapListBox1,1);
      break;
      case MapListBox2:
      SelectionTime = GetPlayerOwner().Level.TimeSeconds;
      DeSelectAllOtherMapListBoxItems(MapListBox2,2);
      break;
      case MapListBox3:
      SelectionTime = GetPlayerOwner().Level.TimeSeconds;
      DeSelectAllOtherMapListBoxItems(MapListBox3,3);
      break;
      case MapListBox4:
      SelectionTime = GetPlayerOwner().Level.TimeSeconds;
      DeSelectAllOtherMapListBoxItems(MapListBox4,4);
      break;
      case lstMapStatus:
      listNum = getListNum(MapStatusListItem(lstMapStatus.SelectedItem).MapName);
      DeSelectAllOtherMapListBoxItems(MapListBox1,0);
      if ( listNum == 1 )
      {
        MapListBox1.SelectMap(MapStatusListItem(lstMapStatus.SelectedItem).MapName);
      }
      if ( listNum == 2 )
      {
        MapListBox2.SelectMap(MapStatusListItem(lstMapStatus.SelectedItem).MapName);
      }
      if ( listNum == 3 )
      {
        MapListBox3.SelectMap(MapStatusListItem(lstMapStatus.SelectedItem).MapName);
      }
      if ( listNum == 4 )
      {
        MapListBox4.SelectMap(MapStatusListItem(lstMapStatus.SelectedItem).MapName);
      }
      SelectionTime = GetPlayerOwner().Level.TimeSeconds;
      break;
      case KickVoteButton:
      if ( GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 5 )
      {
        GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE KICK " $ PlayerVoteListItem(PlayerListBox.SelectedItem).PlayerName);
        LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
      }
      break;
      case lstKickStatus:
      PlayerListBox.SelectPlayer(KickStatusListItem(lstKickStatus.SelectedItem).PlayerName);
      break;
      default:
    }
    break;
    case 7:
    if ( txtMessage.GetValue() != "" )
    {
      GetPlayerOwner().ConsoleCommand("SAY " $ txtMessage.GetValue());
      txtMessage.SetValue("");
      txtMessage.FocusOtherWindow(SendButton);
    }
    break;
    default:
  }
}

function int getListNum (string MapName)
{
  if ( MapListBox1.isMapInList(MapName) )
  {
    return 1;
  }
  if ( MapListBox2.isMapInList(MapName) )
  {
    return 2;
  }
  if ( MapListBox3.isMapInList(MapName) )
  {
    return 3;
  }
  if ( MapListBox4.isMapInList(MapName) )
  {
    return 4;
  }
}

function Tick (float DeltaTime)
{
  if ( (SelectionTime != 0) && (GetPlayerOwner().Level.TimeSeconds > SelectionTime + 1) )
  {
    if ( getSelectedItem() != None )
    {
      SetMap(UMenuMapVoteList(getSelectedItem()).MapName);
      SelectionTime = 0.0;
    }
  }
  Super.Tick(DeltaTime);
}

function SetMap (string MapName)
{
  local int i;
  local int pos;
  local string Prefix;
  local string RealPreFix;
  local LevelSummary L;
  local string RealMapName;

  if (  !cbLoadScreenShot.bChecked )
  {
    return;
  }
  bMapAlreadySet = True;
  i = InStr(Caps(MapName),".UNR");
  if ( i != -1 )
  {
    MapName = Left(MapName,i);
  }
  RealMapName = GetRealMapname(MapName);
  Screenshot = Texture(DynamicLoadObject(RealMapName $ ".Screenshot",Class'Texture'));
  L = LevelSummary(DynamicLoadObject(RealMapName $ ".LevelSummary",Class'LevelSummary'));
  if ( Left(MapName,3) == "[X]" )
  {
    MapTitle = "You can NOT";
    MapAuthor = "vote for this map.";
    IdealPlayerCount = "";
  } else {
    if ( L != None )
    {
      MapTitle = L.Title;
      MapAuthor = L.Author;
      IdealPlayerCount = L.IdealPlayerCount;
    } else {
      MapTitle = "DownLoad";
      MapAuthor = "Required";
      IdealPlayerCount = "";
    }
  }
}

function string GetRealMapname (string VirtualMap)
{
  local string MapName;
  local string Dictionary;
  local string virt;
  local string Real;

  Dictionary = "TDM;DM;LMS;DM;" $ PrefixDictionary;
  if ( Left(VirtualMap,3) ~= "[X]" )
  {
    VirtualMap = Mid(VirtualMap,3);
  }
JL004A:
  MapName = VirtualMap;
  if ( Dictionary != "" )
  {
    virt = Left(Dictionary,InStr(Dictionary,";"));
    Dictionary = Mid(Dictionary,InStr(Dictionary,";") + 1);
    Real = Left(Dictionary,InStr(Dictionary,";"));
    Dictionary = Mid(Dictionary,InStr(Dictionary,";") + 1);
    if ( (Left(VirtualMap,4) != "CTF-") && (Left(VirtualMap,Len(virt) + 1) ~= (virt $ "-")) )
    {
      MapName = Real $ Mid(VirtualMap,Len(virt));
      return MapName;
    }
    goto JL004A;
  }
  return MapName;
}

function Paint (Canvas C, float MouseX, float MouseY)
{
  local int i;
  local int P1;
  local int P2;
  local int pos;
  local string TempText;
  local string textline;
  local float X;
  local float Y;
  local float W;
  local float H;

  Super.Paint(C,MouseX,MouseY);
  DrawStretchedTexture(C,0.0,0.0,WinWidth,WinHeight,Texture'BlackTexture');
  if (  !bMapAlreadySet && (LogoTexture != "") && (Screenshot == None) )
  {
    Screenshot = Texture(DynamicLoadObject(LogoTexture,Class'Texture'));
    bMapAlreadySet = True;
  }
  if ( Screenshot != None )
  {
    C.DrawColor.R = 255;
    C.DrawColor.G = 255;
    C.DrawColor.B = 255;
    DrawStretchedTexture(C,30.0 + 2 * MapListwidth,27.0,PlayerListwidth,110.0,Screenshot);
  }
  if ( MapTitle != "" )
  {
    lblMaptxt1.SetText(MapTitle);
  } else {
    lblMaptxt1.SetText("");
  }
  if ( MapAuthor != "" )
  {
    lblMaptxt2.SetText(MapAuthor);
  } else {
    lblMaptxt2.SetText("");
  }
  if ( IdealPlayerCount != "" )
  {
    lblMaptxt3.SetText(IdealPlayerCount @ "Players");
  } else {
    lblMaptxt3.SetText("");
  }
}

function KeyDown (int Key, float X, float Y)
{
  ParentWindow.KeyDown(Key,X,Y);
}

function Close (optional bool bByParent)
{
  local int W;
  local int Mode;

  if ( Class'BDBMapVote'.Default.bLoadScreenShot != cbLoadScreenShot.bChecked )
  {
    Class'BDBMapVote'.Default.bLoadScreenShot = cbLoadScreenShot.bChecked;
    Class'BDBMapVote'.StaticSaveConfig();
  }
  Super.Close(bByParent);
}

