//================================================================================
// MapStatusListBox.
//================================================================================

class MapStatusListBox extends UWindowListBox;

function Created ()
{
  Super.Created();
  VertSB.Close();
  VertSB = UWindowVScrollbar(CreateWindow(Class'PlainVScrollBar',WinWidth - 12,0.0,12.0,WinHeight));
}

function Paint (Canvas C, float MouseX, float MouseY)
{
  C.DrawColor.R = 255;
  C.DrawColor.G = 255;
  C.DrawColor.B = 255;
  DrawStretchedTexture(C,0.0,0.0,WinWidth,1.0,Texture'WhiteTexture');
  DrawStretchedTexture(C,0.0,0.0,1.0,WinHeight - 1,Texture'WhiteTexture');
  DrawStretchedTexture(C,20.0,0.0,1.0,WinHeight - 1,Texture'WhiteTexture');
  DrawStretchedTexture(C,160.0,0.0,1.0,WinHeight - 1,Texture'WhiteTexture');
  DrawStretchedTexture(C,0.0,WinHeight - 1,WinWidth,1.0,Texture'WhiteTexture');
  Super.Paint(C,MouseX,MouseY);
}

function DrawItem (Canvas C, UWindowList Item, float X, float Y, float W, float H)
{
  if ( MapStatusListItem(Item).bSelected )
  {
    C.DrawColor.R = 0;
    C.DrawColor.G = 0;
    C.DrawColor.B = 128;
    DrawStretchedTexture(C,X,Y + 1,W,H - 2,Texture'WhiteTexture');
    C.DrawColor.R = 255;
    C.DrawColor.G = 255;
    C.DrawColor.B = 255;
    DrawStretchedTexture(C,X,Y + H - 1,W,1.0,Texture'WhiteTexture');
    DrawStretchedTexture(C,20.0,Y,1.0,H,Texture'WhiteTexture');
    DrawStretchedTexture(C,0.0,Y,1.0,H,Texture'WhiteTexture');
    DrawStretchedTexture(C,160.0,Y,1.0,H,Texture'WhiteTexture');
  } else {
    C.DrawColor.R = 255;
    C.DrawColor.G = 255;
    C.DrawColor.B = 255;
    DrawStretchedTexture(C,X,Y + H - 1,W,1.0,Texture'WhiteTexture');
  }
  C.Font = Root.Fonts[0];
  ClipText(C,X + 5,Y,string(MapStatusListItem(Item).rank));
  ClipText(C,X + 25,Y,MapStatusListItem(Item).MapName);
  ClipText(C,X + 165,Y,Left(string(MapStatusListItem(Item).VoteCount),3));
}

function SelectMap (string MapName)
{
  local MapStatusListItem MapItem;

  MapItem = MapStatusListItem(Items);
  if ( MapItem != None )
  {
    if ( MapName ~= MapItem.MapName )
    {
      SetSelectedItem(MapItem);
      MakeSelectedVisible();
    } else {
      MapItem = MapStatusListItem(MapItem.Next);
      goto JL0010;
    }
  }
}

function DoubleClickItem (UWindowListBoxItem i)
{
  UWindowDialogClientWindow(ParentWindow).Notify(self,11);
}

defaultproperties
{
    ItemHeight=13.00

    ListClass=Class'MapStatusListItem'

}
