//================================================================================
// MVWelcomeWRI.
//================================================================================

class MVWelcomeWRI extends WRI;

var string ServerInfoURL;
var string MapInfoURL;
var bool bHasStartWindow;

replication
{
  un?reliable if ( Role == 4 )
    ServerInfoURL,MapInfoURL,bHasStartWindow;
}

simulated function bool SetupWindow ()
{
  local int i;
  local WindowConsole C;

  if ( Class'BDBMapVote'.Default.bUseMsgTimeout )
  {
    Class'SayMessagePlus'.Default.Lifetime = Class'BDBMapVote'.Default.MsgTimeOut;
    Class'CriticalStringPlus'.Default.Lifetime = Class'BDBMapVote'.Default.MsgTimeOut;
    Class'RedSayMessagePlus'.Default.Lifetime = Class'BDBMapVote'.Default.MsgTimeOut;
    Class'TeamSayMessagePlus'.Default.Lifetime = Class'BDBMapVote'.Default.MsgTimeOut;
    Class'StringMessagePlus'.Default.Lifetime = Class'BDBMapVote'.Default.MsgTimeOut;
    Class'DeathMessagePlus'.Default.Lifetime = Class'BDBMapVote'.Default.MsgTimeOut;
  }
  if ( (ServerInfoURL != "") && Class'MapVoteNavBar'.Default.bShowWelcomeWindow )
  {
    if ( Super.SetupWindow() )
    {
      SetTimer(1.0,False);
    } else {
      Log("Super.SetupWindow() = false");
    }
  } else {
    SetTimer(1.0,False);
  }
}

simulated function Timer ()
{
  local WindowConsole C;
  local UWindowWindow KeyBinderWindow;
  local UWindowWindow Child;
  local bool bHotKeyBound;

  if ( (ServerInfoURL != "") && Class'MapVoteNavBar'.Default.bShowWelcomeWindow )
  {
    MVWelcomeWindow(TheWindow).bHasStartWindow = bHasStartWindow;
    ServerInfoWindow(TheWindow.FirstChildWindow).SetInfoServerAddress(ServerInfoURL,MapInfoURL);
    ServerInfoWindow(TheWindow.FirstChildWindow).BrowseWebPage(ServerInfoURL);
  }
  C = WindowConsole(PlayerPawn(Owner).Player.Console);
  bHotKeyBound = HotKeyBound();
  if (  !bHotKeyBound )
  {
    KeyBinderWindow = C.Root.CreateWindow(Class'MVKeyBinderFrameWindow',0.0,0.0,480.0,240.0);
    MVKeyBinderFrameWindow(KeyBinderWindow).bHasStartWindow = bHasStartWindow;
    KeyBinderWindow.bLeaveOnscreen = True;
    KeyBinderWindow.ShowWindow();
  }
  if ( ((ServerInfoURL == "") ||  !Class'MapVoteNavBar'.Default.bShowWelcomeWindow) && bHotKeyBound )
  {
    if ( bHasStartWindow )
    {
      FocusStartWindow();
    } else {
      C.CloseUWindow();
    }
  }
  DestroyWRI();
}

function GetServerConfig ()
{
  ServerInfoURL = Class'BDBMapVote'.Default.ServerInfoURL;
  MapInfoURL = Class'BDBMapVote'.Default.MapInfoURL;
}

simulated function FocusStartWindow ()
{
  local UWindowWindow Child;
  local WindowConsole C;

  Log("FocusStartWindow");
  C = WindowConsole(PlayerPawn(Owner).Player.Console);
  Child = C.Root.LastChildWindow;
  if ( Child != None )
  {
    if ( (Left(string(Child.Class),6) == "UTMenu") || (Left(string(Child.Class),5) == "UMenu") )
    {
      C.CloseUWindow();
    } else {
      if ( Child.Class != self.Class )
      {
        goto JL00ED;
      }
    }
    Child = Child.PrevSiblingWindow;
    goto JL0058;
  }
  if ( Child == None )
  {
    C.CloseUWindow();
  } else {
    Child.bLeaveOnscreen = True;
    Child.FocusWindow();
    Child.ShowWindow();
  }
}

simulated function bool HotKeyBound ()
{
  local int i;
  local string KeyName;
  local string Alias;

  i = 0;
  if ( i < 255 )
  {
    KeyName = PlayerPawn(Owner).ConsoleCommand("KEYNAME " $ string(i));
    if ( KeyName != "" )
    {
      Alias = PlayerPawn(Owner).ConsoleCommand("KEYBINDING " $ KeyName);
      if ( Caps(Alias) == "MUTATE BDBMAPVOTE VOTEMENU" )
      {
        return True;
      }
    }
    i++;
    goto JL0007;
  }
  return False;
}

defaultproperties
{
    WindowClass=Class'MVWelcomeWindow'

    WinLeft=50

    WinTop=30

    WinWidth=405

    WinHeight=345

}
