//================================================================================
// ConfigWindow.
//================================================================================

class ConfigWindow extends UWindowPageWindow;

var string RealKeyName[255];
var UMenuLabelControl lblMenuKey;
var UMenuRaisedButton cmdMenuKey;
var UWindowSmallButton CloseButton;
var bool bPolling;
var UMenuRaisedButton SelectedButton;
var string OldHotKey;
var UWindowHSliderControl sldMsgTimeOut;
var UMenuLabelControl lblMsgTimeOut;
var int sizefactor;
var bool bSliderInited;
var UWindowCheckbox cbUseMsgTimeout;

function Created ()
{
  local Color C;

  Super.Created();
  lblMenuKey = UMenuLabelControl(CreateControl(Class'UMenuLabelControl',20.0,23.0,120.0,20.0));
  lblMenuKey.SetText("Map Voting Menu Hot Key");
  cmdMenuKey = UMenuRaisedButton(CreateControl(Class'UMenuRaisedButton',145.0,20.0,50.0,1.0));
  cmdMenuKey.bAcceptsFocus = False;
  cmdMenuKey.bIgnoreLDoubleClick = True;
  cmdMenuKey.bIgnoreMDoubleClick = True;
  cmdMenuKey.bIgnoreRDoubleClick = True;
  sldMsgTimeOut = UWindowHSliderControl(CreateControl(Class'UWindowHSliderControl',20.0,80.0,170.0,20.0));
  sldMsgTimeOut.bAcceptsFocus = False;
  sldMsgTimeOut.MinValue = 3.0;
  sldMsgTimeOut.MaxValue = 60.0;
  sldMsgTimeOut.Step = 1;
  sldMsgTimeOut.SetText("Message Expiration");
  sldMsgTimeOut.SetValue(Class'BDBMapVote'.Default.MsgTimeOut);
  bSliderInited = True;
  lblMsgTimeOut = UMenuLabelControl(CreateControl(Class'UMenuLabelControl',200.0,80.0,40.0,20.0));
  lblMsgTimeOut.SetText(string(SelectMap) $ sldMsgTimeOut," sec");
  {
    )
    cbUseMsgTimeout = UWindowCheckbox(CreateControl(Class'UWindowCheckbox',20.0,55.0,200.0,20.0));
    cbUseMsgTimeout.SetText("Change Message Expiration");
    cbUseMsgTimeout.SetFont(0);
    cbUseMsgTimeout.Align = 1;
    cbUseMsgTimeout.SetSize(200.0,1.0);
    cbUseMsgTimeout.bChecked = Class'BDBMapVote'.Default.bUseMsgTimeout;
    sizefactor = ;
    WinHeight
    415
    )
    CloseButton = UWindowSmallButton(CreateControl(Class'UWindowSmallButton',570.0,385.0 + sizefactor,80.0,20.0));
    CloseButton.Text = "Close";
    CloseButton.DownSound = Sound'WeaponPickup';
    CloseButton.bDisabled = False;
    CloseButton.bAcceptsFocus = False;
    SetAcceptsFocus();
}

function KeyDown (int Key, float X, float Y)
{
  if ( bPolling )
  {
    ProcessMenuKey(Key,RealKeyName[Key]);
    bPolling = False;
    SelectedButton.bDisabled = False;
  }
}

function LoadExistingKeys ()
{
  local int i;
  local string KeyName;
  local string Alias;

  i = 0;
  if ( i < 255 )
  {
    KeyName = GetPlayerOwner().ConsoleCommand("KEYNAME " $ string(i));
    RealKeyName[i] = KeyName;
    if ( KeyName != "" )
    {
      Alias = GetPlayerOwner().ConsoleCommand("KEYBINDING " $ KeyName);
      if ( Caps(Alias) == "MUTATE BDBMAPVOTE VOTEMENU" )
      {
        cmdMenuKey.SetText(KeyName);
        OldHotKey = KeyName;
      }
    }
    i++;
    goto JL0007;
  }
}

function Notify (UWindowDialogControl C, byte E);

function ProcessMenuKey (int KeyNo, string KeyName)
{
  if ( (KeyName == "") || (KeyName == "Escape") || (KeyNo >= 112) && (KeyNo <= 121) || (KeyNo >= 48) && (KeyNo <= 57) )
  {
    return;
  }
  SetKey(KeyNo,KeyName);
}

function SetKey (int KeyNo, string KeyName)
{
  GetPlayerOwner().ConsoleCommand("SET Input " $ KeyName $ " mutate bdbmapvote votemenu");
  SelectedButton.SetText(KeyName);
  if ( OldHotKey != "" )
  {
    GetPlayerOwner().ConsoleCommand("SET Input " $ OldHotKey);
  }
}

function Close (optional bool bByParent)
{
  SaveMapVoteConfig();
  Super.Close(bByParent);
}

function SaveMapVoteConfig ();

