//=============================================================================
// Cratos (cratos@gmx.at)
//=============================================================================
class DynamicPackageLoader extends Info;

var config bool bEnabled;
var config int DebugLevel;
var config string Serverpackages[25];
var config string DynamicPackages[10];
var config string DynamicActors[5];

var string newServerPackages;
var string SplittedCommand[10];
var bool bNextLevelTweaked;

function PreBeginPlay()
{
   if (bEnabled)
   {
       DebugLog("DynamicPackageLoader is enabled",0);
       enable('Tick');
       StartUp();
   }
   else
   {
       DebugLog("DynamicPackageLoader is disabled",0);
       disable('Tick');
       return;
   }
}

event Tick(float DeltaTime)
{
   local string NextMap;
   if (!bEnabled) return;

   // check for levelchange
   if ((Level.NextURL != "") && (!bNextLevelTweaked))
   {
      NextMap = left(Level.NextURL, instr(Level.NextURL,"."));
      if (NextMap == "") return;  // maybe a ?restart, Serverpackages remain

      DebugLog("-------------------------------",2);
      DebugLog("LevelChange detected",1);
      DebugLog("Actual Level:"@Level.GetURLMap(),2);
      DebugLog("Next URL:"@Level.NextURL,1);
      DebugLog("Next Map:"@NextMap,1);

      TweakPackages(CAPS(NextMap));
      bNextLevelTweaked = true;
   }
}

function TweakPackages(string Mapname)
{
   // Serverpackages
   newServerPackages = "(\"Botpack\")";
   AssembleServerPackages(MapName);
   setServerPackages(newServerPackages);
}

function StartUp()
{
   local string Mapname;
   local string actPackages;

   Mapname = left(string(self), instr(string(self),"."));
   DebugLog("StartUp(): Mapname:"@Mapname,2);
   Mapname = CAPS(MapName);

   // Re-check Serverpackages
   newServerPackages = "(\"Botpack\")";
   AssembleServerPackages(MapName);
   actPackages = getServerPackages();
   setServerPackages(newServerPackages);
   if (CAPS(actPackages) != CAPS(newServerPackages))
   {
      // Serverpackages didn't match --> restart
      DebugLog("StartUp(): Serverpackages did not match! restarting...",0);
      DebugLog("ActServerPackages:"@actpackages,1);
      DebugLog("NewServerPackages:"@newServerPackages,1);
      Level.ServerTravel("?restart",false);
      return;
   }

   // ServerActors
   FireUpServerActors(MapName);
}



function AssembleServerPackages(string MapName)
{
   local int i;
   local int j;

   for (i=0; i<25 && ServerPackages[i]!=""; i++)
   {
      AddServerPackage(ServerPackages[i]);
   }

   for (i=0; i<10 && DynamicPackages[i]!="" ; i++)
   {
       ParseToArray(DynamicPackages[i],";");

       // if the mapname matches to this rule
       if ((instr(Mapname,CAPS(SplittedCommand[0])) >= 0) || (SplittedCommand[0] == "*"))
       {
           // Add all Serverpackages
           for (j=1; j<10 && SplittedCommand[j]!="" ; j++)
           {
              AddServerPackage(SplittedCommand[j]);
           }
       }
   }
}

function AddServerPackage(string SP)
{
   local int i;

   if (instr(CAPS(newServerPackages),CAPS(SP))>=0) return; // Serverpackages is already in

   i = instr(newServerPackages,")");
   DebugLog("Adding Serverpackage:"@SP,1);
   newServerPackages = left(newServerPackages,i)$",\"" $ SP $ "\")";
}

function FireUpServerActors(string Mapname)
{
   local int i;
   local int j;

   for (i=0; i<5 && DynamicActors[i]!="" ; i++)
   {
       ParseToArray(DynamicActors[i],";");

       // if the mapname matches to this rule
       if ((instr(Mapname,CAPS(SplittedCommand[0])) >= 0) || (SplittedCommand[0] == "*"))
       {
           // Add all ServerActors
           for (j=1; j<10 && SplittedCommand[j]!="" ; j++)
           {
              FireUpServerActor(SplittedCommand[j]);
           }
       }
   }
}

function FireUpServerActor(string ServerActor)
{
   local class C;
   local actor A;

   DebugLog("Starting ServerActor:"@ServerActor,0);

   C = class<Actor>(DynamicLoadObject(ServerActor,class'Class'));
   if (C == None) {
      DebugLog("DynamicLoadObject of ServerActor"@ServerActor@"FAILED!",0);
   }
   else {
      A = Level.Spawn(class<Actor>(C));
      if ((A!=None) && A.IsA('Mutator') && (Mutator(A)!=None)) {
          DebugLog(ServerActor@"is a mutator!",1);
          Level.Game.BaseMutator.AddMutator(Mutator(A));
      }
   }
}

function ParseToArray(string Command, string delimiter)
{
   local int i;
   local int row;

   i = instr(Command, delimiter);
   while (i >= 0)
   {
      SplittedCommand[row] = left(Command, i);
      Command = mid(Command, i+1);
      i = instr(Command, delimiter);
      row++;
   }
   SplittedCommand[row] = Command;
   if (row<(10-1)) SplittedCommand [row+1] = "";
}

function string getServerPackages()
{
    local string packages;
    packages = ConsoleCommand("get ini:Engine.Engine.GameEngine ServerPackages");
    return (packages);
}

function string getServerActors()
{
    local string actors;
    actors = ConsoleCommand("get ini:Engine.Engine.GameEngine ServerActors");
    return (actors);
}

function setServerPackages(string newPackages)
{
    DebugLog("Setting Serverpackages:"@newPackages,2);
    ConsoleCommand("set ini:Engine.Engine.GameEngine ServerPackages"@newPackages);
}

function setServerActors(string newActors)
{
    DebugLog("Setting ServerActors:"@newActors,2);
    ConsoleCommand("set ini:Engine.Engine.GameEngine ServerActors"@newActors);
}

function DebugLog(string txt, int level)
{
   if (level <= DebugLevel) Log("DynamicPackageLoader:"@txt);
}

defaultproperties
{
     bEnabled=True
     DebugLevel=1
     ServerPackages(0)="Botpack"
     ServerPackages(1)="Relics"
     ServerPackages(2)="UBrowser"
     ServerPackages(3)="UTBrowser"
     ServerPackages(4)="UMenu"
     ServerPackages(5)="UTMenu"
     ServerPackages(6)="UWindow"
     ServerPackages(7)="SoldierSkins"
     ServerPackages(8)="CommandoSkins"
     ServerPackages(9)="FCommandoSkins"
     ServerPackages(10)="SGirlSkins"
     ServerPackages(11)="BossSkins"
     ServerPackages(12)="MultiMesh"
     ServerPackages(13)="EpicCustomModels"
     ServerPackages(14)="TCowMeshSkins"
     ServerPackages(15)="TNaliMeshSkins"
     ServerPackages(16)="TSkMSkins"
     ServerPackages(17)="SkeletalChars"
     DynamicPackages(0)="DM-;UTPureRC7C;BP1Handler7C;BP4Handler7C"
     DynamicPackages(1)="AS-;LeagueAS-CP;AssaultBonusPack"
     DynamicPackages(2)="AS-Autorip;Autorip"
     DynamicPackages(3)="AS-TheScarabv2_beta;scbdeco"
     DynamicPackages(4)="AS-Junglebridge;InfAdds"
     DynamicActors(0)="DM-;UTPureRC7C.UTPureSA"
}
