class MapVoteTabWindow expands UWindowDialogClientWindow;

var UMenuPageControl Pages;
var MapVoteClientWindow MapWindow;
var ConfigWindow ConfigWindow;
//var AboutMapVoteWindow AboutWindow;
var AdminTabWindow AdminWindow;
var GameTypesTabWindow GameTypesWindow;
var ServerInfoWindow InfoWindow;
var string PrevSelectedMap;
var string PrevSelectedPlayer;
var int MapCount;
var string InfoServerAddress;
var int    InfoServerPort;
var string InfoFilePath;
var string ServerInfoFile;
var GameTypesWindow GTWindow;
var MapVoteWRI WRI;

function Created()
{
   local UWindowPageControlPage PageControl;
   WinLeft = (Root.WinWidth - WinWidth) / 2;
   WinTop = (Root.WinHeight - WinHeight) / 2;

   Pages = UMenuPageControl(CreateWindow(class'MapVotePageControl', 0, 0, WinWidth, WinHeight));
   Pages.SetMultiLine(false);

   // Add the Map Client Window
   PageControl = Pages.AddPage( "Maps/Kick", class'MapVoteClientWindow');
   MapWindow = MapVoteClientWindow(PageControl.Page);

   // Add the config window
   PageControl = Pages.AddPage( "Config", class'ConfigWindow');
   ConfigWindow = ConfigWindow(PageControl.Page);

   // Add the About window
   //PageControl = Pages.AddPage( "About", class'AboutMapVoteWindow');
   //AboutWindow = AboutMapVoteWindow(PageControl.Page);

   // Add the Server Information Window
   PageControl = Pages.AddPage( "Info", class'ServerInfoWindow');
   InfoWindow = ServerInfoWindow(PageControl.Page);

   if(GetPlayerOwner().PlayerReplicationInfo.bAdmin) // only show this tab to the Admin
   {
      // Add the Admin window
      PageControl = Pages.AddPage( "Admin", class'AdminTabWindow');
      AdminWindow = AdminTabWindow(PageControl.Page);
      AdminWindow(AdminWindow.ClientArea).main = self;

      // Add the GameTypes window
      PageControl = Pages.AddPage( "Game Types", class'GameTypesTabWindow');
      GameTypesWindow = GameTypesTabWindow(PageControl.Page);
      GTWindow = GameTypesWindow(GameTypesWindow.ClientArea);
      GTWindow.main = self;
   }

   Super.Created();
}

function Refresh()
{
	// hack to refresh the windows
	WRI.Timer();
}

function AddMapName(String MapName)
{
   local UMenuMapVoteList I;

   //log("Adding " $ MapName);
   I = UMenuMapVoteList(MapWindow.MapListBox.Items.Append(class'UMenuMapVoteList'));
   I.MapName = MapName;
   //MapWindow.MapList[MapWindow.MapCount++] = MapName;
}

function AddPlayerName(String PlayerName)
{
   local PlayerVoteListItem I;
   local UWindowList Item;

   //log("AddPlayerName("$PlayerName$")");
   // check to see if this player name is already in the list
   for(Item=MapWindow.PlayerListBox.Items;Item!=None;Item=Item.Next)
      if(PlayerVoteListItem(Item).PlayerName == PlayerName)
         return;
   // add it to the list box
   I = PlayerVoteListItem(MapWindow.PlayerListBox.Items.Append(class'PlayerVoteListItem'));
   I.PlayerName = PlayerName;
}

function RemovePlayerName(string PlayerID)
{
   local UWindowList Item;

   // Changed from using PlayerName to PlayerIDs. Example PlayerID = 005
   for(Item=MapWindow.PlayerListBox.Items;Item!=None;Item=Item.Next)
   {
      // PlayerName Format in list box = TPPPNNNNNNNN  T = Team, PPP = PlayerID, NNNN = PlayerName
      if(Mid(PlayerVoteListItem(Item).PlayerName,1,3) == PlayerID)
      {
         Item.Remove();
         return;
      }
   }
}

function UpdateAdmin(string p_GameTypes,
                     string p_OtherClass,
                     int p_VoteTimeLimit,
                     int p_KickPercent,
                     int p_ScoreBoardDelay,
                     bool p_bUseMapList,
                     bool p_bAutoOpen,
                     bool p_bKickVote,
                     bool p_bAutoDetect,
                     bool p_bCheckOtherGameTie,
                     int p_RepeatLimit,
                     string p_MapVoteHistoryType,
                     int p_MidGameVotePercent,
                     string p_Mode,
                     int p_MinMapCount,
                     string p_MapPreFixOverRide)
{
   local AdminWindow Window;

   if(AdminWindow!=None)
   {
      Window = AdminWindow(AdminWindow.ClientArea);

      Window.cbLoadDM.bChecked = bool(Mid(p_GameTypes,0,1));
      Window.cbLoadLMS.bChecked = bool(Mid(p_GameTypes,1,1));
      Window.cbLoadTDM.bChecked = bool(Mid(p_GameTypes,2,1));
      Window.cbLoadAS.bChecked = bool(Mid(p_GameTypes,3,1));
      Window.cbLoadDOM.bChecked = bool(Mid(p_GameTypes,4,1));
      Window.cbLoadCTF.bChecked = bool(Mid(p_GameTypes,5,1));
      Window.cbLoadOther.bChecked = bool(Mid(p_GameTypes,6,1));

      Window.txtOtherClass.SetValue(p_OtherClass);

      Window.sldVoteTimeLimit.SetValue(p_VoteTimeLimit);
      Window.sldKickPercent.SetValue(p_KickPercent);
      Window.sldScoreBoardDelay.SetValue(p_ScoreBoardDelay);
      Window.cbUseMapList.bChecked = p_bUseMapList;
      Window.cbAutoOpen.bChecked = p_bAutoOpen;
      Window.cbKickVote.bChecked = p_bKickVote;
      Window.cbAutoDetect.bChecked = p_bAutoDetect;
      Window.cbCheckOtherGameTie.bChecked = p_bCheckOtherGameTie;

      Window.txtRepeatLimit.SetValue(string(p_RepeatLimit));
      Window.cboMapVoteHistoryType.SetValue(p_MapVoteHistoryType);
      Window.sldMidGameVotePercent.SetValue(p_MidGameVotePercent);
      Window.cboMode.SetValue(p_Mode);
      Window.txtMinMapCount.SetValue(string(p_MinMapCount));
      Window.txtMapPreFixOverRide.SetValue(p_MapPreFixOverRide);
   }
}

function UpdateGameTypes(bool bEnableAll, bool bDisableAll)
{
   if(GameTypesWindow!=None)
   {
      GTWindow.EnableAll.bChecked = bEnableAll;
      GTWindow.DisableAll.bChecked = bDisableAll;

   }
}

function UpdateExtraMutators(string EM,string EM1,string EM2,string EM3,string EM4,string EM5,
		string EM6,string EM7, string EM8)
{
	if (GTWindow == none)
		return;

	if ( EM != "")
      		GTWindow.txtExtraMutators.SetValue(EM);
	if ( EM1 != "")
      		GTWindow.txtExtraMutators1.SetValue(EM1);
	if ( EM2 != "")
      		GTWindow.txtExtraMutators2.SetValue(EM2);
	if ( EM3 != "")
      		GTWindow.txtExtraMutators3.SetValue(EM3);
	if ( EM4 != "")
      		GTWindow.txtExtraMutators4.SetValue(EM4);
	if ( EM5 != "")
      		GTWindow.txtExtraMutators5.SetValue(EM5);
	if ( EM6 != "")
      		GTWindow.txtExtraMutators6.SetValue(EM6);
	if ( EM7 != "")
      		GTWindow.txtExtraMutators7.SetValue(EM7);
	if ( EM8 != "")
      		GTWindow.txtExtraMutators8.SetValue(EM8);
}

function UpdateButtonNames(string b1, string b2, string b3, string b4, string b5,
         string b6, string b7, string b8)
{
 MapWindow.btnVote1.Text = b1;
 MapWindow.btnVote2.Text = b2;
 MapWindow.btnVote3.Text = b3;
 MapWindow.btnVote4.Text = b4;
 MapWindow.btnVote5.Text = b5;
 MapWindow.btnVote6.Text = b6;
 MapWindow.btnVote7.Text = b7;
 MapWindow.btnVote8.Text = b8;

 if (GameTypesWindow != None)
 {
	GTWindow.txtButtonName1.SetValue(b1);
	GTWindow.txtButtonName2.SetValue(b2);
	GTWindow.txtButtonName3.SetValue(b3);
	GTWindow.txtButtonName4.SetValue(b4);
	GTWindow.txtButtonName5.SetValue(b5);
	GTWindow.txtButtonName6.SetValue(b6);
	GTWindow.txtButtonName7.SetValue(b7);
	GTWindow.txtButtonName8.SetValue(b8);
 }
}

function EnableKickWindow()
{
   local UWindowPageControlPage PageControl;

   MapWindow.KickVoteButton.bDisabled = false;
}

function UpdateMapVoteResults(string Text, int i)
{
   local UWindowList Item;
   local string MapName;
   local int c,pos;

   if(Text == "Clear")
   {
      if(MapWindow.lstMapStatus.SelectedItem != None)
         PrevSelectedMap = MapStatusListItem(MapWindow.lstMapStatus.SelectedItem).MapName;
      MapWindow.lstMapStatus.Items.Clear();
      return;
   }

   pos = Instr(Text,",");
   if(pos > 0)
   {
      MapName = left(Text,pos);
      c = int(Mid(Text,pos+1));
   }

   // check to see if MapName is already in the list
   for(Item=MapWindow.lstMapStatus.Items;Item!=None;Item=Item.Next)
   {
      if(MapStatusListItem(Item).MapName == MapName)
      {
         MapStatusListItem(Item).Rank = i + 1;
         MapStatusListItem(Item).VoteCount = c;
         return;
      }
   }

   // Add it to the list
   Item = MapStatusListItem(MapWindow.lstMapStatus.Items.Append(class'MapStatusListItem'));
   MapStatusListItem(Item).Rank = i + 1;
   MapStatusListItem(Item).MapName = MapName;
   MapStatusListItem(Item).VoteCount = c;
   if(PrevSelectedMap == MapName) // re-select previously selected map
      MapWindow.lstMapStatus.SelectMap(PrevSelectedMap);
}

// bonehed316:  makes it work
function UpdateModeVoteResults(int b1,int b2,int b3,int b4,int b5,int b6,int b7,int b8)
{

   MapWindow.lblNumVotes1.SetText(b1 $ " votes");
   MapWindow.lblNumVotes2.SetText(b2 $ " votes");
   MapWindow.lblNumVotes3.SetText(b3 $ " votes");
   MapWindow.lblNumVotes4.SetText(b4 $ " votes");
   MapWindow.lblNumVotes5.SetText(b5 $ " votes");
   MapWindow.lblNumVotes6.SetText(b6 $ " votes");
   MapWindow.lblNumVotes7.SetText(b7 $ " votes");
   MapWindow.lblNumVotes8.SetText(b8 $ " votes");
}

function UpdateModeVoteButtons(bool bAllowButton1, bool bAllowButton2, 
		bool bAllowButton3, bool bAllowButton4, bool bAllowButton5, 
		bool bAllowButton6, bool bAllowButton7, bool bAllowButton8)
{
   MapWindow.btnVote1.bDisabled = !bAllowButton1;
   MapWindow.btnVote2.bDisabled = !bAllowButton2;
   MapWindow.btnVote3.bDisabled = !bAllowButton3;
   MapWindow.btnVote4.bDisabled = !bAllowButton4;
   MapWindow.btnVote5.bDisabled = !bAllowButton5;
   MapWindow.btnVote6.bDisabled = !bAllowButton6;
   MapWindow.btnVote7.bDisabled = !bAllowButton7;
   MapWindow.btnVote8.bDisabled = !bAllowButton8;

   if(GameTypesWindow!=None)
   {
      GTWindow.AllowButton1.bChecked = bAllowButton1;
      GTWindow.AllowButton2.bChecked = bAllowButton2;
      GTWindow.AllowButton3.bChecked = bAllowButton3;
      GTWindow.AllowButton4.bChecked = bAllowButton4;
      GTWindow.AllowButton5.bChecked = bAllowButton5;
      GTWindow.AllowButton6.bChecked = bAllowButton6;
      GTWindow.AllowButton7.bChecked = bAllowButton7;
      GTWindow.AllowButton8.bChecked = bAllowButton8;
   }
}

function UpdateKickVoteResults(string Text, int i)
{
   local UWindowList Item;
   local string PlayerName;
   local int c,pos;

   //log("UpdateKickVoteResults(" $ Text $ "," $ i $ ")");
   if(Text == "")
      return;

   if(Text == "Clear")
   {
      if(MapWindow.lstKickStatus.SelectedItem != None)
         PrevSelectedPlayer = KickStatusListItem(MapWindow.lstKickStatus.SelectedItem).PlayerName;
      MapWindow.lstKickStatus.Items.Clear();
      return;
   }

   pos = Instr(Text,",");
   if(pos > 0)
   {
      PlayerName = left(Text,pos);
      c = int(Mid(Text,pos+1));
   }

   // check to see if Player is already in the list
   if(MapWindow.lstKickStatus.Items != none)
   {
      for(Item=MapWindow.lstKickStatus.Items;Item!=None;Item=Item.Next)
      {
         if(KickStatusListItem(Item).PlayerName == PlayerName)
         {
            MapStatusListItem(Item).VoteCount = c;
            return;
         }
      }
   }

   // Add it to the list
   Item = KickStatusListItem(MapWindow.lstKickStatus.Items.Append(class'KickStatusListItem'));
   KickStatusListItem(Item).PlayerName = PlayerName;
   KickStatusListItem(Item).VoteCount = c;
   if(PrevSelectedPlayer != "" && PrevSelectedPlayer == PlayerName) // re-select previously selected player
      MapWindow.lstKickStatus.SelectPlayer(PrevSelectedPlayer);
}

defaultproperties
{
}
