class MapVoteNavBar expands UMenuDialogClientWindow;

var UWindowSmallButton ServerInfoButton;
var UWindowSmallButton MapInfoButton;
var UWindowSmallButton ReportButton1;
var UWindowSmallButton ReportButton2;
var UWindowSmallButton TipsButton;
var UWindowSmallButton AboutButton;
var UWindowSmallButton HelpButton;
var UWindowSmallButton CloseButton;
//var UWindowCheckBox cbShowWelcomeWindow;
var bool bShowWelcomeWindow;

function Created()
{
   Super.Created();

   ServerInfoButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton',1,1,59,10));
   ServerInfoButton.Text= "Server Info";

   MapInfoButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton',60,1,59,10));
   MapInfoButton.Text= "Map Info";

   ReportButton1 = UWindowSmallButton(CreateControl(class'UWindowSmallButton',120,1,49,10));
   ReportButton1.Text= "Report 1";
   ReportButton1.bDisabled = true;

   ReportButton2 = UWindowSmallButton(CreateControl(class'UWindowSmallButton',170,1,49,10));
   ReportButton2.Text= "Report 2";
   ReportButton2.bDisabled = true;

   //cbShowWelcomeWindow = UWindowCheckBox(CreateControl(class'UWindowCheckBox', 200, 20, 160, 20));
   //cbShowWelcomeWindow.Align = TA_right;
   //cbShowWelcomeWindow.SetText("Show this window on Connect");
   //cbShowWelcomeWindow.bChecked = class'x3dfxMapVotev25d.MapVoteNavBar'.default.bShowWelcomeWindow;

   AboutButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton',220,1,39,10));
   AboutButton.Text= "About";

   TipsButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton',260,1,69,10));
   TipsButton.Text= "MapVote Tips";

   HelpButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton',330,1,39,10));
   HelpButton.Text= "Help";

   CloseButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton',370,1,30,10));
   CloseButton.Text= "Close";
}

function Notify(UWindowDialogControl C, byte E)
{
   local string CurrentMapName;
   local int pos;
   local ServerInfoWindow MainWindow;

   MainWindow = ServerInfoWindow(ParentWindow.ParentWindow);

   Super.Notify(C,E);

   switch(E)
   {
      case DE_Click:
         switch(C)
         {
            case ServerInfoButton:
               MainWindow.BrowseWebPage(MainWindow.ServerInfoURL);
               break;

            case MapInfoButton:
               CurrentMapName = GetPlayerOwner().GetURLMap();
               pos = InStr(CurrentMapName,".");
               if(pos > 0)
                  CurrentMapName = Left(CurrentMapName,pos);
               if(CurrentMapName != "")
                  MainWindow.BrowseWebPage(MainWindow.MapInfoURL $ CurrentMapName $ ".htm");
               break;

            case ReportButton1:
               GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE REPORT PC");
               break;

            case ReportButton2:
               GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE REPORT SEQ");
               break;

            case TipsButton:
               MainWindow.BrowseWebPage("www.planetunreal.com:80/BDBUnreal/MapVoteTips.htm");
               break;

            case AboutButton:
               MainWindow.BrowseWebPage("www.planetunreal.com:80/BDBUnreal/AboutMapVote303.htm");
               break;

            case HelpButton:
               MainWindow.BrowseWebPage("www.planetunreal.com:80/BDBUnreal/MapVoteHelp.htm");
               break;

            case CloseButton:
               Root.CloseActiveWindow();
               break;
         }
         break;
   }
}

function Close(bool ByParent)
{
   class'MapVoteNavBar'.default.bShowWelcomeWindow = false; // only show first time
   Super.Close(ByParent);
}

defaultproperties
{
   bShowWelcomeWindow=true
}

