class MVWelcomeWindow expands UWindowFramedWindow;

var float StartTime;
var bool bHasStartWindow;

function Created()
{
    bSizable = false;

    Super.Created();

    StartTime = GetPlayerOwner().Level.TimeSeconds;

    WinLeft = Root.WinWidth/2 - WinWidth/2;
    WinTop = Root.WinHeight/2 - WinHeight/2;
}

function Close(optional bool bByParent)
{
   local UWindowWindow KeyBinderWindow;

   Super.Close(bByParent);

   // find key binder window
   KeyBinderWindow = Root.FindChildWindow(class'x3dfxMapVotev25d.MVKeyBinderFrameWindow', True);

   if(bHasStartWindow && KeyBinderWindow == none)
      FocusStartWindow();
   else
      WindowConsole(GetPlayerOwner().Player.Console).CloseUWindow(); // remove the mouse pointer
}

function FocusStartWindow()
{
   local UWindowWindow Child;

   for(Child = Root.LastChildWindow; Child != None; Child = Child.PrevSiblingWindow)
   {
      if(left(string(Child.Class),6) == "UTMenu" || left(string(Child.Class),5) == "UMenu")
         WindowConsole(GetPlayerOwner().Player.Console).CloseUWindow();
      else
         if(Child.Class != Self.Class)
             break;
   }

   if(Child == None)
      WindowConsole(GetPlayerOwner().Player.Console).CloseUWindow(); // remove the mouse pointer
   else
   {
      Child.bLeaveOnScreen = True;
      Child.FocusWindow();
      Child.ShowWindow();
   }
}

function tick(float DeltaTime)
{
   local UWindowWindow KeyBinderWindow;

   if(StartTime > 0 && GetPlayerOwner().Level.TimeSeconds  > StartTime + 3)
   {
      StartTime = 0;
      // bring this window to front
      FocusWindow();
      BringToFront();
      ShowWindow();

      // find key binder window
      KeyBinderWindow = Root.FindChildWindow(class'x3dfxMapVotev25d.MVKeyBinderFrameWindow', True);

      // bring KeyBinder to front if exists
      if(KeyBinderWindow != none)
      {
         KeyBinderWindow.FocusWindow();
         KeyBinderWindow.BringToFront();
         KeyBinderWindow.ShowWindow();
      }
   }
   super.tick(DeltaTime);
}

defaultproperties
{
     ClientClass=Class'x3dfxMapVotev25d.ServerInfoWindow'
     WindowTitle="Map Vote Welcome Window"
}

