class MVKeyBinderListBox expands UWindowListBox;

function Paint(Canvas C, float MouseX, float MouseY)
{
   C.DrawColor.r = 255;
   C.DrawColor.g = 255;
   C.DrawColor.b = 255;
   //DrawStretchedTexture(C, 0, 0,WinWidth, WinHeight, Texture'UWindow.WhiteTexture');
   DrawStretchedTexture(C, 0, 0, WinWidth, 1, Texture'UWindow.WhiteTexture');
   DrawStretchedTexture(C, 0, 0, 0, WinHeight-1, Texture'UWindow.WhiteTexture');
   Super.Paint(C,MouseX,MouseY);
}

function DrawItem(Canvas C, UWindowList Item, float X, float Y, float W, float H)
{
     if(KeyBinderListItem(Item).bSelected)
     {
          C.DrawColor.r = 0;
          C.DrawColor.g = 0;
          C.DrawColor.b = 128;
          DrawStretchedTexture(C, X, Y+1, W, H-2, Texture'UWindow.WhiteTexture');
          C.DrawColor.r = 255;
          C.DrawColor.g = 255;
          C.DrawColor.b = 255;
          DrawStretchedTexture(C, X, Y+H-1, W, 1, Texture'UWindow.WhiteTexture');
          DrawStretchedTexture(C, 95, Y, 1, H, Texture'UWindow.WhiteTexture');
          DrawStretchedTexture(C, 0, Y, 1, H, Texture'UWindow.WhiteTexture');
          DrawStretchedTexture(C, W, Y, 1, H, Texture'UWindow.WhiteTexture');
     }
     else
     {
          C.DrawColor.r = 255;
          C.DrawColor.g = 255;
          C.DrawColor.b = 255;
          DrawStretchedTexture(C, X, Y+H-1, W, 1, Texture'UWindow.WhiteTexture');
          DrawStretchedTexture(C, 95, Y, 1, H-1, Texture'UWindow.WhiteTexture');
          DrawStretchedTexture(C, 0, Y, 1, H, Texture'UWindow.WhiteTexture');
          DrawStretchedTexture(C, W, Y, 1, H, Texture'UWindow.WhiteTexture');
     }

     C.Font = Root.Fonts[F_Normal];

     ClipText(C, X+5, Y, KeyBinderListItem(Item).KeyName);
     ClipText(C, X+100, Y, KeyBinderListItem(Item).CommandString);
}

defaultproperties
{
     ItemHeight=13.000000
     ListClass=Class'x3dfxMapVotev25d.KeyBinderListItem'
}
