//=============================================================================
// sgInnerWave.
//=============================================================================
class sgInnerWave expands sgSWave;

simulated function Tick( float DeltaTime )
{
	if ( Level.NetMode != NM_DedicatedServer )
	{
		if(lifespan/default.lifespan>0.5) ShockSize=20-(20*(lifespan/default.lifespan-0.5)*2);
		else if(lifespan/default.lifespan<0.5) ShockSize=20*lifespan/default.lifespan*2;
		ScaleGlow = Lifespan/default.lifespan*3;
		AmbientGlow = Lifespan/default.lifespan * 255;
		DrawScale = ShockSize;
	}
}

simulated function Timer()
{
	local actor Victims;
	local float damageScale, dist, MoScale;
	local vector dir;	

	lightbrightness=255*(lifespan/default.lifespan);

	if(lifespan/default.lifespan>0.5) ShockSize=20-(20*(lifespan/default.lifespan-0.5)*2);
	else if(lifespan/default.lifespan<0.5) ShockSize=20*lifespan/default.lifespan*2;

	lightradius=shocksize*12.5;

	foreach radiusActors( class 'Actor', Victims, ShockSize*29, Location )
	{
		dir = Location - victims.Location;
		dist = VSize(dir); 
		dir = normal(dir); 
		
		MoScale = ((ShockSize*29)-dist)/(shocksize*29);
			
		if(victims.isa('pawn') || victims.isa('mover'))
		{	
			Victims.TakeDamage
			(
				MoScale*70,
				Instigator, 
				Victims.Location - 0.5 * (Victims.CollisionHeight + 				Victims.CollisionRadius)*dir,
				vect(0,0,0),
				'exploded'
			);
		}		
	}		
}

simulated function PostBeginPlay()
{
	local Pawn P;

	if ( Role == ROLE_Authority ) //mind me!!!!!!!!!!!!!!!!!!!!!!!!!!
	{
		rotationrate=(rotrand()-rotrand()*2)/2;

		if ( Instigator != None )
			MakeNoise(10.0);

	}	

	SetTimer(0.1, True);
}

defaultproperties
{
     LifeSpan=2.000000
     ScaleGlow=3.000000
     AmbientGlow=255
     SpriteProjForward=31.000000
     MultiSkins(1)=Texture'sgMedia.GFX.sgInnerExp'
     LightType=LT_Steady
     LightEffect=LE_NonIncidence
     LightBrightness=255
     LightHue=36
     LightSaturation=127
     LightRadius=255
}
