//=============================================================================
// sgHUD.
//=============================================================================
class sgHUD expands ChallengeTeamHUD;

var pawn ITarget;
var() color teamcolors[2], GreyColor;

simulated function bool TraceIdentify(canvas Canvas)
{
	local actor Other;
	local vector HitLocation, HitNormal, StartTrace, EndTrace;

	StartTrace = Owner.Location;
	StartTrace.Z += PawnOwner.BaseEyeHeight;
	EndTrace = StartTrace + vector(PawnOwner.ViewRotation) * 10000.0;
	Other = Trace(HitLocation, HitNormal, EndTrace, StartTrace, true);

	if ( Pawn(Other) != None )
	{
		if ( !Other.bHidden && pawn(other)!=none)
		{
			identifytarget=pawn(other).playerreplicationinfo;
			ITarget = Pawn(Other);
			IdentifyFadeTime = 3.0;
		}
	}

	if ( (IdentifyFadeTime == 0.0) || (ITarget == None) || IdentifyTarget.bFeigningDeath )
		return false;

	return true;
}

simulated function bool DrawIdentifyInfo(canvas Canvas)
{
	if ( !TraceIdentify(Canvas))
		return false;

	if(!itarget.isa('sgbuilding'))
	{
		if( ITarget.playerreplicationinfo.PlayerName != "" )
		{
			Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
			DrawTwoColorID(Canvas,ITarget.playerreplicationinfo.PlayerName, 				string(itarget.health), Canvas.ClipY - 256 * Scale);
		}
	}
	else
	{
		if( ITarget.playerreplicationinfo.PlayerName != "" )
		{
			Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
			DrawTwoColorID(Canvas,ITarget.playerreplicationinfo.PlayerName, 				string(int(sgbuilding(itarget).energy/sgbuilding(itarget).maxenergy*100)), 				Canvas.ClipY - 256 * Scale);
			Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
			DrawTwoColorID(Canvas,"Level", string(int(sgbuilding(itarget).grade)), 				Canvas.ClipY - 216 * Scale);
		}
	}
	return true;
}

simulated function DrawGameSynopsis(Canvas Canvas)
{
	local float XL, YL, XOffset, YOffset;
	local TournamentGameReplicationInfo GRI;
	local int i, X;

	GRI = TournamentGameReplicationInfo(PlayerOwner.GameReplicationInfo);
	if ( GRI != None )
		for ( i=0 ;i<4; i++ )
			DrawTeam(Canvas, GRI.Teams[i]);

	if ( (PawnOwner.PlayerReplicationInfo == None) 
		|| PawnOwner.PlayerReplicationInfo.bIsSpectator )
		return;

	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.DrawColor = GreyColor;

	if ( bHideAllWeapons )
		X = 0.5 * Canvas.ClipX + 96 * Scale;
	else
		X = Canvas.ClipX - 176 * Scale;

	if ( bHideAllWeapons )
		YOffset = Canvas.ClipY - YL*2;
	else if ( HudScale * WeaponScale * Canvas.ClipX <= Canvas.ClipX - 256 * Scale )
		YOffset = Canvas.ClipY - 128*Scale - YL*2;
	else
		YOffset = Canvas.ClipY - 160*Scale - YL*2;
	Canvas.SetPos(0, YOffset);
	Canvas.SetPos(XL, YOffset);
	Canvas.SetPos(0, YOffset + YL);
	Canvas.Style = ERenderStyle.STY_Masked;
	Canvas.DrawText("RU: "@int(sgpri(pawnowner.playerreplicationinfo).ru), False);
	if(sgconstructor(pawnowner.weapon)!=none)
	{
		Canvas.SetPos(X, (Canvas.ClipY - 176*Scale - YL*2) + YL);
		Canvas.DrawText(sgconstructor(pawnowner.weapon).optionnames[sgconstructor(pawnowner.weapon).soption], False);
		Canvas.SetPos(X, YOffset + YL);
		if(sgconstructor(pawnowner.weapon).soption<9)
		{
			Canvas.DrawText(int(sgconstructor(pawnowner.weapon).buildcosts[sgconstructor(pawnowner.weapon).soption])@""@sgconstructor(pawnowner.weapon).buildtimes[sgconstructor(pawnowner.weapon).soption], False);
		}
	}
}

simulated function DrawTwoColorID( canvas Canvas, string TitleString, string ValueString, int YStart )
{
	local float XL, YL, XOffset, X1;

	Canvas.Style = ERenderStyle.STY_Masked;
	Canvas.StrLen(TitleString$": ", XL, YL);
	X1 = XL;
	Canvas.StrLen(ValueString, XL, YL);
	XOffset = Canvas.ClipX/2 - (X1+XL)/2;
	Canvas.SetPos(XOffset, YStart);
	SetIDColor(Canvas,0);
	XOffset += X1;
	Canvas.DrawText(TitleString);
	Canvas.SetPos(XOffset, YStart);
	SetIDColor(Canvas,1);
	Canvas.DrawText(ValueString);
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
}

defaultproperties
{
     teamcolors(0)=(R=255,G=83,B=83)
     teamcolors(1)=(R=100,G=100,B=255)
     GreyColor=(R=160,G=160,B=160)
}
