//=============================================================================
// sgBuilding.
//=============================================================================
class sgBuilding expands StationaryPawn;

var() float BuildTime, MaxEnergy, DSofMFX;
var() mesh Model;
var() int NumOfMFX;
var() rotator MFXrotX;
var int buildcost;
var float energy, scount, grade;
var effects myFX;
var int team;

replication
{
	// Things the server should send to the client.
	reliable if ( Role == ROLE_Authority )
		buildtime, maxenergy, energy, scount, grade;
}

function postbeginplay()
{
	playerreplicationinfo=spawn(playerreplicationinfoclass,self);

	team=pawn(owner).playerreplicationinfo.team;
	if(team==2) team=1;
	else if(team==3) team=0;

	if(team==0)
	{
		texture=multiskins[0];
	}			
	else
	{
		texture=multiskins[1];
	}

	playerreplicationinfo.team=team;

	lighthue=team*160;
	energy=MaxEnergy/5;
	scount=buildtime*10;
	
	settimer(0.1,true);
}

simulated function timer()
{
	local actor d;
	local rotator randrot;
	local sgParticle pt;
	local float velo;
	local int i;

	if(scount>0)
	{
		drawscale=0.64*(1-scount/(buildtime*10))+0.16;
		energy+=(maxenergy-maxenergy/5)/(buildtime*10);
		scount-=1;

		for(i=0;i<rand(1)+1;i++)
		{
			RandRot.Pitch += Rand(32768)-16384;
			RandRot.Roll += Rand(32768)-16384;
			RandRot.Yaw += Rand(32768)-16384;

			velo=rand(400);
	
			pt=spawn(class'sgParticle',,,location+vector(randrot)*velo);
			pt.velocity=Normal(Location - pt.Location)*velo;
		}

		if(energy<=0) destruct();

	}
	else
	{
		if(myFX==none)
		{	
			for(i=0; i<numOfMFX; i++)
			{
				myFX=spawn(class'Siege2x.sgmeshfx',self,,,rotator(vect(0,0,0)));
				myfx.mesh=model;
				myFX.drawscale=dsofmfx;	
				myFX.rotationrate.pitch=mfxrotx.pitch*frand();
				myFX.rotationrate.roll=mfxrotx.roll*frand();
				myFX.rotationrate.yaw=mfxrotx.yaw*frand();
			}	
			spawn(class'sgFlash');

			drawscale=0.8;
		}
		

		//grade+=0.0002;
		grade=fmin(grade,6);
		drawscale=0.8-frand()*(0.5*(1-energy/maxenergy));
	}	
}
		
function destruct()
{
	spawn(class'sgFlash');
	spawn(class'ut_spriteballexplosion');
	destroy();
}

function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
{
	local int actualDamage;
	local float tempscore;

	if ( Role < ROLE_Authority ) return;
	
	actualDamage = Level.Game.ReduceDamage(Damage, DamageType, self, instigatedBy);
	if(instigatedby.playerreplicationinfo.team==playerreplicationinfo.team) 		actualdamage*=teamgameplus(level.game).friendlyfirescale;

	tempscore=fmin(energy, actualdamage);

	if(instigatedby.playerreplicationinfo.team==playerreplicationinfo.team)
	{
		tempscore*=-1;
	}

	tempscore*=1+grade/10;

	instigatedby.playerreplicationinfo.score+=tempscore/1000;
	sgpri(instigatedby.playerreplicationinfo).addru(tempscore/30);

	energy-=actualdamage;
	if(energy<=0) destruct();
}

defaultproperties
{
     BuildTime=30.000000
     MaxEnergy=100.000000
     Health=1
     bAlwaysRelevant=True
     RemoteRole=ROLE_SimulatedProxy
     DrawType=DT_Sprite
     Style=STY_Translucent
     Mesh=LodMesh'Botpack.Diamond'
     DrawScale=0.120000
     AmbientGlow=255
     SpriteProjForward=30.000000
     bUnlit=True
     bMeshEnviroMap=True
     bCollideWhenPlacing=True
     CollisionRadius=28.000000
     CollisionHeight=28.000000
     bCollideWorld=False
     bBlockActors=False
     bBlockPlayers=False
     LightEffect=LE_NonIncidence
     LightBrightness=255
     LightRadius=1
     LightPeriod=16
}
