//=============================================================================
// sgBaseCore.
//=============================================================================
class sgBaseCore expands sgBuilding;

var bool texturedone;

function postbeginplay()
{
	playerreplicationinfo=spawn(playerreplicationinfoclass,self);
	playerreplicationinfo.playername="BaseCore";
	maxenergy=teamgameplus(level.game).GoalTeamScore*1000;
	energy=maxenergy;
	scount=0;
	settimer(0.1, true);
}

function destruct()
{
	spawn(class'sgFlash');
	spawn(class'shockwave');
	spawn(class'shockriflewave');
	destroy();
}

function timer()
{
	local sgpri a;

	super.timer();

	if(!texturedone)
	{
		if(team==0)
		{
			texture=multiskins[0];
		}			
		else
		{
			texture=multiskins[1];
		}		
		texturedone=true;
	}


	foreach allactors(class'sgpri', a)
	{
		if(a.team==playerreplicationinfo.team) a.addru(0.05*((grade*0.85)+0.05));
	}
}

function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
{
	local int actualDamage;
	local float tempscore;
	local pawn p;
	local class<CriticalEventPlus> m;

	if ( Role < ROLE_Authority ) return;	

	actualDamage = Level.Game.ReduceDamage(Damage, DamageType, self, instigatedBy);
	if(instigatedby.playerreplicationinfo.team==playerreplicationinfo.team) 		actualdamage*=teamgameplus(level.game).friendlyfirescale;

	if(playerreplicationinfo.team==0) 
		teamgameplus(level.game).teams[1].score=teamgameplus(level.game).GoalTeamScore-energy/1000;
	else teamgameplus(level.game).teams[0].score=teamgameplus(level.game).GoalTeamScore-energy/1000;

	tempscore=fmin(energy, actualdamage);

	if(instigatedby.playerreplicationinfo.team==playerreplicationinfo.team)
	{
		tempscore*=-1;
	}

	instigatedby.playerreplicationinfo.score+=tempscore/500;
	sgpri(instigatedby.playerreplicationinfo).addru(tempscore/25);

	for ( P = Level.PawnList; P!=None; P=P.nextPawn )
	{
		if ( P.IsA('TournamentPlayer' ) && 			p.playerreplicationinfo.team==playerreplicationinfo.team)
		{
			m=class<CriticalEventPlus> (DynamicLoadObject("Siege2x.sgcorewarnmsg",class'Class'));
			TournamentPlayer(P).ReceiveLocalizedMessage(m,actualdamage);
		} 	
	}

	energy-=actualdamage;

	if(energy<=0)
	{
		teamgameplus(level.game).EndGame("teamscorelimit");
		destruct();
	}
}

defaultproperties
{
     MaxEnergy=20000.000000
     DSofMFX=2.500000
     Model=LodMesh'Botpack.Diamond'
     NumOfMFX=1
     MFXrotX=(Yaw=1000)
     MultiSkins(0)=Texture'sgMedia.GFX.sgCoreSpriteT0'
     MultiSkins(1)=Texture'sgMedia.GFX.sgCoreSpriteT1'
     bCollideWorld=True
}
