//=============================================================================
// SiegeGI.
//=============================================================================
class SiegeGI extends TeamGamePlus;

var float maxRUs[2];

replication
{
	// Things the server should send to the client.
	reliable if ( Role == ROLE_Authority )
		maxRUs;
}

event playerpawn Login ( string Portal, string Options, out string Error, class<playerpawn> SpawnClass )
{ 	
	SpawnClass.Default.PlayerReplicationInfoClass = class'Siege2x.sgpri';
	return Super.Login(Portal, Options, Error, SpawnClass); 
} 

function beginplay()
{
	local actor f;
	local sgbasecore b;

	super.beginplay();
	
	maxRUs[0]=300;
	maxRUs[1]=300;

	foreach allactors( class'actor', f)
	{
		if(flagbase(f)!=none)
		{
			b=spawn(class'Siege2x.sgBaseCore',,,f.location);
			b.team=flagbase(f).team;
			b.playerreplicationinfo.team=flagbase(f).team;
		}
		else if(inventory(f)!=none && !f.isa('sgresources') && !f.isa('scubagear'))
		{
			f.destroy();
		}
		else if(pathnode(f)!=none && frand()<0.2)
		{
			spawn(class'Siege2x.sgresources',,,f.location);
		}
	}
	
}

function AddDefaultInventory( pawn PlayerPawn )
{
     local Weapon NewWeapon;
     local Bot B;
     

     if ( PlayerPawn.IsA('Spectator') || (bRequireReady && (CountDown > 0)) )
          return;
	GiveWeapon(PlayerPawn, "Botpack.Impacthammer");	
	GiveWeapon(PlayerPawn, "Botpack.PulseGun");
	GiveWeapon(PlayerPawn, "Botpack.ShockRifle");
	GiveWeapon(PlayerPawn, "Botpack.UT_FlakCannon");
	GiveWeapon(PlayerPawn, "Botpack.UT_BioRifle");
	GiveWeapon(PlayerPawn, "Botpack.Minigun2");
	GiveWeapon(PlayerPawn, "Botpack.SniperRifle");
	GiveWeapon(PlayerPawn, "Botpack.Ripper");
	GiveWeapon(PlayerPawn, "Botpack.UT_Eightball");
      GiveWeapon(PlayerPawn, "Siege2x.sgconstructor");
      GiveWeapon(PlayerPawn, "Siege2x.sgconstructorx");
	GiveWeapon(PlayerPawn, "Siege2x.sgNukeLauncher");
	GiveWeapon(PlayerPawn, "Siege2x.sgEnforcer");

}

function ScoreKill(pawn Killer, pawn Other)
{

	sgpri(other.playerreplicationinfo).addru(-10);

	if( (killer == Other) || (killer == None) )
	{
		Other.PlayerReplicationInfo.Score -= 1;
		sgpri(other.playerreplicationinfo).addru(-50);
	}
	else if ( killer != None )
	{
		killer.killCount++;
		if ( Killer.PlayerReplicationInfo.Team != Other.PlayerReplicationInfo.Team )
		{
			Killer.PlayerReplicationInfo.Score += 1;
			sgpri(killer.playerreplicationinfo).addru(50);
		}
		else
		{
			Killer.PlayerReplicationInfo.Score += 1;
			sgpri(killer.playerreplicationinfo).addru(-50);
		}	
	}

	Other.DieCount++;

	BaseMutator.ScoreKill(Killer, Other);
}

function GiveWeapon(Pawn PlayerPawn, string aClassName )
{
	local class<Weapon> WeaponClass;
	local Weapon NewWeapon;

	WeaponClass = class<Weapon>(DynamicLoadObject(aClassName, class'Class'));

	if( PlayerPawn.FindInventoryType(WeaponClass) != None )
		return;
	newWeapon = Spawn(WeaponClass);
	if( newWeapon != None )
	{
		newWeapon.RespawnTime = 0.0;
		newWeapon.GiveTo(PlayerPawn);
		newWeapon.bHeldItem = true;
		newWeapon.GiveAmmo(PlayerPawn);
		newWeapon.SetSwitchPriority(PlayerPawn);
		newWeapon.WeaponSet(PlayerPawn);
		newWeapon.AmbientGlow = 0;
		if ( PlayerPawn.IsA('PlayerPawn') )
			newWeapon.SetHand(PlayerPawn(PlayerPawn).Handedness);
		else
			newWeapon.GotoState('Idle');
		PlayerPawn.Weapon.GotoState('DownWeapon');
		PlayerPawn.PendingWeapon = None;
		PlayerPawn.Weapon = newWeapon;
		if(sgenforcer(newweapon)==none) newweapon.ammotype.ammoamount=0;
	}
}

function int ReduceDamage(int Damage, name DamageType, pawn injured, pawn instigatedBy)
{
	Damage = Super.ReduceDamage(Damage, DamageType, injured, instigatedBy);
	
	if(injured.health-damage<=1 && damagetype=='sgSpecial' && sgbuilding(injured)==none)
	{
		injured.health=1;
		damage=0;
	}

	return Damage;
}

defaultproperties
{
     bSpawnInTeamArea=True
     TimeLimit=100
     StartUpMessage="Siege2x - Redone by TinyTim."
     TourneyMessage="Waiting for more recruits."
     ReadyMessage="You are READY for Battle!"
     StartMessage="The Battle has begun!"
     GameEndedMessage="has won the Battle!"
     gamegoal="units of crystal damage wins the match."
     ScoreBoardType=Class'Siege2x.sgScoreBoard'
     HUDType=Class'Siege2x.sgHUD'
     MapListType=Class'Botpack.CTFMapList'
     MapPrefix="CTF"
     GameName="Siege2x Game"
}
