//================================================================================
// MessageHelper.
//================================================================================

class MessageHelper extends ReplicationInfo;

var string TheSoundString;

replication
{
  reliable if ( Role == 4 )
    ExecuteMessage;
}

event Trigger (Actor Other, Pawn EventInstigator)
{
  if ( (Other == None) && (EventInstigator == None) )
  {
    ExecuteMessage(TheSoundString);
  }
}

simulated function ExecuteMessage (string SoundString)
{
  local Sound dynSound;

  Log("AnnouncerMessage:" @ SoundString);
  dynSound = Sound(DynamicLoadObject(SoundString,Class'Sound'));
  if ( dynSound != None )
  {
    PlayerPawn(Owner).ClientPlaySound(dynSound,,True);
  }
}

defaultproperties
{
    bAlwaysRelevant=False

    LifeSpan=2.00

}
