//================================================================================
// MapVoteNavBar.
//================================================================================

class MapVoteNavBar extends UMenuDialogClientWindow;

var UWindowSmallButton ServerInfoButton;
var UWindowSmallButton MapInfoButton;
var UWindowSmallButton ReportButton1;
var UWindowSmallButton ReportButton2;
var UWindowSmallButton TipsButton;
var UWindowSmallButton AboutButton;
var UWindowSmallButton CloseButton;
var bool bShowWelcomeWindow;

function Created ()
{
  Super.Created();
  ServerInfoButton = UWindowSmallButton(CreateControl(Class'UWindowSmallButton',1.0,1.0,59.0,10.0));
  ServerInfoButton.Text = "Server Info";
  MapInfoButton = UWindowSmallButton(CreateControl(Class'UWindowSmallButton',60.0,1.0,59.0,10.0));
  MapInfoButton.Text = "Map Info";
  ReportButton1 = UWindowSmallButton(CreateControl(Class'UWindowSmallButton',120.0,1.0,139.0,10.0));
  ReportButton1.Text = "Report 1: Map Vote Ranking";
  ReportButton1.bDisabled = True;
  ReportButton2 = UWindowSmallButton(CreateControl(Class'UWindowSmallButton',260.0,1.0,139.0,10.0));
  ReportButton2.Text = "Report 2: Map Vote Sequence";
  ReportButton2.bDisabled = True;
  AboutButton = UWindowSmallButton(CreateControl(Class'UWindowSmallButton',400.0,1.0,39.0,10.0));
  AboutButton.Text = "About";
  TipsButton = UWindowSmallButton(CreateControl(Class'UWindowSmallButton',440.0,1.0,69.0,10.0));
  TipsButton.Text = "MapVote Tips";
  CloseButton = UWindowSmallButton(CreateControl(Class'UWindowSmallButton',570.0,1.0,80.0,10.0));
  CloseButton.Text = "Close";
}

function Notify (UWindowDialogControl C, byte E)
{
  local string CurrentMapName;
  local int pos;
  local ServerInfoWindow MainWindow;

  MainWindow = ServerInfoWindow(ParentWindow.ParentWindow);
  Super.Notify(C,E);
  switch (E)
  {
    case 2:
    switch (C)
    {
      case ServerInfoButton:
      MainWindow.BrowseWebPage(MainWindow.ServerInfoURL);
      break;
      case MapInfoButton:
      CurrentMapName = GetPlayerOwner().GetURLMap();
      pos = InStr(CurrentMapName,".");
      if ( pos > 0 )
      {
        CurrentMapName = Left(CurrentMapName,pos);
      }
      if ( CurrentMapName != "" )
      {
        MainWindow.BrowseWebPage(MainWindow.MapInfoURL $ CurrentMapName $ ".htm");
      }
      break;
      case ReportButton1:
      GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE REPORT PC");
      break;
      case ReportButton2:
      GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE REPORT SEQ");
      break;
      case TipsButton:
      MainWindow.BrowseWebPage("www.planetunreal.com:80/BDBUnreal/MapVoteTips.htm");
      break;
      case AboutButton:
      MainWindow.TextArea.SetHTML("<html><body><center><br><br><h1><font color="FFFF00">Map Vote LA13</font></h1><br><br><b>Core developement: BDB (Bruce Bickar)<br><br>Enhancements by: Cratos (cratos@gmx.at)<br><br>Support: http://forums.utassault.net</b></center></body></html>");
      break;
      case CloseButton:
      Root.CloseActiveWindow();
      break;
      default:
    }
    break;
    default:
  }
}

function Close (bool ByParent)
{
  Class'MapVoteNavBar'.Default.bShowWelcomeWindow = False;
  Super.Close(ByParent);
}

defaultproperties
{
    bShowWelcomeWindow=True

}
