//================================================================================
// MapVoteHistory_INI.
//================================================================================

class MapVoteHistory_INI extends MapVoteHistory;

var() config string M[512];
var() config int P[512];
var() config int S[512];
var() config int LastMapIndex;
var MapVoteReport MVReport;
var string ReportType;
var int A;
var int B;
var string ReportText;

function AddMap (string MapName)
{
  local int X;
  local int Y;
  local bool bFound;

  if ( MapName == "" )
  {
    return;
  }
  if ( LastMapIndex >= 512 )
  {
    RemoveOldestMap();
  }
  if ( LastMapIndex == 0 )
  {
    M[1] = MapName;
    P[1] = 1;
    S[1] = 1;
    LastMapIndex = 1;
    return;
  }
  bFound = False;
  X = 1;
  if ( X <= LastMapIndex )
  {
    if ( MapName == M[X] )
    {
      S[X] = 1;
      P[X]++;
      bFound = True;
    } else {
      if ( S[X] > -1 )
      {
        S[X]++;
      }
    }
    if ( (Caps(M[X]) > Caps(MapName)) &&  !bFound )
    {
      Y = LastMapIndex;
      if ( Y >= X )
      {
        M[Y + 1] = M[Y];
        P[Y + 1] = P[Y];
        S[Y + 1] = S[Y];
        if ( (Y != X) && (S[Y] > -1) )
        {
          S[Y + 1]++;
        }
        Y--;
        goto JL0101;
      }
      M[X] = MapName;
      P[X] = 1;
      S[X] = 1;
      LastMapIndex++;
      return;
    }
    X++;
    goto JL0065;
  }
  if (  !bFound )
  {
    LastMapIndex++;
    M[LastMapIndex] = MapName;
    P[LastMapIndex] = 1;
    S[LastMapIndex] = 1;
  }
  return;
}

function int GetMapSequence (string MapName)
{
  local int Index;

  Index = FindIndex(MapName);
  if ( Index == 0 )
  {
    return 513;
  } else {
    return S[Index];
  }
}

function SetMapSequence (string MapName, int NewSeq)
{
  local int Index;

  Index = FindIndex(MapName);
  if ( Index > 0 )
  {
    S[Index] = NewSeq;
  }
}

function int GetPlayCount (string MapName)
{
  local int Index;

  Index = FindIndex(MapName);
  if ( Index == 0 )
  {
    return 0;
  } else {
    return P[Index];
  }
}

function SetPlayCount (string MapName, int NewPlayCount)
{
  local int Index;

  Index = FindIndex(MapName);
  if ( Index > 0 )
  {
    P[Index] = NewPlayCount;
  }
}

function Save ()
{
  SaveConfig();
}

function RemoveOldestMap ()
{
  local int X;
  local int Lowest;

  Lowest = 1;
  X = 2;
  if ( X <= LastMapIndex )
  {
    if ( S[X] < S[Lowest] )
    {
      Lowest = X;
    }
    X++;
    goto JL000F;
  }
  RemoveMapByIndex(Lowest);
}

function RemoveMap (string MapName)
{
  local int Index;

  Index = FindIndex(MapName);
  if ( Index > 0 )
  {
    RemoveMapByIndex(Index);
  }
}

function RemoveMapByIndex (int Index)
{
  local int X;

  X = Index;
  if ( X < LastMapIndex )
  {
    M[X] = M[X + 1];
    P[X] = P[X + 1];
    S[X] = S[X + 1];
    X++;
    goto JL000B;
  }
  M[LastMapIndex] = "";
  P[LastMapIndex] = 0;
  S[LastMapIndex] = 0;
  LastMapIndex--;
}

function int FindIndex (string MapName)
{
  local int A;
  local int B;
  local int i;

  if ( LastMapIndex == 0 )
  {
    return 0;
  }
  A = 1;
  B = LastMapIndex;
  MapName = Caps(MapName);
  if ( True )
  {
    i = (B - A) / 2 + A;
    if ( M[i] ~= MapName )
    {
      return i;
    }
    if ( A == B )
    {
      return 0;
    }
    if ( Caps(M[i]) > MapName )
    {
      B = i;
    } else {
      if ( A == i )
      {
        A = B;
      } else {
        A = i;
      }
    }
    goto JL002C;
  }
}

function MapReport (string p_ReportType, MapVoteReport p_MVReport)
{
  MVReport = p_MVReport;
  ReportType = p_ReportType;
  A = 1;
  GotoState('sorting');
}

function SendReport ()
{
}

function Swap (int A, int B)
{
  local int pc;
  local int seq;
  local string MapName;

  MapName = M[A];
  M[A] = M[B];
  M[B] = MapName;
  pc = P[A];
  P[A] = P[B];
  P[B] = pc;
  seq = S[A];
  S[A] = S[B];
  S[B] = seq;
}

state sorting
{
  function Tick (float DeltaTime)
  {
    local int LoopCount;
  
    LoopCount = 1;
    if ( LoopCount <= 4 )
    {
      if ( A <= LastMapIndex - 1 )
      {
        B = A + 1;
        if ( B <= LastMapIndex )
        {
          if ( ReportType == "SEQ" )
          {
            if ( S[A] > S[B] )
            {
              Swap(A,B);
            }
          }
          if ( ReportType == "PC" )
          {
            if ( P[B] > P[A] )
            {
              Swap(A,B);
            }
          }
          B++;
          goto JL0033;
        }
        A++;
      } else {
        GotoState('formating');
        goto JL00DD;
      }
      LoopCount++;
      goto JL0007;
    }
  }
  
}

state formating
{
  function Tick (float DeltaTime)
  {
    local int LoopCount;
    local int MaxMaps;
  
    LoopCount = 1;
    if ( LoopCount <= 2 )
    {
      if ( LastMapIndex > 100 )
      {
        MaxMaps = 100;
      } else {
        MaxMaps = LastMapIndex;
      }
      if ( A <= MaxMaps )
      {
        ReportText = ReportText $ "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        if ( ReportType == "SEQ" )
        {
          ReportText = ReportText $ string(S[A]);
          B = 1;
          if ( B < 20 - Len(string(S[A])) )
          {
            ReportText = ReportText $ "&nbsp;";
            B++;
            goto JL00BE;
          }
        }
        if ( ReportType == "PC" )
        {
          ReportText = ReportText $ string(P[A]);
          B = 1;
          if ( B < 20 - Len(string(P[A])) )
          {
            ReportText = ReportText $ "&nbsp;";
            B++;
            goto JL0127;
          }
        }
        ReportText = ReportText $ M[A] $ "<br>";
        A++;
      } else {
        ReportText = ReportText $ "</body></html>";
        if ( MVReport == None )
        {
          Destroy();
          return;
        }
        MVReport.ReportText = ReportText;
        MVReport.bSendResults = True;
        GotoState('None');
        goto JL01F2;
      }
      LoopCount++;
      goto JL0007;
    }
  }
  
  function BeginState ()
  {
    ReportText = "<html><body bgcolor=#000000><center><h1><font color=#0000FF>Map Report ";
    if ( ReportType == "SEQ" )
    {
      ReportText = ReportText $ "2";
    }
    if ( ReportType == "PC" )
    {
      ReportText = ReportText $ "1";
    }
    ReportText = ReportText $ "</font></h1></center><p>";
    ReportText = ReportText $ "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    if ( ReportType == "SEQ" )
    {
      ReportText = ReportText $ "Sequence&nbsp;&nbsp;";
    }
    if ( ReportType == "PC" )
    {
      ReportText = ReportText $ "PlayCount&nbsp;";
    }
    ReportText = ReportText $ "     Map Name<br>";
    ReportText = ReportText $ "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    ReportText = ReportText $ "------------    -------------------------------<br>";
    A = 1;
  }
  
}

