//================================================================================
// BDBMapVote.
//================================================================================

class BDBMapVote extends Mutator
  Config(MapVoteLA);

var() config bool bAutoDetect;
var() config bool bDM;
var() config bool bLMS;
var() config bool bTDM;
var() config bool bDOM;
var() config bool bCTF;
var() config bool bAS;
var() config bool bSortWithPreFix;
var() config string ASClass;
var() config int VoteTimeLimit;
var() config int KickPercent;
var() config bool bUseMapList;
var() config int ScoreBoardDelay;
var() config bool bAutoOpen;
var() config bool bKickVote;
var() config bool bShowWhoKicksWho;
var() config bool bCheckOtherGameTie;
var() config int RepeatLimit;
var() config int MapListIfNooneVoted;
var() config string MapVoteHistoryType;
var() config string ServerInfoURL;
var() config string MapInfoURL;
var() config int MidGameVotePercent;
var() config string Mode;
var() config int MinMapCount;
var() config bool bRemoveCrashedMaps;
var() config bool bEntryWindows;
var() config bool bDebugMode;
var() config bool bEnableEmptyServerLevelSwitch;
var() config int EmptyServerLevelSwitchTimeMins;
var() config int MsgTimeOut;
var() config bool bLoadScreenShot;
var() config bool bUseMsgTimeout;
var() config bool bReloadMapsOnRequestOnly;
var() config bool bFixCTFModifications;
var() config string MapVoteTitle;
var() config string LogoTexture;
var() config float List1Priority;
var() config float List2Priority;
var() config float List3Priority;
var() config float List4Priority;
var() config string List1Title;
var() config string List2Title;
var() config string List3Title;
var() config string List4Title;
var() config bool bList1ObeyRepeatLimit;
var() config bool bList2ObeyRepeatLimit;
var() config bool bList3ObeyRepeatLimit;
var() config bool bList4ObeyRepeatLimit;
var() config bool bUseExcludeFilter;
var() config CustConfig CustomGameConfig[16];
var() config string DefaultSettings;
var() config string List1Filter[48];
var() config string List2Filter[48];
var() config string List3Filter[48];
var() config string List4Filter[48];
var() config string ExcludeFilter[16];
var() config string CrashedMaps[32];
var() config string AccName[32];
var() config int AccVotes[32];
var() config string TmpNextVirtualPrefix;
var() config string TmpNextRealPrefix;
var bool bInitialized;
var string MapList[1024];
var int PlayerIDList[32];
var int PlayerVote[32];
var int MapCount;
var int PlayerKickVote[32];
var string MapStatusText[32];
var string KickStatusText[32];
var string KickIPList[32];
var string KickPlayerList[32];
var float EndGameTime;
var bool bMidGameVote;
var int CurrentID;
var int CurrentPlayerCount;
var int JoinTickCount;
var float MaxPriority;
var string TravelMap;
var bool bAutoGame;
var string AutoGame;
var string PrefixDictionary;
var int TimeLeft;
var int ScoreBoardTime;
var int ServerTravelTime;
var Class<GameInfo> AutoGameClass;
var Class<GameInfo> CustomGameClass;
var Class<MapVoteHistory> MapVoteHistoryClass;
var bool bLevelSwitchPending;
var string ServerTravelString;
var bool bInitMapsLoaded;
var bool bMapReloadRequested;
var MapVoteHistory History;
var int pos;
var int i;
var string GamePackage;
var string NewPrefix;
var bool bBunnyshit;
var string ActualMapPrefix;
struct CustConfig
{
  var bool bEnabled;
  var string GameClass;
  var string NewPrefix;
  var string Mutators;
  var string Settings;
};

struct MutActConfig
{
  var string Prefixes;
  var string Classes;
};


function bool HandleEndGame ()
{
  local Pawn aPawn;

  DebugLog("1");
  Super.HandleEndGame();
  if (  !bAutoOpen || CheckForTie() )
  {
    DebugLog("2");
    return False;
  }
  if ( Level.Game.IsA('Assault') )
  {
    DebugLog("4");
    if (  !Assault(Level.Game).bDefenseSet )
    {
      DebugLog("bDefenseSet false, Ending game normally.(First half end)");
      return False;
    }
  }
  DebugLog("5");
  DeathMatchPlus(Level.Game).bDontRestart = True;
  TimeLeft = VoteTimeLimit;
  ScoreBoardTime = ScoreBoardDelay;
  SetTimer(1.0,True);
  return False;
}

function HandleServerEmpty ()
{
  local string CurrentMap;
  local string TestMap;
  local int i;
  local int Map;

  if ( MapListIfNooneVoted == 0 )
  {
    return;
  }
  CurrentMap = TmpNextVirtualPrefix $ "-" $ RemovePrefix(GetURLMap());
  if ( InStr(CurrentMap,".") > -1 )
  {
    CurrentMap = Left(CurrentMap,InStr(CurrentMap,"."));
  }
  DebugLog("HandleServerEmpty(): Currentmap:" @ CurrentMap @ "Desired List:" @ string(MapListIfNooneVoted));
  i = 1;
  if ( i <= MapCount )
  {
    TestMap = GetPureMapname(MapList[i]);
    if ( TestMap ~= CurrentMap )
    {
      if ( MapListIfNooneVoted == GetMapListNumber(MapList[i]) )
      {
        return;
      }
    }
    i++;
    goto JL00A2;
  }
  Log("Server is empty for" @ string(EmptyServerLevelSwitchTimeMins) @ "Minutes. Actual Map is:" @ CurrentMap $ ". Switching to a random map in List" @ string(MapListIfNooneVoted));
  Level.ServerTravel(SetupGameMap(MapList[GetRandomMap()]),False);
}

event Timer ()
{
  local Pawn aPawn;
  local int VoterNum;
  local int NoVoteCount;
  local int MapNum;
  local MapVoteWRI A;
  local Pawn P;
  local int i;
  local MapVoteWRI mwri;

  foreach AllActors(Class'MapVoteWRI',mwri)
  {
    i++;
  }
  if ( bLevelSwitchPending )
  {
    DebugLog("6");
    if ( Level.TimeSeconds > ServerTravelTime + 4 )
    {
      DebugLog("NextURL = " $ Level.NextURL);
      DebugLog("NextSwitchCountdown = " $ string(Level.NextSwitchCountdown));
      if ( Level.NextURL == "" )
      {
        DebugLog("7");
        if ( Level.NextSwitchCountdown < 0 )
        {
          Log("Map change Failed, bad or missing map file. TravelMap:" @ TravelMap);
          if ( bRemoveCrashedMaps )
          {
            HandleFailedMap(TravelMap);
          }
          MapNum = GetRandomMap();
          ServerTravelString = SetupGameMap(MapList[MapNum]);
          Level.ServerTravel(ServerTravelString,False);
        } else {
          Level.ServerTravel(ServerTravelString,False);
        }
      }
    }
    return;
  }
  if ( ScoreBoardTime > 0 )
  {
    DebugLog("8");
    ScoreBoardTime--;
    if ( ScoreBoardTime == 0 )
    {
      DebugLog("9");
      EndGameTime = Level.TimeSeconds;
      aPawn = Level.PawnList;
      if ( aPawn != None )
      {
        if ( (PlayerPawn(aPawn) != None) && aPawn.bIsPlayer )
        {
          VoterNum = FindPlayerIndex(PlayerPawn(aPawn).PlayerReplicationInfo.PlayerID,True);
          if ( VoterNum > -1 )
          {
            if ( PlayerVote[VoterNum] == 0 )
            {
              OpenVoteWindow(PlayerPawn(aPawn),False,False);
            }
          }
        }
        aPawn = aPawn.nextPawn;
        goto JL01CA;
      }
      BroadcastMessage(string(TimeLeft) $ " seconds left to vote.",True);
    }
    return;
  }
  TimeLeft--;
  if ( TimeLeft == 60 )
  {
    DebugLog("10");
    BroadcastMessage("1 Minute left to vote.",True);
    P = Level.PawnList;
    if ( P != None )
    {
      if ( P.IsA('TournamentPlayer') )
      {
        TournamentPlayer(P).TimeMessage(12);
      }
      P = P.nextPawn;
      goto JL02E4;
    }
  }
  if ( TimeLeft == 10 )
  {
    DebugLog("11");
    BroadcastMessage("10 seconds left to vote.",True);
  }
  if ( (TimeLeft < 11) && (TimeLeft > 0) )
  {
    P = Level.PawnList;
    if ( P != None )
    {
      if ( P.IsA('TournamentPlayer') )
      {
        TournamentPlayer(P).TimeMessage(TimeLeft);
      }
      P = P.nextPawn;
      goto JL0394;
    }
  }
  CleanUpPlayerIDs();
  if ( (TimeLeft % 20 == 0) && (TimeLeft > 0) )
  {
    DebugLog("12");
    NoVoteCount = 0;
    aPawn = Level.PawnList;
    if ( aPawn != None )
    {
      if ( aPawn.bIsPlayer && (PlayerPawn(aPawn) != None) )
      {
        VoterNum = FindPlayerIndex(PlayerPawn(aPawn).PlayerReplicationInfo.PlayerID,True);
        if ( VoterNum > -1 )
        {
          if ( PlayerVote[VoterNum] == 0 )
          {
            NoVoteCount++;
          }
        }
      }
      aPawn = aPawn.nextPawn;
      goto JL042D;
    }
    if ( NoVoteCount == 0 )
    {
      DebugLog("13");
      TallyVotes(True);
    }
  }
  if ( TimeLeft == 0 )
  {
    DebugLog("14");
    TallyVotes(True);
  }
}

function Tick (float DeltaTime)
{
  local string PlayerName;
  local string PID;
  local int TeamID;
  local Pawn Other;
  local int PlayerIndex;
  local WRI aWRI;

  Super.Tick(DeltaTime);
  if (  !bInitMapsLoaded )
  {
    bInitMapsLoaded = True;
    if ( bReloadMapsOnRequestOnly )
    {
      LoadMapListConfig();
    } else {
      GotoState('Loading');
    }
  }
  if ( Level.Game.NumPlayers > CurrentPlayerCount )
  {
    CurrentPlayerCount = Level.Game.NumPlayers;
  }
  if ( Level.Game.NumPlayers < CurrentPlayerCount )
  {
    DebugLog("16b");
    CurrentPlayerCount = Level.Game.NumPlayers;
    DebugLog("CurrentPlayerCount decreased:" @ string(CurrentPlayerCount));
    CleanUpPlayerIDs();
    if ( Level.Game.NumPlayers > 0 )
    {
      TallyVotes(False);
      UpdateOpenWRI();
    }
  }
  if ( Level.Game.CurrentID > CurrentID )
  {
    if ( JoinTickCount < 20 )
    {
      if ( JoinTickCount == 0 )
      {
        DebugLog("15");
      }
      JoinTickCount++;
      return;
    }
    DebugLog("16");
    JoinTickCount = 0;
    Other = Level.PawnList;
    if ( Other != None )
    {
      if ( Other.IsA('PlayerPawn') && (Other.PlayerReplicationInfo != None) && (Other.PlayerReplicationInfo.PlayerID == CurrentID) )
      {
        goto JL01FD;
      }
      Other = Other.nextPawn;
      goto JL018B;
    }
    CurrentID++;
    if ( (Other == None) ||  !Other.bIsPlayer ||  !Other.IsA('PlayerPawn') )
    {
      DebugLog("17");
      return;
    }
    DebugLog("new Player " $ Other.PlayerReplicationInfo.PlayerName $ ", " $ PlayerPawn(Other).GetPlayerNetworkAddress());
    if ( bKickVote )
    {
      DebugLog("18");
      if ( CheckKickIP(PlayerPawn(Other).GetPlayerNetworkAddress()) )
      {
        DebugLog("19a");
        BroadcastMessage(Other.PlayerReplicationInfo.PlayerName $ " has been refused access to the server (1).",True);
        Other.Destroy();
        return;
      }
      if ( CheckKickPlayer(PlayerPawn(Other).PlayerReplicationInfo.PlayerName) )
      {
        DebugLog("19b");
        BroadcastMessage(Other.PlayerReplicationInfo.PlayerName $ " has been refused access to the server (2).",True);
        Other.Destroy();
        return;
      }
      if ( Other.IsA('Spectator') )
      {
        TeamID = 9;
      } else {
        if ( PlayerPawn(Other).PlayerReplicationInfo.Team == 255 )
        {
          TeamID = 0;
        } else {
          TeamID = PlayerPawn(Other).PlayerReplicationInfo.Team;
        }
      }
      PID = Right("000" $ string(PlayerPawn(Other).PlayerReplicationInfo.PlayerID),3);
      PlayerName = string(TeamID) $ PID $ PlayerPawn(Other).PlayerReplicationInfo.PlayerName;
      DebugLog("20");
      PlayerIndex = FindPlayerIndex(PlayerPawn(Other).PlayerReplicationInfo.PlayerID,True);
      if ( PlayerVote[PlayerIndex] < 1 )
      {
        AddNewPlayer(PlayerName,False);
      } else {
        AddNewPlayer(PlayerName,True);
      }
    }
    if ( bEntryWindows &&  !Other.IsA('Spectator') )
    {
      DebugLog("21");
      if ( Level.Game.IsA('Assault') && Assault(Level.Game).bDefenseSet )
      {
        DebugLog("22");
        return;
      }
      if ( Level.Game.bGameEnded )
      {
        DebugLog("23");
        if ( bAutoOpen )
        {
          OpenVoteWindow(PlayerPawn(Other),False,False);
        }
      } else {
        OpenWelcomeWindow(PlayerPawn(Other));
      }
    }
    DebugLog("24");
  }
}

function bool CheckForTie ()
{
  local TeamInfo Best;
  local int i;
  local Pawn P;
  local Pawn BestP;
  local PlayerPawn Player;

  DebugLog("25");
  if ( Level.Game.IsA('Assault') )
  {
    return False;
  }
  if ( Level.Game.IsA('Domination') )
  {
    return False;
  }
  if (  !bCheckOtherGameTie )
  {
    i = 0;
    if ( i < 16 )
    {
      if ( CustomGameConfig[i].bEnabled && (CustomGameConfig[i].GameClass != "") )
      {
        CustomGameClass = Class<GameInfo>(DynamicLoadObject(CustomGameConfig[i].GameClass,Class'Class'));
        if ( CustomGameClass == None )
        {
          Log("MapVote: Error. CustomGameConfig[" $ string(i) $ "]: Failed to load GameClass:" @ CustomGameConfig[i].GameClass);
        } else {
          if ( CustomGameClass.Default.MapPrefix ~= Level.Game.MapPrefix )
          {
            return False;
          }
        }
      }
      i++;
      goto JL005A;
    }
  }
  if ( Level.Game.IsA('TeamGamePlus') )
  {
    DebugLog("26");
    i = 0;
    if ( i < TeamGamePlus(Level.Game).MaxTeams )
    {
      if ( (Best == None) || (Best.Score < TeamGamePlus(Level.Game).Teams[i].Score) )
      {
        Best = TeamGamePlus(Level.Game).Teams[i];
      }
      i++;
      goto JL018A;
    }
    i = 0;
    if ( i < TeamGamePlus(Level.Game).MaxTeams )
    {
      if ( (Best.TeamIndex != i) && (Best.Score == TeamGamePlus(Level.Game).Teams[i].Score) )
      {
        return True;
      }
      i++;
      goto JL0234;
    }
  } else {
    DebugLog("27");
    P = Level.PawnList;
    if ( P != None )
    {
      if ( P.bIsPlayer && ((BestP == None) || (P.PlayerReplicationInfo.Score > BestP.PlayerReplicationInfo.Score)) )
      {
        BestP = P;
      }
      P = P.nextPawn;
      goto JL02DF;
    }
    P = Level.PawnList;
    if ( P != None )
    {
      if ( P.bIsPlayer && (BestP != P) && (P.PlayerReplicationInfo.Score == BestP.PlayerReplicationInfo.Score) )
      {
        return True;
      }
      P = P.nextPawn;
      goto JL0374;
    }
  }
  return False;
}

function SubmitVote (string MapName, Actor Voter)
{
  local int PlayerIndex;
  local int X;
  local int MapIndex;
  local string PID;

  DebugLog("28");
  Log(PlayerPawn(Voter).PlayerReplicationInfo.PlayerName $ " has voted for " $ GetPureMapname(MapName));
  if ( bLevelSwitchPending )
  {
    return;
  }
  if ( Voter.IsA('Spectator') )
  {
    return;
  }
  if ( Left(MapName,3) == "[X]" )
  {
    return;
  }
  MapName = GetPureMapname(MapName);
  CleanUpPlayerIDs();
  PlayerIndex = FindPlayerIndex(PlayerPawn(Voter).PlayerReplicationInfo.PlayerID,True);
  if ( PlayerIndex == -1 )
  {
    return;
  }
  MapIndex = GetMapIndex(MapName);
  if ( MapIndex == 0 )
  {
    return;
  }
  if ( PlayerVote[PlayerIndex] == MapIndex )
  {
    return;
  }
  if ( PlayerVote[PlayerIndex] <= 0 )
  {
    PID = Right("000" $ string(PlayerPawn(Voter).PlayerReplicationInfo.PlayerID),3);
    UpdatePlayerVoted(PID);
  }
  PlayerVote[PlayerIndex] = MapIndex;
  if ( Mode == "Accumulation" )
  {
    DebugLog("29");
    BroadcastMessage(PlayerPawn(Voter).PlayerReplicationInfo.PlayerName $ " has placed " $ string(GetAccVote(PlayerIndex)) $ " votes for " $ MapName,True);
  } else {
    if ( Mode == "Score" )
    {
      BroadcastMessage(PlayerPawn(Voter).PlayerReplicationInfo.PlayerName $ " has placed " $ string(GetPlayerScore(PlayerIndex)) $ " votes for " $ MapName,True);
    } else {
      BroadcastMessage(PlayerPawn(Voter).PlayerReplicationInfo.PlayerName $ " voted for " $ MapName,True);
    }
  }
  TallyVotes(False);
}

function SubmitKickVote (int PlayerID, Actor Voter)
{
  local Pawn aPawn;
  local int VoterNum;
  local int X;
  local int Y;
  local int VoteCount[32];
  local int Lamer;

  DebugLog("30");
  if ( bLevelSwitchPending )
  {
    return;
  }
  if ( Voter.IsA('Spectator') )
  {
    return;
  }
  if (  !bKickVote )
  {
    return;
  }
  CleanUpPlayerIDs();
  VoterNum = FindPlayerIndex(PlayerPawn(Voter).PlayerReplicationInfo.PlayerID,True);
  if ( VoterNum == -1 )
  {
    return;
  }
  if ( FindPlayerIndex(PlayerID,False) == -1 )
  {
    return;
  }
  if ( PlayerKickVote[VoterNum] == FindPlayerIndex(PlayerID,False) )
  {
    return;
  }
  aPawn = Level.PawnList;
  if ( aPawn != None )
  {
    if ( aPawn.bIsPlayer && (aPawn.PlayerReplicationInfo.PlayerID == PlayerID) )
    {
      if ( (NetConnection(PlayerPawn(aPawn).Player) == None) || PlayerPawn(aPawn).bAdmin )
      {
        PlayerPawn(Voter).ClientMessage("Sorry, You can Not kick the Server or the Admin.");
        return;
      } else {
        PlayerKickVote[VoterNum] = FindPlayerIndex(PlayerID,False);
        Log("BDBMapVote: " $ PlayerPawn(Voter).PlayerReplicationInfo.PlayerName $ " has placed a Kick Vote against " $ aPawn.PlayerReplicationInfo.PlayerName);
        if ( bShowWhoKicksWho )
        {
          BroadcastMessage(PlayerPawn(Voter).PlayerReplicationInfo.PlayerName $ " has placed a Kick Vote against " $ aPawn.PlayerReplicationInfo.PlayerName,True);
        } else {
          BroadcastMessage("A Kick Vote has been placed against " $ aPawn.PlayerReplicationInfo.PlayerName,True);
        }
      }
    }
    aPawn = aPawn.nextPawn;
    goto JL00C2;
  }
  X = 0;
  if ( X < 32 )
  {
    if ( PlayerKickVote[X] != -1 )
    {
      VoteCount[PlayerKickVote[X]]++;
    }
    X++;
    goto JL02D7;
  }
  Lamer = 0;
  X = 0;
  if ( X < 32 )
  {
    if ( VoteCount[X] > VoteCount[Lamer] )
    {
      Lamer = X;
    }
    X++;
    goto JL0323;
  }
  if ( VoteCount[Lamer] / Level.Game.NumPlayers * 100 >= KickPercent )
  {
JL02D7:
    DebugLog("31");
    KickPlayer(PlayerIDList[Lamer],GetPlayerName(PlayerIDList[Lamer]));
    PlayerVote[Lamer] = 0;
    VoteCount[Lamer] = 0;
    PlayerKickVote[Lamer] = -1;
    PlayerIDList[Lamer] = -1;
  }
  X = 0;
  if ( X < 32 )
  {
    if ( VoteCount[X] > 0 )
    {
      KickStatusText[Y++ ] = GetPlayerName(PlayerIDList[X]) $ "," $ string(VoteCount[X]);
    }
    X++;
    goto JL0404;
  }
  KickStatusText[Y] = "";
  UpdateOpenWRI();
  DebugLog("32");
}

function KickPlayer (int PlayerID, string PlayerName)
{
  local Pawn aPawn;
  local string IP;
  local string PID;
  local MapVoteWRI MVWRI;

  DebugLog("Playerkicked:" @ string(PlayerID) @ PlayerName);
  aPawn = Level.PawnList;
  if ( aPawn != None )
  {
    if ( aPawn.bIsPlayer && (aPawn.PlayerReplicationInfo.PlayerID == PlayerID) && ((PlayerPawn(aPawn) == None) || (NetConnection(PlayerPawn(aPawn).Player) != None)) )
    {
      BroadcastMessage(aPawn.PlayerReplicationInfo.PlayerName $ " has been kicked.",True);
      IP = PlayerPawn(aPawn).GetPlayerNetworkAddress();
      AddKickIP(IP);
      AddKickName(Mid(PlayerName,4));
      if ( bKickVote )
      {
        PID = Right("000" $ string(aPawn.PlayerReplicationInfo.PlayerID),3);
        RemovePlayerName(Right("000" $ PID,3));
      }
      foreach AllActors(Class'MapVoteWRI',MVWRI)
      {
        if ( aPawn == MVWRI.Owner )
        {
          MVWRI.CloseWindow();
          MVWRI.Destroy();
        } else {
        }
      }
      aPawn.Destroy();
      return;
    }
    aPawn = aPawn.nextPawn;
    goto JL0038;
  }
  DebugLog("34");
}

function AddKickIP (string IP)
{
  local int i;
  local int P;
  local string ShortIP;

  DebugLog("35" @ IP);
  if ( IP == "" )
  {
    return;
  }
  P = InStr(IP,":");
  if ( P > -1 )
  {
    ShortIP = Left(IP,P);
  } else {
    ShortIP = IP;
  }
  i = 0;
  if ( i < 31 )
  {
    if ( KickIPList[i] == "" )
    {
      KickIPList[i] = ShortIP;
      return;
    }
    i++;
    goto JL0065;
  }
  DebugLog("36");
}

function AddKickName (string PlayerName)
{
  local int i;
  local int P;
  local string ShortIP;

  DebugLog("35a" @ PlayerName);
  if ( PlayerName == "" )
  {
    return;
  }
  i = 0;
  if ( i < 31 )
  {
    if ( KickPlayerList[i] == "" )
    {
      KickPlayerList[i] = PlayerName;
      return;
    }
    i++;
    goto JL0027;
  }
  DebugLog("36a");
}

function bool CheckKickIP (string IP)
{
  local int i;
  local int P;
  local string ShortIP;

  DebugLog("37" @ IP);
  if ( IP == "" )
  {
    return False;
  }
  P = InStr(IP,":");
  if ( P > -1 )
  {
    ShortIP = Left(IP,P);
  } else {
    ShortIP = IP;
  }
  i = 0;
  if ( i < 32 )
  {
    if ( KickIPList[i] == ShortIP )
    {
      return True;
    }
    i++;
    goto JL0065;
  }
  DebugLog("38");
  return False;
}

function bool CheckKickPlayer (string PlayerName)
{
  local int i;
  local int P;

  DebugLog("37a" @ PlayerName);
  if ( PlayerName == "" )
  {
    return False;
  }
  i = 0;
  if ( i < 32 )
  {
    if ( KickPlayerList[i] == PlayerName )
    {
      return True;
    }
    i++;
    goto JL0027;
  }
  DebugLog("38a");
  return False;
}

function PreBeginPlay ()
{
  local int X;
  local MapVoteWRI MVWRI;
  local EmptyServerLevelSwitch ESLS;
  local string defaultPrefix;

  DebugLog("39");
  if (  !bInitialized )
  {
JL0026:
    DebugLog("40");
    X = 0;
    if ( X < 32 )
    {
      PlayerIDList[X] = -1;
      PlayerKickVote[X] = -1;
      X++ ;
      goto JL0026;
    }
    MaxPriority = MaxFloat(Max(Max(DebugLog,rotator(stop),DebugLog,bool(stop)),DebugLog,name(stop)),List4Priority);
    DebugLog("MaxPriority:" @ string(MaxPriority));
    StartMutatorsAndSettings();
    if ( bEnableEmptyServerLevelSwitch )
    {
      ESLS = Level.Spawn(Class'EmptyServerLevelSwitch');
      ESLS.ServerEmptyTimeMins = EmptyServerLevelSwitchTimeMins;
      ESLS.MapVote = self;
      // There are 1 jump destination(s) inside the last statement!
    }
    CustomGameClass = Class<GameInfo>(DynamicLoadObject(ASClass,Class'Class'));
    if ( CustomGameClass == None )
    {
      if (  !ClassIsChildOf(CustomGameClass,Class'Assault') )
      {
        DebugLog("ASClass fixed");
        ASClass = "Botpack.Assault";
        // There are 1 jump destination(s) inside the last statement!
      }
    }
    SaveConfig();
    bInitialized = True;
    // There are 1 jump destination(s) inside the last statement!
  }
  DebugLog("41");
}

function Mutate (string MutateString, PlayerPawn Sender)
{
  local string MapName;
  local string PlayerName;
  local int PlayerID;
  local int pos;
  local int seq;
  local MapVoteReport MVReport;
  local int ObjectCount;
  local MapVoteWRI MVWRI;
  local MapVoteHistory MVHistory;
  local int i;
  local string CustSetting;

  Super.Mutate(MutateString,Sender);
  if ( Left(Caps(MutateString),10) == "BDBMAPVOTE" )
  {
    DebugLog("42");
    if ( Mid(Caps(MutateString),11,8) == "VOTEMENU" )
    {
      DebugLog("43");
      if ( (Level.TimeSeconds > 15) || (Level.NetMode == 0) || Sender.bAdmin )
      {
        CleanUpPlayerIDs();
        OpenVoteWindow(Sender,True,True);
      } else {
        Sender.ClientMessage("Please wait 15 seconds to vote");
      }
      return;
    }
    if ( Mid(Caps(MutateString),11,6) == "REPORT" )
    {
      DebugLog("48");
      ObjectCount = 0;
      foreach AllActors(Class'MapVoteReport',MVReport)
      {
        ObjectCount++;
      }
      if ( ObjectCount > 0 )
      {
        Sender.ClientMessage("Sorry, The server can only run one report at a time, please try again later.");
        return;
      }
      MVReport = Spawn(Class'MapVoteReport');
      if ( MVReport != None )
      {
        MVReport.RunRport(Caps(Mid(MutateString,18)),Sender,MapVoteHistoryClass);
      } else {
        Log("Failed to spawn MVReport");
      }
      return;
    }
    if ( Sender.IsA('Spectator') &&  !Sender.bAdmin )
    {
      Sender.ClientMessage("Spectators are not allowed to vote.");
      return;
    }
    if ( Mid(Caps(MutateString),11,3) == "MAP" )
    {
      DebugLog("44");
      MapName = Mid(MutateString,15);
      if ( Sender.bAdmin )
      {
        MapName = GetPureMapname(MapName);
        BroadcastMessage("Server Admin has force a map switch to " $ MapName,True);
        ServerTravelString = SetupGameMap(MapName);
        CloseAllVoteWindows();
        Level.ServerTravel(ServerTravelString,False);
      } else {
        SubmitVote(MapName,Sender);
      }
      return;
    }
    if ( Mid(Caps(MutateString),11,4) == "KICK" )
    {
      DebugLog("45");
      PlayerName = Mid(MutateString,16);
      PlayerID = int(Mid(Left(PlayerName,4),2));
      if ( Sender.bAdmin )
      {
        Log("BDBMapVote: Admin (" $ Sender.PlayerReplicationInfo.PlayerName $ ") kicked player:" @ PlayerName);
        KickPlayer(PlayerID,PlayerName);
      } else {
        if ( bKickVote )
        {
          SubmitKickVote(PlayerID,Sender);
        } else {
          Sender.ClientMessage("Kickvote is disabled");
        }
      }
      return;
    }
    if ( Mid(Caps(MutateString),11,10) == "RELOADMAPS" )
    {
      DebugLog("46");
      if ( Sender.bAdmin )
      {
        DebugLog("47");
        GotoState('Loading','BeginRequested');
      }
      return;
    }
    if ( Mid(Caps(MutateString),11,15) == "LISTCRASHEDMAPS" )
    {
      DebugLog("46a");
      if ( Sender.bAdmin )
      {
        Sender.ClientMessage("Mapvote: Crashed Maps:");
        i = 0;
        if ( (i < 32) && (CrashedMaps[i] != "") )
        {
          Sender.ClientMessage(string(i) $ ":" @ CrashedMaps[i]);
          i++;
          goto JL04D5;
        }
        if ( i == 0 )
        {
          Sender.ClientMessage("Mapvote: No maps crashed");
        }
      }
    }
    if ( Mid(Caps(MutateString),11,16) == "CLEARCRASHEDMAPS" )
    {
      DebugLog("46a");
      if ( Sender.bAdmin )
      {
        i = 0;
        if ( i < 32 )
        {
          CrashedMaps[i] = "";
          i++;
          goto JL05A2;
        }
        SaveConfig();
        Sender.ClientMessage("Crashed Maps List Cleared!");
      }
    }
    if ( Mid(Caps(MutateString),11,6) == "STATUS" )
    {
      DebugLog("49");
      Sender.ClientMessage("Total Map Count is " $ string(MapCount));
      ObjectCount = 0;
      foreach AllActors(Class'MapVoteWRI',MVWRI)
      {
        ObjectCount++;
      }
      Sender.ClientMessage("Active MapVoteWRI count is " $ string(ObjectCount));
      ObjectCount = 0;
      foreach AllActors(Class'MapVoteReport',MVReport)
      {
        ObjectCount++;
      }
      Sender.ClientMessage("Active MapVoteReport count is " $ string(ObjectCount));
      ObjectCount = 0;
      foreach AllActors(Class'MapVoteHistory',MVHistory)
      {
        ObjectCount++;
      }
      Sender.ClientMessage("Active MapVoteHistory count is " $ string(ObjectCount));
      return;
    }
    if ( Mid(Caps(MutateString),11,6) == "SETSEQ" )
    {
      DebugLog("50");
      if ( Sender.bAdmin )
      {
        MapName = Mid(MutateString,18);
        pos = InStr(MapName," ");
        if ( pos < 1 )
        {
          Sender.ClientMessage("Syntax Error");
          return;
        }
        seq = int(Mid(MapName,pos + 1));
        MapName = Left(MapName,pos);
        MVHistory = Spawn(MapVoteHistoryClass);
        MVHistory.SetMapSequence(MapName,seq);
        MVHistory.Save();
        MVHistory.Destroy();
        Sender.ClientMessage("Sequence changed !");
      } else {
        Sender.ClientMessage("You must be a server admin to perform this fuction !");
      }
      return;
    }
    if ( Mid(Caps(MutateString),11,5) == "SETPC" )
    {
      DebugLog("51");
      if ( Sender.bAdmin )
      {
        MapName = Mid(MutateString,17);
        pos = InStr(MapName," ");
        if ( pos < 1 )
        {
          Sender.ClientMessage("Syntax Error");
          return;
        }
        seq = int(Mid(MapName,pos + 1));
        MapName = Left(MapName,pos);
        MVHistory = Spawn(MapVoteHistoryClass);
        MVHistory.SetPlayCount(MapName,seq);
        MVHistory.Save();
        MVHistory.Destroy();
        Sender.ClientMessage("PlayCount changed !");
      } else {
        Sender.ClientMessage("You must be a server admin to perform this fuction !");
      }
      return;
    }
    if ( Mid(Caps(MutateString),11,11) == "CUSTSETTING" )
    {
      DebugLog("45b");
      if ( Sender.bAdmin )
      {
        CustSetting = Mid(MutateString,23,16);
        DebugLog("new Custsetting:" @ CustSetting);
        i = 0;
        if ( i < 16 )
        {
          if ( Mid(CustSetting,i,1) == "1" )
          {
            CustomGameConfig[i].bEnabled = True;
          } else {
            CustomGameConfig[i].bEnabled = False;
          }
          i++;
          goto JL0A68;
        }
        SaveConfig();
      }
      return;
    }
  }
}

function OpenVoteWindow (PlayerPawn Sender, bool bSpecsAllowed, bool bManualOpen)
{
  local MapVoteWRI MVWRI;
  local int X;
  local int PlayerCount;
  local int Y;
  local int i;
  local Pawn P;
  local MapVoteWRI A;
  local int TeamID;
  local string PID;
  local string CustState;

  DebugLog("52: OpenVoteWindow()");
  if ( Sender.IsA('Spectator') &&  !Sender.bAdmin &&  !bSpecsAllowed )
  {
    return;
  }
  if ( bLevelSwitchPending )
  {
    return;
  }
  foreach AllActors(Class'MapVoteWRI',A)
  {
    if ( Sender == A.Owner )
    {
      DebugLog("53: WRI already Spawned --> return");
      return;
    }
  }
  MVWRI = Spawn(Class'MapVoteWRI',Sender,,Sender.Location);
  if ( MVWRI == None )
  {
    Log("#### -- PostLogin :: Fail:: Could not spawn WRI");
    return;
  }
  MVWRI.MapVoteMutator = self;
  MVWRI.List1Priority = List1Priority;
  MVWRI.List2Priority = List2Priority;
  MVWRI.List3Priority = List3Priority;
  MVWRI.List4Priority = List4Priority;
  MVWRI.MapCount = MapCount;
  i = 0;
  if ( i < 256 )
  {
    MVWRI.MapList1[i] = MapList[i];
    MVWRI.MapList2[i] = MapList[i + 256];
    MVWRI.MapList3[i] = MapList[i + 512];
    MVWRI.MapList4[i] = MapList[i + 768];
    i++;
    goto JL0194;
  }
  if ( Sender.bAdmin )
  {
    CustState = "";
    i = 0;
    if ( i < 16 )
    {
      if ( CustomGameConfig[i].bEnabled )
      {
        CustState = CustState $ "1";
      } else {
        CustState = CustState $ "0";
      }
      if ( CustomGameConfig[i].NewPrefix != "" )
      {
        MVWRI.CustomGames[i] = CustomGameConfig[i].GameClass $ " (" $ CustomGameConfig[i].NewPrefix $ ")";
      } else {
        MVWRI.CustomGames[i] = CustomGameConfig[i].GameClass;
      }
      i++;
      goto JL0263;
    }
    MVWRI.CustomGamesState = CustState;
  }
  MVWRI.PrefixDictionary = PrefixDictionary;
  DebugLog("54");
  PlayerCount = 0;
  P = Level.PawnList;
  if ( P != None )
  {
    if ( (PlayerPawn(P) != None) && P.bIsPlayer )
    {
      if ( P.IsA('Spectator') )
      {
        TeamID = 9;
      } else {
        if ( PlayerPawn(P).PlayerReplicationInfo.Team == 255 )
        {
          TeamID = 0;
        } else {
          TeamID = PlayerPawn(P).PlayerReplicationInfo.Team;
        }
      }
      PID = Right("000" $ string(PlayerPawn(P).PlayerReplicationInfo.PlayerID),3);
      if ( PlayerVote[FindPlayerIndex(PlayerPawn(P).PlayerReplicationInfo.PlayerID,True)] > 0 )
      {
        MVWRI.PlayerName[PlayerCount++ ] = string(TeamID) $ PID $ PlayerPawn(P).PlayerReplicationInfo.PlayerName $ "&?&!&";
      } else {
        MVWRI.PlayerName[PlayerCount++ ] = string(TeamID) $ PID $ PlayerPawn(P).PlayerReplicationInfo.PlayerName;
      }
    }
    P = P.nextPawn;
    goto JL037E;
  }
  X = 0;
  if ( (MapStatusText[X] != "") && (X < 31) )
  {
    MVWRI.MapVoteResults[X] = MapStatusText[X];
    X++;
    goto JL0528;
  }
  MVWRI.MapVoteResults[X] = "";
  Y = 0;
  if ( bKickVote )
  {
    DebugLog("55");
    if ( (KickStatusText[Y] != "") && (Y < 31) )
    {
      MVWRI.KickVoteResults[Y] = KickStatusText[Y++ ];
      goto JL05A3;
    }
    MVWRI.KickVoteResults[Y] = "";
  }
  MVWRI.GetServerConfig();
  DebugLog("56");
}

function OpenWelcomeWindow (PlayerPawn Sender)
{
  local MVWelcomeWRI MVWWRI;
  local MVWelcomeWRI A;

  DebugLog("57");
  if ( Sender.IsA('Spectator') )
  {
    return;
  }
  foreach AllActors(Class'MVWelcomeWRI',A)
  {
    if ( Sender == A.Owner )
    {
      return;
    }
  }
  MVWWRI = Spawn(Class'MVWelcomeWRI',Sender,,Sender.Location);
  if ( MVWWRI == None )
  {
    Log("#### -- PostLogin :: Fail:: Could not spawn MVWelcomeWRI");
    return;
  }
  MVWWRI.GetServerConfig();
  DebugLog("58");
}

function int FindPlayerIndex (int PlayerID, bool bAddIfNotFound)
{
  local int X;

  DebugLog("59");
  X = 0;
  if ( X < 32 )
  {
    if ( PlayerIDList[X] == PlayerID )
    {
      return X;
    }
    X++;
    goto JL0011;
  }
  if ( bAddIfNotFound )
  {
    DebugLog("59b");
    X = 0;
    if ( X < 32 )
    {
      if ( PlayerIDList[X] == -1 )
      {
        PlayerIDList[X] = PlayerID;
        return X;
      }
      X++;
      goto JL005D;
    }
  }
  Log("Mapvote: Could not find PlayerIndex. Already left?");
  DebugLog("60");
  return -1;
}

function AddNewPlayer (string NewPlayerName, bool bHasVoted)
{
  local MapVoteWRI MVWRI;
  local Pawn P;

  DebugLog("61");
  foreach AllActors(Class'MapVoteWRI',MVWRI)
  {
    MVWRI.AddNewPlayer(NewPlayerName,bHasVoted);
  }
  DebugLog("62");
}

function RemovePlayerName (string OldPlayerName)
{
  local MapVoteWRI MVWRI;
  local Pawn P;

  DebugLog("63");
  foreach AllActors(Class'MapVoteWRI',MVWRI)
  {
    MVWRI.RemovePlayerName(OldPlayerName);
  }
}

function UpdatePlayerVoted (string PlayerID)
{
  local MapVoteWRI MVWRI;
  local Pawn P;

  DebugLog("63");
  foreach AllActors(Class'MapVoteWRI',MVWRI)
  {
    MVWRI.UpdatePlayerVoted(PlayerID);
  }
}

function CleanUpPlayerIDs ()
{
  local Pawn aPawn;
  local int X;
  local bool bFound;

  DebugLog("64");
  X = 0;
  if ( X < 32 )
  {
    if ( PlayerIDList[X] > -1 )
    {
      bFound = False;
      aPawn = Level.PawnList;
JL004E:
      if ( aPawn != None )
      {
        if ( aPawn.bIsPlayer && aPawn.IsA('PlayerPawn') && (PlayerPawn(aPawn).PlayerReplicationInfo.PlayerID == PlayerIDList[X]) )
        {
          bFound = True;
        } else {
          aPawn = aPawn.nextPawn;
          goto JL004E;
        }
      }
      if (  !bFound )
      {
        DebugLog("Removing Player that has left:" @ string(PlayerIDList[X]));
        if ( bKickVote )
        {
          RemovePlayerName(Right("000" $ string(PlayerIDList[X]),3));
        }
        PlayerVote[X] = 0;
        PlayerKickVote[X] = -1;
        PlayerIDList[X] = -1;
      }
    }
    X++;
    goto JL0011;
  }
  DebugLog("65");
}

function string GetPlayerName (int PlayerID)
{
  local Pawn aPawn;
  local string PlayerName;

  DebugLog("66");
  PlayerName = "unknown";
  aPawn = Level.PawnList;
  if ( aPawn != None )
  {
    if ( aPawn.bIsPlayer && (PlayerPawn(aPawn) != None) )
    {
      if ( PlayerPawn(aPawn).PlayerReplicationInfo.PlayerID == PlayerID )
      {
        PlayerName = Right("000" $ string(PlayerID),3) $ aPawn.PlayerReplicationInfo.PlayerName;
      } else {
        aPawn = aPawn.nextPawn;
        goto JL002D;
      }
    }
  }
  return PlayerName;
}

function float GetPlayerScore (int PlayerIndex)
{
  local Pawn aPawn;
  local float PlayerScore;

  DebugLog("67");
  aPawn = Level.PawnList;
  if ( aPawn != None )
  {
    if ( aPawn.bIsPlayer && (PlayerPawn(aPawn) != None) )
    {
      if ( PlayerPawn(aPawn).PlayerReplicationInfo.PlayerID == PlayerIDList[PlayerIndex] )
      {
        PlayerScore = PlayerPawn(aPawn).PlayerReplicationInfo.Score;
      } else {
        aPawn = aPawn.nextPawn;
        goto JL001E;
      }
    }
  }
  if ( PlayerScore < 1 )
  {
    PlayerScore = 1.0;
  }
  return PlayerScore;
}

function int GetAccVote (int PlayerIndex)
{
  local Pawn aPawn;
  local int X;
  local int PlayerAccVotes;
  local string PlayerName;

  DebugLog("68");
  aPawn = Level.PawnList;
  if ( aPawn != None )
  {
    if ( aPawn.bIsPlayer && (PlayerPawn(aPawn) != None) )
    {
      if ( PlayerPawn(aPawn).PlayerReplicationInfo.PlayerID == PlayerIDList[PlayerIndex] )
      {
        PlayerName = PlayerPawn(aPawn).PlayerReplicationInfo.PlayerName;
      } else {
        aPawn = aPawn.nextPawn;
        goto JL001E;
      }
    }
  }
  if ( PlayerName == "" )
  {
    return 0;
  }
  X = 0;
  if ( X < 32 )
  {
    if ( AccName[X] == PlayerName )
    {
      PlayerAccVotes = AccVotes[X];
    } else {
      X++;
      goto JL00CA;
    }
  }
  if ( PlayerAccVotes > 0 )
  {
    return PlayerAccVotes;
  }
  X = 0;
  if ( X < 32 )
  {
    if ( AccName[X] == "" )
    {
      AccName[X] = PlayerName;
      AccVotes[X] = 1;
    } else {
      X++;
      goto JL0121;
    }
  }
  DebugLog("69");
  return 1;
}

function SaveAccVotes (int WinningMapIndex)
{
  local Pawn aPawn;
  local int X;
  local bool bFound;

  DebugLog("70");
  X = 0;
  if ( X < 32 )
  {
    if ( AccName[X] != "" )
    {
      bFound = False;
      aPawn = Level.PawnList;
      if ( aPawn != None )
      {
        if ( aPawn.bIsPlayer && (PlayerPawn(aPawn) != None) )
        {
          if ( AccName[X] == PlayerPawn(aPawn).PlayerReplicationInfo.PlayerName )
          {
            if ( PlayerVote[FindPlayerIndex(PlayerPawn(aPawn).PlayerReplicationInfo.PlayerID,False)] != WinningMapIndex )
            {
              bFound = True;
              AccVotes[X]++;
            }
          } else {
            aPawn = aPawn.nextPawn;
            goto JL004B;
          }
        }
      }
      if (  !bFound )
      {
        AccName[X] = "";
        AccVotes[X] = 0;
      }
    }
    X++;
    goto JL0011;
  }
  X = 0;
  if ( X < 32 )
  {
    Class'BDBMapVote'.Default.AccName[X] = AccName[X];
    Class'BDBMapVote'.Default.AccVotes[X] = AccVotes[X];
    X++;
    goto JL013F;
  }
  Class'BDBMapVote'.StaticSaveConfig();
  DebugLog("71");
}

function TallyVotes (bool bForceMapSwitch)
{
  local string MapName;
  local Actor A;
  local int Index;
  local int X;
  local int Y;
  local int topmap;
  local float VoteCount[1024];
  local int Ranking[32];
  local int PlayersThatVoted;
  local int TieCount;
  local string GameType;
  local string CurrentMap;
  local int i;
  local int textline;
  local MapVoteHistory History;
  local int PlayersLeftToVote;

  DebugLog("72");
  if ( bLevelSwitchPending )
  {
JL0023:
    return;
  }
  PlayersThatVoted = 0;
  X = 0;
  if ( X < 32 )
  {
    if ( PlayerVote[X] != 0 )
    {
      PlayersThatVoted++ ;
      if ( Mode == "Score" )
      {
        VoteCount[PlayerVote[X]] = VoteCount[PlayerVote[X]] + FindPlayerIndex;
      }
      )
      if ( Mode == "Accumulation" )
      {
        VoteCount[PlayerVote[X]] = VoteCount[PlayerVote[X]] + GetAccVote(X);
        // There are 1 jump destination(s) inside the last statement!
      }
      if ( (Mode == "Elimination") || (Mode == "Majority") )
      {
        VoteCount[PlayerVote[X]] += GetMapPriority(MapList[PlayerVote[X]]);
        // There are 1 jump destination(s) inside the last statement!
      }
      DebugLog("PlayerVote[x]:" @ string(PlayerVote[X]));
      DebugLog("VoteCount[PlayerVote[x]]:" @ string(VoteCount[PlayerVote[X]]));
      // There are 1 jump destination(s) inside the last statement!
    }
    X++ ;
    goto JL0023;
    // There are 1 jump destination(s) inside the last statement!
  }
  if (  !Level.Game.bGameEnded &&  !bMidGameVote && (PlayersThatVoted / Level.Game.NumPlayers * 100 >= MidGameVotePercent) )
  {
    DebugLog("73");
    BroadcastMessage("Mid-Game Map Voting has been initiated !!!!");
    bMidGameVote = True;
    TimeLeft = VoteTimeLimit;
    ScoreBoardTime = 1;
    SetTimer(1.0,True);
    // There are 1 jump destination(s) inside the last statement!
  }
  Index = 0;
  X = 1;
  if ( X <= MapCount )
  {
    if ( VoteCount[X] > 0 )
    {
      Ranking[Index++ ] = X;
      // There are 1 jump destination(s) inside the last statement!
    }
    X++ ;
    goto JL0257;
    // There are 1 jump destination(s) inside the last statement!
  }
  X = 0;
  if ( X < Index - 1 )
  {
    Y = X + 1;
    if ( Y < Index )
    {
      if ( VoteCount[Ranking[X]] < VoteCount[Ranking[Y]] )
      {
        topmap = Ranking[X];
        Ranking[X] = Ranking[Y];
        Ranking[Y] = topmap;
        // There are 1 jump destination(s) inside the last statement!
      }
      Y++ ;
      goto JL02BC;
      // There are 1 jump destination(s) inside the last statement!
    }
    X++ ;
    goto JL029C;
    // There are 1 jump destination(s) inside the last statement!
  }
  PlayersLeftToVote = Level.Game.NumPlayers - PlayersThatVoted;
  DebugLog("NumPlayer:" $ string(Level.Game.NumPlayers) @ "PlayerVoted:" $ string(PlayersThatVoted) @ "PlayersToVote:" $ string(PlayersLeftToVote) @ "MaxPriority:" $ string(MaxPriority));
  if ( (Mode == "Elimination") || (Mode == "Majority") )
  {
    if ( (PlayersLeftToVote * MaxPriority < VoteCount[Ranking[0]]) && (VoteCount[Ranking[1]] + PlayersLeftToVote * GetMapPriority(MapList[Ranking[1]]) < VoteCount[Ranking[0]]) && (VoteCount[Ranking[2]] + PlayersLeftToVote * GetMapPriority(MapList[Ranking[2]]) < VoteCount[Ranking[0]]) && (VoteCount[Ranking[3]] + PlayersLeftToVote * GetMapPriority(MapList[Ranking[3]]) < VoteCount[Ranking[0]]) && Level.Game.bGameEnded )
    {
      bForceMapSwitch = True;
      // There are 2 jump destination(s) inside the last statement!
    }
  }
  X = 0;
  if ( X < Index )
  {
    MapStatusText[X] = GetPureMapname(MapList[Ranking[X]]) $ "," $ Left(string(VoteCount[Ranking[X]]),3);
    X++ ;
    goto JL050F;
    // There are 1 jump destination(s) inside the last statement!
  }
  MapStatusText[Index] = "";
  UpdateOpenWRI();
  if ( (VoteCount[Ranking[0]] == VoteCount[Ranking[1]]) && (VoteCount[Ranking[0]] != 0) )
  {
    DebugLog("74");
    TieCount = 1;
    X = 1;
    if ( X < Index )
    {
      if ( VoteCount[Ranking[0]] == VoteCount[Ranking[X]] )
      {
        TieCount++ ;
        // There are 1 jump destination(s) inside the last statement!
      }
      X++ ;
      goto JL05C9;
      // There are 1 jump destination(s) inside the last statement!
    }
    topmap = Ranking[Rand(TieCount)];
    CurrentMap = RemovePrefix(GetURLMap());
    if ( InStr(CurrentMap,".") > -1 )
    {
      CurrentMap = Left(CurrentMap,InStr(CurrentMap,"."));
      // There are 1 jump destination(s) inside the last statement!
    }
    X = 0;
    if ( RemovePrefix(GetPureMapname(MapList[topmap])) ~= CurrentMap )
    {
      topmap = Ranking[Rand(TieCount)];
      X++ ;
      if ( X > 20 )
      {
        goto JL06AD;
        // There are 1 jump destination(s) inside the last statement!
      }
      goto JL0660;
      // There are 1 jump destination(s) inside the last statement!
    }
    goto JL06C7;
    // There are 1 jump destination(s) inside the last statement!
  }
  DebugLog("75");
  topmap = Ranking[0];
  if ( bForceMapSwitch )
  {
    if ( (PlayersThatVoted == 0) || (Level.Game.NumPlayers == 0) )
    {
      BroadcastMessage("Noone voted, choosing a random map...",True);
      topmap = GetRandomMap();
      // There are 2 jump destination(s) inside the last statement!
    }
  }
  if ( bForceMapSwitch || (Level.Game.NumPlayers == PlayersThatVoted) )
  {
    DebugLog("76");
    if ( MapList[topmap] == "" )
    {
      return;
      // There are 1 jump destination(s) inside the last statement!
    }
    if ( (VoteCount[Ranking[0]] == VoteCount[Ranking[1]]) && (VoteCount[Ranking[0]] != 0) )
    {
      BroadcastMessage("Tie:" @ GetPureMapname(MapList[Ranking[0]]) @ "and" @ GetPureMapname(MapList[Ranking[1]]) @ "have same score!");
      BroadcastMessage(GetPureMapname(MapList[topmap]) $ " has won.",True);
      goto JL0851;
      // There are 1 jump destination(s) inside the last statement!
    }
    BroadcastMessage(GetPureMapname(MapList[topmap]) $ " has won.",True);
    CloseAllVoteWindows();
    bLevelSwitchPending = True;
    ServerTravelString = SetupGameMap(MapList[topmap]);
    ServerTravelTime = SelectMap;
    Level
    switch (return TimeSeconds)
    {
      if (  !Level.Game.bGameEnded )
      {
        SetTimer(1.0,True);
        // There are 1 jump destination(s) inside the last statement!
      }
      if (! (PlayersThatVoted == 0) || (Level.Game.NumPlayers == 0) ) goto JL08DE;
      break;
JL0660:
      History = Spawn(MapVoteHistoryClass);
      History.AddMap(GetPureMapname(MapList[topmap]));
      History.Save();
      History.Destroy();
      // There are 1 jump destination(s) inside the last statement!
    }
    if ( Mode == "Elimination" )
    {
      RepeatLimit++ ;
JL06AD:
      Class'BDBMapVote'.Default.RepeatLimit = RepeatLimit;
      Class'BDBMapVote'.StaticSaveConfig();
      // There are 1 jump destination(s) inside the last statement!
    }
    if ( Mode == "Accumulation" )
    {
      SaveAccVotes(topmap);
      // There are 2 jump destination(s) inside the last statement!
    }
  }
}

function UpdateOpenWRI ()
{
  local MapVoteWRI MVWRI;
  local int X;
  local int Y;

  DebugLog("78");
  foreach AllActors(Class'MapVoteWRI',MVWRI)
  {
    X = 0;
    MVWRI.UpdateMapVoteResults("Clear",X);
    if ( (MapStatusText[X] != "") && (X < 31) )
    {
      MVWRI.UpdateMapVoteResults(MapStatusText[X],X);
      X++;
      goto JL003C;
    }
    MVWRI.UpdateMapVoteResults("",X);
    Y = 0;
    MVWRI.UpdateKickVoteResults("Clear",Y);
    if ( bKickVote )
    {
      if ( (KickStatusText[Y] != "") && (Y < 31) )
      {
        MVWRI.UpdateKickVoteResults(KickStatusText[Y],Y++ );
        goto JL00C6;
      }
    }
    MVWRI.UpdateKickVoteResults("",Y);
  }
  DebugLog("79");
}

function SortMapList ()
{
  local int A;
  local int B;
  local int pos;
  local string TempMapName;
  local string AMap;
  local string BMap;
  local string AMapPre;
  local string BMapPre;

  DebugLog("80");
  A = 1;
  if ( A < MapCount )
  {
    B = A + 1;
    if ( B <= MapCount )
    {
      AMap = Caps(MapList[A]);
      BMap = Caps(MapList[B]);
      if ( Left(AMap,3) == "[X]" )
      {
        AMap = Mid(AMap,3);
      }
      if ( Left(BMap,3) == "[X]" )
      {
        BMap = Mid(BMap,3);
      }
      AMap = Right(AMap,1) $ AMap;
      BMap = Right(BMap,1) $ BMap;
      AMapPre = AMap;
      BMapPre = BMap;
      if (  !bSortWithPreFix )
      {
        pos = InStr(AMap,"-");
        AMap = Mid(AMap,pos + 1);
        pos = InStr(BMap,"-");
        BMap = Mid(BMap,pos + 1);
      }
      if ( AMap > BMap )
      {
        TempMapName = MapList[A];
        MapList[A] = MapList[B];
        MapList[B] = TempMapName;
      } else {
        if ( AMap == BMap )
        {
          if ( AMapPre > BMapPre )
          {
            TempMapName = MapList[A];
            MapList[A] = MapList[B];
            MapList[B] = TempMapName;
          }
        }
      }
      B++;
      goto JL002E;
    }
    A++;
    goto JL0011;
  }
}

function bool IsCrashedMap (string MapName)
{
  local int j;

  MapName = GetPureMapname(MapName);
  j = 0;
  if ( (j < 32) && (CrashedMaps[j] != "") )
  {
    if ( MapName ~= CrashedMaps[j] )
    {
      if ( bDebugMode )
      {
        DebugLog("Map found in crashed map list:" @ MapName);
      }
      return True;
    }
    j++;
    goto JL0018;
  }
  return False;
}

function string CreateMapnameIncludingListnumber (string mapnameX)
{
  local string MapName;
  local bool locked;
  local int j;

  if ( Left(mapnameX,3) ~= "[x]" )
  {
    MapName = GetPureMapname(mapnameX);
    locked = True;
  } else {
    MapName = GetPureMapname(mapnameX);
  }
  if ( bRemoveCrashedMaps && IsCrashedMap(MapName) )
  {
    return "";
  }
  if ( bUseExcludeFilter )
  {
    j = 0;
    if ( (j < 16) && (ExcludeFilter[j] != "") )
    {
      if ( MatchFilter(MapName,ExcludeFilter[j]) )
      {
        DebugLog("Excluded Map:" @ MapName);
        return "";
      }
      j++;
      goto JL006C;
    }
  }
  j = 0;
  if ( (j < 48) && (List1Filter[j] != "") )
  {
    if ( MatchFilter(MapName,List1Filter[j]) || bAutoDetect )
    {
      if (  !bList1ObeyRepeatLimit && locked )
      {
        mapnameX = MapName;
      }
      mapnameX = mapnameX $ ":1";
      return mapnameX;
    }
    j++;
    goto JL00D5;
  }
  j = 0;
  if ( (j < 48) && (List2Filter[j] != "") )
  {
    if ( MatchFilter(MapName,List2Filter[j]) )
    {
      if (  !bList2ObeyRepeatLimit && locked )
      {
        mapnameX = MapName;
      }
      mapnameX = mapnameX $ ":2";
      return mapnameX;
    }
    j++;
    goto JL0162;
  }
  j = 0;
  if ( (j < 48) && (List3Filter[j] != "") )
  {
    if ( MatchFilter(MapName,List3Filter[j]) )
    {
      if (  !bList3ObeyRepeatLimit && locked )
      {
        mapnameX = MapName;
      }
      mapnameX = mapnameX $ ":3";
      return mapnameX;
    }
    j++;
    goto JL01E4;
  }
  j = 0;
  if ( (j < 48) && (List4Filter[j] != "") )
  {
    if ( MatchFilter(MapName,List4Filter[j]) )
    {
JL01E4:
      if (  !bList4ObeyRepeatLimit && locked )
      {
        mapnameX = MapName;
      }
      mapnameX = mapnameX $ ":4";
      return mapnameX;
    }
    j++;
    goto JL0266;
  }
  return "";
}

function int GetMapListNumber (string MapName)
{
  return int(Right(MapName,1));
}

function float GetMapPriority (string MapName)
{
  local int MapListNum;

  if ( MapName == "" )
  {
    return 0.0;
  }
  MapListNum = GetMapListNumber(MapName);
  if ( MapListNum == 1 )
  {
    return List1Priority;
  }
  if ( MapListNum == 2 )
  {
    return List2Priority;
  }
  if ( MapListNum == 3 )
  {
    return List3Priority;
  }
  if ( MapListNum == 4 )
  {
    return List4Priority;
  }
  Log("ERROR: GetMapPriority(): Mapname has no Priority attached:" @ MapName,'MapVoteLA');
  return 1.0;
}

function string GetPureMapname (string MapName)
{
  if ( Left(MapName,3) ~= "[x]" )
  {
    MapName = Mid(MapName,3);
  }
  if ( Left(Right(MapName,2),1) == ":" )
  {
    MapName = Left(MapName,Len(MapName) - 2);
  }
  return MapName;
}

function bool MatchFilter (string Map, string Filter)
{
  local string modFilter;

  if ( Map ~= Filter )
  {
    return True;
  }
  if ( Right(Filter,1) == "*" )
  {
    modFilter = Mid(Filter,0,Len(Filter) - 1);
    if ( Left(Map,Len(modFilter)) ~= modFilter )
    {
      return True;
    }
  }
  if ( Right(Filter,1) == "-" )
  {
    if ( Left(Map,Len(Filter)) ~= Filter )
    {
      return True;
    }
  }
  if ( (Right(Filter,1) == "*") && (Left(Filter,1) == "*") )
  {
    modFilter = Mid(Filter,1,Len(Filter) - 2);
    if ( InStr(Caps(Map),Caps(modFilter)) >= 0 )
    {
      return True;
    }
  }
  if ( Filter == "*" )
  {
    return True;
  }
  return False;
}

function CloseAllVoteWindows ()
{
  local MapVoteWRI MVWRI;

  DebugLog("81");
  foreach AllActors(Class'MapVoteWRI',MVWRI)
  {
    MVWRI.CloseWindow();
    MVWRI.Destroy();
  }
}

function string SetupGameMap (string MapName)
{
  local string GameType;
  local MapList myList;
  local string MutatorList;
  local int i;

  DebugLog("82");
  MapName = GetPureMapname(MapName);
  ResetAssault();
  TmpNextVirtualPrefix = FixPrefix(GetPrefix(MapName));
  DebugLog("NextVirtualPrefix:" @ TmpNextVirtualPrefix);
  SaveConfig();
  if ( MapName == "" )
  {
    return "?Restart";
  }
  if ( (AutoGameClass != None) && bAutoGame )
  {
    DebugLog("83b");
    if ( Left(Caps(MapName),Len(FixPrefix(AutoGameClass.Default.MapPrefix))) ~= FixPrefix(AutoGameClass.Default.MapPrefix) )
    {
      TmpNextRealPrefix = FixPrefix(AutoGameClass.Default.MapPrefix);
      if ( bFixCTFModifications )
      {
        if ( Right(string(AutoGameClass),12) ~= "MultiCTFGame" )
        {
          DebugLog("MultiCTF detected. Fixing Mapprefix to CTFM");
          TmpNextRealPrefix = "CTFM";
        }
      }
      DebugLog("NextRealPrefix:" @ TmpNextRealPrefix);
      SaveConfig();
      TravelMap = MapName;
      return MapName $ ".unr?game=" $ AutoGame;
    }
  }
  i = 0;
  if ( i < 16 )
  {
    if ( CustomGameConfig[i].bEnabled && (CustomGameConfig[i].GameClass != "") )
    {
      DebugLog("83.1");
      CustomGameClass = Class<GameInfo>(DynamicLoadObject(CustomGameConfig[i].GameClass,Class'Class'));
      if ( CustomGameClass == None )
      {
        Log("MapVote: Error. CustomGameConfig[" $ string(i) $ "]: Failed to load GameClass:" @ CustomGameConfig[i].GameClass);
      } else {
        CustomGameConfig[i].NewPrefix = FixPrefix(CustomGameConfig[i].NewPrefix);
        if ( bFixCTFModifications )
        {
          if ( Right(CustomGameConfig[i].GameClass,12) ~= "MultiCTFGame" )
          {
            DebugLog("MultiCTF detected. Fixing Mapprefix to CTFM");
            CustomGameClass.Default.MapPrefix = "CTFM";
          }
        }
        if ( CustomGameConfig[i].NewPrefix != "" )
        {
          DebugLog("83.2a");
          DebugLog(TmpNextVirtualPrefix @ CustomGameConfig[i].NewPrefix);
          if ( TmpNextVirtualPrefix ~= CustomGameConfig[i].NewPrefix )
          {
            DebugLog("83.2b");
            TmpNextRealPrefix = FixPrefix(CustomGameClass.Default.MapPrefix);
            if ( bFixCTFModifications )
            {
              if ( Right(CustomGameConfig[i].GameClass,12) ~= "MultiCTFGame" )
              {
                TmpNextRealPrefix = "CTFM";
              }
            }
            DebugLog("NextRealPrefix:" @ TmpNextRealPrefix);
            SaveConfig();
            TravelMap = MapName;
            return TmpNextRealPrefix $ Mid(MapName,Len(TmpNextVirtualPrefix)) $ ".unr?game=" $ CustomGameConfig[i].GameClass;
          }
        } else {
          DebugLog("83.3a");
          DebugLog(TmpNextVirtualPrefix @ FixPrefix(CustomGameClass.Default.MapPrefix));
          if ( TmpNextVirtualPrefix ~= FixPrefix(CustomGameClass.Default.MapPrefix) )
          {
            DebugLog("83.3b");
            TmpNextRealPrefix = FixPrefix(GetPrefix(MapName));
            DebugLog("NextRealPrefix:" @ TmpNextRealPrefix);
            SaveConfig();
            TravelMap = MapName;
            return MapName $ ".unr?game=" $ CustomGameConfig[i].GameClass;
          }
        }
      }
    }
    i++;
    goto JL0199;
  }
  if ( Left(Caps(MapName),2) == "DM" )
  {
    GameType = "BotPack.DeathMatchPlus";
  }
  if ( Left(Caps(MapName),3) == "LMS" )
  {
    GameType = "BotPack.LastManStanding";
    MapName = "DM" $ Mid(MapName,3);
  }
  if ( Left(Caps(MapName),3) == "TDM" )
  {
    GameType = "BotPack.TeamGamePlus";
    MapName = "DM" $ Mid(MapName,3);
  }
  if ( Left(Caps(MapName),3) == "DOM" )
  {
    GameType = "BotPack.Domination";
  }
  if ( Left(Caps(MapName),3) == "CTF" )
  {
    GameType = "BotPack.CTFGame";
  }
  if ( Left(Caps(MapName),2) == "AS" )
  {
    GameType = ASClass;
  }
  TmpNextRealPrefix = GetPrefix(MapName);
  DebugLog("NextRealPrefix:" @ TmpNextRealPrefix);
  SaveConfig();
  TravelMap = MapName;
  return MapName $ ".unr?game=" $ GameType;
}

function LoadMapListConfig ()
{
  local MapListTemp TempList;
  local string MapName;
  local int j;

  DebugLog("Loading Maplist from file...");
  MapVoteHistoryClass = Class<MapVoteHistory>(DynamicLoadObject(MapVoteHistoryType,Class'Class'));
  History = Spawn(MapVoteHistoryClass);
  if ( History == None )
  {
    DebugLog("89");
    MapVoteHistoryClass = Class<MapVoteHistory>(DynamicLoadObject("MapVoteLA13.MapVoteHistory1",Class'Class'));
    History = Spawn(MapVoteHistoryClass);
  }
  MapList[0] = "";
  j = 1;
  i = 1;
  if ( i <= Class'MapListTemp'.Default.MapCount )
  {
    MapName = Class'MapListTemp'.Default.M[i];
    if ( History.GetMapSequence(GetPureMapname(MapName)) <= RepeatLimit )
    {
      MapName = "[X]" $ MapName;
    }
    if ( bRemoveCrashedMaps && IsCrashedMap(MapName) )
    {
      goto JL0157;
    }
    MapList[j] = MapName;
    j++;
    i++;
    goto JL00BB;
  }
  MapCount = j - 1;
  PrefixDictionary = Class'MapListTemp'.Default.PrefixDictionary;
  DebugLog("Loading Maplist finished:" @ string(MapCount));
  History.Destroy();
}

function SaveMapListConfig ()
{
  local int i;
  local int j;
  local MapListTemp List;

  DebugLog("Storing Maplist to file...");
  List = Spawn(Class'MapListTemp');
  List.MapCount = MapCount;
  List.M[0] = "";
  i = 1;
  if ( i <= MapCount )
  {
    if ( Left(MapList[i],3) ~= "[X]" )
    {
      List.M[i] = Mid(MapList[i],3);
    } else {
      List.M[i] = MapList[i];
    }
    i++;
    goto JL005E;
  }
  j = i;
  if ( j < 1024 )
  {
    List.M[j] = "";
    j++;
    goto JL00E2;
  }
  List.PrefixDictionary = PrefixDictionary;
  List.SaveConfig();
  List.Destroy();
  DebugLog("Storing Maplist to file finished:" @ string(MapCount));
}

function UpdatePrefixes ()
{
  local int i;
  local string defaultPrefix;

  PrefixDictionary = "";
  i = 0;
  if ( i < 16 )
  {
    if ( CustomGameConfig[i].bEnabled && (CustomGameConfig[i].GameClass != "") )
    {
      CustomGameClass = Class<GameInfo>(DynamicLoadObject(CustomGameConfig[i].GameClass,Class'Class'));
      if ( CustomGameClass != None )
      {
        defaultPrefix = FixPrefix(CustomGameClass.Default.MapPrefix);
        if ( bFixCTFModifications && (Right(CustomGameConfig[i].GameClass,12) ~= "MultiCTFGame") )
        {
          defaultPrefix = "CTFM";
        }
        if ( CustomGameConfig[i].NewPrefix == "" )
        {
          CustomGameConfig[i].NewPrefix = defaultPrefix;
          SaveConfig();
        }
        if ( CustomGameConfig[i].NewPrefix != defaultPrefix )
        {
          PrefixDictionary = PrefixDictionary $ CustomGameConfig[i].NewPrefix $ ";" $ defaultPrefix $ ";";
        }
      }
    }
    i++;
    goto JL000F;
  }
  DebugLog("PrefixDictionary:" @ PrefixDictionary);
}

state Loading
{
  bMapReloadRequested = True;
  BroadcastMessage("Maplist is reloading...",True);
  DebugLog("84a");
  DebugLog("84b");
  UpdatePrefixes();
  MapVoteHistoryClass = Class<MapVoteHistory>(DynamicLoadObject(MapVoteHistoryType,Class'Class'));
  History = Spawn(MapVoteHistoryClass);
  if ( History == None )
  {
    DebugLog("89");
    MapVoteHistoryClass = Class<MapVoteHistory>(DynamicLoadObject("MapVoteLA13.MapVoteHistory1",Class'Class'));
    History = Spawn(MapVoteHistoryClass);
  }
  MapCount = 0;
  i = 0;
  if ( i < 1024 )
  {
    MapList[i] = "";
    i++;
    goto JL00D1;
  }
  if ( bAutoDetect )
  {
    Log("Detected GameType = " $ string(Level.Game.Class));
    bAS = False;
    bCTF = False;
    bDM = False;
    bLMS = False;
    bTDM = False;
    bDOM = False;
    bAutoGame = False;
    if ( string(Level.Game.Class) ~= ASClass )
    {
      bAS = True;
    } else {
      if ( string(Level.Game.Class) ~= "Botpack.CTFGame" )
      {
        bCTF = True;
      } else {
        if ( string(Level.Game.Class) ~= "Botpack.DeathMatchPlus" )
        {
          bDM = True;
        } else {
          if ( string(Level.Game.Class) ~= "Botpack.LastManStanding" )
          {
            bLMS = True;
          } else {
            if ( string(Level.Game.Class) ~= "Botpack.TeamGamePlus" )
            {
              bTDM = True;
            } else {
              if ( string(Level.Game.Class) ~= "Botpack.Domination" )
              {
                bDOM = True;
              } else {
                bAutoGame = True;
                AutoGame = string(Level.Game.Class);
              }
            }
          }
        }
      }
    }
  }
  if ( bAutoGame )
  {
    AutoGameClass = Class<GameInfo>(DynamicLoadObject(AutoGame,Class'Class'));
  }
  if ( bAS )
  {
    if ( bUseMapList )
    {
      LoadMapCycleList(Class'Assault'.Default.MapListType,"AS","AS",History);
    } else {
      LoadMapTypes("AS","AS",History,"Botpack.Assault");
    }
    Sleep(0.01);
  }
  if ( bCTF )
  {
    if ( bUseMapList )
    {
      LoadMapCycleList(Class'CTFGame'.Default.MapListType,"CTF","CTF",History);
    } else {
      LoadMapTypes("CTF","CTF",History,"Botpack.CTFGame");
    }
    Sleep(0.01);
  }
  if ( bDM )
  {
    if ( bUseMapList )
    {
      LoadMapCycleList(Class'DeathMatchPlus'.Default.MapListType,"DM","DM",History);
    } else {
      LoadMapTypes("DM","DM",History,"Botpack.DeathMatchPlus");
    }
    Sleep(0.01);
  }
  if ( bDOM )
  {
    if ( bUseMapList )
    {
      LoadMapCycleList(Class'Domination'.Default.MapListType,"DOM","DOM",History);
    } else {
      LoadMapTypes("DOM","DOM",History,"Botpack.Domination");
    }
    Sleep(0.01);
  }
  if ( bTDM )
  {
    if ( bUseMapList )
    {
      LoadMapCycleList(Class'TeamGamePlus'.Default.MapListType,"DM","TDM",History);
    } else {
      LoadMapTypes("DM","TDM",History,"Botpack.TeamGamePlus");
    }
    Sleep(0.01);
  }
  if ( bLMS )
  {
    if ( bUseMapList )
    {
      LoadMapCycleList(Class'LastManStanding'.Default.MapListType,"DM","LMS",History);
    } else {
      LoadMapTypes("DM","LMS",History,"Botpack.LastManStanding");
    }
    Sleep(0.01);
  }
  if ( bAutoGame && (AutoGameClass != None) )
  {
    DebugLog("85");
    NewPrefix = FixPrefix(AutoGameClass.Default.MapPrefix);
    if ( bUseMapList )
    {
      LoadMapCycleList(AutoGameClass.Default.MapListType,FixPrefix(AutoGameClass.Default.MapPrefix),NewPrefix,History);
    } else {
      LoadMapTypes(FixPrefix(AutoGameClass.Default.MapPrefix),NewPrefix,History,AutoGame);
    }
    Sleep(0.01);
  }
  if (  !bAutoDetect )
  {
    i = 0;
    if ( i < 16 )
    {
      if ( CustomGameConfig[i].bEnabled && (CustomGameConfig[i].GameClass != "") )
      {
        CustomGameClass = Class<GameInfo>(DynamicLoadObject(CustomGameConfig[i].GameClass,Class'Class'));
        if ( bFixCTFModifications && (Right(CustomGameConfig[i].GameClass,12) ~= "MultiCTFGame") )
        {
          DebugLog("MultiCTF detected. Fixing Mapprefix to CTFM");
          CustomGameClass.Default.MapPrefix = "CTFM";
        }
        if ( CustomGameClass == None )
        {
          Log("MapVote: Error. CustomGameConfig[" $ string(i) $ "]: Failed to load GameClass:" @ CustomGameConfig[i].GameClass);
        } else {
          if ( CustomGameConfig[i].NewPrefix == "" )
          {
            NewPrefix = FixPrefix(CustomGameClass.Default.MapPrefix);
          } else {
            NewPrefix = FixPrefix(CustomGameConfig[i].NewPrefix);
          }
          if ( bUseMapList )
          {
            LoadMapCycleList(CustomGameClass.Default.MapListType,FixPrefix(CustomGameClass.Default.MapPrefix),NewPrefix,History);
          } else {
            LoadMapTypes(FixPrefix(CustomGameClass.Default.MapPrefix),NewPrefix,History,CustomGameConfig[i].GameClass);
          }
        }
        Sleep(0.01);
      }
      i++;
      goto JL0640;
    }
  }
  History.Destroy();
  if ( Mode == "Elimination" )
  {
    if ( (MapCount < MinMapCount) || (MapCount == 0) && (RepeatLimit > 0) )
    {
      RepeatLimit = 0;
      GotoState('Loading');
    }
  }
  SortMapList();
  Log("BDBMapVote: Maps Reloaded. Total Maps = " $ string(MapCount));
  if ( bMapReloadRequested )
  {
    BroadcastMessage("MapVote configuration has been changed, Re-Open Voting window for updates.",True);
  }
  bMapReloadRequested = False;
  if ( bReloadMapsOnRequestOnly )
  {
    SaveMapListConfig();
  }
}

function LoadMapTypes (string Prefix, string PreFixChange, MapVoteHistory History, string GameClass)
{
  local string FirstMap;
  local string NextMap;
  local string MapName;
  local string TestMap;
  local string FilteredMap;
  local int Z;
  local int ignoreCount;
  local bool bIsPureCTF;

  DebugLog("86");
  DebugLog("Going to load gametype:" @ GameClass @ "using maps with Prefix:" @ Prefix $ ". PreFixChange:" @ PreFixChange);
  if ( GameClass ~= "Botpack.CTFGame" )
  {
    bIsPureCTF = True;
    DebugLog("Pure CTF Detected");
  }
  FirstMap = Level.GetMapName(Prefix,"",0);
  NextMap = FirstMap;
  if (  !FirstMap ~= TestMap )
  {
    if ( MapCount >= 1023 )
    {
      ignoreCount++;
    } else {
      MapName = NextMap;
      if ( bFixCTFModifications && bIsPureCTF && ( !(Left(MapName,4) ~= "CTF-") || (Left(MapName,6) ~= "CTF-BT")) )
      {
        DebugLog("CTF prevented from loading wrong map:" @ MapName);
      } else {
        Z = InStr(Caps(MapName),".UNR");
        if ( Z != -1 )
        {
          MapName = Left(MapName,Z);
        }
        MapName = PreFixChange $ Mid(MapName,Len(Prefix));
        if ( (InStr(Caps(NextMap),"TUTORIAL") == -1) && (InStr(Caps(NextMap),"INTRO") == -1) )
        {
          if ( History != None )
          {
            if ( History.GetMapSequence(MapName) <= RepeatLimit )
            {
              MapName = "[X]" $ MapName;
            }
          }
          FilteredMap = CreateMapnameIncludingListnumber(MapName);
          if ( FilteredMap != "" )
          {
            MapCount++;
            MapList[MapCount] = FilteredMap;
            if ( bDebugMode )
            {
              DebugLog("Loading Map[" $ string(MapCount) $ "]:" @ FilteredMap);
            }
          } else {
            if ( bDebugMode )
            {
              DebugLog("Map ignored cause no filter matches:" @ GetPureMapname(MapName));
            }
          }
        }
      }
    }
    NextMap = Level.GetMapName(Prefix,NextMap,1);
    TestMap = NextMap;
    goto JL00CD;
  }
  if ( ignoreCount > 0 )
  {
    Log("Ignored" @ string(ignoreCount) @ "Maps with Prefix" @ Prefix @ "cause mapcount > 1023",'MapVoteLA');
  }
}

function LoadMapCycleList (Class<MapList> MapListType, string Prefix, string PreFixChange, MapVoteHistory History)
{
  local MapList MapCycleList;
  local string MapName;
  local string FilteredMap;
  local int X;
  local int Z;

  DebugLog("87");
  MapCycleList = Spawn(MapListType);
  if ( MapCycleList != None )
  {
    X = 0;
    if ( (X < 32) && (MapCycleList.Maps[X] != "") )
    {
      MapName = MapCycleList.Maps[X++ ];
      Z = InStr(Caps(MapName),".UNR");
      if ( Z != -1 )
      {
        MapName = Left(MapName,Z);
      }
      MapName = PreFixChange $ Mid(MapName,Len(Prefix));
      if ( History != None )
      {
        if ( History.GetMapSequence(MapName) <= RepeatLimit )
        {
          MapName = "[X]" $ MapName;
        }
      }
      FilteredMap = CreateMapnameIncludingListnumber(MapName);
      if ( FilteredMap != "" )
      {
        MapCount++;
        MapList[MapCount] = FilteredMap;
        if ( bDebugMode )
        {
          DebugLog("Loading Map[" $ string(MapCount) $ "]" @ FilteredMap);
        }
      } else {
        if ( bDebugMode )
        {
          DebugLog("Map ignored cause no filter matches:" @ GetPureMapname(MapName));
        }
      }
      goto JL002A;
    }
    MapCycleList.Destroy();
  } else {
    Log("MapList Spawn Failed");
  }
}

function DebugLog (string Msg)
{
  if ( bDebugMode )
  {
    Log("MV " $ Msg,'MapVoteLA');
  }
}

function int ResetAssault ()
{
  local int CurrentDefender;

  if ( Level.Game.IsA('Assault') )
  {
    if ( GetWinningTeam() != -1 )
    {
      Log("BDBMapVote: Team " $ string(GetWinningTeam()) $ " won the round.");
      if ( GetWinningTeam() == 1 )
      {
        CurrentDefender = 0;
      } else {
        CurrentDefender = 1;
      }
      Log("BDBMapVote: Setting Team " $ string(CurrentDefender) $ " as the defending team for the next map.");
    } else {
      CurrentDefender = 0;
    }
    Assault(Level.Game).ResetGame();
    Assault(Level.Game).bDefenseSet = False;
    Assault(Level.Game).NumDefenses = 0;
    Assault(Level.Game).SavedTime = 0.0;
    Assault(Level.Game).GameCode = "";
    Assault(Level.Game).Part = 1;
    Assault(Level.Game).bTiePartOne = False;
    Assault(Level.Game).CurrentDefender = CurrentDefender;
    Assault(Level.Game).SaveConfig();
  }
  return 0;
}

function int GetWinningTeam ()
{
  if ( Assault(Level.Game).bDefenseSet )
  {
    if ( Assault(Level.Game).bAssaultWon )
    {
      return Assault(Level.Game).Attacker.TeamIndex;
    } else {
      if (  !Assault(Level.Game).bTiePartOne )
      {
        return Assault(Level.Game).Defender.TeamIndex;
      } else {
        return -1;
      }
    }
  } else {
    return -1;
  }
}

function int GetMapIndex (string MapName)
{
  local int X;
  local int MapIndex;

  MapName = GetPureMapname(MapName);
  X = 1;
  if ( X <= MapCount )
  {
    if ( GetPureMapname(MapList[X]) ~= MapName )
    {
      MapIndex = X;
    } else {
      X++;
      goto JL0018;
    }
  }
  return MapIndex;
}

function int GetRandomMap ()
{
  local int randmap;
  local int security;

  if ( (randmap < 1) || (GetMapListNumber(MapList[randmap]) != MapListIfNooneVoted) )
  {
    randmap = Rand(MapCount) + 1;
    if (  ++security > 100 )
    {
      randmap = Rand(MapCount) + 1;
    } else {
      goto JL0000;
    }
  }
  if ( security > 100 )
  {
    Log("Error: GetRandomMap() failed for List" @ string(MapListIfNooneVoted),'MapVoteLA');
  }
  Log("GetRandomMap() configured for List" @ string(MapListIfNooneVoted) @ "took the random map:" @ string(randmap) @ MapList[randmap]);
  return randmap;
}

function HandleFailedMap (string MapName)
{
  local int i;

  MapName = GetPureMapname(MapName);
  DebugLog("Crashed map:" @ MapName);
  i = 0;
  if ( (i < 31) && (CrashedMaps[i] != "") )
  {
    if ( CrashedMaps[i] == MapName )
    {
      return;
    }
    i++;
    goto JL0033;
  }
  CrashedMaps[i] = MapName;
  DebugLog("Added failed map:" @ MapName @ "to slot" @ string(i));
  SaveConfig();
  StaticSaveConfig();
}

function StartMutatorsAndSettings ()
{
  local string ActualPrefix;
  local string TestPrefix;
  local string Prefixes;
  local string Mutators;
  local string Settings;
  local int i;
  local int pos;

  if ( bFixCTFModifications )
  {
    if ( Right(string(Level.Game.Class),12) ~= "MultiCTFGame" )
    {
      DebugLog("MultiCTF detected. Fixing Mapprefix to CTFM");
      Level.Game.Default.MapPrefix = "CTFM";
      Level.Game.MapPrefix = "CTFM";
    }
  }
  ActualPrefix = FixPrefix(Level.Game.MapPrefix);
  DebugLog("NextVirtualPrefix/NextRealPrefix/ActualPrefix:" @ TmpNextVirtualPrefix $ "/" $ TmpNextRealPrefix $ "/" $ ActualPrefix);
  if ( (TmpNextRealPrefix == ActualPrefix) && (TmpNextVirtualPrefix != "") )
  {
    ActualPrefix = TmpNextVirtualPrefix;
    DebugLog("MapVote: Prefix OK. Mapchange seems to have been successful");
  }
  if ( DefaultSettings != "" )
  {
    Settings = DefaultSettings;
    if ( Len(Settings) > 0 )
    {
      pos = InStr(Settings,";");
      if ( pos < 0 )
      {
        pos = InStr(Settings,",");
      }
      if ( pos < 0 )
      {
        ExecuteSetting(Settings,True);
        Settings = "";
      } else {
        ExecuteSetting(Left(Settings,pos),True);
        Settings = Mid(Settings,pos + 1);
      }
      goto JL01A1;
    }
  }
  i = 0;
  if ( i < 16 )
  {
    if ( CustomGameConfig[i].bEnabled )
    {
      TestPrefix = CustomGameConfig[i].NewPrefix;
      if ( ActualPrefix ~= TestPrefix )
      {
        if ( CustomGameConfig[i].Mutators != "" )
        {
          Mutators = CustomGameConfig[i].Mutators;
          if ( Len(Mutators) > 0 )
          {
            pos = InStr(Mutators,";");
            if ( pos < 0 )
            {
              pos = InStr(Mutators,",");
            }
            if ( pos < 0 )
            {
              StartActorMutator(Mutators);
              Mutators = "";
            } else {
              StartActorMutator(Left(Mutators,pos));
              Mutators = Mid(Mutators,pos + 1);
            }
            goto JL029F;
          }
        }
        if ( CustomGameConfig[i].Settings != "" )
        {
          Settings = CustomGameConfig[i].Settings;
          if ( Len(Settings) > 0 )
          {
            pos = InStr(Settings,";");
            if ( pos < 0 )
            {
              pos = InStr(Settings,",");
            }
            if ( pos < 0 )
            {
              ExecuteSetting(Settings,False);
              Settings = "";
            } else {
              ExecuteSetting(Left(Settings,pos),False);
              Settings = Mid(Settings,pos + 1);
            }
            goto JL034F;
          }
        }
      }
    }
    i++;
    goto JL022D;
  }
}

function StartActorMutator (string ClassString)
{
  local Actor A;
  local Class<Actor> ActorClass;

  Log("StartMutator:" @ ClassString,'MapVoteLA');
  ActorClass = Class<Actor>(DynamicLoadObject(ClassString,Class'Class'));
  if ( ActorClass == None )
  {
    Log("Starting Actor/Mutator FAILED. Could not DynamicLoadObject:" @ ClassString,'MapVoteLA');
    return;
  }
  foreach AllActors(ActorClass,A)
  {
    Log("Actor already spawned:" @ ClassString,'MapVoteLA');
    return;
  }
  A = Spawn(ActorClass);
  if ( A == None )
  {
    Log("Spawning Actor/Mutator FAILED:" @ ClassString,'MapVoteLA');
    return;
  }
  if ( A.IsA('Mutator') )
  {
    Level.Game.BaseMutator.AddMutator(Mutator(A));
  }
}

function ExecuteSetting (string Setting, bool bIsDefaultSetting)
{
  local string Property;
  local string Value;
  local string Prev;
  local string Next;

  Property = Left(Setting,InStr(Setting,"="));
  Value = Mid(Setting,InStr(Setting,"=") + 1);
  if ( bIsDefaultSetting )
  {
    Log("Execute default Setting:" @ Setting $ ". Property:" @ Property $ ". Value:" @ Value,'MapVoteLA');
  } else {
    Log("Execute Setting:" @ Setting $ ". Property:" @ Property $ ". Value:" @ Value,'MapVoteLA');
  }
  Prev = Level.Game.GetPropertyText(Property);
  Level.Game.SetPropertyText(Property,Value);
  Next = Level.Game.GetPropertyText(Property);
  DebugLog("Changed Setting:" @ Property $ ". Previous value:" @ Prev $ ". new value:" @ Next);
}

function float MaxFloat (float val1, float val2)
{
  if ( val1 > val2 )
  {
    return val1;
  } else {
    return val2;
  }
}

function string GetPrefix (string MapName)
{
  if ( Left(MapName,6) ~= "CTF-BT" )
  {
    return "CTF-BT";
  }
  return Caps(Left(MapName,InStr(MapName,"-")));
}

function string FixPrefix (string Prefix)
{
  if ( Right(Prefix,1) == "-" )
  {
    return Left(Prefix,Len(Prefix) - 1);
  } else {
    return Prefix;
  }
}

function string RemovePrefix (string MapName)
{
  return Mid(MapName,InStr(MapName,"-") + 1);
}

defaultproperties
{
    bDM=True

    bDOM=True

    bCTF=True

    bAS=True

    bSortWithPreFix=True

    ASClass="Botpack.Assault"

    VoteTimeLimit=50

    KickPercent=51

    ScoreBoardDelay=10

    bAutoOpen=True

    bKickVote=True

    RepeatLimit=5

    MapListIfNooneVoted=1

    MapVoteHistoryType="MapVoteLA13.MapVoteHistory1"

    MidGameVotePercent=51

    Mode="Majority"

    MinMapCount=2

    EmptyServerLevelSwitchTimeMins=15

    MsgTimeOut=8

    bLoadScreenShot=True

    bFixCTFModifications=True

    MapVoteTitle="Welcome"

    List1Priority=1.00

    List2Priority=1.00

    List3Priority=1.00

    List4Priority=1.00

    List1Title="Assault"

    List2Title="Deathmatch"

    List3Title="Capture the Flag"

    List4Title="Others"

    bList1ObeyRepeatLimit=True

    bList2ObeyRepeatLimit=True

    bList3ObeyRepeatLimit=True

    bList4ObeyRepeatLimit=True

    bUseExcludeFilter=True

    CustomGameConfig=(bEnabled=True,GameClass="Botpack.DeathMatchPlus",NewPrefix="iDM",Mutators="BotPack.InstaGibDM",Settings=""),

    List1Filter="AS-*"

    List2Filter(0)="DM-*"

    List2Filter(1)="iDM-*"

    List3Filter="CTF-*"

    List4Filter="*"

}
