class MVKeyBinderFrameWindow expands UWindowFramedWindow;

var bool bHasStartWindow;

function Created()
{
    bSizable = False;

    Super.Created();

    WinWidth = 480;
    WinHeight = 200;
    WinLeft = Root.WinWidth/2 - WinWidth/2;
    WinTop = Root.WinHeight/2 - WinHeight/2;
}

function Close(optional bool bByParent)
{
   local UWindowWindow WelcomeWindow;

   Super.Close(bByParent);

   WelcomeWindow = Root.FindChildWindow(class'x3dfxMapVotev25d.MVWelcomeWindow', True);

   if(WelcomeWindow == none)  // no welcome window present
   {
      if(bHasStartWindow)
         FocusStartWindow();
      else
         WindowConsole(GetPlayerOwner().Player.Console).CloseUWindow(); // remove the mouse pointer
   }
}

function FocusStartWindow()
{
   local UWindowWindow Child;

   for(Child = Root.LastChildWindow; Child != None; Child = Child.PrevSiblingWindow)
   {
      if(left(string(Child.Class),6) == "UTMenu" || left(string(Child.Class),5) == "UMenu")
         WindowConsole(GetPlayerOwner().Player.Console).CloseUWindow();
      else
         if(Child.Class != Self.Class)
            break;
   }

   if(Child == None)
      WindowConsole(GetPlayerOwner().Player.Console).CloseUWindow(); // remove the mouse pointer
   else
   {
      Child.bLeaveOnScreen = True;
      Child.FocusWindow();
      Child.ShowWindow();
   }
}


defaultproperties
{
     ClientClass=Class'x3dfxMapVotev25d.MVKeyBinderClientWindow'
     WindowTitle="MapVote Key Binder"
}
