// Smiling Monsters Boost Handler
// By Ti-Lung 02/09/2007
// Version 1.0 (20070902)
// Created for the Smiling Monsters community
// http://www.smiling-monsters.com/community/
// Request by Hermskii http://www.unrealadmin.org/forums/showthread.php?t=25095

class SMoBoostHandler expands Mutator;

var bool bInitialized;

var int NoBoost[32];

function PreBeginPlay()
{
	local int i;

	if ( bInitialized )
		return;

	bInitialized = True;
	Log("Mutator initialized.",'SMoBoostHandler');

	Level.Game.RegisterDamageMutator(Self);

	if ( NextMutator != None )
		NextMutator.PreBeginPlay();
}

function Mutate(string MutateString, PlayerPawn Sender)
{
    if ( NextMutator != None )
		NextMutator.Mutate(MutateString, Sender);

	if ( Caps(MutateString) == "BOOSTON" )
	{
		NoBoost[Sender.PlayerReplicationInfo.PlayerID] = 0;
		Sender.ClientMessage("SMoBoostHandler: Boost is on.");
	}

	if ( Caps(MutateString) == "BOOSTOFF" )
	{
		NoBoost[Sender.PlayerReplicationInfo.PlayerID] = 1;
		Sender.ClientMessage("SMoBoostHandler: Boost is off.");
	}

}

function MutatorTakeDamage( out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
	if( Victim != InstigatedBy ) // Not damage to self
	{
		if( NoBoost[Victim.PlayerReplicationInfo.PlayerID] == 1 )
			Momentum = Vect(0,0,0);
	}

	if ( NextDamageMutator != None )
		NextDamageMutator.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType );
}
